<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Contact extends CI_Controller{

    public function __construct() {
        parent::__construct();
		$this->lang->load('front_login' , 'english');
        
    }
	
	public function index(){
		
		// get account id
        $account_id = $this->User->get_domain_account();
        $accountData = $this->User->get_account_data($account_id);
		
        $contactDetail = $this->db->get_where('website_contact_detail',array('account_id'=>$account_id))->row_array(); 

		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
            'accountData' => $accountData,
            'contactDetail'=>$contactDetail,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'contact'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }



    public function sendMessage()
    {   
        //check for foem validation
        $post = $this->input->post();
            $account_id = $this->User->get_domain_account();
            $accountData = $this->User->get_account_data($account_id);
            
            $data = array(
             'account_id' => $account_id,
             'name'    => $post['name'],
             'mobile'  => $post['mobile'],
             'email'   => $post['email'],
             'state'   => $post['state'],
             'pin_code'=> $post['pin_code'],
             'message'=> $post['message'],
             'created'  => date('Y-m-d h:i:s')
            );
            
            $status = $this->db->insert('enquiry',$data);
            if($status == true)
            {
                $this->Az->redirect('contact', 'system_message_error',lang('ENQUIRY_SAVE_SUCCESS'));
            }
            else
            {
                $this->Az->redirect('contact', 'system_message_error',lang('DB_ERROR'));
            }
            
    
    }


    
}


/* End of file login.php */
/* Location: ./application/controllers/login.php */