<?php
if(!defined('BASEPATH'))
    exit('No direct script access allowed.');

/*
 * Model for manage users information.
 * 
 * This model used for manage user data.
 * this one used for authenticate users, get informations about users
 * @author trilok
 */


class User extends CI_Model{

    public function checkPermission($mode = SUPERADMIN_SESSION_ID, $is_front = false) {
        
        $user = $this->session->userdata($mode);
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            $currLang = $this->session->userdata('language');
            $this->lang->load('superadmin/dashboard', $currLang);
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('superadmin/login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('superadmin/login');
            }
        }


    }


    public function checkSuperEmployePermission($mode = SUPERADMIN_EMPLOYE_SESSION_ID, $is_front = false) {
        
        $user = $this->session->userdata($mode);
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            $currLang = $this->session->userdata('language');
            $this->lang->load('superadmin/dashboard', $currLang);
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            }
        }


    }
	
	public function checkAdminPermission($mode = ADMIN_SESSION_ID, $is_front = false) {
        
        $user = $this->session->userdata($mode);
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            $currLang = $this->session->userdata('language');
            $this->lang->load('superadmin/dashboard', $currLang);
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            }
        }
        $loggedUser = $this->session->userdata(ADMIN_SESSION_ID);
		$memberDetail = $this->db->get_where('users',array('id'=>$loggedUser['id'],'is_active'=>1))->num_rows();
		if(!$memberDetail)
		{
			$this->session->unset_userdata(ADMIN_SESSION_ID);
			$currLang = $this->session->userdata('language');
            $this->lang->load('superadmin/dashboard', $currLang);
			$this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
		}
 

    }



    public function checkEmployePermission($mode = ADMIN_EMPLOYE_SESSION_ID, $is_front = false) {
        
        $user = $this->session->userdata($mode);
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            $currLang = $this->session->userdata('language');
            $this->lang->load('employe/dashboard', $currLang);
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            }
        }
        $loggedUser = $this->session->userdata(ADMIN_EMPLOYE_SESSION_ID);
		$memberDetail = $this->db->get_where('users',array('id'=>$loggedUser['id'],'is_active'=>1))->num_rows();
		if(!$memberDetail)
		{
			$this->session->unset_userdata(ADMIN_EMPLOYE_SESSION_ID);
			$currLang = $this->session->userdata('language');
            $this->lang->load('employe/dashboard', $currLang);
			$this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
		}
 

    }
	
	public function checkMasterPermission($mode = MASTER_DIST_SESSION_ID, $is_front = false) {
        
        $user = $this->session->userdata($mode);
        
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            }
        }
        $loggedUser = $this->session->userdata(MASTER_DIST_SESSION_ID);
		$memberDetail = $this->db->get_where('users',array('id'=>$loggedUser['id'],'is_active'=>1))->num_rows();
		if(!$memberDetail)
		{
			$this->session->unset_userdata(MASTER_DIST_SESSION_ID);
			$this->load->helper('language');
			$this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
		}

    }

    public function checkDistributorPermission($mode = DISTRIBUTOR_SESSION_ID, $is_front = false) {
        
        $user = $this->session->userdata($mode);
        
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            }
        }
        $loggedUser = $this->session->userdata(DISTRIBUTOR_SESSION_ID);
		$memberDetail = $this->db->get_where('users',array('id'=>$loggedUser['id'],'is_active'=>1))->num_rows();
		if(!$memberDetail)
		{
			$this->session->unset_userdata(DISTRIBUTOR_SESSION_ID);
			$this->load->helper('language');
			$this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
		}

    }

    public function checkRetailerPermission($mode = RETAILER_SESSION_ID, $is_front = false) {
        
        $user = $this->session->userdata($mode);
        
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            }
        }
        $loggedUser = $this->session->userdata(RETAILER_SESSION_ID);
		$memberDetail = $this->db->get_where('users',array('id'=>$loggedUser['id'],'is_active'=>1))->num_rows();
		if(!$memberDetail)
		{
			$this->session->unset_userdata(RETAILER_SESSION_ID);
			$this->load->helper('language');
			$this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
		}

    }


    public function checkUserPermission($mode = USER_SESSION_ID, $is_front = false) {
        
        $user = $this->session->userdata($mode);
        
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            }
        }
        $loggedUser = $this->session->userdata(USER_SESSION_ID);
		$memberDetail = $this->db->get_where('users',array('id'=>$loggedUser['id'],'is_active'=>1))->num_rows();
		if(!$memberDetail)
		{
			$this->session->unset_userdata(USER_SESSION_ID);
			$this->load->helper('language');
			$this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
		}

    }


    public function checkApiMemberPermission($mode = API_MEMBER_SESSION_ID, $is_front = false) {
        
        $user = $this->session->userdata($mode);
        
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            }
        }
        $loggedUser = $this->session->userdata(API_MEMBER_SESSION_ID);
		$memberDetail = $this->db->get_where('users',array('id'=>$loggedUser['id'],'is_active'=>1))->num_rows();
		if(!$memberDetail)
		{
			$this->session->unset_userdata(API_MEMBER_SESSION_ID);
			$this->load->helper('language');
			$this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
		}

    }


    


    
    public function getLoggedUser($sessionID = ''){
        
		$user = $this->session->userdata($sessionID);
		
        if(!$user){
	   		 redirect('superadmin/Login');
            return false;
        }
       if($user){
            $user = $this->db->get_where('users',array('id'=>$user['id']))->row_array();
            return $user;
        }

        

    }

    public function getAdminLoggedUser($sessionID = ''){
        
		$user = $this->session->userdata($sessionID);
		
        if(!$user){
	   		 redirect('login');
            return false;
        }
       if($user){
            $user = $this->db->select('id,account_id,role_id,user_code,name,is_active,mobile,email')->get_where('users',array('id'=>$user['id']))->row_array();
            return $user;
        }

        

    }
	
	public function generate_unique_member_id($role_id = 0)
	{
		$account_id = $this->User->get_domain_account();
		if($role_id == 3)
		{
			$user_display_id = MASTER_DIST_DISPLAY_ID;
		}
		elseif($role_id == 4)
		{
			$user_display_id = DISTRIBUTOR_DISPLAY_ID;
		}
		elseif($role_id == 5)
		{
			$user_display_id = RETAILER_DISPLAY_ID;
		}
		elseif($role_id == 6)
		{
			$user_display_id = API_DISPLAY_ID;
		}
		elseif($role_id == 8)
		{
			$user_display_id = USER_DISPLAY_ID;
		}
		$this->load->helper('string');
		$user_display_number = random_string('numeric',6);
		$user_display_id.=$user_display_number;
		
		// check member id already registered or not
		$chk_member_id = $this->db->get_where('users',array('account_id'=>$account_id,'user_code'=>$user_display_id))->num_rows();
		if($chk_member_id)
		{
			$user_display_id = $this->generate_new_unique_member_id($role_id);
		}
		return $user_display_id;
	}
	
	public function generate_new_unique_member_id($role_id = 0)
	{
		$account_id = $this->User->get_domain_account();
		if($role_id == 3)
		{
			$user_display_id = MASTER_DIST_DISPLAY_ID;
		}
		elseif($role_id == 4)
		{
			$user_display_id = DISTRIBUTOR_DISPLAY_ID;
		}
		elseif($role_id == 5)
		{
			$user_display_id = RETAILER_DISPLAY_ID;
		}
		elseif($role_id == 6)
		{
			$user_display_id = API_DISPLAY_ID;
		}
		elseif($role_id == 8)
		{
			$user_display_id = USER_DISPLAY_ID;
		}
		$this->load->helper('string');
		$user_display_number = random_string('numeric',6);
		$user_display_id.=$user_display_number;
		
		// check member id already registered or not
		$chk_member_id = $this->db->get_where('users',array('account_id'=>$account_id,'user_code'=>$user_display_id))->num_rows();
		if($chk_member_id)
		{
			$user_display_id = $this->generate_new_unique_member_id($role_id);
		}
		return $user_display_id;
	}
	
	public function generate_unique_admin_id()
	{
		$user_display_id = ADMIN_DISPLAY_ID;
		$this->load->helper('string');
		$user_display_number = random_string('numeric',6);
		$user_display_id.=$user_display_number;
		
		// check member id already registered or not
		$chk_member_id = $this->db->get_where('users',array('user_code'=>$user_display_id))->num_rows();
		if($chk_member_id)
		{
			$user_display_id = $this->generate_new_unique_admin_id();
		}
		return $user_display_id;
	}
	
	public function generate_new_unique_admin_id()
	{
		$user_display_id = ADMIN_DISPLAY_ID;
		$this->load->helper('string');
		$user_display_number = random_string('numeric',6);
		$user_display_id.=$user_display_number;
		
		// check member id already registered or not
		$chk_member_id = $this->db->get_where('users',array('user_code'=>$user_display_id))->num_rows();
		if($chk_member_id)
		{
			$user_display_id = $this->generate_new_unique_admin_id();
		}
		return $user_display_id;
	}

	public function get_domain_account()
	{
		return 7;
	}

	public function get_account_data($account_id = 0)
	{
		// get domain id
		$get_domain_id = $this->db->get_where('account',array('id'=>$account_id))->row_array();
		return $get_domain_id;
	}

	public function get_account_package_id($account_id = 0)
	{
		// get domain id
		$get_domain_id = $this->db->select('package_id')->get_where('account',array('id'=>$account_id))->row_array();
		return ($get_domain_id['package_id']) ? $get_domain_id['package_id'] : 0;
	}

	public function getMemberWalletBalance($account_id = 0)
	{
		// get domain id
		$get_domain_id = $this->db->select('wallet_balance')->get_where('users',array('id'=>$account_id))->row_array();
		return isset($get_domain_id['wallet_balance']) ? $get_domain_id['wallet_balance'] : 0;
	}

	public function getMemberEwalletBalance($account_id = 0)
	{
		// get domain id
		$get_domain_id = $this->db->select('aeps_wallet_balance')->get_where('users',array('id'=>$account_id))->row_array();
		return isset($get_domain_id['aeps_wallet_balance']) ? $get_domain_id['aeps_wallet_balance'] : 0;
	}

	public function getMemberPackageID($account_id = 0)
	{
		// get domain id
		$get_domain_id = $this->db->select('package_id')->get_where('users',array('id'=>$account_id))->row_array();
		return isset($get_domain_id['package_id']) ? $get_domain_id['package_id'] : 0;
	}

	public function getMemberUPIID($account_id = 0)
	{
		// get domain id
		$get_domain_id = $this->db->select('upi_id')->get_where('users',array('id'=>$account_id))->row_array();
		return isset($get_domain_id['upi_id']) ? $get_domain_id['upi_id'] : '';
	}

	public function get_distributor_id($user_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		// get account role id
		$get_role_id = $this->db->select('role_id,created_by')->get_where('users',array('id'=>$user_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['role_id']) ? $get_role_id['role_id'] : 0 ;
		$md_id = isset($get_role_id['created_by']) ? $get_role_id['created_by'] : 0 ;
		
		// check return id rold
		$get_return_id_role = $this->db->select('role_id')->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
		$return_id_role = isset($get_return_id_role['role_id']) ? $get_return_id_role['role_id'] : 0 ;
		if($return_id_role == 2)
		{
			$md_id = 0;
		}

		return $md_id;


	}

	public function get_member_downline_id($user_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		// get account role id
		$get_role_id = $this->db->select('GROUP_CONCAT(id) as member_id_str')->get_where('users',array('created_by'=>$user_id,'account_id'=>$domain_account_id))->row_array();
		$md_id = isset($get_role_id['member_id_str']) ? explode(',',$get_role_id['member_id_str']) : array() ;
		$md_idd = array();
		$md_iddd = array();
		if($md_id)
		{
			// get account role id
			$get_role_idd = $this->db->select('GROUP_CONCAT(id) as member_id_str')->where_in('created_by',$md_id)->get_where('users',array('account_id'=>$domain_account_id))->row_array();
			$md_idd = isset($get_role_idd['member_id_str']) ? explode(',',$get_role_idd['member_id_str']) : array() ;
			if($md_idd)
			{
				// get account role id
				$get_role_iddd = $this->db->select('GROUP_CONCAT(id) as member_id_str')->where_in('created_by',$md_idd)->get_where('users',array('account_id'=>$domain_account_id))->row_array();
				$md_iddd = isset($get_role_iddd['member_id_str']) ? explode(',',$get_role_iddd['member_id_str']) : array() ;
			}
		}

		$member_id_str = implode(',', $md_id).','.implode(',', $md_idd).','.implode(',', $md_iddd);

		return array_filter(explode(',', $member_id_str));


	}

	public function get_master_distributor_id($user_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		// get account role id
		$get_role_id = $this->db->select('role_id,created_by')->get_where('users',array('id'=>$user_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['role_id']) ? $get_role_id['role_id'] : 0 ;
		$created_by = isset($get_role_id['created_by']) ? $get_role_id['created_by'] : 0 ;
		$md_id = 0;
		if($user_role_id == 4)
		{
			$md_id = $created_by;
		}
		elseif($user_role_id == 5)
		{
			// get account role id
			$get_id = $this->db->select('role_id,created_by')->get_where('users',array('id'=>$created_by,'account_id'=>$domain_account_id))->row_array();
			$created_by = isset($get_id['created_by']) ? $get_id['created_by'] : 0 ;
			$md_id = $created_by;
		}

		// check return id rold
		$get_return_id_role = $this->db->select('role_id')->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
		$return_id_role = isset($get_return_id_role['role_id']) ? $get_return_id_role['role_id'] : 0 ;
		if($return_id_role == 2)
		{
			$md_id = 0;
		}
		
		return $md_id;


	}

	public function get_admin_id($domain_account_id = 0)
	{
		if($domain_account_id == 0)
		{
			$domain_account_id = $this->User->get_domain_account();
		}
		// get account role id
		$get_role_id = $this->db->select('id')->get_where('users',array('role_id'=>2,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['id']) ? $get_role_id['id'] : 0 ;
		return $user_role_id;


	}

	public function get_admin_wallet_balance($admin_id = 0,$domain_account_id = 0)
	{
		if($domain_account_id == 0)
		{
			$domain_account_id = $this->User->get_domain_account();
		}
		// get account role id
		$get_role_id = $this->db->select('wallet_balance')->get_where('users',array('id'=>$admin_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['wallet_balance']) ? $get_role_id['wallet_balance'] : 0 ;
		return $user_role_id;


	}

	public function get_admin_ewallet_balance($admin_id = 0,$domain_account_id = 0)
	{
		if($domain_account_id == 0)
		{
			$domain_account_id = $this->User->get_domain_account();
		}
		// get account role id
		$get_role_id = $this->db->select('aeps_wallet_balance')->get_where('users',array('id'=>$admin_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['aeps_wallet_balance']) ? $get_role_id['aeps_wallet_balance'] : 0 ;
		return $user_role_id;


	}

	public function account_active_service($account_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		$activeService = $this->db->select('account_user_services.*')->get_where('account_user_services',array('account_id'=>$domain_account_id,'member_id'=>$account_id,'status'=>1))->result_array();

	 	$activeServiceID = array();
	 	if($activeService)
	 	{
	 		foreach($activeService as $key=>$list)
	 		{
	 			$activeServiceID[$key] = $list['service_id'];
	 		}
	 	}
	 	return $activeServiceID;
	}

	public function admin_active_service($account_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		$activeService = $this->db->select('account_services.*')->get_where('account_services',array('account_id'=>$domain_account_id,'status'=>1))->result_array();
		$activeServiceID = array();
	 	if($activeService)
	 	{
	 		foreach($activeService as $key=>$list)
	 		{
	 			$activeServiceID[$key] = $list['service_id'];
	 		}
	 	}
	 	return $activeServiceID;
	}

	public function account_active_gateway()
	{
		$domain_account_id = $this->User->get_domain_account();
		$activeService = $this->db->select('account_payment_gateway.*')->get_where('account_payment_gateway',array('account_id'=>$domain_account_id,'status'=>1))->result_array();

	 	$activeServiceID = array();
	 	if($activeService)
	 	{
	 		foreach($activeService as $key=>$list)
	 		{
	 			$activeServiceID[$key] = $list['gateway_id'];
	 		}
	 	}
	 	return $activeServiceID;
	}

	public function get_member_aeps_status($member_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		$chk_member = $this->db->get_where('users',array('id'=>$member_id,'account_id'=>$domain_account_id,'aeps_status'=>1))->num_rows();
		return $chk_member;
	}
	
	
	public function get_member_2fa_aeps_status($member_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		$chk_member = $this->db->get_where('users',array('id'=>$member_id,'account_id'=>$domain_account_id,'2fa_status'=>1))->num_rows();
		return $chk_member;
	}
	
	
    
    public function get_member_virtual_kyc_status($member_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		$chk_member = $this->db->get_where('users',array('id'=>$member_id,'account_id'=>$domain_account_id,'virtual_kyc_status'=>1))->num_rows();
		return $chk_member;
	}
	
	public function get_member_icici_aeps_status($member_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		$chk_member = $this->db->get_where('users',array('id'=>$member_id,'account_id'=>$domain_account_id,'icici_aeps_status'=>1))->num_rows();
		return $chk_member;
	}

	public function account_razorpay_key()
	{
		$domain_account_id = $this->User->get_domain_account();
		$activeService = $this->db->select('account_payment_gateway.*')->get_where('account_payment_gateway',array('account_id'=>$domain_account_id,'gateway_id'=>1,'status'=>1))->row_array();
		
		$key = isset($activeService['gateway_key']) ? $activeService['gateway_key'] : '';
		$secret = isset($activeService['gateway_secret']) ? $activeService['gateway_secret'] : '';

		return array('key'=>$key,'secret'=>$secret);
	}

	public function generateLog($log_msg = '')
	{
		$account_id = $this->User->get_domain_account();
		$accountData = $this->User->get_account_data($account_id);
		if($accountData['account_type'] == 2)
		{
			$account_id = SUPERADMIN_ACCOUNT_ID;
		}
		$log_file = 'Account-'.$account_id.'-'.date('d-M-Y').'.php';
		write_file(ACCOUNT_LOG_PATH.$log_file,$log_msg,'a+');
		return true;
	}

	public function generateCallbackLog($log_msg = '')
	{
		$account_id = $this->User->get_domain_account();
		$log_file = 'Callback-Account-'.$account_id.'-'.date('d-M-Y').'.php';
		write_file(ACCOUNT_LOG_PATH.$log_file,$log_msg,'a+');
		return true;
	}
	

	public function generateVANLog($log_msg = '')
	{
		$account_id = SUPERADMIN_ACCOUNT_ID;
		$log_file = 'VAN-Account-'.$account_id.'-'.date('d-M-Y').'.php';
		write_file(ACCOUNT_LOG_PATH.$log_file,$log_msg.'[break]','a+');
		return true;
	}



/*	public function prepaid_rechage_api($api_url,$api_post_data,$account_id,$recharge_unique_id,$api_id,$response_type = 0,$responsePara = array(),$seperator = '',$api_header_data = array(),$user_code = '',$user_type = '')
	{
		$domain_account_id = $this->User->get_domain_account();
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		if($api_post_data && !$api_header_data)
		{
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($api_post_data));		
		}
		if($api_header_data)
		{
			
            $headers = array();
            $h = 0;
            foreach($api_header_data as $hkey=>$hval)
            {
                $headers[$h] = $hkey.':'.$hval;
                $h++;
            }
            if($headers)
            {
	        	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	    	}
	    	if($api_post_data)
			{
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $api_post_data);		
			}
		}
		$output = curl_exec($ch); 
		curl_close($ch);

		// save system log
        $log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - API Response - '.$output.']'.PHP_EOL;
        $this->User->generateLog($log_msg);

        log_message('debug', 'Recharge Auth API - API Response - '.$output);
		
		// save api response
		$apiData = array(
			'account_id' => $domain_account_id,
			'user_id' => $account_id,
			'recharge_id' => $recharge_unique_id,
			'api_response' => $output,
			'api_url' => $api_url,
			'api_id' => $api_id,
			'status' => 1,
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('api_response',$apiData);
		$api_response_id = $this->db->insert_id();
		$txid = '';
		$recharge_status = '';
		$success_value = '';
		$failed_value = '';
		$pending_value = '';
		$opt_msg = '';
		$opt_ref_id = '';
		$timestamp = '';
		$memberid = '';
		$balance = '';
		$commision = '';
		if($response_type == 1)
		{
			$api_response = explode($seperator,$output);
			if($responsePara)
			{
				foreach($responsePara as $key=>$val)
				{
					if($val['value'] == 'TXNID')
					{
						$txid = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'STATUS')
					{
						$recharge_status = isset($api_response[$key]) ? trim(strtolower($api_response[$key])) : '';
						$success_value = strtolower($val['success']);
						$failed_value = strtolower($val['failed']);
						$pending_value = strtolower($val['pending']);
					}
					elseif($val['value'] == 'OPTMSG')
					{
						$opt_msg = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'OPTREFID')
					{
						$opt_ref_id = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'TIMESTAMP')
					{
						$timestamp = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'MEMBERID')
					{
						$memberid = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'BALANCE')
					{
						$balance = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'COMMISION')
					{
						$commision = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
				}
			}

		}
		elseif($response_type == 2)
		{
			$api_response = (array) simplexml_load_string($output);
			if($responsePara)
			{
				foreach($responsePara as $key=>$val)
				{
					if($val['value'] == 'TXNID')
					{
						$txid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'STATUS')
					{
						$recharge_status = isset($api_response[$val['key']]) ? trim(strtolower($api_response[$val['key']])) : '';
						$success_value = strtolower($val['success']);
						$failed_value = strtolower($val['failed']);
						$pending_value = strtolower($val['pending']);
					}
					elseif($val['value'] == 'OPTMSG')
					{
						$opt_msg = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'OPTREFID')
					{
						$opt_ref_id = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'TIMESTAMP')
					{
						$timestamp = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'MEMBERID')
					{
						$memberid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'BALANCE')
					{
						$balance = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'COMMISION')
					{
						$commision = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
				}
			}

		}
		elseif($response_type == 3)
		{
			$api_response = json_decode($output,true);
			if($responsePara)
			{
				foreach($responsePara as $key=>$val)
				{
					if($val['value'] == 'TXNID')
					{
						$txid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'STATUS')
					{
						$recharge_status = isset($api_response[$val['key']]) ? trim(strtolower($api_response[$val['key']])) : '';
						$success_value = strtolower($val['success']);
						$failed_value = strtolower($val['failed']);
						$pending_value = strtolower($val['pending']);
					}
					elseif($val['value'] == 'OPTMSG')
					{
						$opt_msg = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'OPTREFID')
					{
						$opt_ref_id = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'TIMESTAMP')
					{
						$timestamp = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'MEMBERID')
					{
						$memberid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'BALANCE')
					{
						$balance = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'COMMISION')
					{
						$commision = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
				}
			}

		}

		$status = 0;
		if($recharge_status == $failed_value || $recharge_status == '')
		{
			$status = 3;
		}
		elseif($recharge_status == $pending_value)
		{
			$status = 1;
		}
		elseif($recharge_status == $success_value)
		{
			$status = 2;
		}
		
		return array(
			'status' => $status,
			'txid' => $txid,
			'operator_ref' => $opt_ref_id,
			'api_timestamp' => $timestamp,
			'opt_msg' => $opt_msg,
			'memberid' => $memberid,
			'balance' => $balance,
			'commision' => $commision,
			'api_response_id' => $api_response_id,
		);
		
	}*/
	
	public function prepaid_rechage_api($api_url,$api_post_data,$account_id,$recharge_unique_id,$api_id,$response_type = 0,$responsePara = array(),$seperator = '',$api_header_data = array(),$user_code = '',$user_type = '')
	{
		$domain_account_id = $this->User->get_domain_account();
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		if($api_post_data && !$api_header_data)
		{
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($api_post_data));		
		}
		if($api_header_data)
		{
			
            $headers = array();
            $h = 0;
            foreach($api_header_data as $hkey=>$hval)
            {
                $headers[$h] = $hkey.':'.$hval;
                $h++;
            }
            if($headers)
            {
	        	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	    	}
	    	if($api_post_data)
			{
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $api_post_data);		
			}
		}
		$output = curl_exec($ch); 
		curl_close($ch);

		// save system log
        $log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - API Response - '.$output.']'.PHP_EOL;
        $this->User->generateLog($log_msg);

        log_message('debug', 'Recharge Auth API - API Response - '.$output);
		
		// save api response
		$apiData = array(
			'account_id' => $domain_account_id,
			'user_id' => $account_id,
			'recharge_id' => $recharge_unique_id,
			'api_response' => $output,
			'api_url' => $api_url,
			'api_id' => $api_id,
			'status' => 1,
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('api_response',$apiData);
		$api_response_id = $this->db->insert_id();
		$txid = '';
		$recharge_status = '';
		$success_value = array();
		$failed_value = array();
		$pending_value = array();
		$opt_msg = '';
		$opt_ref_id = '';
		$timestamp = '';
		$memberid = '';
		$balance = '';
		$commision = '';
		if($response_type == 1)
		{
			$api_response = explode($seperator,$output);
			if($responsePara)
			{
				foreach($responsePara as $key=>$val)
				{
					if($val['value'] == 'TXNID')
					{
						$txid = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'STATUS')
					{
						$recharge_status = isset($api_response[$key]) ? trim(strtolower($api_response[$key])) : '';
						$success_value = array_filter(explode(',', $val['success']),'strlen');
						$failed_value = array_filter(explode(',', $val['failed']),'strlen');
						$pending_value = array_filter(explode(',', $val['pending']),'strlen');
					}
					elseif($val['value'] == 'OPTMSG')
					{
						$opt_msg = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'OPTREFID')
					{
						$opt_ref_id = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'TIMESTAMP')
					{
						$timestamp = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'MEMBERID')
					{
						$memberid = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'BALANCE')
					{
						$balance = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'COMMISION')
					{
						$commision = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
				}
			}

		}
		elseif($response_type == 2)
		{
			$api_response = (array) simplexml_load_string($output);
			if($responsePara)
			{
				foreach($responsePara as $key=>$val)
				{
					if($val['value'] == 'TXNID')
					{
						$txid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'STATUS')
					{
						$recharge_status = isset($api_response[$val['key']]) ? trim(strtolower($api_response[$val['key']])) : '';
						$success_value = array_filter(explode(',', $val['success']),'strlen');
						$failed_value = array_filter(explode(',', $val['failed']),'strlen');
						$pending_value = array_filter(explode(',', $val['pending']),'strlen');
					}
					elseif($val['value'] == 'OPTMSG')
					{
						$opt_msg = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'OPTREFID')
					{
						$opt_ref_id = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'TIMESTAMP')
					{
						$timestamp = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'MEMBERID')
					{
						$memberid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'BALANCE')
					{
						$balance = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'COMMISION')
					{
						$commision = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
				}
			}

		}
		elseif($response_type == 3)
		{
			$api_response = json_decode($output,true);
			if($responsePara)
			{
				foreach($responsePara as $key=>$val)
				{
					if($val['value'] == 'TXNID')
					{
						$txid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'STATUS')
					{
						$recharge_status = isset($api_response[$val['key']]) ? trim(strtolower($api_response[$val['key']])) : '';
						
						$success_value = array_filter(explode(',', $val['success']),'strlen');
						$failed_value = array_filter(explode(',', $val['failed']),'strlen');
						$pending_value = array_filter(explode(',', $val['pending']),'strlen');
					}
					elseif($val['value'] == 'OPTMSG')
					{
						$opt_msg = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'OPTREFID')
					{
						$opt_ref_id = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'TIMESTAMP')
					{
						$timestamp = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'MEMBERID')
					{
						$memberid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'BALANCE')
					{
						$balance = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'COMMISION')
					{
						$commision = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
				}
			}

		}

		
		
		$status = 0;
		if(in_array($recharge_status, $failed_value))
		{
			$status = 3;
		}
		elseif(in_array($recharge_status, $pending_value) || $recharge_status == '')
		{
			$status = 1;
		}
		elseif(in_array($recharge_status, $success_value))
		{
			$status = 2;
		}
		else
		{
			$status = 1;
		}
		
		
		return array(
			'status' => $status,
			'txid' => $txid,
			'operator_ref' => $opt_ref_id,
			'api_timestamp' => $timestamp,
			'opt_msg' => $opt_msg,
			'memberid' => $memberid,
			'balance' => $balance,
			'commision' => $commision,
			'api_response_id' => $api_response_id,
		);
		
	}
	
	public function postpaid_rechage_api($mobile,$operator_code,$circle_code,$amount,$recharge_unique_id,$account_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		$api_url = RECHARGE_API_URL.'memberid='.RECHARGE_MEMBERID.'&pin='.RECHARGE_API_PIN.'&number='.$mobile.'&operator='.$operator_code.'&circle='.$circle_code.'&amount='.$amount.'&account='.$mobile.'&usertx='.$recharge_unique_id;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);	
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);	
		$output = curl_exec($ch); 
		curl_close($ch);
		
		// save api response
		$apiData = array(
			'account_id' => $domain_account_id,
			'user_id' => $account_id,
			'mobile' => $mobile,
			'operator' => $operator_code,
			'circle' => $circle_code,
			'amount' => $amount,
			'recharge_id' => $recharge_unique_id,
			'account_no' => $account,
			'api_response' => $output,
			'status' => 1,
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('api_response',$apiData);
		$api_response_id = $this->db->insert_id();
		
		$api_response = explode(',',$output);
		$recharge_status = isset($api_response[1]) ? strtolower($api_response[1]) : '';
		$txid = isset($api_response[0]) ? strtolower($api_response[0]) : '';
		$operator_ref = isset($api_response[3]) ? strtolower($api_response[3]) : '';
		$api_timestamp = isset($api_response[4]) ? strtolower($api_response[4]) : '';
		if($api_timestamp){
			$position = strpos($api_timestamp, 'M');
			$api_timestamp = substr($api_timestamp,0,$position+1);
		}
		$status = 0;
		if($recharge_status == 'failure')
		{
			$status = 3;
		}
		elseif($recharge_status == 'pending')
		{
			$status = 1;
		}
		elseif($recharge_status == 'success' || $recharge_status == '' )
		{
			$status = 2;
		}
		
		return array(
			'status' => $status,
			'txid' => $txid,
			'operator_ref' => $operator_ref,
			'api_timestamp' => $api_timestamp,
			'api_response_id' => $api_response_id
		);
	}
	
	
	public function getElectricityOperatorDetail($operator_code = '')
	{
		$domain_account_id = $this->User->get_domain_account();
		$url = ELECTRICITY_RECHARGE_FETCH_API_URL.'memberid='.RECHARGE_MEMBERID.'&pin='.RECHARGE_API_PIN.'&sp_key='.$operator_code;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);		
		$output = curl_exec($ch); 
		curl_close($ch);
		
		$api_response = explode('#',$output);
		
		$response = array();
		
		if(isset($api_response[0]) && $api_response[0])
		{
			$status_response = explode(',',$api_response[0]);
			
			if(isset($status_response[1]) && $status_response[1] == 'Success')
			{
				$billDetail = (array) json_decode($api_response[1]);
				if(isset($billDetail['data'][0]->params))
				{
					$billFieldDetail = (array) json_decode($billDetail['data'][0]->params);
					$response = array(
						'status' => 1,
						'msg' => 'Success',
						'fieldName' => $billFieldDetail[0]->name,
						'fieldOther' => $billFieldDetail[0]->Other,
						'minLength' => $billFieldDetail[0]->MinLength,
						'maxLength' => $billFieldDetail[0]->MaxLength,
					);
				}
				else
				{
					$response = array(
						'status' => 0,
						'msg' => 'Operator is not activated.'
					);
				}
				
			}
			else
			{
				$response = array(
					'status' => 0,
					'msg' => 'Operator is not activated.'
				);
			}
			
		}
		else
		{
			$response = array(
				'status' => 0,
				'msg' => 'Operator is not activated.'
			);
		}
		
		return $response;
		
		
	}
	
	public function getElectricityOperatorBillerDetail($operator_code = '',$account_number = '',$account_id = 0)
	{
		
		if($account_id){
			// get user mobile
			$get_user_mobile = $this->db->select('mobile')->get_where('users',array('id'=>$account_id))->row_array();
			$mobile = isset($get_user_mobile['mobile']) ? $get_user_mobile['mobile'] : '';
			

			$url = ELECTRICITY_RECHARGE_FETCH_CUSTOMER_API_URL.'memberid='.RECHARGE_MEMBERID.'&pin='.RECHARGE_API_PIN.'&sp_key='.$operator_code.'&agentid='.$account_id.'&customer_mobile='.$mobile.'&servicenum='.$account_number;
			
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);	
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
			curl_setopt($ch, CURLOPT_TIMEOUT, 30);	
			$output = curl_exec($ch); 
			curl_close($ch);
			
			$api_response = explode('#',$output);
		
			
			$response = array();
			
			if(isset($api_response[0]) && $api_response[0])
			{
				$status_response = explode(',',$api_response[0]);
				
				
				if(isset($status_response[1]) && $status_response[1] == 'Success')
				{
					$billDetail = (array) json_decode($api_response[1]);
					
					if(isset($billDetail['data']->dueamount))
					{
						$response = array(
							'status' => 1,
							'msg' => 'Success',
							'amount' => $billDetail['data']->dueamount,
							'customername' => $billDetail['data']->customername,
							'reference_id' => $billDetail['data']->reference_id,
						);
					}
					else
					{
						$response = array(
							'status' => 0,
							'msg' => 'Biller is not valid.'
						);
					}
					
				}
				else
				{
					$response = array(
						'status' => 0,
						'msg' => 'Biller is not valid.'
					);
				}
				
			}
			else
			{
				$response = array(
					'status' => 0,
					'msg' => 'Biller is not valid.'
				);
			}
		}
		else
		{
			$response = array(
				'status' => 0,
				'msg' => 'Please login for getting the biller detail.'
			);
		}
		
		return $response;
		
		
	}
	
	public function electricity_rechage_api($account_number,$operator_code,$amount,$reference_id,$recharge_unique_id,$account_id = 0,$mobile,$customer_mobile = '')
	{
		$domain_account_id = $this->User->get_domain_account();
		/*$api_url = ELECTRICITY_RECHARGE_API_URL.'memberid='.RECHARGE_MEMBERID.'&pin='.RECHARGE_API_PIN.'&number='.$account_number.'&operator='.$operator_code.'&circle=1&amount='.$amount.'&account='.$reference_id.'&usertx='.$recharge_unique_id.'&format=csv&CustomerMobile='.$customer_mobile;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);		
		$output = curl_exec($ch); 
		curl_close($ch);
		
		// save api response
		$apiData = array(
			'account_id' => $domain_account_id,
			'user_id' => $account_id,
			'recharge_id' => $recharge_unique_id,
			'api_response' => $output,
			'api_url' => $api_url,
			'status' => 1,
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('api_response',$apiData);
		$api_response_id = $this->db->insert_id();
		
		$api_response = explode(',',$output);
		$recharge_status = isset($api_response[1]) ? strtolower($api_response[1]) : '';
		$txid = isset($api_response[0]) ? strtolower($api_response[0]) : '';
		$operator_ref = isset($api_response[3]) ? strtolower($api_response[3]) : '';
		$api_timestamp = isset($api_response[4]) ? strtolower($api_response[4]) : '';
		
		$status = 0;
		if($recharge_status == '' || $recharge_status == 'failed')
		{
			$status = 3;
		}
		elseif($recharge_status == 'pending')
		{
			$status = 1;
		}
		elseif($recharge_status == 'success')
		{
			$status = 2;
		}*/

		$status = 1;
		$txid = '';
		$operator_ref = '';
		$api_timestamp = '';
		$api_response_id = 0;
		
		return array(
			'status' => $status,
			'txid' => $txid,
			'operator_ref' => $operator_ref,
			'api_timestamp' => $api_timestamp,
			'api_response_id' => $api_response_id
		);
		
	}

	public function distribute_recharge_commision($recharge_id, $recharge_unique_id, $amount, $account_id, $domain_account_id = 0)
	{

		$member_package_id = $this->User->getMemberPackageID($account_id);
		if($domain_account_id == 0)
		{
			$domain_account_id = $this->User->get_domain_account();
		}
		$accountData = $this->User->get_account_data($domain_account_id);

		// get account role id
		$get_role_id = $this->db->select('role_id')->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['role_id']) ? $get_role_id['role_id'] : 0 ;

		// save system log
        $log_msg = '['.date('d-m-Y H:i:s').' - Account Role ID - '.$user_role_id.']'.PHP_EOL;
        $this->User->generateLog($log_msg);
		if($user_role_id == 3)
		{
			// get operator id
			$get_recharge_data = $this->db->select('recharge_history.api_id,recharge_history.operator_code')->get_where('recharge_history',array('recharge_history.id'=>$recharge_id,'recharge_history.account_id'=>$domain_account_id))->row_array();
			$api_id = isset($get_recharge_data['api_id']) ? $get_recharge_data['api_id'] : 0 ;
			$operator_code = isset($get_recharge_data['operator_code']) ? $get_recharge_data['operator_code'] : '' ;

			$op_id = 0;
			if($api_id && $operator_code)
			{
				if($accountData['account_type'] == 2)
                {
					// get operator id
					$get_op_id = $this->db->select('api_operator.opt_id')->get_where('api_operator',array('api_operator.account_id'=>SUPERADMIN_ACCOUNT_ID,'api_operator.api_id'=>$api_id,'api_operator.opt_code'=>$operator_code))->row_array();
				}
				else
				{
					// get operator id
					$get_op_id = $this->db->select('api_operator.opt_id')->get_where('api_operator',array('api_operator.account_id'=>$domain_account_id,'api_operator.api_id'=>$api_id,'api_operator.opt_code'=>$operator_code))->row_array();
				}
				$op_id = isset($get_op_id['opt_id']) ? $get_op_id['opt_id'] : 0 ;
			}



			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Operator ID - '.$op_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($op_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];

                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$is_surcharge = $get_comm['is_surcharge'];
					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}

				

			}
		}
		elseif($user_role_id == 6)
		{
			// get operator id
			$get_recharge_data = $this->db->select('recharge_history.api_id,recharge_history.operator_code')->get_where('recharge_history',array('recharge_history.id'=>$recharge_id,'recharge_history.account_id'=>$domain_account_id))->row_array();
			$api_id = isset($get_recharge_data['api_id']) ? $get_recharge_data['api_id'] : 0 ;
			$operator_code = isset($get_recharge_data['operator_code']) ? $get_recharge_data['operator_code'] : '' ;

			$op_id = 0;
			if($api_id && $operator_code)
			{
				if($accountData['account_type'] == 2)
                {
					// get operator id
					$get_op_id = $this->db->select('api_operator.opt_id')->get_where('api_operator',array('api_operator.account_id'=>SUPERADMIN_ACCOUNT_ID,'api_operator.api_id'=>$api_id,'api_operator.opt_code'=>$operator_code))->row_array();
				}
				else
				{
					// get operator id
					$get_op_id = $this->db->select('api_operator.opt_id')->get_where('api_operator',array('api_operator.account_id'=>$domain_account_id,'api_operator.api_id'=>$api_id,'api_operator.opt_code'=>$operator_code))->row_array();
				}
				$op_id = isset($get_op_id['opt_id']) ? $get_op_id['opt_id'] : 0 ;
			}

			

			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Operator ID - '.$op_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($op_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];

                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['api_commision'];
					$is_flat = $get_comm['api_is_flat'];
					$is_surcharge = $get_comm['api_is_surcharge'];
					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}

				

			}
		}
		elseif($user_role_id == 4)
		{
			// get operator id
			$get_recharge_data = $this->db->select('recharge_history.api_id,recharge_history.operator_code')->get_where('recharge_history',array('recharge_history.id'=>$recharge_id,'recharge_history.account_id'=>$domain_account_id))->row_array();
			$api_id = isset($get_recharge_data['api_id']) ? $get_recharge_data['api_id'] : 0 ;
			$operator_code = isset($get_recharge_data['operator_code']) ? $get_recharge_data['operator_code'] : '' ;

			$op_id = 0;
			if($api_id && $operator_code)
			{
				if($accountData['account_type'] == 2)
                {
					// get operator id
					$get_op_id = $this->db->select('api_operator.opt_id')->get_where('api_operator',array('api_operator.account_id'=>SUPERADMIN_ACCOUNT_ID,'api_operator.api_id'=>$api_id,'api_operator.opt_code'=>$operator_code))->row_array();
				}
				else
				{
					// get operator id
					$get_op_id = $this->db->select('api_operator.opt_id')->get_where('api_operator',array('api_operator.account_id'=>$domain_account_id,'api_operator.api_id'=>$api_id,'api_operator.opt_code'=>$operator_code))->row_array();
				}
				$op_id = isset($get_op_id['opt_id']) ? $get_op_id['opt_id'] : 0 ;
			}

			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Operator ID - '.$op_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($op_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];

                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['dt_commision'];
					$is_flat = $get_comm['dt_is_flat'];
					$is_surcharge = $get_comm['dt_is_surcharge'];

					$total_distribute_amount = 0;

					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
						$total_distribute_amount+=$charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}

				
				$md_id = $this->User->get_master_distributor_id($account_id);

				$md_package_id = $this->User->getMemberPackageID($md_id);

				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Master Distributor ID - '.$md_id.']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				// get master distribution recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$md_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$md_is_surcharge = $get_comm['is_surcharge'];
					if($md_is_surcharge)
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}

					}
					else
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}
						
					}
					$remaining_charge_amount = 0;
					$deduct_charge_amount = 0;
					if($is_surcharge && !$md_is_surcharge)
					{
						$remaining_charge_amount = $charge_amount + $md_charge_amount;
					}
					elseif($is_surcharge && $md_is_surcharge)
					{
						$remaining_charge_amount = $charge_amount - $md_charge_amount;
						if($charge_amount < $md_charge_amount)
						{
							$deduct_charge_amount = $md_charge_amount - $charge_amount;
						}
						$total_distribute_amount+=$remaining_charge_amount;
					}
					else
					{
						if($md_charge_amount >= $charge_amount)
						{
							$remaining_charge_amount = $md_charge_amount - $charge_amount;
							$total_distribute_amount+=$remaining_charge_amount;
						}
						else
						{
							$remaining_charge_amount = $charge_amount - $md_charge_amount;
							$deduct_charge_amount = $charge_amount - $md_charge_amount;
						}
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Charge Amount - '.$md_charge_amount.' - Credit Amount - '.$remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($remaining_charge_amount > 0)
					{
						$after_balance = $before_balance + $remaining_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $md_is_surcharge,
							'commision_amount' => $md_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $remaining_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
					elseif($remaining_charge_amount < 0)
					{
						$after_balance = $before_balance - $deduct_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $md_is_surcharge,
							'commision_amount' => $md_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $deduct_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Deduction.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
				}

				
			}
		}
		elseif($user_role_id == 5)
		{
			// get operator id
			$get_recharge_data = $this->db->select('recharge_history.api_id,recharge_history.operator_code')->get_where('recharge_history',array('recharge_history.id'=>$recharge_id,'recharge_history.account_id'=>$domain_account_id))->row_array();
			$api_id = isset($get_recharge_data['api_id']) ? $get_recharge_data['api_id'] : 0 ;
			$operator_code = isset($get_recharge_data['operator_code']) ? $get_recharge_data['operator_code'] : '' ;

			$op_id = 0;
			if($api_id && $operator_code)
			{
				if($accountData['account_type'] == 2)
                {
					// get operator id
					$get_op_id = $this->db->select('api_operator.opt_id')->get_where('api_operator',array('api_operator.account_id'=>SUPERADMIN_ACCOUNT_ID,'api_operator.api_id'=>$api_id,'api_operator.opt_code'=>$operator_code))->row_array();
				}
				else
				{
					// get operator id
					$get_op_id = $this->db->select('api_operator.opt_id')->get_where('api_operator',array('api_operator.account_id'=>$domain_account_id,'api_operator.api_id'=>$api_id,'api_operator.opt_code'=>$operator_code))->row_array();
				}
				$op_id = isset($get_op_id['opt_id']) ? $get_op_id['opt_id'] : 0 ;
			}

			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Operator ID - '.$op_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($op_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['rt_commision'];
					$is_flat = $get_comm['rt_is_flat'];
					$is_surcharge = $get_comm['rt_is_surcharge'];

					$total_distribute_amount = 0;

					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
						$total_distribute_amount+=$charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}

				
				$distributor_id = $this->User->get_distributor_id($account_id,$domain_account_id);

				$distributor_package_id = $this->User->getMemberPackageID($distributor_id);

				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor ID - '.$distributor_id.']'.PHP_EOL;
        		$this->User->generateLog($log_msg);

				// get master distribution recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$distributor_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);

				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					$commision = $get_comm['dt_commision'];
					$is_flat = $get_comm['dt_is_flat'];
					$dist_is_surcharge = $get_comm['dt_is_surcharge'];
					if($dist_is_surcharge)
					{
						$dist_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$dist_charge_amount = $commision;
						}

					}
					else
					{
						$dist_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$dist_charge_amount = $commision;
						}
						
					}
					$remaining_charge_amount = 0;
					$deduct_charge_amount = 0;
					if($is_surcharge && $dist_is_surcharge)
					{
						$remaining_charge_amount = $charge_amount - $dist_charge_amount;
						if($charge_amount < $dist_charge_amount)
						{
							$deduct_charge_amount = $dist_charge_amount - $charge_amount;
						}
						$total_distribute_amount+=$remaining_charge_amount;
					}
					else
					{
						if($dist_charge_amount >= $charge_amount)
						{
							$remaining_charge_amount = $dist_charge_amount - $charge_amount;
							$total_distribute_amount+=$remaining_charge_amount;
						}
						else
						{
							$remaining_charge_amount = $charge_amount - $dist_charge_amount;
							$deduct_charge_amount = $charge_amount - $dist_charge_amount;
						}
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor Charge Amount - '.$dist_charge_amount.' - Credit Amount - '.$remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					

					if($remaining_charge_amount > 0)
					{
						$after_balance = $before_balance + $remaining_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $remaining_charge_amount,
							'commision_amount' => $dist_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $remaining_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
					elseif($remaining_charge_amount < 0)
					{
						$after_balance = $before_balance - $deduct_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $deduct_charge_amount,
							'commision_amount' => $dist_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $deduct_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Deduction.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
				}

				$total_downline_com = $charge_amount + $remaining_charge_amount;
				$md_id = $this->User->get_master_distributor_id($distributor_id,$domain_account_id);

				$md_package_id = $this->User->getMemberPackageID($md_id);

				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Master Distributor ID - '.$md_id.']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				// get master distribution recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$md_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$md_is_surcharge = $get_comm['is_surcharge'];
					if($md_is_surcharge)
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}

					}
					else
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}
						
					}
					$md_remaining_charge_amount = 0;
					$deduct_charge_amount = 0;
					if($is_surcharge && $md_is_surcharge && $dist_is_surcharge)
					{
						$md_remaining_charge_amount = $dist_charge_amount - $md_charge_amount;
						if($dist_charge_amount < $md_charge_amount)
						{
							$deduct_charge_amount = $md_charge_amount - $dist_charge_amount;
						}
						$total_distribute_amount+=$md_remaining_charge_amount;
					}
					else
					{
						if($md_charge_amount >= $total_downline_com)
						{
							$md_remaining_charge_amount = $md_charge_amount - $total_downline_com;
							$total_distribute_amount+=$md_remaining_charge_amount;
						}
						else
						{
							$md_remaining_charge_amount = $total_downline_com - $md_charge_amount;
							$deduct_charge_amount = $total_downline_com - $md_charge_amount;
						}
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Charge Amount - '.$md_charge_amount.' - Credit Amount - '.$md_remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					
					if($md_remaining_charge_amount > 0)
					{
						$after_balance = $before_balance + $md_remaining_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $md_is_surcharge,
							'commision_amount' => $md_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $md_remaining_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
					elseif($md_remaining_charge_amount < 0)
					{
						$after_balance = $before_balance - $deduct_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $md_is_surcharge,
							'commision_amount' => $md_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $deduct_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Recharge #'.$recharge_unique_id.' Commision Deduction.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
				}


				

			}
		}
		
	}

	public function distribute_electricity_commision($recharge_id, $recharge_unique_id, $amount, $account_id, $domain_account_id = 0)
	{
		$member_package_id = $this->User->getMemberPackageID($account_id);
		if($domain_account_id == 0)
		{
			$domain_account_id = $this->User->get_domain_account();
		}
		// get account role id
		$get_role_id = $this->db->select('role_id')->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['role_id']) ? $get_role_id['role_id'] : 0 ;
		// save system log
        $log_msg = '['.date('d-m-Y H:i:s').' - Account Role ID - '.$user_role_id.']'.PHP_EOL;
        $this->User->generateLog($log_msg);
		if($user_role_id == 3 || $user_role_id == 6)
		{
			// get operator id
			$get_recharge_data = $this->db->select('recharge_history.operator_code')->get_where('recharge_history',array('recharge_history.id'=>$recharge_id,'recharge_history.account_id'=>$domain_account_id))->row_array();
			$operator_code = isset($get_recharge_data['operator_code']) ? $get_recharge_data['operator_code'] : '' ;

			$op_id = 0;
			if($operator_code)
			{
				// get operator id
				$get_op_id = $this->db->select('operator.id')->get_where('operator',array('operator.operator_code'=>$operator_code))->row_array();
				$op_id = isset($get_op_id['id']) ? $get_op_id['id'] : 0 ;
			}

			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Operator ID - '.$op_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($op_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];

                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$is_surcharge = $get_comm['is_surcharge'];
					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'ELECTRICITY',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}
			}
		}
		elseif($user_role_id == 4)
		{
			// get operator id
			$get_recharge_data = $this->db->select('recharge_history.api_id,recharge_history.operator_code')->get_where('recharge_history',array('recharge_history.id'=>$recharge_id,'recharge_history.account_id'=>$domain_account_id))->row_array();
			$api_id = isset($get_recharge_data['api_id']) ? $get_recharge_data['api_id'] : 0 ;
			$operator_code = isset($get_recharge_data['operator_code']) ? $get_recharge_data['operator_code'] : '' ;

			$op_id = 0;
			if($operator_code)
			{
				// get operator id
				$get_op_id = $this->db->select('operator.id')->get_where('operator',array('operator.operator_code'=>$operator_code))->row_array();
				$op_id = isset($get_op_id['id']) ? $get_op_id['id'] : 0 ;
			}

			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Operator ID - '.$op_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($op_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];

                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$is_surcharge = $get_comm['is_surcharge'];
					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'ELECTRICITY',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}

				
				$md_id = $this->User->get_master_distributor_id($account_id);

				$md_package_id = $this->User->getMemberPackageID($md_id);

				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Master Distributor ID - '.$md_id.']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				// get master distribution recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$md_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$md_is_surcharge = $get_comm['is_surcharge'];
					if($md_is_surcharge)
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}

					}
					else
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}
						
					}
					$remaining_charge_amount = 0;
					$deduct_charge_amount = 0;
					if($is_surcharge && !$md_is_surcharge)
					{
						$remaining_charge_amount = $charge_amount + $md_charge_amount;
					}
					elseif($is_surcharge && $md_is_surcharge)
					{
						$remaining_charge_amount = $charge_amount - $md_charge_amount;
						if($charge_amount < $md_charge_amount)
						{
							$deduct_charge_amount = $md_charge_amount - $charge_amount;
						}
					}
					else
					{
						if($md_charge_amount > $charge_amount)
						{
							$remaining_charge_amount = $md_charge_amount - $charge_amount;
						}
						else
						{
							$remaining_charge_amount = $charge_amount - $md_charge_amount;
							$deduct_charge_amount = $charge_amount - $md_charge_amount;
						}
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Charge Amount - '.$md_charge_amount.' - Credit Amount - '.$remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($remaining_charge_amount > 0)
					{
						$after_balance = $before_balance + $remaining_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'ELECTRICITY',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $remaining_charge_amount,
							'commision_amount' => $md_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $remaining_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
					elseif($remaining_charge_amount < 0)
					{
						$after_balance = $before_balance - $deduct_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'ELECTRICITY',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $deduct_charge_amount,
							'commision_amount' => $md_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $deduct_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Deduction.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
				}
			}
		}
		elseif($user_role_id == 5)
		{
			// get operator id
			$get_recharge_data = $this->db->select('recharge_history.api_id,recharge_history.operator_code')->get_where('recharge_history',array('recharge_history.id'=>$recharge_id,'recharge_history.account_id'=>$domain_account_id))->row_array();
			$api_id = isset($get_recharge_data['api_id']) ? $get_recharge_data['api_id'] : 0 ;
			$operator_code = isset($get_recharge_data['operator_code']) ? $get_recharge_data['operator_code'] : '' ;

			$op_id = 0;
			if($operator_code)
			{
				// get operator id
				$get_op_id = $this->db->select('operator.id')->get_where('operator',array('operator.operator_code'=>$operator_code))->row_array();
				$op_id = isset($get_op_id['id']) ? $get_op_id['id'] : 0 ;
			}

			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Operator ID - '.$op_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($op_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$is_surcharge = $get_comm['is_surcharge'];
					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'ELECTRICITY',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}

				
				$distributor_id = $this->User->get_distributor_id($account_id);

				$distributor_package_id = $this->User->getMemberPackageID($distributor_id);

				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor ID - '.$distributor_id.']'.PHP_EOL;
        		$this->User->generateLog($log_msg);

				// get master distribution recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$distributor_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);

				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$dist_is_surcharge = $get_comm['is_surcharge'];
					if($dist_is_surcharge)
					{
						$dist_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$dist_charge_amount = $commision;
						}

					}
					else
					{
						$dist_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$dist_charge_amount = $commision;
						}
						
					}
					$remaining_charge_amount = 0;
					$deduct_charge_amount = 0;
					if($is_surcharge && $dist_is_surcharge)
					{
						$remaining_charge_amount = $charge_amount - $dist_charge_amount;
						if($charge_amount < $dist_charge_amount)
						{
							$deduct_charge_amount = $dist_charge_amount - $charge_amount;
						}
					}
					else
					{
						if($dist_charge_amount > $charge_amount)
						{
							$remaining_charge_amount = $dist_charge_amount - $charge_amount;
						}
						else
						{
							$remaining_charge_amount = $charge_amount - $dist_charge_amount;
							$deduct_charge_amount = $charge_amount - $dist_charge_amount;
						}
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor Charge Amount - '.$dist_charge_amount.' - Credit Amount - '.$remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					

					if($remaining_charge_amount > 0)
					{
						$after_balance = $before_balance + $remaining_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'ELECTRICITY',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $remaining_charge_amount,
							'commision_amount' => $dist_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $remaining_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
					elseif($remaining_charge_amount < 0)
					{
						$after_balance = $before_balance - $deduct_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'ELECTRICITY',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $deduct_charge_amount,
							'commision_amount' => $dist_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $deduct_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Deduction.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
				}

				$total_downline_com = $charge_amount + $remaining_charge_amount;
				$md_id = $this->User->get_master_distributor_id($distributor_id);

				$md_package_id = $this->User->getMemberPackageID($md_id);

				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Master Distributor ID - '.$md_id.']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				// get master distribution recharge commision
				$get_comm = $this->db->get_where('recharge_commision',array('account_id'=>$domain_account_id,'package_id'=>$md_package_id,'op_id'=>$op_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$md_is_surcharge = $get_comm['is_surcharge'];
					if($md_is_surcharge)
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}

					}
					else
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}
						
					}
					$md_remaining_charge_amount = 0;
					$deduct_charge_amount = 0;
					if($is_surcharge && $md_is_surcharge && $dist_is_surcharge)
					{
						$md_remaining_charge_amount = $dist_charge_amount - $md_charge_amount;
						if($dist_charge_amount < $md_charge_amount)
						{
							$deduct_charge_amount = $md_charge_amount - $dist_charge_amount;
						}
					}
					else
					{
						if($md_charge_amount > $total_downline_com)
						{
							$md_remaining_charge_amount = $md_charge_amount - $total_downline_com;
						}
						else
						{
							$md_remaining_charge_amount = $total_downline_com - $md_charge_amount;
							$deduct_charge_amount = $total_downline_com - $md_charge_amount;
						}
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Charge Amount - '.$md_charge_amount.' - Credit Amount - '.$md_remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					
					if($md_remaining_charge_amount > 0)
					{
						$after_balance = $before_balance + $md_remaining_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'ELECTRICITY',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $md_remaining_charge_amount,
							'commision_amount' => $md_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $md_remaining_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
					elseif($md_remaining_charge_amount < 0)
					{
						$after_balance = $before_balance - $deduct_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'ELECTRICITY',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $deduct_charge_amount,
							'commision_amount' => $md_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $deduct_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2,      
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Electricity #'.$recharge_unique_id.' Commision Deduction.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
				}
			}
		}
		
	}

	public function get_admin_dmr_surcharge($amount = 0, $loggedAccountID = 0)
	{
		$surcarge_amount = 0;
		$domain_account_id = $this->User->get_domain_account();
		$package_id = $this->User->get_account_package_id($domain_account_id);
		// get surcharge
		$getSurcharge = $this->db->get_where('dmr_commision',array('account_id'=>10000,'package_id'=>$package_id,'start_range <='=>$amount,'end_range >='=>$amount))->row_array();
		if($getSurcharge)
		{
			$surcharge = $getSurcharge['surcharge'];
			$is_flat = $getSurcharge['is_flat'];

			$surcarge_amount = round(($surcharge/100)*$amount,2);

			if($is_flat)
			{
				$surcarge_amount = $surcharge;
			}
		}
		return $surcarge_amount;
	}

	public function get_dmr_surcharge($amount = 0, $loggedAccountID = 0)
	{
		$member_package_id = $this->User->getMemberPackageID($loggedAccountID);
		$member_role_id = $this->User->getMemberRoleID($loggedAccountID);
		$surcarge_amount = 0;
		$domain_account_id = $this->User->get_domain_account();
		// get surcharge
		$getSurcharge = $this->db->get_where('dmr_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'start_range <='=>$amount,'end_range >='=>$amount))->row_array();
		
		if($getSurcharge)
		{
			$is_flat = $getSurcharge['is_flat'];
			if($member_role_id == 3)
			{
				$surcharge = $getSurcharge['md_charge'];
			}
			elseif($member_role_id == 4)
			{
				$surcharge = $getSurcharge['dt_charge'];
			}
			elseif($member_role_id == 5)
			{
				$surcharge = $getSurcharge['rt_charge'];
			}
			elseif($member_role_id == 6)
			{
				$surcharge = $getSurcharge['api_charge'];
			}
			elseif($member_role_id == 8)
			{
				$surcharge = $getSurcharge['user_charge'];
			}
			

			$surcarge_amount = round(($surcharge/100)*$amount,2);

			if($is_flat)
			{
				$surcarge_amount = $surcharge;
			}
		}
		return $surcarge_amount;
	}


	public function get_admin_payout_surcharge($amount = 0, $loggedAccountID = 0)
	{
		$surcarge_amount = 0;
		$domain_account_id = $this->User->get_domain_account();
		$package_id = $this->User->get_account_package_id($domain_account_id);
		// get surcharge
		$getSurcharge = $this->db->get_where('payout_commision',array('account_id'=>10000,'package_id'=>$package_id,'start_range <='=>$amount,'end_range >='=>$amount))->row_array();
		if($getSurcharge)
		{
			$surcharge = $getSurcharge['surcharge'];
			$is_flat = $getSurcharge['is_flat'];

			$surcarge_amount = round(($surcharge/100)*$amount,2);

			if($is_flat)
			{
				$surcarge_amount = $surcharge;
			}
		}
		return $surcarge_amount;

	}


	public function get_admin_van_surcharge($amount = 0, $loggedAccountID = 0)
	{
		$surcarge_amount = 0;
		$domain_account_id = $this->User->get_domain_account();
		$package_id = $this->User->get_account_package_id($domain_account_id);
		// get surcharge
		$getSurcharge = $this->db->get_where('van_commision',array('account_id'=>10000,'package_id'=>$package_id,'start_range <='=>$amount,'end_range >='=>$amount))->row_array();
		if($getSurcharge)
		{
			$surcharge = $getSurcharge['surcharge'];
			$is_flat = $getSurcharge['is_flat'];

			$surcarge_amount = round(($surcharge/100)*$amount,2);

			if($is_flat)
			{
				$surcarge_amount = $surcharge;
			}
		}
		return $surcarge_amount;

	}


	public function get_payout_surcharge($amount = 0, $loggedAccountID = 0)
	{
		$member_package_id = $this->User->getMemberPackageID($loggedAccountID);
		$member_role_id = $this->User->getMemberRoleID($loggedAccountID);
		$surcarge_amount = 0;
		$domain_account_id = $this->User->get_domain_account();
		// get surcharge
		$getSurcharge = $this->db->get_where('payout_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'start_range <='=>$amount,'end_range >='=>$amount))->row_array();
		
		if($getSurcharge)
		{
			$is_flat = $getSurcharge['is_flat'];
			if($member_role_id == 3)
			{
				$surcharge = $getSurcharge['md_charge'];
			}
			elseif($member_role_id == 4)
			{
				$surcharge = $getSurcharge['dt_charge'];
			}
			elseif($member_role_id == 5)
			{
				$surcharge = $getSurcharge['rt_charge'];
			}
			elseif($member_role_id == 6)
			{
				$surcharge = $getSurcharge['api_charge'];
			}
			elseif($member_role_id == 8)
			{
				$surcharge = $getSurcharge['user_charge'];
			}
			

			$surcarge_amount = round(($surcharge/100)*$amount,2);

			if($is_flat)
			{
				$surcarge_amount = $surcharge;
			}
		}
		return $surcarge_amount;
	}



	public function get_van_surcharge($amount = 0, $loggedAccountID = 0)
	{
		$member_package_id = $this->User->getMemberPackageID($loggedAccountID);
		$member_role_id = $this->User->getMemberRoleID($loggedAccountID);
		$surcarge_amount = 0;
		$domain_account_id = $this->User->get_domain_account();
		// get surcharge
		$getSurcharge = $this->db->get_where('van_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'start_range <='=>$amount,'end_range >='=>$amount))->row_array();
		
		if($getSurcharge)
		{
			$is_flat = $getSurcharge['is_flat'];
			if($member_role_id == 3)
			{
				$surcharge = $getSurcharge['md_charge'];
			}
			elseif($member_role_id == 4)
			{
				$surcharge = $getSurcharge['dt_charge'];
			}
			elseif($member_role_id == 5)
			{
				$surcharge = $getSurcharge['rt_charge'];
			}
			elseif($member_role_id == 6)
			{
				$surcharge = $getSurcharge['api_charge'];
			}
			elseif($member_role_id == 8)
			{
				$surcharge = $getSurcharge['user_charge'];
			}
			

			$surcarge_amount = round(($surcharge/100)*$amount,2);

			if($is_flat)
			{
				$surcarge_amount = $surcharge;
			}
		}
		return $surcarge_amount;
	}



	public function get_xpress_payout_surcharge($amount = 0, $loggedAccountID = 0)
	{
		$member_package_id = $this->User->getMemberPackageID($loggedAccountID);
		$member_role_id = $this->User->getMemberRoleID($loggedAccountID);
		$surcarge_amount = 0;
		$domain_account_id = $this->User->get_domain_account();
		// get surcharge
		$getSurcharge = $this->db->get_where('xpress_payout_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'start_range <='=>$amount,'end_range >='=>$amount))->row_array();
		
		if($getSurcharge)
		{
			$is_flat = $getSurcharge['is_flat'];
			if($member_role_id == 3)
			{
				$surcharge = $getSurcharge['md_charge'];
			}
			elseif($member_role_id == 4)
			{
				$surcharge = $getSurcharge['dt_charge'];
			}
			elseif($member_role_id == 5)
			{
				$surcharge = $getSurcharge['rt_charge'];
			}
			elseif($member_role_id == 6)
			{
				$surcharge = $getSurcharge['api_charge'];
			}
			elseif($member_role_id == 8)
			{
				$surcharge = $getSurcharge['user_charge'];
			}
			

			$surcarge_amount = round(($surcharge/100)*$amount,2);

			if($is_flat)
			{
				$surcarge_amount = $surcharge;
			}
		}
		return $surcarge_amount;
	}


	public function get_aeps_commission($amount = 0, $loggedAccountID = 0, $com_type = 0)
	{
		$member_package_id = $this->User->getMemberPackageID($loggedAccountID);
		$member_role_id = $this->User->getMemberRoleID($loggedAccountID);
		$is_surcharge = 0;
		$domain_account_id = $this->User->get_domain_account();
		$commission_amount = 0;
		// get surcharge
		$getSurcharge = $this->db->get_where('aeps_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'start_range <='=>$amount,'end_range >='=>$amount,'com_type'=>$com_type))->row_array();
		if($getSurcharge)
		{
			$is_flat = $getSurcharge['is_flat'];
			$is_surcharge = $getSurcharge['is_surcharge'];
			if($member_role_id == 3)
			{
				$commission = $getSurcharge['md_commision'];
			}
			elseif($member_role_id == 4)
			{
				$commission = $getSurcharge['dt_commision'];
			}
			elseif($member_role_id == 5)
			{
				$commission = $getSurcharge['rt_commision'];
			}
			elseif($member_role_id == 6)
			{
				$commission = $getSurcharge['api_commision'];
			}
			elseif($member_role_id == 8)
			{
				$commission = $getSurcharge['user_commision'];
			}
			if($commission)
			{
				$commission_amount = round(($commission/100)*$amount,2);
				if($is_flat)
				{
					$commission_amount = $commission;
				}
			}
		}
		return array('commission_amount'=>$commission_amount,'is_surcharge'=>$is_surcharge);
	}

	public function distribute_dmt_commision($dmt_id, $transaction_id, $amount, $account_id, $surcharge_amount,$user_type = '',$user_code = '')
	{

		$domain_account_id = $this->User->get_domain_account();
		// get account role id
		$get_role_id = $this->db->select('role_id')->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['role_id']) ? $get_role_id['role_id'] : 0 ;
		// save system log
	    $log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT Api - Distribute Commision/Surcharge - User Role - '.$user_role_id.']'.PHP_EOL;
	    $this->User->generateLog($log_msg);
        if($user_role_id == 4)
		{
			$md_id = $this->User->get_master_distributor_id($account_id);

			// get dmr surcharge
            $md_surcharge_amount = $this->User->get_dmr_surcharge($amount,$md_id);
            // save system log
	    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT Api - Distribute Commision/Surcharge - MD Charge - '.$md_surcharge_amount.']'.PHP_EOL;
	    	$this->User->generateLog($log_msg);

	    	if($surcharge_amount > $md_surcharge_amount)
	    	{
	    		$commision = $surcharge_amount - $md_surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT Api - Distribute Commision/Surcharge - MD Commision - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// credit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance + $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $md_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $md_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 1, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Fund Transfer #'.$transaction_id.' Commision Credited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$md_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}
	    	elseif($surcharge_amount < $md_surcharge_amount)
	    	{
	    		$commision = $md_surcharge_amount - $surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT Api - Distribute Commision/Surcharge - MD Charge - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// debit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance - $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $md_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'is_surcharge' => 1,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $md_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 2, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Fund Transfer #'.$transaction_id.' Charge Debited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$md_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}
            
		}
		elseif($user_role_id == 5)
		{
			$distributor_id = $this->User->get_distributor_id($account_id);

			// get dmr surcharge
            $dist_surcharge_amount = $this->User->get_dmr_surcharge($amount,$distributor_id);
            // save system log
	    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT Api - Distribute Commision/Surcharge - DT Charge - '.$dist_surcharge_amount.']'.PHP_EOL;
	    	$this->User->generateLog($log_msg);

	    	if($surcharge_amount > $dist_surcharge_amount)
	    	{
	    		$commision = $surcharge_amount - $dist_surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT Api - Distribute Commision/Surcharge - DT Commision - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// credit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance + $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $distributor_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $distributor_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 1, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Fund Transfer #'.$transaction_id.' Commision Credited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$distributor_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}
	    	elseif($surcharge_amount < $dist_surcharge_amount)
	    	{
	    		$commision = $dist_surcharge_amount - $surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT Api - Distribute Commision/Surcharge - DT Charge - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// debit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance - $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $distributor_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'is_surcharge' => 1,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $distributor_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 2, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Fund Transfer #'.$transaction_id.' Charge Debited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$distributor_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}

            $md_id = $this->User->get_master_distributor_id($distributor_id);

			// get dmr surcharge
            $md_surcharge_amount = $this->User->get_dmr_surcharge($amount,$md_id);
            
            // save system log
	    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT Api - Distribute Commision/Surcharge - MD Charge - '.$md_surcharge_amount.']'.PHP_EOL;
	    	$this->User->generateLog($log_msg);

	    	if($dist_surcharge_amount > $md_surcharge_amount)
	    	{
	    		$commision = $dist_surcharge_amount - $md_surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT Api - Distribute Commision/Surcharge - MD Commision - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// credit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance + $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $md_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $md_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 1, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Fund Transfer #'.$transaction_id.' Commision Credited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$md_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}
	    	elseif($dist_surcharge_amount < $md_surcharge_amount)
	    	{
	    		$commision = $md_surcharge_amount - $dist_surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT Api - Distribute Commision/Surcharge - MD Charge - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// debit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance - $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $md_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'is_surcharge' => 1,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $md_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 2, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Fund Transfer #'.$transaction_id.' Charge Debited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$md_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}
		}
	}

	public function distribute_payout_commision($dmt_id, $transaction_id, $amount, $account_id, $surcharge_amount,$user_type = '',$user_code = '')
	{

		$domain_account_id = $this->User->get_domain_account();
		// get account role id
		$get_role_id = $this->db->select('role_id')->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['role_id']) ? $get_role_id['role_id'] : 0 ;
		// save system log
	    $log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - Payout Api - Distribute Commision/Surcharge - User Role - '.$user_role_id.']'.PHP_EOL;
	    $this->User->generateLog($log_msg);
        if($user_role_id == 4)
		{
			$md_id = $this->User->get_master_distributor_id($account_id);

			// get dmr surcharge
            $md_surcharge_amount = $this->User->get_payout_surcharge($amount,$md_id);
            // save system log
	    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - Payout Api - Distribute Commision/Surcharge - MD Charge - '.$md_surcharge_amount.']'.PHP_EOL;
	    	$this->User->generateLog($log_msg);

	    	if($surcharge_amount > $md_surcharge_amount)
	    	{
	    		$commision = $surcharge_amount - $md_surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - Payout Api - Distribute Commision/Surcharge - MD Commision - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// credit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance + $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $md_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $md_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 1, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Payout #'.$transaction_id.' Commision Credited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$md_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}
	    	elseif($surcharge_amount < $md_surcharge_amount)
	    	{
	    		$commision = $md_surcharge_amount - $surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - Payout Api - Distribute Commision/Surcharge - MD Charge - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// debit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance - $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $md_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'is_surcharge' => 1,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $md_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 2, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Payout #'.$transaction_id.' Charge Debited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$md_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}
            
		}
		elseif($user_role_id == 5)
		{
			$distributor_id = $this->User->get_distributor_id($account_id);

			// get dmr surcharge
            $dist_surcharge_amount = $this->User->get_payout_surcharge($amount,$distributor_id);
            // save system log
	    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - Payout Api - Distribute Commision/Surcharge - DT Charge - '.$dist_surcharge_amount.']'.PHP_EOL;
	    	$this->User->generateLog($log_msg);

	    	if($surcharge_amount > $dist_surcharge_amount)
	    	{
	    		$commision = $surcharge_amount - $dist_surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - Payout Api - Distribute Commision/Surcharge - DT Commision - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// credit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance + $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $distributor_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $distributor_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 1, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Payout #'.$transaction_id.' Commision Credited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$distributor_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}
	    	elseif($surcharge_amount < $dist_surcharge_amount)
	    	{
	    		$commision = $dist_surcharge_amount - $surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - Payout Api - Distribute Commision/Surcharge - DT Charge - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// debit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance - $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $distributor_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'is_surcharge' => 1,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $distributor_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 2, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Payout #'.$transaction_id.' Charge Debited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$distributor_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}

            $md_id = $this->User->get_master_distributor_id($distributor_id);

			// get dmr surcharge
            $md_surcharge_amount = $this->User->get_payout_surcharge($amount,$md_id);
            
            // save system log
	    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - Payout Api - Distribute Commision/Surcharge - MD Charge - '.$md_surcharge_amount.']'.PHP_EOL;
	    	$this->User->generateLog($log_msg);

	    	if($dist_surcharge_amount > $md_surcharge_amount)
	    	{
	    		$commision = $dist_surcharge_amount - $md_surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - Payout Api - Distribute Commision/Surcharge - MD Commision - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// credit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance + $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $md_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $md_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 1, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Payout #'.$transaction_id.' Commision Credited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$md_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}
	    	elseif($dist_surcharge_amount < $md_surcharge_amount)
	    	{
	    		$commision = $md_surcharge_amount - $dist_surcharge_amount;
	    		// save system log
	    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - Payout Api - Distribute Commision/Surcharge - MD Charge - '.$commision.']'.PHP_EOL;
	    		$this->User->generateLog($log_msg);
	    		if($commision)
	    		{
	    			// debit wallet
	            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
					$before_balance = $accountBalanceData['aeps_wallet_balance'];
					$after_balance = $before_balance - $commision;

	            	$commisionData = array(
						'account_id' => $domain_account_id,
						'member_id' => $md_id,
						'type' => 'PAYOUT',
						'record_id' => $dmt_id,
						'is_surcharge' => 1,
						'commision_amount' => $commision,
						'is_downline' => 1,
						'downline_id' => $account_id,
						'before_balance' => $before_balance,
						'after_balance' => $after_balance,
						'status' => 1,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('user_commision',$commisionData);

					$wallet_data = array(
		                'account_id'          => $domain_account_id,
		                'member_id'           => $md_id,    
		                'before_balance'      => $before_balance,
		                'amount'              => $commision,  
		                'after_balance'       => $after_balance,      
		                'status'              => 1,
		                'type'                => 2, 
		                'wallet_type'		  => 2,       
		                'created'             => date('Y-m-d H:i:s'),      
		                'credited_by'         => $account_id,
		                'description'         => 'Payout #'.$transaction_id.' Charge Debited.'
	                );

	                $this->db->insert('member_wallet',$wallet_data);

	                $user_wallet = array(
	                    'aeps_wallet_balance'=>$after_balance,        
	                );    

	                $this->db->where('id',$md_id);
	                $this->db->where('account_id',$domain_account_id);
	                $this->db->update('users',$user_wallet); 
	    		}
	    	}
		}
	}

	public function distribute_money_transfer_commision($dmt_id, $transaction_id, $amount, $account_id, $surcharge_amount,$user_type = '',$user_code = '')
	{

		$domain_account_id = $this->User->get_domain_account();
		// get account role id
		$get_role_id = $this->db->select('role_id')->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['role_id']) ? $get_role_id['role_id'] : 0 ;
		// save system log
	    $log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT API - Distribute Commision/Surcharge - User Role - '.$user_role_id.']'.PHP_EOL;
	    $this->User->generateLog($log_msg);
        if($user_role_id == 4)
		{
			$md_id = $this->User->get_master_distributor_id($account_id);
			if($md_id)
			{
				// get dmr surcharge
	            $md_surcharge_amount = $this->User->get_money_transfer_surcharge($amount,$md_id);
	            // save system log
		    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT API - Distribute Commision/Surcharge - MD Charge - '.$md_surcharge_amount.']'.PHP_EOL;
		    	$this->User->generateLog($log_msg);

		    	if($surcharge_amount > $md_surcharge_amount)
		    	{
		    		$commision = $surcharge_amount - $md_surcharge_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT API - Distribute Commision/Surcharge - MD Commision - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance + $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'DMT',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Fund Transfer #'.$transaction_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
		    	}
		    	elseif($surcharge_amount < $md_surcharge_amount)
		    	{
		    		$commision = $md_surcharge_amount - $surcharge_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT API - Distribute Commision/Surcharge - MD Charge - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// debit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance - $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'DMT',
							'record_id' => $dmt_id,
							'is_surcharge' => 1,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Fund Transfer #'.$transaction_id.' Charge Debited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
		    	}
		    }
            
		}
		elseif($user_role_id == 5)
		{
			$distributor_id = $this->User->get_distributor_id($account_id);
			if($distributor_id)
			{
				// get dmr surcharge
	            $dist_surcharge_amount = $this->User->get_money_transfer_surcharge($amount,$distributor_id);
	            // save system log
		    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT API - Distribute Commision/Surcharge - DT Charge - '.$dist_surcharge_amount.']'.PHP_EOL;
		    	$this->User->generateLog($log_msg);

		    	if($surcharge_amount > $dist_surcharge_amount)
		    	{
		    		$commision = $surcharge_amount - $dist_surcharge_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT API - Distribute Commision/Surcharge - DT Commision - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance + $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'DMT',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Fund Transfer #'.$transaction_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
		    	}
		    	elseif($surcharge_amount < $dist_surcharge_amount)
		    	{
		    		$commision = $dist_surcharge_amount - $surcharge_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT API - Distribute Commision/Surcharge - DT Charge - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// debit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance - $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'DMT',
							'record_id' => $dmt_id,
							'is_surcharge' => 1,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Fund Transfer #'.$transaction_id.' Charge Debited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
		    	}

	            $md_id = $this->User->get_master_distributor_id($distributor_id);

				// get dmr surcharge
	            $md_surcharge_amount = $this->User->get_money_transfer_surcharge($amount,$md_id);
	            
	            // save system log
		    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT API - Distribute Commision/Surcharge - MD Charge - '.$md_surcharge_amount.']'.PHP_EOL;
		    	$this->User->generateLog($log_msg);

		    	if($dist_surcharge_amount > $md_surcharge_amount)
		    	{
		    		$commision = $dist_surcharge_amount - $md_surcharge_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT API - Distribute Commision/Surcharge - MD Commision - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance + $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'DMT',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Fund Transfer #'.$transaction_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
		    	}
		    	elseif($dist_surcharge_amount < $md_surcharge_amount)
		    	{
		    		$commision = $md_surcharge_amount - $dist_surcharge_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - DMT API - Distribute Commision/Surcharge - MD Charge - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// debit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance - $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'DMT',
							'record_id' => $dmt_id,
							'is_surcharge' => 1,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Fund Transfer #'.$transaction_id.' Charge Debited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
		    	}
		    }
		}
	}


	public function generate_api_url($member_id = 0,$opt_id = 0,$amount = 0,$loggedAccountID = 0)
	{
		$account_id = $this->User->get_domain_account();
		$account_package_id = $this->User->get_account_package_id($account_id);	
		$accountData = $this->User->get_account_data($account_id);
		$upper_package_id = $this->User->getMemberPackageID($member_id);
		$member_package_id = $this->User->getMemberPackageID($loggedAccountID);
		
		$api_id = 0;
		if($accountData['account_type'] == 2)
		{
			$account_id = SUPERADMIN_ACCOUNT_ID;
			// get active api id
			$get_api_id = $this->db->get_where('member_active_api',array('account_id'=>$account_id,'package_id'=>$account_package_id,'op_id'=>$opt_id))->row_array();
			$api_id = isset($get_api_id['api_id']) ? $get_api_id['api_id'] : 0;
		}
		else
		{
			if($amount == 0)
			{
				// get active api id
				$get_api_id = $this->db->get_where('member_active_api',array('account_id'=>$account_id,'package_id'=>$upper_package_id,'op_id'=>$opt_id))->row_array();
				$api_id = isset($get_api_id['api_id']) ? $get_api_id['api_id'] : 0;
				if(!$api_id)
				{
					// get active api id
					$get_api_id = $this->db->get_where('member_active_api',array('account_id'=>$account_id,'member_id'=>$member_id,'op_id'=>$opt_id))->row_array();
					$api_id = isset($get_api_id['api_id']) ? $get_api_id['api_id'] : 0;
				}
			}
			else
			{
				// get active api id
				$get_amount_api_id = $this->db->get_where('amount_active_api',array('account_id'=>$account_id,'start_range <='=>$amount,'end_range >='=>$amount,'op_id'=>$opt_id))->row_array();
				$api_id = isset($get_amount_api_id['api_id']) ? $get_amount_api_id['api_id'] : 0;
				if(!$api_id)
				{
					// get active api id
					$get_api_id = $this->db->get_where('member_active_api',array('account_id'=>$account_id,'package_id'=>$member_package_id,'op_id'=>$opt_id))->row_array();
					$api_id = isset($get_api_id['api_id']) ? $get_api_id['api_id'] : 0;
					if(!$api_id)
					{
						// get active api id
						$get_api_id = $this->db->get_where('member_active_api',array('account_id'=>$account_id,'member_id'=>$loggedAccountID,'op_id'=>$opt_id))->row_array();
						$api_id = isset($get_api_id['api_id']) ? $get_api_id['api_id'] : 0;
						if(!$api_id)
						{
							// get active api id
							$get_api_id = $this->db->get_where('member_active_api',array('account_id'=>$account_id,'package_id'=>$upper_package_id,'op_id'=>$opt_id))->row_array();
							$api_id = isset($get_api_id['api_id']) ? $get_api_id['api_id'] : 0;
							if(!$api_id)
							{
								// get active api id
								$get_api_id = $this->db->get_where('member_active_api',array('account_id'=>$account_id,'member_id'=>$member_id,'op_id'=>$opt_id))->row_array();
								$api_id = isset($get_api_id['api_id']) ? $get_api_id['api_id'] : 0;
							}
						}
					}
				}
			}
		}
		if($api_id)
		{
			// get api data
		 	$apiData = $this->db->get_where('api',array('id'=>$api_id,'account_id'=>$account_id))->row_array();

		 	// get method data
		 	$getMethodData = $this->db->get_where('api_parameter',array('account_id'=>$account_id,'api_id'=>$api_id,'type'=>1))->row_array();

		 	// get header data
		 	$getHeaderData = $this->db->get_where('api_header_parameter',array('account_id'=>$account_id,'api_id'=>$api_id,'type'=>1))->row_array();

		 	// get method all parameters
		 	$getParaList = $this->db->get_where('api_get_parameter',array('account_id'=>$account_id,'api_id'=>$api_id))->result_array();

		 	// post method data
		 	$postMethodData = $this->db->get_where('api_parameter',array('account_id'=>$account_id,'api_id'=>$api_id,'type'=>2))->row_array();

		 	// get method all parameters
		 	$postParaList = $this->db->get_where('api_post_parameter',array('account_id'=>$account_id,'api_id'=>$api_id))->result_array();

		 	$responseParaList = array();
		 	if($apiData['response_type'] == 1)
		 	{
		 		$responseParaList = $this->db->get_where('api_str_response',array('account_id'=>$account_id,'api_id'=>$api_id))->result_array();
		 	}
		 	elseif($apiData['response_type'] == 2)
		 	{
		 		$responseParaList = $this->db->get_where('api_xml_response',array('account_id'=>$account_id,'api_id'=>$api_id))->result_array();
		 	}
		 	elseif($apiData['response_type'] == 3)
		 	{
		 		$responseParaList = $this->db->get_where('api_json_response',array('account_id'=>$account_id,'api_id'=>$api_id))->result_array();
		 	}

		 	$api_url = $apiData['request_base_url'];
		 	$post_data = array();
		 	$header_data = array();
		 	if(isset($getHeaderData['is_access_key']) && $getHeaderData['is_access_key'])
	 		{
	 			$header_data[$getHeaderData['access_key']] = $apiData['access_key'];
	 		}
	 		if(isset($getHeaderData['is_username']) && $getHeaderData['is_username'])
	 		{
	 			$header_data[$getHeaderData['username_key']] = $apiData['username'];
	 		}
	 		if(isset($getHeaderData['is_password']) && $getHeaderData['is_password'])
	 		{
	 			$header_data[$getHeaderData['password_key']] = $apiData['password'];
	 		}
		 	if($apiData['request_type'] == 1)
		 	{
		 		if(isset($getMethodData['is_access_key']) && $getMethodData['is_access_key'])
		 		{
		 			$api_url.='&'.$getMethodData['access_key'].'='.$apiData['access_key'];
		 		}
		 		if(isset($getMethodData['is_username']) && $getMethodData['is_username'])
		 		{
		 			$api_url.='&'.$getMethodData['username_key'].'='.$apiData['username'];
		 		}
		 		if(isset($getMethodData['is_password']) && $getMethodData['is_password'])
		 		{
		 			$api_url.='&'.$getMethodData['password_key'].'='.$apiData['password'];
		 		}

		 		if($getParaList)
		 		{
		 			foreach($getParaList as $getList)
		 			{
		 				if($getList['value'] == '#')
		 				{
		 					$value_code = '';
		 					if($getList['value_id'] == 1)
		 						$value_code = '{AMOUNT}';
		 					elseif($getList['value_id'] == 2)
		 						$value_code = '{OPERATOR}';
		 					elseif($getList['value_id'] == 3)
		 						$value_code = '{CIRCLE}';
		 					elseif($getList['value_id'] == 4)
		 						$value_code = '{TXNID}';
		 					elseif($getList['value_id'] == 5)
		 						$value_code = '{MOBILE}';
		 					elseif($getList['value_id'] == 6)
		 						$value_code = '{MEMBERID}';

		 					$api_url.='&'.$getList['para_key'].'='.$value_code;
		 				}
		 				elseif($getList['value_id'] == 7)
		 				{
		 					$explode_str = explode('|', $getList['value']);
		 					// get operator type
		 					$get_opt_type = $this->db->select('type,operator_code')->get_where('operator',array('id'=>$opt_id))->row_array();
		 					$opt_type = isset($get_opt_type['type']) ? $get_opt_type['type'] : '';
		 					$opt_code = isset($get_opt_type['operator_code']) ? $get_opt_type['operator_code'] : '';
		 					if($opt_type == 'Prepaid' && $opt_code != 'BV')
		 					{
		 						$api_url.='&'.$getList['para_key'].'='.$explode_str[0];
		 					}
		 					elseif($opt_type == 'Prepaid' && $opt_code == 'BV')
		 					{
		 						$api_url.='&'.$getList['para_key'].'='.$explode_str[1];
		 					}
		 					elseif($opt_type == 'Postpaid')
		 					{
		 						$api_url.='&'.$getList['para_key'].'='.$explode_str[3];
		 					}
		 					elseif($opt_type == 'DTH')
		 					{
		 						$api_url.='&'.$getList['para_key'].'='.$explode_str[2];
		 					}
		 				}
		 				else
		 				{
		 					$api_url.='&'.$getList['para_key'].'='.$getList['value'];
		 				}
		 			}
		 		}
		 	}
		 	elseif($apiData['request_type'] == 2)
		 	{
		 		if(isset($postMethodData['is_access_key']) && $postMethodData['is_access_key'])
		 		{
		 			$post_data[$postMethodData['access_key']] = $apiData['access_key'];
		 		}
		 		if(isset($postMethodData['is_username']) && $postMethodData['is_username'])
		 		{
		 			$post_data[$postMethodData['username_key']] = $apiData['username'];
		 		}
		 		if(isset($postMethodData['is_password']) && $postMethodData['is_password'])
		 		{
		 			$post_data[$postMethodData['password_key']] = $apiData['password'];
		 		}

		 		if($postParaList)
		 		{
		 			foreach($postParaList as $getList)
		 			{
		 				if($getList['value'] == '#')
		 				{
		 					$value_code = '';
		 					if($getList['value_id'] == 1)
		 						$value_code = '{AMOUNT}';
		 					elseif($getList['value_id'] == 2)
		 						$value_code = '{OPERATOR}';
		 					elseif($getList['value_id'] == 3)
		 						$value_code = '{CIRCLE}';
		 					elseif($getList['value_id'] == 4)
		 						$value_code = '{TXNID}';
		 					elseif($getList['value_id'] == 5)
		 						$value_code = '{MOBILE}';
		 					elseif($getList['value_id'] == 6)
		 						$value_code = '{MEMBERID}';

		 					$post_data[$getList['para_key']] = $value_code;
		 				}
		 				elseif($getList['value_id'] == 7)
		 				{
		 					$explode_str = explode('|', $getList['value']);
		 					// get operator type
		 					$get_opt_type = $this->db->select('type,operator_code')->get_where('operator',array('id'=>$opt_id))->row_array();
		 					$opt_type = isset($get_opt_type['type']) ? $get_opt_type['type'] : '';
		 					$opt_code = isset($get_opt_type['operator_code']) ? $get_opt_type['operator_code'] : '';
		 					if($opt_type == 'Prepaid' && $opt_code != 'BV')
		 					{
		 						$post_data[$getList['para_key']] = $explode_str[0];
		 					}
		 					elseif($opt_type == 'Prepaid' && $opt_code == 'BV')
		 					{
		 						$post_data[$getList['para_key']] = $explode_str[1];
		 					}
		 					elseif($opt_type == 'Postpaid')
		 					{
		 						$post_data[$getList['para_key']] = $explode_str[3];
		 					}
		 					elseif($opt_type == 'DTH')
		 					{
		 						$post_data[$getList['para_key']] = $explode_str[2];
		 					}
		 				}
		 				else
		 				{
		 					if($getList['para_key'] == 'is_stv' && $opt_id == 4)
		 					{
		 						$post_data[$getList['para_key']] = 'true';
		 					}
		 					else
		 					{
		 						$post_data[$getList['para_key']] = $getList['value'];
		 					}
		 				}
		 			}
		 		}
		 	}
		 	elseif($apiData['request_type'] == 3)
		 	{
		 		if(isset($getMethodData['is_access_key']) && $getMethodData['is_access_key'])
		 		{
		 			$api_url.='&'.$getMethodData['access_key'].'='.$apiData['access_key'];
		 		}
		 		if(isset($getMethodData['is_username']) && $getMethodData['is_username'])
		 		{
		 			$api_url.='&'.$getMethodData['username_key'].'='.$apiData['username'];
		 		}
		 		if(isset($getMethodData['is_password']) && $getMethodData['is_password'])
		 		{
		 			$api_url.='&'.$getMethodData['password_key'].'='.$apiData['password'];
		 		}

		 		if($getParaList)
		 		{
		 			foreach($getParaList as $getList)
		 			{
		 				if($getList['value'] == '#')
		 				{
		 					$value_code = '';
		 					if($getList['value_id'] == 1)
		 						$value_code = '{AMOUNT}';
		 					elseif($getList['value_id'] == 2)
		 						$value_code = '{OPERATOR}';
		 					elseif($getList['value_id'] == 3)
		 						$value_code = '{CIRCLE}';
		 					elseif($getList['value_id'] == 4)
		 						$value_code = '{TXNID}';
		 					elseif($getList['value_id'] == 5)
		 						$value_code = '{MOBILE}';
		 					elseif($getList['value_id'] == 6)
		 						$value_code = '{MEMBERID}';

		 					$api_url.='&'.$getList['para_key'].'='.$value_code;
		 				}
		 				elseif($getList['value_id'] == 7)
		 				{
		 					$explode_str = explode('|', $getList['value']);
		 					// get operator type
		 					$get_opt_type = $this->db->select('type,operator_code')->get_where('operator',array('id'=>$opt_id))->row_array();
		 					$opt_type = isset($get_opt_type['type']) ? $get_opt_type['type'] : '';
		 					$opt_code = isset($get_opt_type['operator_code']) ? $get_opt_type['operator_code'] : '';
		 					if($opt_type == 'Prepaid' && $opt_code != 'BV')
		 					{
		 						$api_url.='&'.$getList['para_key'].'='.$explode_str[0];
		 					}
		 					elseif($opt_type == 'Prepaid' && $opt_code == 'BV')
		 					{
		 						$api_url.='&'.$getList['para_key'].'='.$explode_str[1];
		 					}
		 					elseif($opt_type == 'Postpaid')
		 					{
		 						$api_url.='&'.$getList['para_key'].'='.$explode_str[3];
		 					}
		 					elseif($opt_type == 'DTH')
		 					{
		 						$api_url.='&'.$getList['para_key'].'='.$explode_str[2];
		 					}
		 				}
		 				else
		 				{
		 					$api_url.='&'.$getList['para_key'].'='.$getList['value'];
		 				}
		 			}
		 		}

		 		if(isset($postMethodData['is_access_key']) && $postMethodData['is_access_key'])
		 		{
		 			$post_data[$postMethodData['access_key']] = $apiData['access_key'];
		 		}
		 		if(isset($postMethodData['is_username']) && $postMethodData['is_username'])
		 		{
		 			$post_data[$postMethodData['username_key']] = $apiData['username'];
		 		}
		 		if(isset($postMethodData['is_password']) && $postMethodData['is_password'])
		 		{
		 			$post_data[$postMethodData['password_key']] = $apiData['password'];
		 		}

		 		if($postParaList)
		 		{
		 			foreach($postParaList as $getList)
		 			{
		 				if($getList['value'] == '#')
		 				{
		 					$value_code = '';
		 					if($getList['value_id'] == 1)
		 						$value_code = '{AMOUNT}';
		 					elseif($getList['value_id'] == 2)
		 						$value_code = '{OPERATOR}';
		 					elseif($getList['value_id'] == 3)
		 						$value_code = '{CIRCLE}';
		 					elseif($getList['value_id'] == 4)
		 						$value_code = '{TXNID}';
		 					elseif($getList['value_id'] == 5)
		 						$value_code = '{MOBILE}';
		 					elseif($getList['value_id'] == 6)
		 						$value_code = '{MEMBERID}';

		 					$post_data[$getList['para_key']] = $value_code;
		 				}
		 				elseif($getList['value_id'] == 7)
		 				{
		 					$explode_str = explode('|', $getList['value']);
		 					// get operator type
		 					$get_opt_type = $this->db->select('type,operator_code')->get_where('operator',array('id'=>$opt_id))->row_array();
		 					$opt_type = isset($get_opt_type['type']) ? $get_opt_type['type'] : '';
		 					$opt_code = isset($get_opt_type['operator_code']) ? $get_opt_type['operator_code'] : '';
		 					if($opt_type == 'Prepaid' && $opt_code != 'BV')
		 					{
		 						$post_data[$getList['para_key']] = $explode_str[0];
		 					}
		 					elseif($opt_type == 'Prepaid' && $opt_code == 'BV')
		 					{
		 						$post_data[$getList['para_key']] = $explode_str[1];
		 					}
		 					elseif($opt_type == 'Postpaid')
		 					{
		 						$post_data[$getList['para_key']] = $explode_str[3];
		 					}
		 					elseif($opt_type == 'DTH')
		 					{
		 						$post_data[$getList['para_key']] = $explode_str[2];
		 					}
		 				}
		 				else
		 				{
		 					if($getList['para_key'] == 'is_stv' && $opt_id == 4)
		 					{
		 						$post_data[$getList['para_key']] = 'true';
		 					}
		 					else
		 					{
		 						$post_data[$getList['para_key']] = $getList['value'];
		 					}
		 				}
		 			}
		 		}
		 	}

		 	$responsePara = array();
		 	if($responseParaList)
		 	{
		 		foreach($responseParaList as $rkey=>$rlist)
		 		{
		 			$value_code = '';
 					if($rlist['value_id'] == 1)
 						$value_code = 'TXNID';
 					elseif($rlist['value_id'] == 2)
 						$value_code = 'STATUS';
 					elseif($rlist['value_id'] == 3)
 						$value_code = 'OPTMSG';
 					elseif($rlist['value_id'] == 4)
 						$value_code = 'OPTREFID';
 					elseif($rlist['value_id'] == 5)
 						$value_code = 'TIMESTAMP';
 					elseif($rlist['value_id'] == 6)
 						$value_code = 'MEMBERID';
 					elseif($rlist['value_id'] == 7)
 						$value_code = 'BALANCE';
 					elseif($rlist['value_id'] == 8)
 						$value_code = 'COMMISION';

		 			$responsePara[$rkey]['key'] = isset($rlist['para_key']) ? $rlist['para_key'] : '';
		 			$responsePara[$rkey]['value'] = $value_code;
		 			$responsePara[$rkey]['success'] = $rlist['success_val'];
		 			$responsePara[$rkey]['failed'] = $rlist['failed_val'];
		 			$responsePara[$rkey]['pending'] = $rlist['pending_val'];
		 		}
		 	}

		 	return array('status'=>1,'msg'=>'Success','api_url'=>$api_url,'api_id'=>$api_id,'post_data'=>$post_data,'header_data'=>$header_data,'response_type'=>$apiData['response_type'],'responsePara'=>$responsePara,'seperator'=>$apiData['response_seperator']);

		}
		else
		{
			return array('status'=>0,'msg'=>'API Not Found.');
		}
	}


	public function generate_get_balance_api_url($api_id = 0, $account_id = 0)
	{
		if($account_id == 0)
		{
			$account_id = $this->User->get_domain_account();
		}
		
		// get api data
	 	$apiData = $this->db->get_where('api',array('id'=>$api_id,'account_id'=>$account_id))->row_array();

	 	$get_balance_base_url = $apiData['get_balance_base_url'];
	 	if($get_balance_base_url)
	 	{

		 	// get method data
		 	$getMethodData = $this->db->get_where('api_get_balance_parameter',array('account_id'=>$account_id,'api_id'=>$api_id,'type'=>1))->row_array();

		 	// get header data
		 	$getHeaderData = $this->db->get_where('api_get_balance_header_parameter',array('account_id'=>$account_id,'api_id'=>$api_id,'type'=>1))->row_array();

		 	// get method all parameters
		 	$getParaList = $this->db->get_where('api_get_balance_get_parameter',array('account_id'=>$account_id,'api_id'=>$api_id))->result_array();

		 	// post method data
		 	$postMethodData = $this->db->get_where('api_get_balance_parameter',array('account_id'=>$account_id,'api_id'=>$api_id,'type'=>2))->row_array();

		 	// get method all parameters
		 	$postParaList = $this->db->get_where('api_get_balance_post_parameter',array('account_id'=>$account_id,'api_id'=>$api_id))->result_array();

		 	$responseParaList = array();
		 	if($apiData['get_balance_response_type'] == 1)
		 	{
		 		$responseParaList = $this->db->get_where('api_get_balance_str_response',array('account_id'=>$account_id,'api_id'=>$api_id))->result_array();
		 	}
		 	elseif($apiData['get_balance_response_type'] == 2)
		 	{
		 		$responseParaList = $this->db->get_where('api_get_balance_xml_response',array('account_id'=>$account_id,'api_id'=>$api_id))->result_array();
		 	}
		 	elseif($apiData['get_balance_response_type'] == 3)
		 	{
		 		$responseParaList = $this->db->get_where('api_get_balance_json_response',array('account_id'=>$account_id,'api_id'=>$api_id))->result_array();
		 	}

		 	$api_url = $apiData['get_balance_base_url'];
		 	$post_data = array();
		 	$header_data = array();

		 	if(isset($getHeaderData['is_access_key']) && $getHeaderData['is_access_key'])
	 		{
	 			$header_data[$getHeaderData['access_key']] = $apiData['access_key'];
	 		}
	 		if(isset($getHeaderData['is_username']) && $getHeaderData['is_username'])
	 		{
	 			$header_data[$getHeaderData['username_key']] = $apiData['username'];
	 		}
	 		if(isset($getHeaderData['is_password']) && $getHeaderData['is_password'])
	 		{
	 			$header_data[$getHeaderData['password_key']] = $apiData['password'];
	 		}

		 	if($apiData['get_balance_request_type'] == 1)
		 	{
		 		if(isset($getMethodData['is_access_key']) && $getMethodData['is_access_key'])
		 		{
		 			$api_url.='&'.$getMethodData['access_key'].'='.$apiData['access_key'];
		 		}
		 		if(isset($getMethodData['is_username']) && $getMethodData['is_username'])
		 		{
		 			$api_url.='&'.$getMethodData['username_key'].'='.$apiData['username'];
		 		}
		 		if(isset($getMethodData['is_password']) && $getMethodData['is_password'])
		 		{
		 			$api_url.='&'.$getMethodData['password_key'].'='.$apiData['password'];
		 		}

		 		if($getParaList)
		 		{
		 			foreach($getParaList as $getList)
		 			{
		 				if($getList['value'] == '#')
		 				{
		 					$value_code = '';
		 					if($getList['value_id'] == 1)
		 						$value_code = '{AMOUNT}';
		 					elseif($getList['value_id'] == 2)
		 						$value_code = '{OPERATOR}';
		 					elseif($getList['value_id'] == 3)
		 						$value_code = '{CIRCLE}';
		 					elseif($getList['value_id'] == 4)
		 						$value_code = '{TXNID}';
		 					elseif($getList['value_id'] == 5)
		 						$value_code = '{MOBILE}';
		 					elseif($getList['value_id'] == 6)
		 						$value_code = '{MEMBERID}';

		 					$api_url.='&'.$getList['para_key'].'='.$value_code;
		 				}
		 				else
		 				{
		 					$api_url.='&'.$getList['para_key'].'='.$getList['value'];
		 				}
		 			}
		 		}
		 	}
		 	elseif($apiData['get_balance_request_type'] == 2)
		 	{
		 		if(isset($postMethodData['is_access_key']) && $postMethodData['is_access_key'])
		 		{
		 			$post_data[$postMethodData['access_key']] = $apiData['access_key'];
		 		}
		 		if(isset($postMethodData['is_username']) && $postMethodData['is_username'])
		 		{
		 			$post_data[$postMethodData['username_key']] = $apiData['username'];
		 		}
		 		if(isset($postMethodData['is_password']) && $postMethodData['is_password'])
		 		{
		 			$post_data[$postMethodData['password_key']] = $apiData['password'];
		 		}

		 		if($postParaList)
		 		{
		 			foreach($postParaList as $getList)
		 			{
		 				if($getList['value'] == '#')
		 				{
		 					$value_code = '';
		 					if($getList['value_id'] == 1)
		 						$value_code = '{AMOUNT}';
		 					elseif($getList['value_id'] == 2)
		 						$value_code = '{OPERATOR}';
		 					elseif($getList['value_id'] == 3)
		 						$value_code = '{CIRCLE}';
		 					elseif($getList['value_id'] == 4)
		 						$value_code = '{TXNID}';
		 					elseif($getList['value_id'] == 5)
		 						$value_code = '{MOBILE}';
		 					elseif($getList['value_id'] == 6)
		 						$value_code = '{MEMBERID}';

		 					$post_data[$getList['para_key']] = $value_code;
		 				}
		 				else
		 				{
		 					$post_data[$getList['para_key']] = $getList['value'];
		 				}
		 			}
		 		}
		 	}
		 	elseif($apiData['get_balance_request_type'] == 3)
		 	{
		 		if(isset($getMethodData['is_access_key']) && $getMethodData['is_access_key'])
		 		{
		 			$api_url.='&'.$getMethodData['access_key'].'='.$apiData['access_key'];
		 		}
		 		if(isset($getMethodData['is_username']) && $getMethodData['is_username'])
		 		{
		 			$api_url.='&'.$getMethodData['username_key'].'='.$apiData['username'];
		 		}
		 		if(isset($getMethodData['is_password']) && $getMethodData['is_password'])
		 		{
		 			$api_url.='&'.$getMethodData['password_key'].'='.$apiData['password'];
		 		}

		 		if($getParaList)
		 		{
		 			foreach($getParaList as $getList)
		 			{
		 				if($getList['value'] == '#')
		 				{
		 					$value_code = '';
		 					if($getList['value_id'] == 1)
		 						$value_code = '{AMOUNT}';
		 					elseif($getList['value_id'] == 2)
		 						$value_code = '{OPERATOR}';
		 					elseif($getList['value_id'] == 3)
		 						$value_code = '{CIRCLE}';
		 					elseif($getList['value_id'] == 4)
		 						$value_code = '{TXNID}';
		 					elseif($getList['value_id'] == 5)
		 						$value_code = '{MOBILE}';
		 					elseif($getList['value_id'] == 6)
		 						$value_code = '{MEMBERID}';

		 					$api_url.='&'.$getList['para_key'].'='.$value_code;
		 				}
		 				else
		 				{
		 					$api_url.='&'.$getList['para_key'].'='.$getList['value'];
		 				}
		 			}
		 		}

		 		if(isset($postMethodData['is_access_key']) && $postMethodData['is_access_key'])
		 		{
		 			$post_data[$postMethodData['access_key']] = $apiData['access_key'];
		 		}
		 		if(isset($postMethodData['is_username']) && $postMethodData['is_username'])
		 		{
		 			$post_data[$postMethodData['username_key']] = $apiData['username'];
		 		}
		 		if(isset($postMethodData['is_password']) && $postMethodData['is_password'])
		 		{
		 			$post_data[$postMethodData['password_key']] = $apiData['password'];
		 		}

		 		if($postParaList)
		 		{
		 			foreach($postParaList as $getList)
		 			{
		 				if($getList['value'] == '#')
		 				{
		 					$value_code = '';
		 					if($getList['value_id'] == 1)
		 						$value_code = '{AMOUNT}';
		 					elseif($getList['value_id'] == 2)
		 						$value_code = '{OPERATOR}';
		 					elseif($getList['value_id'] == 3)
		 						$value_code = '{CIRCLE}';
		 					elseif($getList['value_id'] == 4)
		 						$value_code = '{TXNID}';
		 					elseif($getList['value_id'] == 5)
		 						$value_code = '{MOBILE}';
		 					elseif($getList['value_id'] == 6)
		 						$value_code = '{MEMBERID}';

		 					$post_data[$getList['para_key']] = $value_code;
		 				}
		 				else
		 				{
		 					$post_data[$getList['para_key']] = $getList['value'];
		 				}
		 			}
		 		}
		 	}

		 	$responsePara = array();
		 	if($responseParaList)
		 	{
		 		foreach($responseParaList as $rkey=>$rlist)
		 		{
		 			$value_code = '';
						if($rlist['value_id'] == 1)
							$value_code = 'TXNID';
						elseif($rlist['value_id'] == 2)
							$value_code = 'STATUS';
						elseif($rlist['value_id'] == 3)
							$value_code = 'OPTMSG';
						elseif($rlist['value_id'] == 4)
							$value_code = 'OPTREFID';
						elseif($rlist['value_id'] == 5)
							$value_code = 'TIMESTAMP';
						elseif($rlist['value_id'] == 6)
							$value_code = 'MEMBERID';
						elseif($rlist['value_id'] == 7)
							$value_code = 'BALANCE';
						elseif($rlist['value_id'] == 8)
							$value_code = 'COMMISION';

		 			$responsePara[$rkey]['key'] = isset($rlist['para_key']) ? $rlist['para_key'] : '';
		 			$responsePara[$rkey]['value'] = $value_code;
		 			$responsePara[$rkey]['success'] = $rlist['success_val'];
		 			$responsePara[$rkey]['failed'] = $rlist['failed_val'];
		 			$responsePara[$rkey]['pending'] = $rlist['pending_val'];
		 		}
		 	}

		 	return array('status'=>1,'msg'=>'Success','api_url'=>$api_url,'api_id'=>$api_id,'post_data'=>$post_data,'header_data'=>$header_data,'response_type'=>$apiData['response_type'],'responsePara'=>$responsePara,'seperator'=>$apiData['get_balance_response_seperator']);
	 	}
	 	else
	 	{
	 		return array('status'=>0,'msg'=>'No API Found.');
	 	}

		
	}


	public function call_get_balance_api($api_url,$api_post_data,$api_id = 0,$response_type = 0,$responsePara = array(),$seperator = '',$api_header_data = array())
	{
		$domain_account_id = $this->User->get_domain_account();
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		if($api_header_data)
		{
			
            $headers = array();
            $h = 0;
            foreach($api_header_data as $hkey=>$hval)
            {
                $headers[$h] = $hkey.':'.$hval;
                $h++;
            }
            if($headers)
            {
	        	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	    	}
		}
		if($api_post_data)
		{
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $api_post_data);		
		}
		$output = curl_exec($ch); 
		curl_close($ch);

		$txid = '';
		$recharge_status = '';
		$success_value = '';
		$failed_value = '';
		$pending_value = '';
		$opt_msg = '';
		$opt_ref_id = '';
		$timestamp = '';
		$memberid = '';
		$balance = '';
		$commision = '';
		if($response_type == 1)
		{
			$api_response = explode($seperator,$output);
			if($responsePara)
			{
				foreach($responsePara as $key=>$val)
				{
					if($val['value'] == 'TXNID')
					{
						$txid = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'STATUS')
					{
						$recharge_status = isset($api_response[$key]) ? trim(strtolower($api_response[$key])) : '';
						$success_value = strtolower($val['success']);
						$failed_value = strtolower($val['failed']);
						$pending_value = strtolower($val['pending']);
					}
					elseif($val['value'] == 'OPTMSG')
					{
						$opt_msg = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'OPTREFID')
					{
						$opt_ref_id = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'TIMESTAMP')
					{
						$timestamp = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'MEMBERID')
					{
						$memberid = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'BALANCE')
					{
						$balance = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
					elseif($val['value'] == 'COMMISION')
					{
						$commision = isset($api_response[$key]) ? trim($api_response[$key]) : '';
					}
				}
			}

		}
		elseif($response_type == 2)
		{
			$api_response = (array) simplexml_load_string($output);
			if($responsePara)
			{
				foreach($responsePara as $key=>$val)
				{
					if($val['value'] == 'TXNID')
					{
						$txid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'STATUS')
					{
						$recharge_status = isset($api_response[$val['key']]) ? trim(strtolower($api_response[$val['key']])) : '';
						$success_value = strtolower($val['success']);
						$failed_value = strtolower($val['failed']);
						$pending_value = strtolower($val['pending']);
					}
					elseif($val['value'] == 'OPTMSG')
					{
						$opt_msg = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'OPTREFID')
					{
						$opt_ref_id = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'TIMESTAMP')
					{
						$timestamp = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'MEMBERID')
					{
						$memberid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'BALANCE')
					{
						$balance = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'COMMISION')
					{
						$commision = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
				}
			}

		}
		elseif($response_type == 3)
		{
			$api_response = json_decode($output,true);
			if($responsePara)
			{
				foreach($responsePara as $key=>$val)
				{
					if($val['value'] == 'TXNID')
					{
						$txid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'STATUS')
					{
						$recharge_status = isset($api_response[$val['key']]) ? trim(strtolower($api_response[$val['key']])) : '';
						$success_value = strtolower($val['success']);
						$failed_value = strtolower($val['failed']);
						$pending_value = strtolower($val['pending']);
					}
					elseif($val['value'] == 'OPTMSG')
					{
						$opt_msg = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'OPTREFID')
					{
						$opt_ref_id = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'TIMESTAMP')
					{
						$timestamp = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'MEMBERID')
					{
						$memberid = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'BALANCE')
					{
						$balance = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
					elseif($val['value'] == 'COMMISION')
					{
						$commision = isset($api_response[$val['key']]) ? trim($api_response[$val['key']]) : '';
					}
				}
			}

		}

		$status = 0;
		if($recharge_status == '' || $recharge_status == $failed_value)
		{
			$status = 3;
		}
		elseif($recharge_status == $pending_value)
		{
			$status = 1;
		}
		elseif($recharge_status == $success_value)
		{
			$status = 2;
		}
		
		return array(
			'status' => $status,
			'txid' => $txid,
			'operator_ref' => $opt_ref_id,
			'api_timestamp' => $timestamp,
			'opt_msg' => $opt_msg,
			'memberid' => $memberid,
			'balance' => $balance,
			'commision' => $commision,
			'api_response_id' => $api_response_id,
		);
		
	}


	public function utiKycStatus($mobile = ''){


		$pancard_kyc_status_url = PANCARD_KYC_STATUS_CHECK_URL;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$pancard_kyc_status_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $headers = [
            'Token: '.PANCARD_API_TOKEN,
            'mobile: '.$mobile,
            'Content-Type:application/x-www-form-urlencoded'
        ];
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $output = curl_exec ($ch);
        curl_close ($ch);
        
        return $responseData = json_decode($output,true);
        
	}



	public function get_bbps_biller_list($service_id = 0)
	{
		return $this->db->get_where('bbps_service_category',array('service_id'=>$service_id))->result_array();
	}

	public function get_bbps_biller_id($biller_id = 0)
	{
		return $this->db->get_where('bbps_service_category',array('id'=>$biller_id))->row_array();
	}

	public function get_bbps_pmr_service_id($biller_id = 0)
	{
		return $this->db->get_where('bbps_service',array('id'=>$biller_id))->row_array();
	}

	public function get_bbps_biller_param($service_id = 0,$biller_id = 0)
	{
		return $this->db->get_where('bbps_category_params',array('service_id'=>$service_id,'cat_id'=>$biller_id))->result_array();
	}
	
	public function generateBBPSLog($log_msg = '')
	{
		$account_id = SUPERADMIN_ACCOUNT_ID;
		$log_file = 'BBPS-Account-'.$account_id.'-'.date('d-M-Y').'.php';
		$log_msg = $log_msg.'/n';
		write_file(ACCOUNT_LOG_PATH.$log_file,$log_msg,'a+');
		return true;
	}



	public function distribute_bbps_commision($recharge_id, $recharge_unique_id, $amount, $account_id)
	{

		$member_package_id = $this->User->getMemberPackageID($account_id);

		$domain_account_id = $this->User->get_domain_account();
		$accountData = $this->User->get_account_data($domain_account_id);

		// get account role id
		$get_role_id = $this->db->select('role_id')->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['role_id']) ? $get_role_id['role_id'] : 0 ;

		// save system log
        $log_msg = '['.date('d-m-Y H:i:s').' - Account Role ID - '.$user_role_id.']'.PHP_EOL;
        $this->User->generateLog($log_msg);
		if($user_role_id == 3)
		{
			// get operator id
			$get_recharge_data = $this->db->select('bbps_history.service_id')->get_where('bbps_history',array('bbps_history.id'=>$recharge_id,'bbps_history.account_id'=>$domain_account_id))->row_array();
			$service_id = isset($get_recharge_data['service_id']) ? $get_recharge_data['service_id'] : 0 ;
			
			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Service ID - '.$service_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($service_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('bbps_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'service_id'=>$service_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];

                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$is_surcharge = $get_comm['is_surcharge'];
					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'BBPS',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'settlement_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,  
				                'wallet_type'         => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,  
				                'wallet_type'         => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}

				if($accountData['account_type'] == 2){

					$admin_id = $this->User->get_admin_id($domain_account_id);
					$admin_package_id = $this->User->get_account_package_id($domain_account_id);
					
					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin ID - '.$admin_id.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					// get master distribution recharge commision
					$get_comm = $this->db->get_where('bbps_commision',array('package_id'=>$admin_package_id,'service_id'=>$service_id))->row_array();
					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
	        		if($get_comm)
					{
						// debit wallet
	                	$accountBalanceData = $this->db->get_where('users',array('id'=>$admin_id,'account_id'=>$domain_account_id))->row_array();

	                	$before_balance = $accountBalanceData['wallet_balance'];
	                	// save system log
		        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Wallet Balance - '.$before_balance.']'.PHP_EOL;
		        		$this->User->generateLog($log_msg);

						$commision = $get_comm['commision'];
						$is_flat = $get_comm['is_flat'];
						$admin_is_surcharge = $get_comm['is_surcharge'];
						if($admin_is_surcharge)
						{
							$admin_charge_amount = round(($commision/100)*$amount,2);
							if($is_flat)
							{
								$admin_charge_amount = $commision;
							}

						}
						else
						{
							$admin_charge_amount = round(($commision/100)*$amount,2);
							if($is_flat)
							{
								$admin_charge_amount = $commision;
							}
							
						}
						$remaining_charge_amount = 0;
						$deduct_charge_amount = 0;
						if($is_surcharge && !$admin_is_surcharge)
						{
							$remaining_charge_amount = $charge_amount + $admin_charge_amount;
						}
						elseif($is_surcharge && $admin_is_surcharge)
						{
							$remaining_charge_amount = $charge_amount - $admin_charge_amount;
							if($charge_amount < $admin_charge_amount)
							{
								$deduct_charge_amount = $admin_charge_amount - $charge_amount;
							}
						}
						else
						{
							if($admin_charge_amount > $charge_amount)
							{
								$remaining_charge_amount = $admin_charge_amount - $charge_amount;
							}
							else
							{
								$remaining_charge_amount = $charge_amount - $admin_charge_amount;
								$deduct_charge_amount = $charge_amount - $admin_charge_amount;
							}
						}

						// save system log
		        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Charge Amount - '.$admin_charge_amount.' - Credit Amount - '.$remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
		        		$this->User->generateLog($log_msg);

						if($remaining_charge_amount > 0)
						{
							$after_balance = $before_balance + $remaining_charge_amount;
							$commisionData = array(
								'account_id' => $domain_account_id,
								'member_id' => $admin_id,
								'type' => 'BBPS',
								'record_id' => $recharge_id,
								'commision' => $commision,
								'is_flat' => $is_flat,
								'is_surcharge' => $admin_is_surcharge,
								'commision_amount' => $admin_charge_amount,
								'settlement_amount' => $remaining_charge_amount,
								'is_downline' => 1,
								'downline_id' => $account_id,
								'before_balance' => $before_balance,
								'after_balance' => $after_balance,
								'status' => 1,
								'created' => date('Y-m-d H:i:s')
							);
							$this->db->insert('user_commision',$commisionData);
							
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $admin_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $remaining_charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,     
				                'wallet_type'         => 1,   
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$admin_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
							
						}
						elseif($remaining_charge_amount < 0)
						{
							$after_balance = $before_balance - $deduct_charge_amount;
							$commisionData = array(
								'account_id' => $domain_account_id,
								'member_id' => $admin_id,
								'type' => 'BBPS',
								'record_id' => $recharge_id,
								'commision' => $commision,
								'is_flat' => $is_flat,
								'is_surcharge' => $admin_is_surcharge,
								'commision_amount' => $admin_charge_amount,
								'settlement_amount' => $deduct_charge_amount,
								'is_downline' => 1,
								'downline_id' => $account_id,
								'before_balance' => $before_balance,
								'after_balance' => $after_balance,
								'status' => 1,
								'created' => date('Y-m-d H:i:s')
							);
							$this->db->insert('user_commision',$commisionData);
							
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $admin_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $deduct_charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,      
				                'wallet_type'         => 1,  
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$admin_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
							
						}
					}
				}

			}
		}
		elseif($user_role_id == 6)
		{
			// get operator id
			$get_recharge_data = $this->db->select('bbps_history.service_id')->get_where('bbps_history',array('bbps_history.id'=>$recharge_id,'bbps_history.account_id'=>$domain_account_id))->row_array();
			$service_id = isset($get_recharge_data['service_id']) ? $get_recharge_data['service_id'] : 0 ;
			
			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Service ID - '.$service_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($service_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('bbps_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'service_id'=>$service_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];

                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['api_commision'];
					$is_flat = $get_comm['api_is_flat'];
					$is_surcharge = $get_comm['api_is_surcharge'];
					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'BBPS',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'settlement_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,   
				                'wallet_type'         => 1,         
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,      
				                'wallet_type'         => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}

				if($accountData['account_type'] == 2){

					$admin_id = $this->User->get_admin_id($domain_account_id);
					$admin_package_id = $this->User->get_account_package_id($domain_account_id);
					
					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin ID - '.$admin_id.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					// get master distribution recharge commision
					$get_comm = $this->db->get_where('bbps_commision',array('package_id'=>$admin_package_id,'service_id'=>$service_id))->row_array();
					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
	        		if($get_comm)
					{
						// debit wallet
	                	$accountBalanceData = $this->db->get_where('users',array('id'=>$admin_id,'account_id'=>$domain_account_id))->row_array();

	                	$before_balance = $accountBalanceData['wallet_balance'];
	                	// save system log
		        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Wallet Balance - '.$before_balance.']'.PHP_EOL;
		        		$this->User->generateLog($log_msg);

						$commision = $get_comm['commision'];
						$is_flat = $get_comm['is_flat'];
						$admin_is_surcharge = $get_comm['is_surcharge'];
						if($admin_is_surcharge)
						{
							$admin_charge_amount = round(($commision/100)*$amount,2);
							if($is_flat)
							{
								$admin_charge_amount = $commision;
							}

						}
						else
						{
							$admin_charge_amount = round(($commision/100)*$amount,2);
							if($is_flat)
							{
								$admin_charge_amount = $commision;
							}
							
						}
						$remaining_charge_amount = 0;
						$deduct_charge_amount = 0;
						if($is_surcharge && !$admin_is_surcharge)
						{
							$remaining_charge_amount = $charge_amount + $admin_charge_amount;
						}
						elseif($is_surcharge && $admin_is_surcharge)
						{
							$remaining_charge_amount = $charge_amount - $admin_charge_amount;
							if($charge_amount < $admin_charge_amount)
							{
								$deduct_charge_amount = $admin_charge_amount - $charge_amount;
							}
						}
						else
						{
							if($admin_charge_amount > $charge_amount)
							{
								$remaining_charge_amount = $admin_charge_amount - $charge_amount;
							}
							else
							{
								$remaining_charge_amount = $charge_amount - $admin_charge_amount;
								$deduct_charge_amount = $charge_amount - $admin_charge_amount;
							}
						}

						// save system log
		        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Charge Amount - '.$admin_charge_amount.' - Credit Amount - '.$remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
		        		$this->User->generateLog($log_msg);

						if($remaining_charge_amount > 0)
						{
							$after_balance = $before_balance + $remaining_charge_amount;
							$commisionData = array(
								'account_id' => $domain_account_id,
								'member_id' => $admin_id,
								'type' => 'BBPS',
								'record_id' => $recharge_id,
								'commision' => $commision,
								'is_flat' => $is_flat,
								'is_surcharge' => $admin_is_surcharge,
								'commision_amount' => $admin_charge_amount,
								'settlement_amount' => $remaining_charge_amount,
								'is_downline' => 1,
								'downline_id' => $account_id,
								'before_balance' => $before_balance,
								'after_balance' => $after_balance,
								'status' => 1,
								'created' => date('Y-m-d H:i:s')
							);
							$this->db->insert('user_commision',$commisionData);
							
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $admin_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $remaining_charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,     
				                'wallet_type'         => 1,    
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$admin_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
							
						}
						elseif($remaining_charge_amount < 0)
						{
							$after_balance = $before_balance - $deduct_charge_amount;
							$commisionData = array(
								'account_id' => $domain_account_id,
								'member_id' => $admin_id,
								'type' => 'BBPS',
								'record_id' => $recharge_id,
								'commision' => $commision,
								'is_flat' => $is_flat,
								'is_surcharge' => $admin_is_surcharge,
								'commision_amount' => $admin_charge_amount,
								'settlement_amount' => $deduct_charge_amount,
								'is_downline' => 1,
								'downline_id' => $account_id,
								'before_balance' => $before_balance,
								'after_balance' => $after_balance,
								'status' => 1,
								'created' => date('Y-m-d H:i:s')
							);
							$this->db->insert('user_commision',$commisionData);
							
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $admin_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $deduct_charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,    
				                'wallet_type'         => 1,    
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$admin_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
							
						}
					}
				}

			}
		}
		elseif($user_role_id == 4)
		{
			// get operator id
			$get_recharge_data = $this->db->select('bbps_history.service_id')->get_where('bbps_history',array('bbps_history.id'=>$recharge_id,'bbps_history.account_id'=>$domain_account_id))->row_array();
			$service_id = isset($get_recharge_data['service_id']) ? $get_recharge_data['service_id'] : 0 ;
			
			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Service ID - '.$service_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($service_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('bbps_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'service_id'=>$service_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];

                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['dt_commision'];
					$is_flat = $get_comm['dt_is_flat'];
					$is_surcharge = $get_comm['dt_is_surcharge'];

					$total_distribute_amount = 0;

					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
						$total_distribute_amount+=$charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'BBPS',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'settlement_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,      
				                'wallet_type'         => 1,  
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1, 
				                'wallet_type'         => 1,        
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}

				
				$md_id = $this->User->get_master_distributor_id($account_id);

				$md_package_id = $this->User->getMemberPackageID($md_id);

				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Master Distributor ID - '.$md_id.']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				// get master distribution recharge commision
				$get_comm = $this->db->get_where('bbps_commision',array('account_id'=>$domain_account_id,'package_id'=>$md_package_id,'service_id'=>$service_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$md_is_surcharge = $get_comm['is_surcharge'];
					if($md_is_surcharge)
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}

					}
					else
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}
						
					}
					$remaining_charge_amount = 0;
					$deduct_charge_amount = 0;
					if($is_surcharge && !$md_is_surcharge)
					{
						$remaining_charge_amount = $charge_amount + $md_charge_amount;
					}
					elseif($is_surcharge && $md_is_surcharge)
					{
						$remaining_charge_amount = $charge_amount - $md_charge_amount;
						if($charge_amount < $md_charge_amount)
						{
							$deduct_charge_amount = $md_charge_amount - $charge_amount;
						}
						$total_distribute_amount+=$remaining_charge_amount;
					}
					else
					{
						if($md_charge_amount >= $charge_amount)
						{
							$remaining_charge_amount = $md_charge_amount - $charge_amount;
							$total_distribute_amount+=$remaining_charge_amount;
						}
						else
						{
							$remaining_charge_amount = $charge_amount - $md_charge_amount;
							$deduct_charge_amount = $charge_amount - $md_charge_amount;
						}
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Charge Amount - '.$md_charge_amount.' - Credit Amount - '.$remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($remaining_charge_amount > 0)
					{
						$after_balance = $before_balance + $remaining_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'BBPS',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $md_is_surcharge,
							'commision_amount' => $md_charge_amount,
							'settlement_amount' => $remaining_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $remaining_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1,   
			                'wallet_type'         => 1,     
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
					elseif($remaining_charge_amount < 0)
					{
						$after_balance = $before_balance - $deduct_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'BBPS',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $md_is_surcharge,
							'commision_amount' => $md_charge_amount,
							'settlement_amount' => $deduct_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $deduct_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2,      
			                'wallet_type'         => 1,  
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Deduction.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
				}

				if($accountData['account_type'] == 2){

					$admin_id = $this->User->get_admin_id($domain_account_id);
					$admin_package_id = $this->User->get_account_package_id($domain_account_id);
					
					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin ID - '.$admin_id.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					// get master distribution recharge commision
					$get_comm = $this->db->get_where('bbps_commision',array('package_id'=>$admin_package_id,'service_id'=>$service_id))->row_array();
					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
	        		if($get_comm)
					{
						// debit wallet
	                	$accountBalanceData = $this->db->get_where('users',array('id'=>$admin_id,'account_id'=>$domain_account_id))->row_array();

	                	$before_balance = $accountBalanceData['wallet_balance'];
	                	// save system log
		        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Wallet Balance - '.$before_balance.']'.PHP_EOL;
		        		$this->User->generateLog($log_msg);

						$commision = $get_comm['commision'];
						$is_flat = $get_comm['is_flat'];
						$admin_is_surcharge = $get_comm['is_surcharge'];
						if($admin_is_surcharge)
						{
							$admin_charge_amount = round(($commision/100)*$amount,2);
							if($is_flat)
							{
								$admin_charge_amount = $commision;
							}

						}
						else
						{
							$admin_charge_amount = round(($commision/100)*$amount,2);
							if($is_flat)
							{
								$admin_charge_amount = $commision;
							}
							
						}


						$remaining_charge_amount = 0;
						$deduct_charge_amount = 0;
						if($is_surcharge && $admin_is_surcharge)
						{
							$remaining_charge_amount = $charge_amount - $admin_charge_amount;
							$remaining_charge_amount = $remaining_charge_amount - $total_distribute_amount;
						}
						else
						{
							if($admin_charge_amount >= $total_distribute_amount)
							{
								$remaining_charge_amount = $admin_charge_amount - $total_distribute_amount;
							}
							else
							{
								$remaining_charge_amount = $total_distribute_amount - $admin_charge_amount;
								$deduct_charge_amount = $total_distribute_amount - $admin_charge_amount;
							}
						}

						// save system log
		        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Charge Amount - '.$admin_charge_amount.' - Credit Amount - '.$remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
		        		$this->User->generateLog($log_msg);

						if($remaining_charge_amount > 0)
						{
							$after_balance = $before_balance + $remaining_charge_amount;
							$commisionData = array(
								'account_id' => $domain_account_id,
								'member_id' => $admin_id,
								'type' => 'BBPS',
								'record_id' => $recharge_id,
								'commision' => $commision,
								'is_flat' => $is_flat,
								'is_surcharge' => $admin_is_surcharge,
								'commision_amount' => $admin_charge_amount,
								'settlement_amount' => $remaining_charge_amount,
								'is_downline' => 1,
								'downline_id' => $account_id,
								'before_balance' => $before_balance,
								'after_balance' => $after_balance,
								'status' => 1,
								'created' => date('Y-m-d H:i:s')
							);
							$this->db->insert('user_commision',$commisionData);
							
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $admin_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $remaining_charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,   
				                'wallet_type'         => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$admin_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
							
						}
						
					}
				}
			}
		}
		elseif($user_role_id == 5)
		{
			// get operator id
			$get_recharge_data = $this->db->select('bbps_history.service_id')->get_where('bbps_history',array('bbps_history.id'=>$recharge_id,'bbps_history.account_id'=>$domain_account_id))->row_array();
			$service_id = isset($get_recharge_data['service_id']) ? $get_recharge_data['service_id'] : 0 ;
			
			// save system log
        	$log_msg = '['.date('d-m-Y H:i:s').' - Service ID - '.$service_id.']'.PHP_EOL;
        	$this->User->generateLog($log_msg);

			if($service_id)
			{
				// get recharge commision
				$get_comm = $this->db->get_where('bbps_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'service_id'=>$service_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					$commision = $get_comm['rt_commision'];
					$is_flat = $get_comm['rt_is_flat'];
					$is_surcharge = $get_comm['rt_is_surcharge'];

					$total_distribute_amount = 0;

					if($is_surcharge)
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance - $charge_amount;

					}
					else
					{
						$charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$charge_amount = $commision;
						}

						$after_balance = $before_balance + $charge_amount;
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Charge Amount - '.$charge_amount.' - After Wallet - '.$after_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					if($charge_amount)
					{

						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $account_id,
							'type' => 'BBPS',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $is_surcharge,
							'commision_amount' => $charge_amount,
							'settlement_amount' => $charge_amount,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						if($is_surcharge)
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 2,      
				                'wallet_type'         => 1,  
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Deduction.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
						else
						{
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $account_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,      
				                'wallet_type'         => 1,        
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$account_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
						}
					}
				}

				
				$distributor_id = $this->User->get_distributor_id($account_id);

				$distributor_package_id = $this->User->getMemberPackageID($distributor_id);

				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor ID - '.$distributor_id.']'.PHP_EOL;
        		$this->User->generateLog($log_msg);

				// get master distribution recharge commision
				$get_comm = $this->db->get_where('bbps_commision',array('account_id'=>$domain_account_id,'package_id'=>$distributor_package_id,'service_id'=>$service_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);

				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					$commision = $get_comm['dt_commision'];
					$is_flat = $get_comm['dt_is_flat'];
					$dist_is_surcharge = $get_comm['dt_is_surcharge'];
					if($dist_is_surcharge)
					{
						$dist_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$dist_charge_amount = $commision;
						}

					}
					else
					{
						$dist_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$dist_charge_amount = $commision;
						}
						
					}
					$remaining_charge_amount = 0;
					$deduct_charge_amount = 0;
					if($is_surcharge && $dist_is_surcharge)
					{
						$remaining_charge_amount = $charge_amount - $dist_charge_amount;
						if($charge_amount < $dist_charge_amount)
						{
							$deduct_charge_amount = $dist_charge_amount - $charge_amount;
						}
						$total_distribute_amount+=$remaining_charge_amount;
					}
					else
					{
						if($dist_charge_amount > $charge_amount)
						{
							$remaining_charge_amount = $dist_charge_amount - $charge_amount;
							$total_distribute_amount+=$remaining_charge_amount;
						}
						else
						{
							$remaining_charge_amount = $charge_amount - $dist_charge_amount;
							$deduct_charge_amount = $charge_amount - $dist_charge_amount;
						}
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Distributor Charge Amount - '.$dist_charge_amount.' - Credit Amount - '.$remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					

					if($remaining_charge_amount > 0)
					{
						$after_balance = $before_balance + $remaining_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'BBPS',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $dist_is_surcharge,
							'commision_amount' => $dist_charge_amount,
							'settlement_amount' => $remaining_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $remaining_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1,    
			                'wallet_type'         => 1,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
					elseif($remaining_charge_amount < 0)
					{
						$after_balance = $before_balance - $deduct_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'RECHARGE',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $dist_is_surcharge,
							'commision_amount' => $dist_charge_amount,
							'settlement_amount' => $deduct_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $deduct_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2,   
			                'wallet_type'         => 1,     
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Deduction.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
				}

				$total_downline_com = $charge_amount + $remaining_charge_amount;
				$md_id = $this->User->get_master_distributor_id($distributor_id);

				$md_package_id = $this->User->getMemberPackageID($md_id);

				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - Master Distributor ID - '.$md_id.']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				// get master distribution recharge commision
				$get_comm = $this->db->get_where('bbps_commision',array('account_id'=>$domain_account_id,'package_id'=>$md_package_id,'service_id'=>$service_id))->row_array();
				// save system log
        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
        		$this->User->generateLog($log_msg);
				if($get_comm)
				{
					// debit wallet
                	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();

                	$before_balance = $accountBalanceData['wallet_balance'];
                	// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Wallet Balance - '.$before_balance.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					$commision = $get_comm['commision'];
					$is_flat = $get_comm['is_flat'];
					$md_is_surcharge = $get_comm['is_surcharge'];
					if($md_is_surcharge)
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}

					}
					else
					{
						$md_charge_amount = round(($commision/100)*$amount,2);
						if($is_flat)
						{
							$md_charge_amount = $commision;
						}
						
					}
					$md_remaining_charge_amount = 0;
					$deduct_charge_amount = 0;
					if($is_surcharge && $md_is_surcharge && $dist_is_surcharge)
					{
						$md_remaining_charge_amount = $dist_charge_amount - $md_charge_amount;
						if($dist_charge_amount < $md_charge_amount)
						{
							$deduct_charge_amount = $md_charge_amount - $dist_charge_amount;
						}
						$total_distribute_amount+=$md_remaining_charge_amount;
					}
					else
					{
						if($md_charge_amount > $total_downline_com)
						{
							$md_remaining_charge_amount = $md_charge_amount - $total_downline_com;
							$total_distribute_amount+=$md_remaining_charge_amount;
						}
						else
						{
							$md_remaining_charge_amount = $total_downline_com - $md_charge_amount;
							$deduct_charge_amount = $total_downline_com - $md_charge_amount;
						}
					}

					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - MD Charge Amount - '.$md_charge_amount.' - Credit Amount - '.$md_remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);

					
					if($md_remaining_charge_amount > 0)
					{
						$after_balance = $before_balance + $md_remaining_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'BBPS',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $md_is_surcharge,
							'commision_amount' => $md_charge_amount,
							'settlement_amount' => $remaining_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $md_remaining_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1,   
			                'wallet_type'         => 1,        
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
					elseif($md_remaining_charge_amount < 0)
					{
						$after_balance = $before_balance - $deduct_charge_amount;
						$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'BBPS',
							'record_id' => $recharge_id,
							'commision' => $commision,
							'is_flat' => $is_flat,
							'is_surcharge' => $md_is_surcharge,
							'commision_amount' => $md_charge_amount,
							'settlement_amount' => $deduct_charge_amount,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);
						
						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $deduct_charge_amount,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2,   
			                'wallet_type'         => 1,     
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Deduction.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
						
					}
				}

				if($accountData['account_type'] == 2){

					$admin_id = $this->User->get_admin_id($domain_account_id);
					$admin_package_id = $this->User->get_account_package_id($domain_account_id);
					
					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin ID - '.$admin_id.']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
					// get master distribution recharge commision
					$get_comm = $this->db->get_where('bbps_commision',array('package_id'=>$admin_package_id,'service_id'=>$service_id))->row_array();
					// save system log
	        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Commision Data - '.json_encode($get_comm).']'.PHP_EOL;
	        		$this->User->generateLog($log_msg);
	        		if($get_comm)
					{
						// debit wallet
	                	$accountBalanceData = $this->db->get_where('users',array('id'=>$admin_id,'account_id'=>$domain_account_id))->row_array();

	                	$before_balance = $accountBalanceData['wallet_balance'];
	                	// save system log
		        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Wallet Balance - '.$before_balance.']'.PHP_EOL;
		        		$this->User->generateLog($log_msg);

						$commision = $get_comm['commision'];
						$is_flat = $get_comm['is_flat'];
						$admin_is_surcharge = $get_comm['is_surcharge'];
						if($admin_is_surcharge)
						{
							$admin_charge_amount = round(($commision/100)*$amount,2);
							if($is_flat)
							{
								$admin_charge_amount = $commision;
							}

						}
						else
						{
							$admin_charge_amount = round(($commision/100)*$amount,2);
							if($is_flat)
							{
								$admin_charge_amount = $commision;
							}
							
						}


						$remaining_charge_amount = 0;
						$deduct_charge_amount = 0;
						if($is_surcharge && $admin_is_surcharge)
						{
							$remaining_charge_amount = $charge_amount - $admin_charge_amount;
							$remaining_charge_amount = $remaining_charge_amount - $total_distribute_amount;
						}
						else
						{
							if($admin_charge_amount >= $total_distribute_amount)
							{
								$remaining_charge_amount = $admin_charge_amount - $total_distribute_amount;
							}
							else
							{
								$remaining_charge_amount = $total_distribute_amount - $admin_charge_amount;
								$deduct_charge_amount = $total_distribute_amount - $admin_charge_amount;
							}
						}

						// save system log
		        		$log_msg = '['.date('d-m-Y H:i:s').' - Admin Charge Amount - '.$admin_charge_amount.' - Credit Amount - '.$remaining_charge_amount.' - Deduct Amount - '.$deduct_charge_amount.']'.PHP_EOL;
		        		$this->User->generateLog($log_msg);

						if($remaining_charge_amount > 0)
						{
							$after_balance = $before_balance + $remaining_charge_amount;
							$commisionData = array(
								'account_id' => $domain_account_id,
								'member_id' => $admin_id,
								'type' => 'BBPS',
								'record_id' => $recharge_id,
								'commision' => $commision,
								'is_flat' => $is_flat,
								'is_surcharge' => $admin_is_surcharge,
								'commision_amount' => $admin_charge_amount,
								'settlement_amount' => $remaining_charge_amount,
								'is_downline' => 1,
								'downline_id' => $account_id,
								'before_balance' => $before_balance,
								'after_balance' => $after_balance,
								'status' => 1,
								'created' => date('Y-m-d H:i:s')
							);
							$this->db->insert('user_commision',$commisionData);
							
							$wallet_data = array(
				                'account_id'          => $domain_account_id,
				                'member_id'           => $admin_id,    
				                'before_balance'      => $before_balance,
				                'amount'              => $remaining_charge_amount,  
				                'after_balance'       => $after_balance,      
				                'status'              => 1,
				                'type'                => 1,   
				                'wallet_type'         => 1,      
				                'created'             => date('Y-m-d H:i:s'),      
				                'credited_by'         => $account_id,
				                'description'         => 'Bill #'.$recharge_unique_id.' Pay Commision Credited.'
			                );

			                $this->db->insert('member_wallet',$wallet_data);

			                $user_wallet = array(
			                    'wallet_balance'=>$after_balance,        
			                );    

			                $this->db->where('id',$admin_id);
			                $this->db->where('account_id',$domain_account_id);
			                $this->db->update('users',$user_wallet); 
							
						}
						
					}
				}
			}
		}
		
	}


	public function generate_imei_number()
	{
		$this->load->helper('string');
		$num1 = random_string('numeric', 2);
		$num2 = random_string('alpha', 3);
		$num3 = random_string('numeric', 1);
		$num4 = random_string('alpha', 2);
		$num5 = random_string('numeric', 2);
		$num6 = random_string('alpha', 2);
		$num7 = random_string('numeric', 4);
		return $num1.$num2.$num3.$num4.$num5.$num6.$num7;
	}


	public function generate_bbps_reference_id($recharge_unique_id = '')
	{
		$this->load->helper('string');
		$num1 = date('dMY');
		$num2 = random_string('alpha', 5);
		if($recharge_unique_id)
		{
			$num3 = $recharge_unique_id;
		}
		else
		{
			$num3 = rand(1111,9999).time();
		}
		$num4 = random_string('numeric', 7);
		return $num1.$num2.$num3.$num4;
	}




	public function generate_bbps_token($member_id = 0)
	{
		$account_id = $this->User->get_domain_account();
		// get active token
		$get_token = $this->db->get_where('bbps_token',array('status'=>1))->row_array();
		$access_token = isset($get_token['access_token']) ? $get_token['access_token'] : '';
		if($access_token == '')
		{
			$api_url = BBPS_TOKEN_CREATE_URL;
		 	$headers = [
	            'Content-Type: application/x-www-form-urlencoded'
	        ];

	        $api_post_data = array();
	        $api_post_data['client_id'] = BBPS_CLIENT_ID;
	        $api_post_data['client_secret'] = BBPS_CLIENT_SECRET;
	        $api_post_data['grant_type'] = 'client_credentials';
	        $api_post_data['scope'] = 'read_biller_categories read_billers read_regions read_bills create_transactions read_transactions read_plans register_complain check_complain_status read_operators read_circles read_operator_circle read_packs read_agent_balance';
	        $ch = curl_init();
	        curl_setopt($ch, CURLOPT_URL,$api_url);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	        curl_setopt($ch, CURLOPT_POST, true);
	        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($api_post_data));     
	        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
	        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	        $output = curl_exec ($ch);
	        curl_close ($ch);

	        // save api response 
	        $api_data = array(
	        	'account_id' => $account_id,
	        	'user_id' => $member_id,
	        	'api_response' => $output,
	        	'api_url' => $api_url,
	        	'api_post_data' => json_encode($api_post_data),
	        	'status' => 1,
	        	'created' => date('Y-m-d H:i:s')
	        );
	        $this->db->insert('bbps_api_response',$api_data);

	        $responseData = json_decode($output,true);

	        if(isset($responseData['access_token']) && $responseData['access_token'])
	        {
	        	$access_token = $responseData['access_token'];
	        	$expires_in = $responseData['expires_in'];
	        	$start_datetime = date('Y-m-d H:i:s');
	        	$end_datetime = date('Y-m-d H:i:s',strtotime($start_datetime.' +'.$expires_in.' second'));
	        	// save token data
		        $token_data = array(
		        	'access_token' => $access_token,
		        	'expires_in' => $expires_in,
		        	'start_datetime' => $start_datetime,
		        	'end_datetime' => $end_datetime,
		        	'created_by_account_id' => $account_id,
		        	'created_by_member_id' => $member_id,
		        	'status' => 1,
		        	'api_response' => $output
		        );
		        $this->db->insert('bbps_token',$token_data);
	        }

		}
		return $access_token;
	}

	public function call_bbps_service_bill_fetch_api($member_id = 0,$biller_payu_id = '',$pmr_service_id = 0,$post_data = array())
	{
		$account_id = $this->User->get_domain_account();
		$accountData = $this->User->get_account_data($account_id);
		$api_url = BBPS_SERVICE_BILL_FETCH_URL;
		if($pmr_service_id == 32)
		{
			$number = isset($post_data['number']) ? $post_data['number'] : '';
			$headers = [
	            'Token:'.BBPS_TOKEN,
	            'ServiceID:'.$pmr_service_id,
	            'biller_id:'.$biller_payu_id,
	            'BillerNumber:'.$number,
	            'BillerNumber2:'
	        ];
    	}
    	else
    	{
    		$headers = [
	            'Token:'.BBPS_TOKEN,
	            'ServiceID:'.$pmr_service_id,
	            'biller_id:'.$biller_payu_id
	        ];
    		$params = isset($post_data['params']) ? $post_data['params'] : array();
    		if($params)
	        {
	        	$i = 3;
	        	$k = 1;
	        	foreach($params as $key=>$val)
	        	{
	        		if($i == 3)
	        		{
	        			$headers[$i] = 'BillerNumber:'.$val;
	        		}
	        		else
	        		{
	        			$headers[$i] = 'BillerNumber'.$k.':'.$val;
	        		}
	        		$i++;
	        		$k++;
	        	}
	        }
    	}

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $output = curl_exec ($ch);
        curl_close ($ch);

        // save api response 
        $api_data = array(
        	'account_id' => $account_id,
        	'user_id' => $member_id,
        	'api_response' => $output,
        	'api_url' => $api_url,
        	'api_post_data' => json_encode($headers),
        	'status' => 1,
        	'created' => date('Y-m-d H:i:s')
        );
        $this->db->insert('bbps_api_response',$api_data);

        $responseData = json_decode($output,true);

        // 0 = Error
        // 1 = Success
        
        $status = 0;
        $final_response = array();

        if(isset($responseData['status_code']) && $responseData['status_code'] == 200)
        {
        	$final_response = array(
        		'status' => 1,
        		'amount' => isset($responseData['amount']) ? round($responseData['amount'],2) : 0,
        		'accountHolderName' => isset($responseData['accountHolderName']) ? $responseData['accountHolderName'] : ''
        	);
        }
        else
        {
        	$errors = isset($responseData['status_msg']) ? $responseData['status_msg'] : '';
        	$final_response = array(
        		'status' => 0,
        		'errors' => $errors
        	);
        }

		return $final_response;
	}

	public function call_bbps_service_bill_pay_api($member_id = 0,$biller_payu_id = '',$pmr_service_id = 0,$post_data = array(),$recharge_unique_id = '',$billerName = '')
	{
		$account_id = $this->User->get_domain_account();
		$accountData = $this->User->get_account_data($account_id);
		
		$api_url = BBPS_SERVICE_BILL_PAY_URL;
		if($pmr_service_id == 32)
		{
			$number = isset($post_data['number']) ? $post_data['number'] : '';
		 	$headers = [
	            'Token:'.BBPS_TOKEN,
	            'ServiceID:'.$pmr_service_id,
	            'biller_id:'.$biller_payu_id,
	            'BillerNumber:'.$number,
	            'BillerNumber2:',
	            'BillerName:'.$billerName,
	            'BillAmount:'.$post_data['amount'],
	            'TransID:'.$recharge_unique_id
	        ];
	    }
	    else
	    {
	    	$params = isset($post_data['params']) ? $post_data['params'] : array();
	    	$headers = [
	            'Token:'.BBPS_TOKEN,
	            'ServiceID:'.$pmr_service_id,
	            'biller_id:'.$biller_payu_id,
	            'BillerName:'.$billerName,
	            'BillAmount:'.$post_data['amount'],
	            'TransID:'.$recharge_unique_id
	        ];

	        if($params)
	        {
	        	$i = 6;
	        	$k = 1;
	        	foreach($params as $key=>$val)
	        	{
	        		if($i == 6)
	        		{
	        			$headers[$i] = 'BillerNumber:'.$val;
	        		}
	        		else
	        		{
	        			$headers[$i] = 'BillerNumber'.$k.':'.$val;
	        		}
	        		$i++;
	        		$k++;
	        	}
	        }
	    }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $output = curl_exec ($ch);
        curl_close ($ch);

        // save api response 
        $api_data = array(
        	'account_id' => $account_id,
        	'user_id' => $member_id,
        	'api_response' => $output,
        	'api_url' => $api_url,
        	'api_post_data' => json_encode($headers),
        	'status' => 1,
        	'created' => date('Y-m-d H:i:s')
        );
        $this->db->insert('bbps_api_response',$api_data);
        $response_id = $this->db->insert_id();

        
        $responseData = json_decode($output,true);

        // 0 = Error
        // 1 = Success
        // 2 = Pending

        $status = 2;
        $final_response = array();

        if(isset($responseData['status_code']) && $responseData['status_code'] == 200)
        {
        	if($responseData['status'] == 'SUCCESS')
        	{
	        	$final_response = array(
	        		'status' => 1,
	        		'txnid' => isset($responseData['optTxnID']) ? $responseData['optTxnID'] : '',
	        		'response_id' => $response_id
	        	);
        	}
        	elseif($responseData['status'] == 'PENDING')
        	{
        		$final_response = array(
	        		'status' => 2,
	        		'txnid' => isset($responseData['optTxnID']) ? $responseData['optTxnID'] : '',
	        		'response_id' => $response_id
	        	);
        	}
        	elseif($responseData['status'] == 'FAILED')
        	{
        		$errors = isset($responseData['optMsg']) ? $responseData['optMsg'] : '';
	        	$final_response = array(
	        		'status' => 0,
	        		'errors' => $errors
	        	);
        	}

        }
        elseif(!$responseData)
        {
        	$final_response = array(
        		'status' => 2,
        		'txnid' => isset($responseData['optTxnID']) ? $responseData['optTxnID'] : '',
        		'response_id' => $response_id
        	);
        }
        else
        {
        	$errors = isset($responseData['status_msg']) ? $responseData['status_msg'] : '';
        	$final_response = array(
        		'status' => 0,
        		'errors' => $errors
        	);
        }

		return $final_response;
	}

	public function call_bbps_electricity_bill_fetch_api($member_id = 0,$biller_payu_id = '',$pmr_service_id = 0,$post_data = array())
	{
		$account_id = $this->User->get_domain_account();
		$accountData = $this->User->get_account_data($account_id);
		$params = isset($post_data['params']) ? $post_data['params'] : array();
		$api_url = BBPS_ELECTRICITY_BILL_FETCH_URL;
	 	$headers = [
            'Token:'.BBPS_TOKEN,
            'ServiceID:'.$pmr_service_id,
            'biller_id:'.$biller_payu_id
        ];

        if($params)
        {
        	$i = 3;
        	$k = 1;
        	foreach($params as $key=>$val)
        	{
        		if($i == 3)
        		{
        			$headers[$i] = 'BillerNumber:'.$val;
        		}
        		else
        		{
        			$headers[$i] = 'BillerNumber'.$k.':'.$val;
        		}
        		$i++;
        		$k++;
        	}
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $output = curl_exec ($ch);
        curl_close ($ch);

        // save api response 
        $api_data = array(
        	'account_id' => $account_id,
        	'user_id' => $member_id,
        	'api_response' => $output,
        	'api_url' => $api_url,
        	'api_post_data' => json_encode($headers),
        	'status' => 1,
        	'created' => date('Y-m-d H:i:s')
        );
        $this->db->insert('bbps_api_response',$api_data);

        $responseData = json_decode($output,true);

        // 0 = Error
        // 1 = Success
        
        $status = 0;
        $final_response = array();

        if(isset($responseData['status_code']) && $responseData['status_code'] == 200)
        {
        	$final_response = array(
        		'status' => 1,
        		'amount' => isset($responseData['amount']) ? round($responseData['amount'],2) : 0,
        		'accountHolderName' => isset($responseData['accountHolderName']) ? $responseData['accountHolderName'] : ''
        	);
        }
        else
        {
        	$errors = isset($responseData['status_msg']) ? $responseData['status_msg'] : '';
        	$final_response = array(
        		'status' => 0,
        		'errors' => $errors
        	);
        }

		return $final_response;
	}

	public function call_bbps_electricity_bill_pay_api($member_id = 0,$biller_payu_id = '',$pmr_service_id = 0,$post_data = array(),$recharge_unique_id = '',$billerName = '')
	{
		$account_id = $this->User->get_domain_account();
		$accountData = $this->User->get_account_data($account_id);
		$params = isset($post_data['params']) ? $post_data['params'] : array();
		$api_url = BBPS_ELECTRICITY_BILL_PAY_URL;
	 	$headers = [
            'Token:'.BBPS_TOKEN,
            'ServiceID:'.$pmr_service_id,
            'biller_id:'.$biller_payu_id,
            'BillerName:'.$billerName,
            'BillAmount:'.$post_data['amount'],
            'TransID:'.$recharge_unique_id
        ];

        if($params)
        {
        	$i = 6;
        	$k = 1;
        	foreach($params as $key=>$val)
        	{
        		if($i == 6)
        		{
        			$headers[$i] = 'BillerNumber:'.$val;
        		}
        		else
        		{
        			$headers[$i] = 'BillerNumber'.$k.':'.$val;
        		}
        		$i++;
        		$k++;
        	}
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $output = curl_exec ($ch);
        curl_close ($ch);

        // save api response 
        $api_data = array(
        	'account_id' => $account_id,
        	'user_id' => $member_id,
        	'api_response' => $output,
        	'api_url' => $api_url,
        	'api_post_data' => json_encode($headers),
        	'status' => 1,
        	'created' => date('Y-m-d H:i:s')
        );
        $this->db->insert('bbps_api_response',$api_data);
        $response_id = $this->db->insert_id();

        
        $responseData = json_decode($output,true);

        // 0 = Error
        // 1 = Success
        // 2 = Pending

        $status = 2;
        $final_response = array();

        if(isset($responseData['status_code']) && $responseData['status_code'] == 200)
        {
        	if($responseData['status'] == 'SUCCESS')
        	{
	        	$final_response = array(
	        		'status' => 1,
	        		'txnid' => isset($responseData['optTxnID']) ? $responseData['optTxnID'] : '',
	        		'response_id' => $response_id
	        	);
        	}
        	elseif($responseData['status'] == 'PENDING')
        	{
        		$final_response = array(
	        		'status' => 2,
	        		'txnid' => isset($responseData['optTxnID']) ? $responseData['optTxnID'] : '',
	        		'response_id' => $response_id
	        	);
        	}
        	elseif($responseData['status'] == 'FAILED')
        	{
        		$errors = isset($responseData['optMsg']) ? $responseData['optMsg'] : '';
	        	$final_response = array(
	        		'status' => 0,
	        		'errors' => $errors
	        	);
        	}

        }
        elseif(!$responseData)
        {
        	$final_response = array(
        		'status' => 2,
        		'txnid' => isset($responseData['optTxnID']) ? $responseData['optTxnID'] : '',
        		'response_id' => $response_id
        	);
        }
        else
        {
        	$errors = isset($responseData['status_msg']) ? $responseData['status_msg'] : '';
        	$final_response = array(
        		'status' => 0,
        		'errors' => $errors
        	);
        }

		return $final_response;
	}


	public function get_bbps_api_balance($member_id = 0)
	{
		$account_id = $this->User->get_domain_account();
		$access_token = $this->User->generate_bbps_token($member_id);
		
		$api_url = BBPS_NBC_API_URL.'getAgentBalance?agentId='.BBPS_AGENT_ID;
	 	$headers = [
            'Authorization:bearer '.$access_token
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $output = curl_exec ($ch);
        curl_close ($ch);

        // save api response 
        $api_data = array(
        	'account_id' => $account_id,
        	'user_id' => $member_id,
        	'api_response' => $output,
        	'api_url' => $api_url,
        	'api_post_data' => '',
        	'status' => 1,
        	'created' => date('Y-m-d H:i:s')
        );
        $this->db->insert('bbps_api_response',$api_data);
        
        $responseData = json_decode($output,true);

        // 0 = Error
        // 1 = Success
        
        $balance = 0;
        
        if(isset($responseData['balance']))
        {
        	$balance = $responseData['balance'];
        }
        
		return $balance;
	}

	public function get_api_operator_name($api_id = 0,$operator_code = '',$account_id = 0)
	{
		$operator_name = '';
		if($api_id && $operator_code)
		{
			if($account_id)
			{
				$get_operator_name = $this->db->select('operator.operator_name')->join('operator','operator.id = api_operator.opt_id')->get_where('api_operator',array('api_operator.account_id'=>$account_id,'api_operator.api_id'=>$api_id,'api_operator.opt_code'=>$operator_code))->row_array();
			}
			else
			{
				$get_operator_name = $this->db->select('operator.operator_name')->join('operator','operator.id = api_operator.opt_id')->get_where('api_operator',array('api_operator.api_id'=>$api_id,'api_operator.opt_code'=>$operator_code))->row_array();
			}
			$operator_name = isset($get_operator_name['operator_name']) ? $get_operator_name['operator_name'] : '';
		}
		return $operator_name;
	}


	public function getDthOperatorBillerDetail($operator_code = '',$card_number = '',$account_id = 0)
	{
		
		if($account_id){
			

			$url = DTH_BILLER_DETAIL_API_URL;

			$ch = curl_init();

			$headers = array(
			   "Content-Type: application/x-www-form-urlencoded",
			   "Token : ".PLAN_FINDER_API_TOKEN, 
			);

			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS,
            'VCnumber='.$card_number.'&operatorName='.$operator_code.'');
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
			curl_setopt($ch, CURLOPT_TIMEOUT, 30);	
			$output = curl_exec($ch); 
			curl_close($ch);
			
				

			$api_response = json_decode($output,true);
			

			$response = array();
			$detail = (array) $api_response['Data']['records'][0];
			if($api_response['Error'] == "False" && $api_response['Message'] == "Success" && isset($detail['customerName'])){
              
              	$response = array(

           			'status' => 1,
           			'message' => 'success',
           			'biller_name' => $detail['customerName'],
           			'amount'     => $detail['Balance']	
           		);
			
			}
			else{

				$response = array(

				  'status' => 0,
				  'message'=> 'Sorry!! Biller is not valid.'		

				);
			}
			
		}
		else
		{
			$response = array(
				'status' => 0,
				'msg' => 'Please login for getting the biller detail.'
			);
		}
		
		return $response;
		
		
	}


	public function menu_permission($menu_id = 0, $type = 1)
	{
		$loggedUser = $this->User->getLoggedUser(SUPERADMIN_EMPLOYE_SESSION_ID);
		$account_id = $loggedUser['id'];
		// get account access role
		$get_access_role_id = $this->db->select('employe_role')->get_where('users',array('id'=>$account_id))->row_array();
		$access_role_id = isset($get_access_role_id['employe_role']) ? $get_access_role_id['employe_role'] : 0 ;
		$column = 'menu_id';
		if($type == 2)
		{
			$column = 'sub_menu_id';
		}
		// check role id 
		$chk_role = $this->db->get_where('superadmin_role_permission',array('role_id'=>$access_role_id,$column=>$menu_id))->num_rows();
		return $chk_role;
	}


	public function admin_menu_permission($menu_id = 0, $type = 1)
	{
		$loggedUser = $this->User->getLoggedUser(ADMIN_EMPLOYE_SESSION_ID);
		$account_id = $loggedUser['id'];
		// get account access role
		$get_access_role_id = $this->db->select('employe_role')->get_where('users',array('id'=>$account_id))->row_array();
		$access_role_id = isset($get_access_role_id['employe_role']) ? $get_access_role_id['employe_role'] : 0 ;
		$column = 'menu_id';
		if($type == 2)
		{
			$column = 'sub_menu_id';
		}
		// check role id 
		$chk_role = $this->db->get_where('admin_role_permission',array('role_id'=>$access_role_id,$column=>$menu_id))->num_rows();
		return $chk_role;
	}


	public function sendOtp($user_id='',$otp_code='',$post){

		$account_id = $this->User->get_domain_account();


		if($user_id && $otp_code){

			$status = $this->db->get_where('users',array('id'=>$user_id,'account_id'=>$account_id))->row_array();

		    $sms = ''.$otp_code.' is the One Time Password (OTP) for Login at Maxpaymoney.';

			$mobile = $status['mobile'];

			$api_url = SMS_API_URL.'authkey='.SMS_AUTH_KEY.'&mobiles='.$mobile.'&message='.urlencode($sms).'&sender='.SMS_SENDER_ID.'&route=4&country=91&DLT_TE_ID=1207163911970006958';
						
	        
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $api_url);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
			$output = curl_exec($ch); 
			curl_close($ch);


			$encoded_otp_code = do_hash($otp_code);

			$otp_data = array(
				'account_id' => $account_id,
				'member_id'  => $status['id'],
				'otp_code'   => $otp_code,
				'encrypt_otp_code'=> do_hash($otp_code),
				'mobile' =>  $status['mobile'],
				'status' => 0,
				'json_post_data' => json_encode($post),
				'created' => date('Y-m-d H:i:s')	
			);

			$this->db->insert('users_otp',$otp_data);


		}

		return true;
	}

	public function getMemberCollectionWalletBalance($account_id = 0)
	{
		// get domain id
		$get_domain_id = $this->db->select('collection_wallet_balance')->get_where('users',array('id'=>$account_id))->row_array();
		return isset($get_domain_id['collection_wallet_balance']) ? $get_domain_id['collection_wallet_balance'] : 0;
	}


	public function get_admin_aeps_commission($amount = 0, $loggedAccountID = 0, $com_type = 0)
	{
		$member_package_id = $this->User->get_account_package_id($loggedAccountID);
		$surcarge_amount = 0;
		$is_surcharge = 0;
		$domain_account_id = 10000;
		$commission_amount = 0;
		// get surcharge
		$getSurcharge = $this->db->get_where('aeps_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'start_range <='=>$amount,'end_range >='=>$amount,'com_type'=>$com_type))->row_array();
		
		if($getSurcharge)
		{
			$commission = $getSurcharge['commission'];
			$is_flat = $getSurcharge['is_flat'];
			$is_surcharge = $getSurcharge['is_surcharge'];

			$commission_amount = round(($commission/100)*$amount,2);
			if($is_flat)
			{
				$commission_amount = $commission;
			}
		}
		return array('commission_amount'=>$commission_amount,'is_surcharge'=>$is_surcharge);
	}


	public function getSuperadminCollectionWalletBalance($account_id = 0)
	{
		// get domain id
		$get_domain_id = $this->db->select('SUM(collection_wallet_balance) as totalBalance')->get_where('users',array('role_id'=>2))->row_array();
		return isset($get_domain_id['totalBalance']) ? $get_domain_id['totalBalance'] : 0;
	}


	public function getMemberRoleID($account_id = 0)
	{
		// get domain id
		$get_domain_id = $this->db->select('role_id')->get_where('users',array('id'=>$account_id))->row_array();
		return isset($get_domain_id['role_id']) ? $get_domain_id['role_id'] : 0;
	}

	public function distribute_aeps_commision($dmt_id, $transaction_id, $amount, $account_id, $com_amount,$is_surcharge,$com_type,$user_type = '',$user_code = '')
	{

		$domain_account_id = $this->User->get_domain_account();
		// get account role id
		$get_role_id = $this->db->select('role_id')->get_where('users',array('id'=>$account_id,'account_id'=>$domain_account_id))->row_array();
		$user_role_id = isset($get_role_id['role_id']) ? $get_role_id['role_id'] : 0 ;
		// save system log
	    $log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - User Role - '.$user_role_id.']'.PHP_EOL;
	    $this->User->generateLog($log_msg);
        if($user_role_id == 4)
		{
			$md_id = $this->User->get_master_distributor_id($account_id);

			// get dmr surcharge
            $commisionData = $this->User->get_aeps_commission($amount,$md_id,$com_type);
            $md_amount = isset($commisionData['commission_amount']) ? $commisionData['commission_amount'] : 0 ;
        	$md_is_surcharge = isset($commisionData['is_surcharge']) ? $commisionData['is_surcharge'] : 0 ;
            // save system log
	    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - MD Amount - '.$md_amount.' - MD Is Surcharge - '.$md_is_surcharge.']'.PHP_EOL;
	    	$this->User->generateLog($log_msg);

	    	if($is_surcharge)
	    	{
	    		if($com_amount > $md_amount)
	    		{
	    			$commision = $com_amount - $md_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - MD Commision - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance + $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    		elseif($com_amount < $md_amount)
	    		{
	    			$commision = $md_amount - $com_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - MD Charge - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance - $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_surcharge' => 1,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Charge Debited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    	}
	    	else
	    	{
	    		if($com_amount > $md_amount)
	    		{
	    			$commision = $com_amount - $md_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - MD Charge - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance - $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_surcharge' => 1,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Charge Debited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    		elseif($com_amount < $md_amount)
	    		{
	    			$commision = $md_amount - $com_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - MD Commision - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance + $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    	}

		}
		elseif($user_role_id == 5)
		{
			$distributor_id = $this->User->get_distributor_id($account_id);

			// get dmr surcharge
            $dtCommisionData = $this->User->get_aeps_commission($amount,$distributor_id,$com_type);
            $dt_amount = isset($dtCommisionData['commission_amount']) ? $dtCommisionData['commission_amount'] : 0 ;
        	$dt_is_surcharge = isset($dtCommisionData['is_surcharge']) ? $dtCommisionData['is_surcharge'] : 0 ;
            // save system log
	    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - DT Amount - '.$md_amount.' - DT Is Surcharge - '.$md_is_surcharge.']'.PHP_EOL;
	    	$this->User->generateLog($log_msg);

	    	if($is_surcharge)
	    	{
	    		if($com_amount > $dt_amount)
	    		{
	    			$commision = $com_amount - $dt_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - DT Commision - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance + $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    		elseif($com_amount < $dt_amount)
	    		{
	    			$commision = $dt_amount - $com_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - DT Charge - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance - $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_surcharge' => 1,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Charge Debited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    	}
	    	else
	    	{
	    		if($com_amount > $dt_amount)
	    		{
	    			$commision = $com_amount - $dt_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - DT Charge - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance - $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_surcharge' => 1,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Charge Debited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    		elseif($com_amount < $dt_amount)
	    		{
	    			$commision = $dt_amount - $com_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - DT Commision - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$distributor_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance + $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $distributor_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $distributor_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$distributor_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    	}

            $md_id = $this->User->get_master_distributor_id($distributor_id);

			// get dmr surcharge
            $commisionData = $this->User->get_aeps_commission($amount,$md_id,$com_type);
            $md_amount = isset($commisionData['commission_amount']) ? $commisionData['commission_amount'] : 0 ;
        	$md_is_surcharge = isset($commisionData['is_surcharge']) ? $commisionData['is_surcharge'] : 0 ;
            // save system log
	    	$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - MD Amount - '.$md_amount.' - MD Is Surcharge - '.$md_is_surcharge.']'.PHP_EOL;
	    	$this->User->generateLog($log_msg);

	    	if($is_surcharge)
	    	{
	    		if($dt_amount > $md_amount)
	    		{
	    			$commision = $dt_amount - $md_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - MD Commision - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance + $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    		elseif($dt_amount < $md_amount)
	    		{
	    			$commision = $md_amount - $dt_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - MD Charge - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance - $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_surcharge' => 1,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Charge Debited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    	}
	    	else
	    	{
	    		if($dt_amount > $md_amount)
	    		{
	    			$commision = $dt_amount - $md_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - MD Charge - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance - $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_surcharge' => 1,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 2, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Charge Debited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    		elseif($dt_amount < $md_amount)
	    		{
	    			$commision = $md_amount - $dt_amount;
		    		// save system log
		    		$log_msg = '['.date('d-m-Y H:i:s').' - '.$user_type.'('.$user_code.') - AEPS - Distribute Commision/Surcharge - MD Commision - '.$commision.']'.PHP_EOL;
		    		$this->User->generateLog($log_msg);
		    		if($commision)
		    		{
		    			// credit wallet
		            	$accountBalanceData = $this->db->get_where('users',array('id'=>$md_id,'account_id'=>$domain_account_id))->row_array();
						$before_balance = $accountBalanceData['aeps_wallet_balance'];
						$after_balance = $before_balance + $commision;

		            	$commisionData = array(
							'account_id' => $domain_account_id,
							'member_id' => $md_id,
							'type' => 'AEPS',
							'record_id' => $dmt_id,
							'commision_amount' => $commision,
							'is_downline' => 1,
							'downline_id' => $account_id,
							'before_balance' => $before_balance,
							'after_balance' => $after_balance,
							'status' => 1,
							'created' => date('Y-m-d H:i:s')
						);
						$this->db->insert('user_commision',$commisionData);

						$wallet_data = array(
			                'account_id'          => $domain_account_id,
			                'member_id'           => $md_id,    
			                'before_balance'      => $before_balance,
			                'amount'              => $commision,  
			                'after_balance'       => $after_balance,      
			                'status'              => 1,
			                'type'                => 1, 
			                'wallet_type'		  => 2,       
			                'created'             => date('Y-m-d H:i:s'),      
			                'credited_by'         => $account_id,
			                'description'         => 'AEPS Txn #'.$transaction_id.' Commision Credited.'
		                );

		                $this->db->insert('member_wallet',$wallet_data);

		                $user_wallet = array(
		                    'aeps_wallet_balance'=>$after_balance,        
		                );    

		                $this->db->where('id',$md_id);
		                $this->db->where('account_id',$domain_account_id);
		                $this->db->update('users',$user_wallet); 
		    		}
	    		}
	    	}
		}
	}



	public function get_upi_commission($loggedAccountID = 0, $amount = 0)
	{
		$member_package_id = $this->User->getMemberPackageID($loggedAccountID);
		$member_role_id = $this->User->getMemberRoleID($loggedAccountID);
		$is_surcharge = 0;
		$domain_account_id = 2;
		$commission_amount = 0;
		// get surcharge
		
		$getSurcharge = $this->db->get_where('upi_commision',array('account_id'=>$domain_account_id,'package_id'=>$member_package_id,'start_range <='=>$amount,'end_range >='=>$amount))->row_array();
		
		if($getSurcharge)
		{
			$is_flat = $getSurcharge['is_flat'];
			$is_surcharge = $getSurcharge['is_surcharge'];
			if($member_role_id == 3)
			{
				$commission = $getSurcharge['md_commision'];
			}
			elseif($member_role_id == 4)
			{
				$commission = $getSurcharge['dt_commision'];
			}
			elseif($member_role_id == 5)
			{
				$commission = $getSurcharge['rt_commision'];
			}
			elseif($member_role_id == 6)
			{
				$commission = $getSurcharge['commission'];
			}
			elseif($member_role_id == 8)
			{
				$commission = $getSurcharge['user_commision'];
			}
			if($commission)
			{
				$commission_amount = round(($commission/100)*$amount,2);
				if($is_flat)
				{
					$commission_amount = $commission;
				}
			}
		}
		return array('commission_amount'=>$commission_amount,'is_surcharge'=>$is_surcharge);
	}
	
	
    	public function getMemberWalletBalanceSP($account_id = 0, $walletType = 1)
	{
		if(IS_POSTGRES_DB == 1)
		{
			$procQuery = $this->db->query("SELECT getwalletbalance($account_id,$walletType) as actualbalance;");
	        $procResponse = $procQuery->row_array();
	        $before_wallet_balance = isset($procResponse['actualbalance']) ? ($procResponse['actualbalance']) ? $procResponse['actualbalance'] : 0 : 0 ;
	    }
		else
		{
			$callStoreProc = "CALL getwalletbalance(?,?)";
	        $queryData = array('member_id' => $account_id,'walletType'=>$walletType);
	        $procQuery = $this->db->query($callStoreProc, $queryData);
	        $procResponse = $procQuery->row_array();
	        //add this two line 
	        $procQuery->next_result(); 
	        $procQuery->free_result(); 
	        $before_wallet_balance = isset($procResponse['actualBalance']) ? $procResponse['actualBalance'] : 0 ;
    	}
		return $before_wallet_balance;
	}
	
	public function getMemberUpiWalletBalanceSP($account_id = 0, $walletType = 1)
	{
		/*$callStoreProc = "CALL getUpiWalletBalance(?,?)";
        $queryData = array('member_id' => $account_id,'walletType'=>$walletType);
        $procQuery = $this->db->query($callStoreProc, $queryData);
        $procResponse = $procQuery->row_array();
        //add this two line 
        $procQuery->next_result(); 
        $procQuery->free_result(); 
        $before_wallet_balance = isset($procResponse['actualBalance']) ? $procResponse['actualBalance'] : 0 ;
        */
        
         $procResponse = $this->db->query("SELECT ROUND(SUM((CASE WHEN type = 1 THEN amount ELSE CONCAT('-',amount) END)),2) as actualBalance FROM tbl_member_upi_wallet WHERE member_id = '$account_id' and wallet_type = 1")->row_array();
        
     	$before_wallet_balance = isset($procResponse['actualBalance']) ? $procResponse['actualBalance'] : 0 ;
    
    
		return $before_wallet_balance;
	}
	
	public function getMemberAepsWalletBalanceSP($account_id = 0, $walletType = 2)
	{
		$callStoreProc = "CALL getAepsWalletBalance(?,?)";
        $queryData = array('member_id' => $account_id,'walletType'=>$walletType);
        $procQuery = $this->db->query($callStoreProc, $queryData);
        $procResponse = $procQuery->row_array();
      
        //add this two line 
        $procQuery->next_result(); 
        $procQuery->free_result(); 
     	$before_wallet_balance = isset($procResponse['actualBalance']) ? $procResponse['actualBalance'] : 0 ;
    
		return $before_wallet_balance;
	}
	
	public function get_lat_lon($address = '')
	{
		$api_url = 'https://maps.googleapis.com/maps/api/geocode/json?address='.urlencode($address).'&sensor=false&key=AIzaSyBqKeybSwcaOp9vdjAbhF1Pt-t3teXNHCE';
		$ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $output = curl_exec ($ch);
        curl_close ($ch);

        $decodeResponse = json_decode($output,true);
        $lat = isset($decodeResponse['results'][0]['geometry']['location']['lat']) ? $decodeResponse['results'][0]['geometry']['location']['lat'] : '';
        $lng = isset($decodeResponse['results'][0]['geometry']['location']['lng']) ? $decodeResponse['results'][0]['geometry']['location']['lng'] : '';

        return array('lat'=>$lat,'lng'=>$lng);
	}
	
	
	public function get_member_qr_status($member_id = 0)
	{
		$domain_account_id = $this->User->get_domain_account();
		$chk_member = $this->db->get_where('users',array('id'=>$member_id,'account_id'=>$domain_account_id,'is_static_qr'=>1))->num_rows();
		return $chk_member;
	}
	
	
	
	public function generateUpiCollectionLog($log_msg = '')
	{
		$account_id = $this->User->get_domain_account();
		$log_file = 'UPI-Account-'.$account_id.'-'.date('d-M-Y').'.php';
		write_file(ACCOUNT_LOG_PATH.$log_file,$log_msg.'[break]','a+');
		return true;
	}
	
	public function get_user_ip()
	{
		return $_SERVER['REMOTE_ADDR'];
	}
	
	public function get_upi_payin_active_api($loggedAccountID = 0){

		$get_active_api = $this->db->get_where('member_upi_active_api',array('user_id'=>$loggedAccountID))->row_array();

		$active_api_id = isset($get_active_api['api_id']) ? $get_active_api['api_id'] : 2;

		$response = array(

			'status' => 1,
			'active_api_id' => $active_api_id
		);

		return $response;

	}
	
	public function get_payout_active_api($loggedAccountID = 0){

		$get_active_api = $this->db->get_where('member_payout_active_api',array('user_id'=>$loggedAccountID))->row_array();

		$active_api_id = isset($get_active_api['api_id']) ? $get_active_api['api_id'] : 1;

		$response = array(

			'status' => 1,
			'active_api_id' => $active_api_id
		);

		return $response;

	}
	
	public function get_zyro_token($loggedAccountID = 0){
        
        
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://payout.myzyro.com/api/ZyroBanking/UserLogin',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
 "UserId": "amginfotechs@gmail.com",
 "Password": "5|Qyl\'T&7g9K"
} ',
  CURLOPT_HTTPHEADER => array(
    'X-Zyro-Key: CB4B3C0C-F5D5-41AB-B7D8-321F17EC0CE9',
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);

curl_close($curl);

 $responseData = json_decode($response,true);
 
         if($responseData['success'] == 'true')
         {
             $token = isset($responseData['data']['token']) ? $responseData['data']['token'] : '' ;
             
             	return $token;
             
         }
         else
         {
             $token = '';
             return $token;
             
         }

	

	}
	
	public function zyroEncryptData($post_data)
	{
	    $datapost = json_encode($post_data);   
    $method = "AES-256-CBC";
    $encryption_key = 'JZqVGkPiT_6ZMJTt@h2XTjtGtZMgtAXV';
    $iv = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";

    // $ciphertext = openssl_encrypt($plaintext, $method, $key, OPENSSL_RAW_DATA, $iv);
    // $hash = hash_hmac('sha256', $ciphertext . $iv, $key, true);
    //$cipher  =   openssl_encrypt(json_encode($datapost,true), 'AES-256-CBC', $key, $options=OPENSSL_RAW_DATA, $iv);
    //$body=       base64_encode($cipher);
    $encrypted_data = openssl_encrypt($datapost, $method, $encryption_key, 0, $iv); 
    
    return $encrypted_data;
	}
	
	
// 	public function payolPayoutApi($account_holder_name,$account_no,$ifsc,$getAccountData,$transaction_id,$mobile,$domain_account_id,$loggedAccountID,$final_amount,$amount,$admin_surcharge_amount,$memberID,$old_transaction_id)
//     {

//             //payol api call for payout 
         
//             $api_url = PAYOL_OPEN_PAYOUT_API_URL;
         
//             $postdata = array(
//                 'bene_id' => $bene_id,
//                 'txnID' => $transaction_id,
//                 'amount'=>$amount,
//                 'payment_mode'=>'imps'
//             );

//             $curl = curl_init();

//             curl_setopt_array($curl, array(
//                 CURLOPT_URL => $api_url,
//                 CURLOPT_RETURNTRANSFER => true,
//                 CURLOPT_ENCODING => '',
//                 CURLOPT_MAXREDIRS => 10,
//                 CURLOPT_TIMEOUT => 0,
//                 CURLOPT_FOLLOWLOCATION => true,
//                 CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//                 CURLOPT_CUSTOMREQUEST => 'POST',
//                 CURLOPT_POSTFIELDS =>$postdata,
//                 CURLOPT_HTTPHEADER => array(
//                     'Memberid:'.PAYOL_MEMBER_ID,
//                     'Txnpwd:'.PAYOL_TXN_PASS
//                 ),
//             ));
//             $response = curl_exec($curl);


//             $payoutResponseData = json_decode($output,true);

//             $log_msg = '['.date('d-m-Y H:i:s').' - Fund Transfer API Txnid : '.$transaction_id.' Express Payout API Response : '.$response.']'.PHP_EOL;
//             $this->User->generateLog($log_msg);
            
//             // save api response
//             $apiData = array(
//                 'account_id' => $domain_account_id,
//                 'user_id' => $loggedAccountID,
//                 'recharge_id' => $transaction_id,
//                 'api_response' => $response,
//                 'api_url' => $api_url,
//                 'status' => 1,
//                 'is_dmr' => 1,
//                 'created' => date('Y-m-d H:i:s')
//             );
//             $this->db->insert('api_response',$apiData);

//             if(isset($payoutResponseData) && $payoutResponseData['status_code'] == 401 && $payoutResponseData['status_msg'] == 'Insuficient balance in account wallet'){

//                 $finalResponse = array(
//                     'status' => 1,
//                     'opt_msg' => 'Your transaction is under processing, status will be updated soon.'
//                 );

//             }
//             elseif(isset($payoutResponseData) && ($payoutResponseData['status_code'] == 200 && $payoutResponseData['status'] == 'FAILED')){

                
//                 $this->db->where('account_id',$domain_account_id);
//                 $this->db->where('id',$recordID);
//                 $this->db->where('user_id',$loggedAccountID);
//                 $this->db->where('transaction_id',$old_transaction_id);
//                 $this->db->update('user_fund_transfer',array('status'=>4,'updated'=>date('Y-m-d H:i:s')));

//                 $before_balance =  $this->User->getMemberAepsWalletBalanceSP($loggedAccountID,2);
//                 $after_balance = $before_balance + $final_amount;    
                
//                 // save system log
//                 $log_msg = '['.date('d-m-Y H:i:s').' - Payout Callback API Txnid : '.$transaction_id.' Refund to Member - '.$memberID.' - Before Balance - '.$before_balance.' - Refund Amount - '.$final_amount.' - After Balance - '.$after_balance.'.]'.PHP_EOL;
                        
//                 $wallet_data = array(
//                     'account_id'          => $domain_account_id,
//                     'member_id'           => $loggedAccountID,    
//                     'before_balance'      => $before_balance,
//                     'amount'              => $final_amount,  
//                     'after_balance'       => $after_balance,      
//                     'status'              => 1,
//                     'type'                => 1,  
//                     'wallet_type'         => 2,          
//                     'created'             => date('Y-m-d H:i:s'),      
//                     'credited_by'         => 1,
//                     'description'         => 'Express Payout #'.$transaction_id.' Refund Credited'
//                 );

//                 $this->db->insert('member_wallet',$wallet_data);
                
//                 $finalResponse = array(
//                     'status' => 3,
//                     'opt_msg' => 'Transcation Failed From Bank Side.'
//                 );
                                    
//             }
//             else{

//                 $finalResponse = array(
//                     'status' => 2,                  
//                     'opt_msg' => 'Your transaction is under processing, status will be updated soon.'
//                 );
//             }

//         }
       	
//         return $finalResponse;
//     }

    //open money payout api

    public function openMoneyPayoutApi($account_holder_name,$account_no,$ifsc,$getAccountData,$transaction_id,$mobile,$domain_account_id,$loggedAccountID,$final_amount,$amount,$admin_surcharge_amount,$memberID,$old_transaction_id,$bene_id,$recordID)
    {
        

            //payol api call for payout                                          
             $api_url = OPEN_MONEY_PAYOUT_URL;

            $request = array(
                'type'=> 'account_number',
                'currency_code'=> 'inr',
                'debit_account_id'=> 'va_7LGrwW1IeKIs3YD2vxtiEMSyJ',
                'beneficiary_id'=> $bene_id,
                'amount'=> floatval($amount),
                'payment_mode' => 'imps',
                'merchant_reference_id'=> $transaction_id,
                'payment_remark'=> 'payout'
            );  

            $header = array(
               'Authorization: Bearer ak_live_naXGOTL7CVju0xUOgjy4qM8Qlr1Lg3ABNneW:sk_live_U6YuRUhBDaNFUHCLNJkfmByj42845Kusld9N',
                'content-type: application/json',
                'accept: application/json'                                          
            );


            $curl = curl_init();
            // URL
            curl_setopt($curl, CURLOPT_URL, $api_url);

            // Return Transfer
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

            // SSL Verify Peer
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);

            // SSL Verify Host
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);

            // Timeout
            curl_setopt($curl, CURLOPT_TIMEOUT, 30);

            // HTTP Version
            curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);

            // Request Method
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");

            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);

            // Request Body
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($request));

            // Execute
            $output = curl_exec($curl);
    
            curl_close ($curl);

            $payoutResponseData = json_decode($output,true);

            $log_msg = '['.date('d-m-Y H:i:s').' - Fund Transfer API Txnid : '.$transaction_id.' Api Response - '.$output.']'.PHP_EOL;
            $this->User->generateLog($log_msg);

            // save api response
            $apiData = array(
                'account_id' => $domain_account_id,
                'user_id' => $loggedAccountID,
                'recharge_id' => $transaction_id,
                'api_response' => $output,
                'api_url' => $api_url,
                'status' => 1,
                'is_dmr' => 1,
                'created' => date('Y-m-d H:i:s')
            );
            $this->db->insert('api_response',$apiData);

            if(isset($payoutResponseData['error']) && $payoutResponseData['error']  && $payoutResponseData['error']['message'] == 'insufficient balance in account'){

                
                $finalResponse = array(
                    'status' => 1,
                    'opt_msg' => 'Your transaction is under processing, status will be updated soon.'
                );              
            }
            elseif(isset($payoutResponseData['error']) && $payoutResponseData['error']['message'] != 'insufficient balance in account'){

                $this->db->where('account_id',$domain_account_id);
                $this->db->where('id',$recordID);
                $this->db->where('user_id',$loggedAccountID);                
                $this->db->update('user_fund_transfer',array('transaction_id'=>$transaction_id,'old_transaction_id'=>$old_transaction_id,'rehit_status'=>1,'status'=>4,'updated'=>date('Y-m-d H:i:s')));

                $before_balance = $this->User->getMemberAepsWalletBalanceSP($loggedAccountID,2);
                $after_balance = $before_balance + $final_amount; 

                // save system log
                $log_msg = '['.date('d-m-Y H:i:s').' - Payout Callback API Txnid : '.$transaction_id.' Refund to Member - '.$memberID.' - Before Balance - '.$before_balance.' - Refund Amount - '.$final_amount.' - After Balance - '.$after_balance.'.]'.PHP_EOL;   
                        
                $wallet_data = array(
                    'account_id'          => $domain_account_id,
                    'member_id'           => $loggedAccountID,    
                    'before_balance'      => $before_balance,
                    'amount'              => $final_amount,  
                    'after_balance'       => $after_balance,      
                    'status'              => 1,
                    'type'                => 1,  
                    'wallet_type'         => 2,          
                    'created'             => date('Y-m-d H:i:s'),      
                    'credited_by'         => 1,
                    'description'         => 'Express Payout #'.$old_transaction_id.' Refund Credited'
                );

                $this->db->insert('member_wallet',$wallet_data);

                 
                $finalResponse = array(
                    'status' => 3,
                    'opt_msg' => 'Transcation Failed From Bank Side.'
                );
            
            }
            else{

            	  $this->db->where('account_id',$domain_account_id);
                $this->db->where('id',$recordID);
                $this->db->where('user_id',$loggedAccountID);                
                $this->db->update('user_fund_transfer',array('transaction_id'=>$transaction_id,'old_transaction_id'=>$old_transaction_id,'rehit_status'=>1,'updated'=>date('Y-m-d H:i:s')));

                 $finalResponse = array(
                    'status' => 2,                  
                    'opt_msg' => 'Your transaction is under processing, status will be updated soon.'
                );
            }
            	

        return $finalResponse;
    }



    public function zyroQrStatusCheckApi($account_id,$loggedAccountID,$txnid = '',$refid = '',$zyroid=''){

		$response = array();

		$account_id = $this->User->get_domain_account();
		

		$chk_txn = $this->db->get_where('upi_dynamic_qr',array('account_id'=>$account_id,'txnid'=>$txnid,'zyro_order_id'=>$zyroid,'status'=>1))->row_array();

		if(!$chk_txn){


			$response = array(

				'status' => 0,
				'msg' => 'Txn invalid'
			);

		}
		else{


			if($chk_txn['api_id'] == 5){


				$api_url = 'https://secure.myzyro.com/api/PaymentProcess/CheckStatusByOrderId?order_id='.$zyroid.'';
					$curl = curl_init();

					curl_setopt_array($curl, array(
					  CURLOPT_URL => $api_url,
					  CURLOPT_RETURNTRANSFER => true,
					  CURLOPT_ENCODING => '',
					  CURLOPT_MAXREDIRS => 10,
					  CURLOPT_TIMEOUT => 0,
					  CURLOPT_FOLLOWLOCATION => true,
					  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					  CURLOPT_CUSTOMREQUEST => 'POST',
					  CURLOPT_HTTPHEADER => array(
						'x-api-key: CB4B3C0C-F5D5-41AB-B7D8-321F17EC0CE9'
					  ),
					));

					$output = curl_exec($curl);

					curl_close($curl);

				log_message('debug', 'Qr Status check api response - '.$output);

									        // save upi api response
				$apiData = array(
					'account_id' => $account_id,
					'member_id' => $loggedAccountID,
					'txnid' => $txnid,
					'api_url' => $api_url,
					'response' => $output,
					'created' => date('Y-m-d H:i:s')
				);
				$this->db->insert('upi_check_status_api_response',$apiData);

				$responseData = json_decode($output,true);

				if(isset($responseData['success']) && $responseData['success'] == 'true')
				{

					log_message('debug', 'Zyro UPI payin check status api called');

					

					log_message('debug', 'Zyro UPI payin check status api txnid - '.$txnid);
						
					$bank_rrno = $responseData['data']['bank_reference'];
					$PayerAmount = $responseData['data']['order_amount'];
					$PayerVA = '';
					$PayerName ='';
					$TxnInitDate ='';
					$TxnCompletionDate='';
					

					$get_dynamic_qr_txn = $this->db->get_where('upi_dynamic_qr',array('account_id'=>$account_id,'txnid'=>$txnid,'zyro_order_id'=>$zyroid))->row_array();

					$chk_txn_already = $this->db->get_where('upi_transcation',array('txnid'=>$txnid,'zyro_order_id'=>$zyroid))->num_rows();

					$member_id = $loggedAccountID;

					if($member_id && !$chk_txn_already)
					{	

						$get_member_status = $this->db->select('wallet_balance,role_id,upi_call_back_url,user_code')->get_where('users',array('id'=>$member_id))->row_array();		

						$get_surcharge_amount = $this->User->get_upi_commission($member_id,$PayerAmount);

						$surcharge_amount = isset($get_surcharge_amount['commission_amount']) ? $get_surcharge_amount['commission_amount'] : 0;

						$charge_amount = $surcharge_amount;	

								$txnData = array(
								'account_id' => $account_id,
								'member_id' => $member_id,
								'type_id' => 2,
								'zyro_order_id' => $zyroid,
								'txnid'=>$txnid,
								'amount' => $PayerAmount,
								'charge_amount'=> $charge_amount, 
								'vpa_id' => $PayerVA,
								'bank_rrno' => $bank_rrno,
								'description' => 'QR Scan #'.$bank_rrno.' Txn #'.$txnid.' Amount Received.',
								'status'=>2,
								'is_api_response' => 1,
								'api_id'=>5,
								'created' => date('Y-m-d H:i:s'),
								'created_by' => $member_id
							);
							$this->db->insert('upi_transaction',$txnData);

						$recordID = $this->db->insert_id();	

	    	          	//get member wallet_balance
						$get_member_status = $this->db->select('wallet_balance,role_id,upi_call_back_url,user_code')->get_where('users',array('account_id'=>$account_id,'id'=>$member_id))->row_array();
						
						$user_role_id  = $get_member_status['role_id'];
						$api_member_code = $get_member_status['user_code'];
					
						$before_balance = $this->User->getMemberUpiWalletBalanceSP($member_id);
						$final_amount = $PayerAmount- $charge_amount;
						$after_balance = $before_balance + $final_amount;
					
							// update member wallet
							$wallet_data = array(
							'account_id'          => $account_id,
							'member_id'           => $member_id,    
							'before_balance'      => $before_balance,
							'amount'              => $final_amount,
							'after_balance'       => $after_balance,      
							'status'              => 1,
							'type'                => 1,      
							'wallet_type'		  => 1,
							'created'             => date('Y-m-d H:i:s'),      
							'description'         => 'QR Scan #'.$bank_rrno.' Txn '.$txnid.' Amount Credited.'
						);

						$this->db->insert('member_upi_wallet',$wallet_data);

	    	            
						
						if($user_role_id == 6){

							$user_call_back_url = isset($get_member_status['upi_call_back_url']) ? $get_member_status['upi_call_back_url'] : '' ;
    
                        $log_msg = '['.date('d-m-Y H:i:s').' - Txn ID #'.$txnid.' Sys Txn id '.$txnid.' - Zyro UPI Callback API API Member - '.$api_member_code.' - Call Back URL - '.$user_call_back_url.']'.PHP_EOL;
                        $this->User->generateUpiCollectionLog($log_msg);
    
                        $api_post_data = array();
                        $api_post_data['status'] = 200;
                        $api_post_data['payerAmount'] = $PayerAmount;
                        $api_post_data['payerName'] = $PayerName;
                        $api_post_data['txnID'] = $txnid;
                        $api_post_data['BankRRN'] = $bank_rrno;
                        $api_post_data['payerVA'] = $PayerVA;
                        $api_post_data['TxnInitDate'] = $TxnInitDate;
                        $api_post_data['TxnCompletionDate'] = $TxnCompletionDate;
                        
                        
                        $header = [
                            'Content-type: application/json'
                        ];
                        
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, $user_call_back_url);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
                        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($api_post_data));      
                        $output = curl_exec($ch); 
                        $error_msg = '';
                        if (curl_errno($ch)) {
                            $error_msg = curl_error($ch);
                        }
                        curl_close($ch);
                        
                        
                        $log_msg = '['.date('d-m-Y H:i:s').' - Txn ID #'.$txnid.' - Zyro UPI Callback API API Member - '.$api_member_code.' - Call Back cURL Error - '.$error_msg.']'.PHP_EOL;
                        $this->User->generateUpiCollectionLog($log_msg);
                        
                        $log_msg = '['.date('d-m-Y H:i:s').' - Txn ID #'.$txnid.' - Zyro UPI Callback API API Member - '.$api_member_code.' - Call Back Post Data - '.json_encode($api_post_data).']'.PHP_EOL;
                        $this->User->generateUpiCollectionLog($log_msg);
    
                        $log_msg = '['.date('d-m-Y H:i:s').' - Txn ID #'.$txnid.' - Zyro UPI Callback API API Member - '.$api_member_code.' - Call Back Response - '.$output.']'.PHP_EOL;
                        $this->User->generateUpiCollectionLog($log_msg);
						
							
						}

					}

					$response = array(
						'status' => 1,
						'msg' => 'Txn Status - Success.'
					);

				}
				
				else{

					$response = array(
						'status' => 0,
						'msg' => 'Txn in pending or not completed.'
					);
				}
			}
			
			}

		echo json_encode($response);

	}
	
	
	public function check_axis_payin_status($payment_id=''){
	    
	    $user_name = AXIS_LIVE_KEY;
        
        $password = AXIS_SECRET_KEY;
        
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => RAZORPAY_QR_STATUS_CHECK_API_URL.'payment_id='.$payment_id,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Basic '. base64_encode("$user_name:$password")
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        
        $responseData = json_decode($response,true);
        
        $res = array(
          'status' => $responseData['items'][0]['payments_count_received'],
          'qr_id' => $responseData['items'][0]['id'],
          'payment_amount' => $responseData['items'][0]['payment_amount']/100
        );
        
        return $res;
	}


	

}


/* end of file: user.php */
/* Location: ./application/models/admin/user.php */

