<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */
require('razorpay-php/Razorpay.php');
use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;
class Checkout extends CI_Controller{

    public function __construct() {
        parent::__construct();
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front/message', 'english');
        $this->lang->load('front_common', 'english');
        $this->lang->load('email_lang', 'english');
		$this->load->model('front/Checkout_model');
		if(!$this->session->userdata('pinkekart_vendor_session') && !$this->session->userdata('pinkekart_customer_session')){
			$this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
			redirect('login');
		}
    }
	
	
	public function index(){
		
		// get country list
		$countryList = $this->db->order_by('name','asc')->get('countries')->result_array();
		
		// get state list
		$stateList = $this->db->order_by('name','asc')->get_where('states',array('country_code_char2'=>'IN'))->result_array();
		
		// get user address list
		$account_id = $this->User->get_logged_user_account_id();
		
		$addressList = $this->db->get_where('user_address',array('userID'=>$account_id))->result_array();


		
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			// 'loggedUser'  	=> $loggedUser,
			'countryList' 		=> $countryList,
			'stateList' 		=> $stateList,
			'addressList' 		=> $addressList,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'checkout'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function addAuth()
	{
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('address_line_1', 'Address', 'required|xss_clean');
		$this->form_validation->set_rules('address_line_2', 'Address', 'xss_clean');
		$this->form_validation->set_rules('city', 'City', 'required|xss_clean');
		$this->form_validation->set_rules('postal_code', 'Zip/Postal Code', 'required|xss_clean');
		$this->form_validation->set_rules('phone_number', 'Phone Number', 'required|xss_clean|min_length[10]');
		$this->form_validation->set_rules('state', 'State', 'required|xss_clean');
		$this->form_validation->set_rules('country', 'Country', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->index();
		}
		else
		{
			// update organizer detail
			$address_id = $this->Checkout_model->save_user_address($post);
			$this->Az->redirect('checkout/review/'.$address_id, 'system_message_error',lang('CHECKOUT_ADDRESS_SAVE_SUCCESS'));
		}
		
	}
	
	public function getAddressData($recordID = 0)
	{
		
		$response = array();
		// get user address list
		$account_id = $this->User->get_logged_user_account_id();
		$addressList = $this->db->get_where('user_address',array('id'=>$recordID,'userID'=>$account_id))->row_array();

		$get_state = $this->db->get_where('states',array('id'=>$addressList['state']))->row_array();

		$state = $get_state['name'];

		$get_country = $this->db->get_where('countries',array('id'=>$addressList['country']))->row_array();

		$country = $get_country['name'];

		
		if($addressList)
		{
			$response = array(
				'status' 		=> 1,
				'name' 			=> $addressList['name'],
				'phone_number' 	=> $addressList['phone_number'],
				'address_1' 	=> $addressList['address_1'],
				'address_2' 	=> $addressList['address_2'],
				'city' 			=> $addressList['city'],
				'state' 		=> $state,
				'country'		=> $country,
				'zip_code' 		=> $addressList['zip_code'],
			);
		}
		else
		{
			$this->session->set_flashdata('system_message_error', lang('DB_ERROR'));
			$response = array(
				'status' => 0,
				'msg' => 'Something Wrong'
			);
		}
		echo json_encode($response);
	}
	
	public function updateCheckoutAdd()
	{
		$response = array();
		$post = $this->input->post();
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('address_line_1', 'Address', 'required|xss_clean');
		$this->form_validation->set_rules('address_line_2', 'Address', 'xss_clean');
		$this->form_validation->set_rules('city', 'City', 'required|xss_clean');
		$this->form_validation->set_rules('postal_code', 'Zip/Postal Code', 'required|xss_clean');
		$this->form_validation->set_rules('phone_number', 'Phone Number', 'required|xss_clean|min_length[10]');
		// $this->form_validation->set_rules('state', 'State', 'required|xss_clean');
		$this->form_validation->set_rules('country', 'Country', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$response = array(
				'status' => 0,
				'msg' => validation_errors()
			);
		}
		else
		{
			// update organizer detail
			$this->Checkout_model->update_user_address($post);
			$this->session->set_flashdata('system_message_error', lang('CHECKOUT_ADDRESS_SAVE_SUCCESS'));
			$response = array(
				'status' => 1,
				'msg' => 'Success'
			);
		}
		echo json_encode($response);
	}
	
	public function deleteAddress($recordID = 0)
	{
		$response = array();
		// get user address list
		$account_id = $this->User->get_logged_user_account_id();
		$chkAddress = $this->db->get_where('user_address',array('id'=>$recordID,'userID'=>$account_id))->num_rows();
		if($chkAddress)
		{
			$this->db->where('id',$recordID);
			$this->db->where('userID',$account_id);
			$this->db->delete('user_address');
		
			$this->session->set_flashdata('system_message_error', lang('CHECKOUT_ADDRESS_DELETE_SUCCESS'));
			$response = array(
				'status' => 1,
				'msg' => 'Success'
			);
		}
		else
		{
			$this->session->set_flashdata('system_message_error', lang('DB_ERROR'));
			$response = array(
				'status' => 0,
				'msg' => 'Something Wrong'
			);
		}
		echo json_encode($response);
	}
	
	public function review($address_id = 0){
		
		$account_id = $this->User->get_logged_user_account_id();
		
		// check address valid or not
		$chk_address = $this->db->get_where('user_address',array('id'=>$address_id,'userID'=>$account_id))->num_rows();
		if(!$chk_address)
		{
			$this->Az->redirect('checkout', 'system_message_error',lang('DB_ERROR'));
		}
		
		$cartProductList = $this->User->get_cart_temp_data();


		
		if(!$cartProductList)
		{
			$this->Az->redirect('checkout/error', 'system_message_error','');
		}

		// get address data
		$addressData = $this->db->get_where('user_address',array('id'=>$address_id,'userID'=>$account_id))->row_array();



		$delivery_price = 0;
		foreach($cartProductList as $list){
			
			$gst_percentage = 0;
				$is_variation = 0;
				$variation_pro_id = 0;
				if($list['is_variation'])
				{
					$is_variation = 1;
					$variation_pro_id = $list['variation_pro_id'];
					// get total tax for this product
					$get_total_tax = $this->db->select('tax_rules.percentage')->join('tax_rules','tax_rules.id = product_variation_product_data.tax_rule_id')->get_where('product_variation_product_data',array('product_variation_product_data.id'=>$variation_pro_id,'product_variation_product_data.product_id'=>$list['id'],'tax_rules.status'=>1))->row_array();
					$pro_tax_percentage = isset($get_total_tax['percentage']) ? $get_total_tax['percentage'] : 0 ;
					$gst_percentage = $pro_tax_percentage;
				}
				else
				{
					// get total tax for this product
					$get_total_tax = $this->db->select('tax_rules.percentage')->join('tax_rules','tax_rules.id = products.tax_rule_id')->get_where('products',array('products.id'=>$list['id'],'tax_rules.status'=>1))->row_array();
					$pro_tax_percentage = isset($get_total_tax['percentage']) ? $get_total_tax['percentage'] : 0 ;
					$gst_percentage = $pro_tax_percentage;
				}

				$total_gst_percentage+=$gst_percentage;
				
				
				$product_base_price = $list['price'];
				if($gst_percentage){
					// calculate product base price
					$tax_divide_amount = round((($gst_percentage + 100)/100),2);
					$pro_base_price = round(($list['price']/$tax_divide_amount),2);
					$product_base_price = $pro_base_price;
				}
				
				$product_total_price = $product_base_price * $list['qty'];
				

				
				// get customer state
				$get_customer_zip_code = $this->db->select('zip_code')->get_where('user_address',array('id'=>$address_id,'userID'=>$account_id))->row_array();

				$customer_zip_code = isset($get_customer_zip_code['zip_code']) ? ($get_customer_zip_code['zip_code']) ? $get_customer_zip_code['zip_code'] : 0 : 0 ;


				$api_url = 'https://api.postalpincode.in/pincode/'.$customer_zip_code;
				$ch = curl_init();
		        curl_setopt($ch, CURLOPT_URL, $api_url);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
		        $output = curl_exec($ch); 
		        curl_close($ch);

		        $result = json_decode($output);

		        $state_name = $result[0]->PostOffice[0]->State;
		        

				// get customer state
				$get_customer_state = $this->db->select('id')->get_where('states',array('name'=>$state_name))->row_array();
				

				$customer_state_id = isset($get_customer_state['id']) ? ($get_customer_state['id']) ? $get_customer_state['id'] : 0 : 0 ;


				// get vendor state
				$get_vendor_state = $this->db->select('state_id')->get_where('users',array('id'=>$list['account_id']))->row_array();
				$vendor_state_id = isset($get_vendor_state['state_id']) ? ($get_vendor_state['state_id']) ? $get_vendor_state['state_id'] : 0 : 0 ;
				
				// check delivery is out of state or not
				$is_out_state = 0;
				if($customer_state_id && $vendor_state_id && $customer_state_id != $vendor_state_id)
				{
					$is_out_state = 1;
				}
				
				// calculate total GST amount
				$gst_amount = 0;
				if($gst_percentage)
				{
					$gst_amount = round((($gst_percentage/100)*$product_total_price),2);
				}

				$total_gst_amount+=$gst_amount;

				$igst_percentage = 0;
				$igst_amount = 0;
				
				$sgst_percentage = 0;
				$sgst_amount = 0;
				
				$cgst_percentage = 0;
				$cgst_amount = 0;
				
				if($is_out_state)
				{
					$igst_percentage = $gst_percentage;
					$igst_amount = round((($gst_percentage/100)*$product_total_price),2);
				}
				else
				{
					$sgst_percentage = round(($gst_percentage/2),2);
					$sgst_amount = round((($sgst_percentage/100)*$product_total_price),2);
					
					$cgst_percentage = round(($gst_percentage/2),2);
					$cgst_amount = round((($cgst_percentage/100)*$product_total_price),2);
				}
				
				$gross_amount = $product_total_price + $gst_amount;


				// get vendor id
				$vendor_id = $list['account_id'];
				// get vendor role id
				$vendor_role_id = $this->User->get_vendor_role_id($vendor_id);

				// get product catgory
				$productCatList = $this->db->get_where('product_category',array('product_id'=>$list['id']))->result_array();
				$product_parent_category = array();
				if($productCatList)
				{
					foreach($productCatList as $catKey=>$catList)
					{
						$pro_cat_id = $catList['category_id'];
						// get parent cat
						$cat_parent_cat_id = $this->User->get_parent_category_id($pro_cat_id);
						$product_parent_category[$catKey] = $cat_parent_cat_id;
					}
				}

				$total_commision = 0;
				if($product_parent_category)
				{
					// get total commision percentage
					$get_total_commision_percentage = $this->db->select('SUM(commission) as total_commision')->where_in('category_id',$product_parent_category)->get_where('commision_setting',array('vendor_role_id'=>$vendor_role_id))->row_array();
					$total_commision = isset($get_total_commision_percentage['total_commision']) ? $get_total_commision_percentage['total_commision'] : 0 ;
				}

				// calculate total commision amount
				$total_commision_amount = 0;
				if($total_commision)
				{
					$total_commision_amount = round((($total_commision/100)*$gross_amount),2);
				}

				$payable_amount+= $gross_amount - $total_commision_amount;
		}


		
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords'	 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			// 'loggedUser'  => $loggedUser,
			'cartProductList' 	=> $cartProductList,
			'addressData' 		=> $addressData,
			'address_id' 		=> $address_id,
			'payable_amount' 	=> $payable_amount,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'review'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function orderAuth($address_id = 0){
		
		$account_id = $this->User->get_logged_user_account_id();
		
		/*$address_status = $this->User->save_shiprocket_address($account_id,$address_id);

		if($address_status['status'] == 0){

			$this->Az->redirect('checkout', 'system_message_error','<div class="alert alert-danger alert-dismissable">  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'.$address_status['message'].'</div>');
		}*/

		// check address valid or not
		$chk_address = $this->db->get_where('user_address',array('id' => $address_id,'userID' => $account_id))->num_rows();

		if(!$chk_address)
		{
			$this->Az->redirect('checkout', 'system_message_error',lang('DB_ERROR'));
		}
		
		$cartProductList = $this->User->get_cart_temp_data();


		if(!$cartProductList)
		{
			$this->Az->redirect('checkout/error', 'system_message_error','');
		}
		
		// save order data
		$shopping_order_id = $this->Checkout_model->save_order($cartProductList,$address_id,$account_id);

		$shopping_order_id = $shopping_order_id[1];
	
		// get last order display id
		$order_id_data = $this->User->get_last_order_display_id();
		$order_display_id = $order_id_data['order_display_id'];
		$order_number = $order_id_data['order_number'];
		
		$total_item = count($cartProductList);

		$delivery_price = 0;
		foreach($cartProductList as $list){
			
			$gst_percentage = 0;
				$is_variation = 0;
				$variation_pro_id = 0;
				if($list['is_variation'])
				{
					$is_variation = 1;
					$variation_pro_id = $list['variation_pro_id'];
					// get total tax for this product
					$get_total_tax = $this->db->select('tax_rules.percentage')->join('tax_rules','tax_rules.id = product_variation_product_data.tax_rule_id')->get_where('product_variation_product_data',array('product_variation_product_data.id'=>$variation_pro_id,'product_variation_product_data.product_id'=>$list['id'],'tax_rules.status'=>1))->row_array();

					$pro_tax_percentage = isset($get_total_tax['percentage']) ? $get_total_tax['percentage'] : 0 ;

					$gst_percentage = $pro_tax_percentage;
				}
				else
				{
					// get total tax for this product
					$get_total_tax = $this->db->select('tax_rules.percentage')->join('tax_rules','tax_rules.id = products.tax_rule_id')->get_where('products',array('products.id'=>$list['id'],'tax_rules.status'=>1))->row_array();

					$pro_tax_percentage = isset($get_total_tax['percentage']) ? $get_total_tax['percentage'] : 0 ;
					$gst_percentage = $pro_tax_percentage;
				}

				$total_gst_percentage+=$gst_percentage;
				
				
				$product_base_price = $list['price'];
				if($gst_percentage){
					// calculate product base price
					$tax_divide_amount = round((($gst_percentage + 100)/100),2);
					$pro_base_price = round(($list['price']/$tax_divide_amount),2);
					$product_base_price = $pro_base_price;
				}
				
				$product_total_price = $product_base_price * $list['qty'];
				

				
				// get customer state
				// $get_customer_zip_code = $this->db->select('zip_code')->get_where('user_address',array('id' => $address_id,'userID' => $account_id))->row_array();

				// $customer_zip_code = isset($get_customer_zip_code['zip_code']) ? (($get_customer_zip_code['zip_code']) ? $get_customer_zip_code['zip_code'] : 0) : 0 ;


				// $api_url = 'https://api.postalpincode.in/pincode/'.$customer_zip_code;
				// $ch = curl_init();
		        // curl_setopt($ch, CURLOPT_URL, $api_url);
		        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
		        // $output = curl_exec($ch); 
		        // curl_close($ch);

		        // $result = json_decode($output);

		        // $state_name = $result[0]->PostOffice[0]->State;
		        

				// // get customer state
				// $get_customer_state = $this->db->select('id')->get_where('states',array('name' => $state_name))->row_array();
				

				$customer_state_id = isset($get_customer_state['id']) ? (($get_customer_state['id']) ? $get_customer_state['id'] : 0) : 0 ;


				// get vendor state
				$get_vendor_state = $this->db->select('state_id')->get_where('users',array('id'=>$list['account_id']))->row_array();
				$vendor_state_id = isset($get_vendor_state['state_id']) ? (($get_vendor_state['state_id']) ? $get_vendor_state['state_id'] : 0) : 0 ;
				
				// check delivery is out of state or not
				$is_out_state = 0;
				if($customer_state_id && $vendor_state_id && $customer_state_id != $vendor_state_id)
				{
					$is_out_state = 1;
				}
				
				// calculate total GST amount
				$gst_amount = 0;
				if($gst_percentage)
				{
					$gst_amount = round((($gst_percentage/100)*$product_total_price),2);
				}

				$total_gst_amount+=$gst_amount;

				$igst_percentage = 0;
				$igst_amount = 0;
				
				$sgst_percentage = 0;
				$sgst_amount = 0;
				
				$cgst_percentage = 0;
				$cgst_amount = 0;
				
				if($is_out_state)
				{
					$igst_percentage = $gst_percentage;
					$igst_amount = round((($gst_percentage/100)*$product_total_price),2);
				}
				else
				{
					$sgst_percentage = round(($gst_percentage/2),2);
					$sgst_amount = round((($sgst_percentage/100)*$product_total_price),2);
					
					$cgst_percentage = round(($gst_percentage/2),2);
					$cgst_amount = round((($cgst_percentage/100)*$product_total_price),2);
				}
				
				$gross_amount = $product_total_price + $gst_amount;


				// get vendor id
				$vendor_id = $list['account_id'];
				// get vendor role id
				$vendor_role_id = $this->User->get_vendor_role_id($vendor_id);

				// get product catgory
				$productCatList = $this->db->get_where('product_category',array('product_id'=>$list['id']))->result_array();

				$product_parent_category = array();
				if($productCatList)
				{
					foreach($productCatList as $catKey=>$catList)
					{
						$pro_cat_id = $catList['category_id'];
						// get parent cat
						$cat_parent_cat_id = $this->User->get_parent_category_id($pro_cat_id);

						$product_parent_category[$catKey] = $cat_parent_cat_id;
					}
				}

				$total_commision = 0;
				if($product_parent_category)
				{
					// get total commision percentage
					$get_total_commision_percentage = $this->db->select('SUM(commission) as total_commision')->where_in('category_id',$product_parent_category)->get_where('commision_setting',array('vendor_role_id'=>$vendor_role_id))->row_array();

					$total_commision = isset($get_total_commision_percentage['total_commision']) ? $get_total_commision_percentage['total_commision'] : 0 ;
				}

				// calculate total commision amount
				$total_commision_amount = 0;
				if($total_commision)
				{
					$total_commision_amount = round((($total_commision/100)*$gross_amount),2);
				}

				$payable_amount+= $gross_amount - $total_commision_amount;
		}
		
		
		
		
        // $keyId = RAZOR_KEY_ID;
		// $keySecret = RAZOR_KEY_SECRET;
        // $receipt_id = $order_display_id;
		// $api = new Api($keyId, $keySecret);
		// $orderData = [
		// 	'receipt'         => $receipt_id,
		// 	'amount'          => ($payable_amount + $delivery_price) * 100, // 2000 rupees in paise
		// 	'currency'        => 'INR',
		// 	'payment_capture' => 1 // auto capture
		// 	];

		// $razorpayOrder = $api->order->create($orderData);
		// $order_id = $razorpayOrder['id'];
		
		
		//save payment request data
			$paymentRequestData = array(
				'userID' 			 => $account_id,
				'orderID' 			 => $shopping_order_id,
				'payment_request_id' => '',
				'amount' 			 => $payable_amount + $delivery_price,
				'status' 			 => 1,
				
				'api_response' 		 => '',
				'posted' 			 => date('Y-m-d H:i:s')
			);
			$this->db->insert('payment_request',$paymentRequestData);
		
						
		$siteUrl = base_url();		
		$data = array(
		'meta_title' 		=> lang('SITE_NAME'),
		'meta_keywords' 	=> lang('SITE_NAME'),
		'meta_description' 	=> lang('SITE_NAME'),
		'site_copyright'	=> lang('FRONT_COMMON_COPYRIGHT'),
		'site_url' 			=> $siteUrl,
		'account_id'  		=> $account_id,
		'shopping_order_id' => $shopping_order_id,
		// 'receipt_id'		=> $receipt_id,
		'amount'    		=> $payable_amount + $delivery_price,
		// 'order_id'  		=> $order_id,
		'encoded_order_id'  => $shopping_order_id,
		'system_message' 	=> $this->Az->getSystemMessageError(),
		'system_info' 		=> $this->Az->getsystemMessageInfo(),
		'system_warning' 	=> $this->Az->getSystemMessageWarning(),
		'content_block' 	=> 'paymentPage'
		);
		
		
		$this->parser->parse('front/layout/column-3' , $data);
        
		
		// $this->Az->redirect('checkout/success/'.$encoded_order_id, 'system_message_error',lang('DB_ERROR'));
		
		
    }


    public function verify()
	{
		$account_id = $this->User->get_logged_user_account_id();
		$post = $this->input->post();
		$encoded_order_id = $post['encoded_order_id'];

		if(isset($post['cod'])){

            // check order id valid or not
			$chk_address = $this->db->get_where('orders',array('encoded_order_id' => $encoded_order_id))->num_rows();
			if(!$chk_address)
			{	
				$this->Az->redirect('checkout', 'system_message_error',lang('DB_ERROR'));
			}
            

			// update order status
			$orderData = array(

				'payment_status'=> 1,
				'payment_mode'  => 3,
				'payment_request_id' => $_POST["shopping_order_id"]
			);

				
			$this->db->where('customer_id',$account_id);
			$this->db->where('encoded_order_id',$encoded_order_id);
			$this->db->update('orders',$orderData);
				
			$get_order_data = $this->db->select('orders.*,user_address.phone_number')->join('user_address','user_address.id = orders.address_id')->get_where('orders',array('encoded_order_id' => $encoded_order_id))->row_array();
				
			$order_display_id = $get_order_data['order_display_id'];
			$phone_number = $get_order_data['phone_number'];

            //delete data from cart
            $this->db->where('user_id',$account_id);
            $this->db->delete('tbl_cart_temp_data');

           
				
			$siteUrl = base_url();
			$data = array(
		        'meta_title'        => lang('SITE_NAME'),
		        'meta_keywords'     => lang('SITE_NAME'),
		        'meta_description'  => lang('SITE_NAME'),
		        'site_url'          => $siteUrl,
				'order_display_id'  => $order_display_id,
				'phone_number'      => $phone_number,
				'system_message'    => $this->Az->getSystemMessageError(),
		        'system_info'       => $this->Az->getsystemMessageInfo(),
		        'system_warning'    => $this->Az->getSystemMessageWarning(),
		        // 'content_block'     => 'order-success'
		        );
				$this->Az->redirect('checkout/success/'.$encoded_order_id, 'system_message_error','');

		}



		// $get_user_data = $this->db->get_where('users',array('id' => $account_id))->row_array();
		
		// $get_order_data = $this->db->get_where('orders',array('encoded_order_id'=>$_POST['shopping_order_id']))->row_array();
		// $encoded_order_id = $get_order_data['encoded_order_id'];

		
		// $success = true;
		// $keyId = RAZOR_KEY_ID;
		// $keySecret = RAZOR_KEY_SECRET;
		// $error = "Payment Failed";
		// if (empty($_POST['razorpay_payment_id']) === false)
		// {
			
			
		// 	$payment_request_id = $_POST['razorpay_payment_id'];
			
		// 	$api = new Api($keyId, $keySecret);

		// 	try
		// 	{
		// 		// Please note that the razorpay order ID must
		// 		// come from a trusted source (session here, but
		// 		// could be database or something else)
		// 		$attributes = array(
		// 			'razorpay_order_id' => $_POST['razorpay_order_id'],
		// 			'razorpay_payment_id' => $_POST['razorpay_payment_id'],
		// 			'razorpay_signature' => $_POST['razorpay_signature']
		// 		);
				
				
		// 		$api->utility->verifyPaymentSignature($attributes);
		// 	}
		// 	catch(SignatureVerificationError $e)
		// 	{
		// 		$success = false;
		// 		$error = 'Razorpay Error : ' . $e->getMessage();
				
		// 		$this->Az->redirect('checkout', 'system_message_error',$e->getMessage());
		// 	}
		// }

		// if ($success === true)
		// {	
            
        //     $orderData = array(
		// 	'payment_status'=>2,
		// 	'payment_request_id' => $payment_request_id
    	// 	);
    	// 	$this->db->where('customer_id',$account_id);
    	// 	$this->db->where('encoded_order_id',$encoded_order_id);
    	// 	$this->db->update('orders',$orderData);
			
		// 	$this->db->where('userID',$account_id);
		// 	$this->db->where('orderID',$_POST['shopping_order_id']);
		// 	$this->db->update('payment_request',array('status'=>2,'payment_request_id' => $payment_request_id));

        //     $get_user_name = $this->db->get_where('users',array('id'=>$account_id))->row_array();
		    
		//     $user_name = isset($get_user_name['name']) ? $get_user_name['name'] : '';
		    
		//     $orderData = $this->User->get_customer_current_order_data($account_id,$encoded_order_id);

		//     $sub_total = 0;
		//     if($orderData){

		//     	$order_items = array();
		// 	    if($orderData[0]['productInfo']){

		// 	    	foreach($orderData[0]['productInfo'] as $key => $value){

		// 	    		$sub_total+= $value['payable_amount'];
		// 	    		$order_items[$key]['name'] = $value['product_name'];
		// 	    		$order_items[$key]['sku'] = $value['sku'];
		// 	    		$order_items[$key]['units'] = $value['product_qty'];
		// 	    		$order_items[$key]['selling_price'] = $value['payable_amount'];

		// 	    	}
		// 	    }


		    	

		//     	$order_data = array(

		//     	 'order_id'   			=> $orderData[0]['order_display_id'],
		//     	 'order_date' 			=> $orderData[0]['created'],
		//     	 'pickup_location'		=> 'codunite',
		//     	 'billing_customer_name'=> $orderData[0]['add_name'],
		//     	 'billing_last_name' 	=> '',
		//     	 'billing_address' 		=> $orderData[0]['address_1'],
		//     	 'billing_city' 		=> $orderData[0]['city'],
		//     	 'billing_pincode' 		=> $orderData[0]['zip_code'],
		//     	 'billing_state' 		=> $orderData[0]['state'],
		//     	 'billing_country' 		=> $orderData[0]['country_name'],
		//     	 'billing_email' 		=> $orderData[0]['customer_email'],
		//     	 'billing_phone' 		=> $orderData[0]['phone_number'],
		//     	 'billing_phone' 		=> $orderData[0]['phone_number'],
		//     	 'shipping_customer_name'=> $orderData[0]['add_name'],
		//     	 'shipping_last_name' 	=> '',
		//     	 'shipping_address' 	=> $orderData[0]['address_1'],
		//     	 'shipping_city' 		=> $orderData[0]['city'],
		//     	 'shipping_pincode' 	=> $orderData[0]['zip_code'],
		//     	 'shipping_state' 		=> $orderData[0]['state'],
		//     	 'shipping_country' 	=> $orderData[0]['country_name'],
		//     	 'shipping_email' 		=> $orderData[0]['customer_email'],
		//     	 'shipping_phone' 		=> $orderData[0]['phone_number'],
		//     	 'shipping_phone' 		=> $orderData[0]['phone_number'],
		//     	 'payment_method' 		=> 'Prepaid',
		//     	 'sub_total'	  		=> $sub_total,
		//     	 'length'         		=> 0.5,
		//     	 'breadth'		  		=> 0.5,	
		//     	 'height'         		=> 0.5,
		//     	 'weight'		  		=> 0.5,
		//     	 'shipping_is_billing' 	=> 1,
		//     	 'order_items' 			=> $order_items	 
		//     	);

		//     	$this->User->create_shiprocket_order($order_data);
		    
		//     }

		    
		    
		    
		//     $product = '';
		//     if(isset($orderData[0]['productInfo']) && $orderData[0]['productInfo']){
            
        //     foreach($orderData[0]['productInfo'] as $key=>$list){ 
           
        //       $product.= $list['product_qty'].' '.$list['product_name'].' ';
           
        //     }}
                
		    	
			
	    //     $mobile = isset($get_user_data['mobile']) ? $get_user_data['mobile'] : '';
	        
	    //     $email = isset($get_user_data['email']) ? $get_user_data['email'] : '';
	        
	    //     $smsTemplateData = $this->db->get_where('sms_templates',array('id'=>4,'status'=>1))->row_array();
        //     $sms_message = isset($smsTemplateData['message']) ? $smsTemplateData['message'] : '' ;

        //     if($sms_message){
            
        //     $output = '';
        //     $sms = $sms_message;

        //     $sms = str_replace('{USER_NAME}',$user_name,$sms);
        //     $sms = str_replace('{PRODUCT}',$product,$sms);

		// 	$api_url = SMS_API_URL.'authkey='.SMS_API_AUTH_KEY.'&mobiles=91'.$mobile.'&message='.urlencode($sms).'&sender='.SMS_API_SENDERID.'&route=4&country=91';
			
		// 	$ch = curl_init();
		// 	curl_setopt($ch, CURLOPT_URL, $api_url);
		// 	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		// 	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		// 	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
		// 	$output = curl_exec($ch); 
		// 	curl_close($ch);

        //    }
           
           
        //     $get_site_email = $this->db->select('email_id')->get_where('site_settings',array('id'=>1))->row_array();

        //     $site_email = isset($get_site_email['email_id']) ? $get_site_email['email_id'] : '';
            
            
        //     $emailTemplateData = $this->db->get_where('email_templates',array('id'=>3,'status'=>1))->row_array();
        //     $email_message = isset($emailTemplateData['message']) ? $emailTemplateData['message'] : '' ;

        //     if($email_message){

        //         $sms = $email_message;

        //         $sms = str_replace('{USER_NAME}',$user_name,$sms);
        //         $sms = str_replace('{PRODUCT}',$product,$sms);
                
        //         $siteName = 'Dgcicart';
                
        //         $emailTimeStamp = date('d-m-Y h:i:s');
        //         $emailTemplate = sprintf((string) lang('ORDER_EMAIL'), site_url(), $siteName,$sms,$emailTimeStamp);
    
        //         $email_subject = 'Dgcicart Order'; 
    
        //         $configEmail = array(
        //             'mailtype' => 'html',
        //         );
                
                
        //         // send mail to customer
        //         $this->load->library('email');
        //         $this->email->initialize($configEmail);
        //         $this->email->from($site_email, 'Dgcicart');
        //         $this->email->to($email);
        //         $this->email->subject($email_subject);
        //         $this->email->message($emailTemplate);
        //         $this->email->send();
                
                
        //         //send mail to admin
                
        //         $this->load->library('email');
        //         $this->email->initialize($configEmail);
        //         $this->email->from($site_email, 'Dgcicart');
        //         $this->email->to($site_email);
        //         $this->email->subject($email_subject);
        //         $this->email->message($emailTemplate);
        //         $this->email->send();
                
                
        //     }
	        

		// 	$this->Az->redirect('checkout/success/'.$encoded_order_id, 'system_message_error','');
		// }
		// else
		// {	
		//     $orderData = array(
		// 	'payment_status' => 3,
		// 	'payment_request_id' => $payment_request_id
    	// 	);
    	// 	$this->db->where('customer_id',$account_id);
    	// 	$this->db->where('encoded_order_id',$encoded_order_id);
    	// 	$this->db->update('orders',$orderData);
    		
		// 	$this->db->where('userID',$account_id);
		// 	$this->db->where('orderID',$_POST['shopping_order_id']);
		// 	$this->db->update('payment_request',array('status'=>3));	
		// 	$this->Az->redirect('checkout/error', 'system_message_error',lang('PAYMENT_FAILED'));
		// }
    
    
	}
	
	public function success($encoded_order_id = ''){
		
		$account_id = $this->User->get_logged_user_account_id();
		
		// check order id valid or not
		$chk_address = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();
		if(!$chk_address)
		{
			$this->Az->redirect('checkout', 'system_message_error',lang('DB_ERROR'));
		}
		
		$get_order_data = $this->db->select('orders.*,user_address.phone_number')->join('user_address','user_address.id = orders.address_id')->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->row_array();
		
		$order_display_id = $get_order_data['order_display_id'];
		$phone_number = $get_order_data['phone_number'];
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			// 'loggedUser'  	=> $loggedUser,
			'order_display_id'  => $order_display_id,
			'phone_number'  	=> $phone_number,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'order-success'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function error(){
		
		$account_id = $this->User->get_logged_user_account_id();
		
		$siteUrl = base_url();
		$data = array(
            'meta_title'	 	=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			// 'loggedUser'  	=> $loggedUser,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'cart-error'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	

    public function applyOffer()
	{
		$response = array();
		$post = $this->input->post();
		$this->load->library('form_validation');
		$this->form_validation->set_rules('offerCode', 'Offer Code', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$response = array(
				'status' => 0,
				'msg' => validation_errors()
			);
		}
		else
		{
			// update organizer detail
			$userID = $this->User->get_logged_user_account_id();
			$offer_code = $post['offerCode'];

			$chk_offer_applied = $this->db->get_where('offer_history',array('userID'=>$userID,'account_id'=>$post['account_id'],'product_id'=>$post['product_id'],'offer_code'=>$offer_code))->num_rows();

			
			if($chk_offer_applied){

				 $response = array(
					'status' => 0,
					'msg' => 'Sorry !! You Have Already Applied.'
				 );	

			}

			else{
				$today_date = date('Y-m-d');
					
				 $chk_offer_code = $this->db->get_where('product_offer',array('account_id'=>$post['account_id'],'product_id'=>$post['product_id'],'offer_start_date <=' => $today_date,'offer_end_date >= ' => $today_date,'offer_code'=>$offer_code))->row_array();

		 		if(!$chk_offer_code){

		 		   $response = array(
					 'status' => 0,
					 'msg' => 'Offer Code Not Valid'
					);	

		 		 }
				 else{

				 	//get product price
				 	$get_product_price = $this->db->get_where('products',array('id'=>$post['product_id'],'account_id'=>$post['account_id']))->row_array();
				 
					 if($get_product_price['special_price'] && $get_product_price['special_price_to'] >= $today_date)
					 {
						$product_price = $get_product_price['special_price'];
					 }
					 else{

					 	$product_price = $get_product_price['price'];
					 }

					 //apply offer

					 if($chk_offer_code['offer_type'] == 1){

					  $final_price = $product_price - $chk_offer_code['offer_type_value'];	

					 }
					 else{

					  $final_price = $product_price - (($product_price*$chk_offer_code['offer_type_value'])/100);

					 }

					 

					 $offerData = array(
					  'userID' 		=> $userID,
					  'account_id'	=> $post['account_id'],
					  'product_id'	=> $post['product_id'],
					  'offer_code'	=> $offer_code,
					  'before_apply_offer_price' 	=> $product_price,
					  'after_apply_offer_price' 	=> $final_price,
					  'created' 	=> date('Y-m-d H:i:s')	
					 );

					 $this->db->insert('offer_history',$offerData);

					 $cart_data = $this->User->get_cart_temp_data();
					 $total_price = 0;
					 foreach($cart_data as $cList){ 
							$total_price+=$cList['price'] * $cList['qty'];
					  }

					 $response = array(
					 'status' 		=> 1,
					 'final_price'	=> number_format($final_price,2),
					 'total_price'	=> number_format($total_price,2),
					 'address_id'	=> $post['address_id'],
					 'msg' 			=> 'Offer Applied Successfully.'
					);

				 }	

			}
		}
		echo json_encode($response);
	}	



	public function applyCoupon()
	{
		$response = array();
		$post = $this->input->post();
		$this->load->library('form_validation');
		$this->form_validation->set_rules('couponCode', 'Coupon Code', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$response = array(
				'status' => 0,
				'msg' => validation_errors()
			);
		}
		else
		{
			// update organizer detail
			$userID = $this->User->get_logged_user_account_id();
			$cartData = $this->User->get_cart_temp_data();
			$coupon_code = $post['couponCode'];
			
				$today_date = date('Y-m-d');
					
				 $chk_coupon_code = $this->db->get_where('coupon',array('date_start <=' => $today_date,'date_end >= ' => $today_date,'code'=>$coupon_code,'status'=>1))->row_array();

		 		if(!$chk_coupon_code){

		 		   $response = array(
					 'status' => 0,
					 'msg' => 'Offer Code Not Valid'
					);	

		 		 }
				 else{
				 	$product_data=array();
				 	foreach($cartData as $list){

				 	  $get_product_cat_id = $this->db->get_where('product_category',array('product_id'=>$list['id'],'account_id'=>$list['account_id']))->row_array();
				 	  	
				 	  $chk_coupon_category = $this->db->get_where('coupon_category',array('coupon_id'=>$chk_coupon_code['id'],'category_id'=>$get_product_cat_id['category_id']))->num_rows();


				 	  $chk_coupon_product = $this->db->get_where('coupon_product',array('coupon_id'=>$chk_coupon_code['id'],'product_id'=>$list['id']))->num_rows();

				 	  
				 	  $chk_product_price = 0;

				 	  if($list['price'] > $chk_coupon_code['total_amount']){
				 	  	$chk_product_price = 1;
				 	  }

				 	  if($chk_coupon_category || $chk_coupon_product && $chk_product_price){
							$product_data[]=$list['id'];
					 		
				 	  }
				 	}	
				 	if(!empty($product_data)){
				 	
				 	$get_product = $this->db->select('cart_temp_data.qty as pro_qty,products.*')->from('products')->join('cart_temp_data','products.id = cart_temp_data.product_id')->where_in('products.id',$product_data)->get()->result_array();
				 	$total_pro_price=0;
                   	  
                   	  foreach ($get_product as  $list) {
                   	 
				 	 if($list['special_price'] && $list['special_price_to'] >= $today_date)
					 {
						$product_price = $list['special_price'] * $list['pro_qty'];
						$total_pro_price = $total_pro_price + $product_price;
					 }
					 else{

					 	$product_price = $list['price']* $list['pro_qty'];
					 	$total_pro_price= $total_pro_price + $product_price;
					 }	

				}

                      if($chk_coupon_code['type'] != 1){

					  	$final_price = $total_pro_price - $chk_coupon_code['discount'];	

					  }
					  else{

						$final_price = $total_pro_price - (($total_pro_price*$chk_coupon_code['discount'])/100);

					  }

						 

						 $offerData = array(

						  'userID' 		=> $userID,
						  'account_id'	=> $list['account_id'],
						  'product_id'	=> json_encode($product_data),
						  'coupon_code'	=> $coupon_code,
						  'coupon_id'	=> $chk_coupon_code['id'],
						  'before_apply_offer_price' => $total_pro_price,
						  'after_apply_offer_price' => $final_price,
						  'created' 	=> date('Y-m-d H:i:s')	
						 );

						 $this->db->insert('coupon_history',$offerData); 

				 	


				 	$response = array(
						 'status' 		=> 1,
						 'product_id'	=> $product_data,
						 'get_product'	=> $get_product,
						 'msg' 			=> 'Coupon Applied Successfully.'
						);	
				 	}
				 	else{
				 	 	$response = array(
						 'status' 	=> 0,
						 'msg' 		=> 'Coupon Not Valid'
						); 	
				 	  }
					 

				 }	
				 	

		}
		echo json_encode($response);
	}	
	
	
	
	public function pgAuth($address_id='')
    {

        $loggedUser = $this->User->get_logged_user_account_id("pinkekart_customer_session");
	
        $account_id = $loggedUser;
        	
		$userdata = $this->db->get_where('tbl_users', array('id' => $account_id))->row_array();

		$cartProductList = $this->User->get_cart_temp_data();

        // check address valid or not
        $chk_address = $this->db->get_where('user_address', array('id' => $address_id, 'userID' => $account_id))->num_rows();
        

        
        if (!$chk_address) {
            $this->Az->redirect('checkout', 'system_message_error', lang('DB_ERROR'));
        }
        
        if (!$cartProductList) {
            $this->Az->redirect('checkout/error', 'system_message_error', '');
        }

        // save order data
        $response = $this->Checkout_model->save_order($cartProductList, $address_id, $account_id);  
        
        $amount = $response[0];
        $txnid = $response[1];
        
        // save system log
        // $log_msg = '['.date('d-m-Y H:i:s').' - ('.$loggedUser['user_code'].') - Topup Wallet Post Data - '.$amount.']'.PHP_EOL;
        // $this->User->generateLog($log_msg);

        // $this->load->library('form_validation'); 

        $paymentRequestData = array(
            'userID' 				=> $account_id,
            'orderID' 				=> $txnid,
            'payment_request_id' 	=> '',
            'amount' 				=> $amount,
            'status' 				=> 1,
            'api_response' 			=> '',
            'posted' 				=> date('Y-m-d H:i:s')
        );
        $this->db->insert('payment_request', $paymentRequestData);

        //call api

        $api_url = PHONEPAY_PG_REQUEST_URL;
       
        $post_data =array(   
            
            "merchantId"			=> PHONEPAY_MERCHANT_ID,
            "merchantTransactionId" => $txnid,
            "amount" 				=> $amount*100,
			"merchantUserId"		=> $userdata['user_display_id'],
            "redirectUrl"			=> base_url().'cron/setUserSession/'.$userdata['user_display_id'].'/'.$txnid,
            "redirectMode"			=> "POST",
            "merchantOrderId"		=> $txnid,
            "callbackUrl"			=> base_url().'cron/phonepayCallback',
            "mobileNumber"			=> $userdata['mobile'],
            "paymentInstrument" 	=> array("type"=>"PAY_PAGE")        
        );

		
        // echo "<pre>"; print_r($post_data);exit;
        
       
        $payloadMain = json_encode($post_data);
        $str = base64_encode($payloadMain);
              
        $payload = $str . "/pg/v1/pay" . PHONEPAY_MERCHANT_KEY;
        $Checksum = hash('sha256', $payload);
        $Checksum = $Checksum.'###1';
                
            
        $header = array
        (
            'Content-type: application/json',
            'X-VERIFY: '.$Checksum,
            'accept: application/json'
        );        
                
        $request = array(
            'request' => $str
        );
                    
        $curl = curl_init();
        // URL
        curl_setopt($curl, CURLOPT_URL, $api_url);

        // Return Transfer
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        // SSL Verify Peer
        // curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);


        // SSL Verify Host
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);

        // Timeout
        curl_setopt($curl, CURLOPT_TIMEOUT, 30);

        // HTTP Version
        curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);

        // Request Method
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");

        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);

        // Request Body
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($request));

        // Execute
        $output = curl_exec($curl);
        
        log_message('debug', 'API Response: ' . $output);
        
        log_message('debug', 'Sending Request: ' . json_encode($post_data));
        log_message('debug', 'cURL Error: ' . curl_error($curl));
        log_message('debug', 'cURL Info: ' . json_encode(curl_getinfo($curl)));


         
        // Close
        curl_close ($curl);


        $api_data = array(                        
            'user_id' 		=> $account_id,
            'api_response' 	=> $output,
            'api_url' 		=> $api_url,
            'post_data' 	=> json_encode($post_data),
            'status' 		=> 1,
            'created' 		=> date('Y-m-d H:i:s')
        );
        $this->db->insert('api_response',$api_data);       


        $responseData = json_decode($output,true);

        if(isset($responseData['success']) && $responseData['success'] == true)
        {
            $paymentRequestData = array(
                'api_response' => $output,
                'posted' => date('Y-m-d H:i:s'),
                'post_data' => json_encode($post_data)
            );

            $this->db->where('userID',$account_id);
            $this->db->where('orderID',$txnid);
            $this->db->update('payment_request', $paymentRequestData);

            $redirect_url = $responseData['data']['instrumentResponse']['redirectInfo']['url'];
            header("Location: $redirect_url");

        } 
        else{
			
            $paymentRequestData = array(

                'userID' 			=> $account_id,
                'orderID' 			=> $txnid,
                'payment_request_id'=> '',
                'amount' 			=> $amount,
                'status' 			=> 1,
                'api_response' 		=> $output,
                'posted' 			=> date('Y-m-d H:i:s'),
                'post_data' 		=> json_encode($post_data)
            );

            $this->db->where('userID',$account_id);
            $this->db->where('orderID',$txnid);
            $this->db->update('payment_request', $paymentRequestData);
            
            $this->Az->redirect('checkout/review/'.$address_id, 'system_message_error', '');
        }     
    
    }
    
    
    
    public function customPaymentPage($payable_amount=0)
	{
		$account_id = $this->User->get_logged_user_account_id();
		
		

			$siteUrl = base_url();
			$data = array(
		        'meta_title'        => lang('SITE_NAME'),
		        'meta_keywords'     => lang('SITE_NAME'),
		        'meta_description'  => lang('SITE_NAME'),
		        'site_url'          => $siteUrl,
		        'payable_amount'       =>$payable_amount,
				'system_message'    => $this->Az->getSystemMessageError(),
		        'system_info'       => $this->Az->getsystemMessageInfo(),
		        'system_warning'    => $this->Az->getSystemMessageWarning(),
		        'content_block'     => 'custom-payment-page'
		        );
		        
		        echo "<pre>";
		        print_r($data);
		        die;
				$this->parser->parse('front/layout/column-3' , $data);

		}
		
		
		public function pgAuthUpi($address_id='')
    {
        $loggedUser = $this->User->get_logged_user_account_id("pinkekart_customer_session");
	
        $account_id = $loggedUser;
        	
		$userdata = $this->db->get_where('tbl_users', array('id' => $account_id))->row_array();

		$cartProductList = $this->User->get_cart_temp_data();

        // check address valid or not
        $chk_address = $this->db->get_where('user_address', array('id' => $address_id, 'userID' => $account_id))->num_rows();
        
        
        if (!$chk_address) {
            $this->Az->redirect('checkout', 'system_message_error', lang('DB_ERROR'));
        }
        
        if (!$cartProductList) {
            $this->Az->redirect('checkout/error', 'system_message_error', '');
        }

        // save order data
        $response = $this->Checkout_model->save_order($cartProductList, $address_id, $account_id);  
        
        /*echo "<pre>";
        print_r($response);
        die;*/
        
        $amount = $response[0];
        $txnid = $response[1];
        
        // save system log
        // $log_msg = '['.date('d-m-Y H:i:s').' - ('.$loggedUser['user_code'].') - Topup Wallet Post Data - '.$amount.']'.PHP_EOL;
        // $this->User->generateLog($log_msg);

        // $this->load->library('form_validation'); 

        $paymentRequestData = array(
            'userID' 				=> $account_id,
            'orderID' 				=> $txnid,
            'payment_request_id' 	=> '',
            'amount' 				=> $amount,
            'status' 				=> 1,
            'api_response' 			=> '',
            'posted' 				=> date('Y-m-d H:i:s'),
            'api_type'              => 2
        );
        $this->db->insert('payment_request', $paymentRequestData);

        //call api
    
        // $memberid = PINPOCKET_PAYMENT_MEMBER_ID;
        // $txnpwd = PINPOCKET_PAYMENT_MEMBER_TXN_PASS;
        // $name = 'PINPOCKET_SOLUTION_PVT_LTD';
        
        // $api_url = PINPOCKET_PAYMENT_REQUEST_URL.'memberid='.$memberid.'&txnpwd='.$txnpwd.'&name='.$name.'&amount='.$amount.'&txnid='.$txnid;
       

        // $curl = curl_init();
        
        // curl_setopt_array($curl, array(
        //   CURLOPT_URL => $api_url,
        //   CURLOPT_RETURNTRANSFER => true,
        //   CURLOPT_ENCODING => '',
        //   CURLOPT_MAXREDIRS => 10,
        //   CURLOPT_TIMEOUT => 0,
        //   CURLOPT_FOLLOWLOCATION => true,
        //   CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        //   CURLOPT_CUSTOMREQUEST => 'GET',
        //   CURLOPT_HTTPHEADER => array(
        //     'Cookie: PHPSESSID=1c387ecccbee3673904805e81ffc90de921f8620'
        //   ),
        // ));
        
        // $output = curl_exec($curl);
        
        // curl_close($curl);
        
        
        
        // $orderData = $this->User->generateOwlxfintechOrder($txnid,$amount,$userdata['name'],$userdata['mobile'],$userdata['email']);
        
        
        
        // $orderId = $orderData['orderId'];
        
        // $token = $orderData['token'];
        
        // sleep(5);
        
        // $api_url = 'https://api.owlxfintech.com/api/v1/collect/status';
        
        // $curl = curl_init();

        // curl_setopt_array($curl, array(
        //   CURLOPT_URL => $api_url,
        //   CURLOPT_RETURNTRANSFER => true,
        //   CURLOPT_ENCODING => '',
        //   CURLOPT_MAXREDIRS => 10,
        //   CURLOPT_TIMEOUT => 0,
        //   CURLOPT_FOLLOWLOCATION => true,
        //   CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        //   CURLOPT_CUSTOMREQUEST => 'POST',
        //   CURLOPT_POSTFIELDS =>'{
        //   "orderId": "'.$orderId.'"
        //   }',
        //   CURLOPT_HTTPHEADER => array(
        //     'Content-Type: application/json',
        //     'Authorization: Bearer '.$token
        //   ),
        // ));
        
        // $output = curl_exec($curl);
        
        // curl_close($curl);
        
       
        
        // log_message('debug', 'API Response: ' . $output);
        
        // log_message('debug', 'Sending Request: ' . $api_url);
        // log_message('debug', 'cURL Error: ' . curl_error($curl));
        // log_message('debug', 'cURL Info: ' . json_encode(curl_getinfo($curl)));


         
        // // Close
        // curl_close ($curl);
        
        $api_url = 'https://www.primewallet.co.in/service/api/payin';
        
        $post_data = array('order_id' => $txnid,'clientName' => $userdata['name'],'clientEmail' => $userdata['email'],'clientMobile' => $userdata['mobile'],'amount' => $amount,'upi_app_package' => 'com.phonepe.app');
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => $api_url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => $post_data,
          CURLOPT_HTTPHEADER => array(
            'Token: eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhZXBzX2tleSI6ImQ3MGJiM2YwNDRmMTQ5Y2E1Njc2ZTNiMCIsImFlcHNfaXYiOiIxYzE5YzkxZWJiM2Y1ZjU1MTlkZmQyZGQ5ODU5In0.QN9aHnch8WHNGAzw511Hw50NnhRCAzW2MvHliHMldF8',
            'Key: d70bb3f044f149ca5676e3b0',
            'Iv: 1c19c91ebb3f5f5519dfd2dd9859',
            'Cookie: AWSALB=d09It/oxrUiEnBgCZJwWxl2ytYsT6Z3Hq7GmgQPw0VuULvJh8W+EM2c/n0QIXUpM/Zsj9mC9QA8AQVZ8I3nLnG3uy/2gG5deHt37GVZ/nO6S4LpzjVa7I8ettail; AWSALBCORS=d09It/oxrUiEnBgCZJwWxl2ytYsT6Z3Hq7GmgQPw0VuULvJh8W+EM2c/n0QIXUpM/Zsj9mC9QA8AQVZ8I3nLnG3uy/2gG5deHt37GVZ/nO6S4LpzjVa7I8ettail; PHPSESSID=rfudjc2cvgqq227q5l698ppoc78dpvkv'
          ),
        ));
        
        $output = curl_exec($curl);
        
        curl_close($curl);


        $api_data = array(                        
            'user_id' 		=> $account_id,
            'api_response' 	=> $output,
            'api_url' 		=> $api_url,
            'post_data' 	=> json_encode($post_data),
            'status' 		=> 1,
            'created' 		=> date('Y-m-d H:i:s')
        );
        $this->db->insert('api_response',$api_data);       
        

        $responseData = json_decode($output,true);
            
            
        $responseData['intent_link'] = 'upi://pay?ver=01&mode=01&orgid=180071&pa=blueadpvt@idfcbank&pn=BLUECREST ADVERTISING PRIVATE LIMITED&mc=5969&mid=MID89556457225&mtid=TID89556457225A&qrMedium=04&am='.$amount;  
        if(isset($responseData['intent_link']) && $responseData['intent_link'] != '')
        {
            $siteUrl = base_url();
			$data = array(
		        'meta_title'        => lang('SITE_NAME'),
		        'meta_keywords'     => lang('SITE_NAME'),
		        'meta_description'  => lang('SITE_NAME'),
		        'site_url'          => $siteUrl,
		        'qr_image'          => $responseData['intent_link'],
		        'amount'            => $amount,
		        'txnid'             => $txnid,
				'system_message'    => $this->Az->getSystemMessageError(),
		        'system_info'       => $this->Az->getsystemMessageInfo(),
		        'system_warning'    => $this->Az->getSystemMessageWarning(),
		        'content_block'     => 'custom-payment-page'
		        );
			$this->parser->parse('front/layout/column-3' , $data);
        } 
        else{
            $this->Az->redirect('checkout/review/'.$address_id, 'system_message_error', '');
        }     
    
    }

	
}
/* End of file login.php */
/* Location: ./application/controllers/login.php */