<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Contact extends CI_Controller{

    public function __construct() {
        parent::__construct();
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front/message', 'english');
        $this->lang->load('front_common', 'english');
    }
	
	
	public function index(){
		
		$account_id = $this->User->get_logged_user_account_id();
		$loggedUser = $account_id;

        $get_setting = $this->db->get('site_settings')->row_array();
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title'        => lang('SITE_NAME'),
            'meta_keywords'     => lang('SITE_NAME'),
            'meta_description'  => lang('SITE_NAME'),
            'site_url'          => $siteUrl,
			'loggedUser'  		=> $loggedUser,
            'get_setting'       => $get_setting,
			'system_message'    => $this->Az->getSystemMessageError(),
            'system_info'       => $this->Az->getsystemMessageInfo(),
            'system_warning'    => $this->Az->getSystemMessageWarning(),
            'content_block'     => 'contact'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }

    public function contactAuth(){

        //check for foem validation
        $post = $this->input->post();

        $this->load->library('form_validation');
        $this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
        $this->form_validation->set_rules('mobile', 'Mobile Number ', 'required|regex_match[/^[0-9]{10}$/]'); 
        $this->form_validation->set_rules('message', 'Message', 'required|xss_clean');

		if ($this->form_validation->run() == FALSE) {

			$this->index();
            // $this->Az->redirect('contact', 'system_message_error',  '<div class="alert alert-danger alert-dismissable"> <button type="button" class="close" data-bs-dismiss="alert" aria-hidden="true">&times;</button>'.validation_errors().'</div>');

		} else{
           
            $data = array(

                'name'       => $post['name'],
                'mobile'     => $post['mobile'],
                'email'      => $post['email'],
                'message'    => $post['message'],
                'created'    => date('Y-m-d h:i:s')
            );
            $status = $this->db->insert('tbl_enquiry', $data);

            if ($status == true) {
                $this->Az->redirect('contact', 'system_message_error', lang('ENQUIRY_SAVE_SUCCESS'));
            } else {
                $this->Az->redirect('contact', 'system_message_error', lang('DB_ERROR'));
            }


        }
    }
}