<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Forgot extends CI_Controller{

    public function __construct() {
        parent::__construct();
        $this->lang->load('front/message', 'english');
        $this->lang->load('front_common', 'english');
		$this->load->model('front/Register_model');		
    }
	
	
	public function index(){
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'forgot'
        );
        $this->parser->parse('front/layout/column-2' , $data);
    }
	
	public function auth()
	{
		$post = $this->input->post();
		$this->load->library('form_validation');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean|min_length[10]|max_length[10]');
		if ($this->form_validation->run() == FALSE) {
			
			$this->index();
		}	
		else
		{
			$mobile = trim($post['mobile']);
			// check email already exits or not
			$chk_user_email = $this->db->query("SELECT * from tbl_users where mobile = '$mobile'")->num_rows();
			
			if(!$chk_user_email)
			{
				$this->Az->redirect('forgot', 'system_message_error',lang('CUSTOMER_MOBILE_NOT_EXITS_ERROR'));
			}
			// update organizer detail
			$encrypt_otp_code = $this->Register_model->sendForgotOTP($post);
			
			$mobile_last_digit = substr($post['mobile'], -3);
			
			$this->Az->redirect('forgot/otp/'.$encrypt_otp_code, 'system_message_error',sprintf(lang('CUSTOMER_REGISTER_OTP_SUCCESS'),$mobile_last_digit));
			
		}
		
	}
	
	public function otp($encrypt_otp_code = ''){
		
		// check otp encryption
		$chk_otp = $this->db->get_where('users_otp',array('encrypt_otp_code'=>$encrypt_otp_code,'status'=>0))->num_rows();
		if(!$chk_otp)
		{
			$this->Az->redirect('forgot', 'system_message_error',lang('COMMON_ERROR'));
		}
		
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			'encrypt_otp_code'  => $encrypt_otp_code,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'forgot-otp'
        );
        $this->parser->parse('front/layout/column-2' , $data);
    }
	
	public function otpAuth()
	{
		$post = $this->input->post();
        if(isset($post['resend'])){
		$encrypt_otp_code = $this->Register_model->resendForgotOTP($post);
		
		$get_customer_mobile = $this->db->get_where('users_otp',array('encrypt_otp_code'=>$encrypt_otp_code,'status'=>0))->row_array();
        $post_data = isset($get_customer_mobile['json_post_data']) ? json_decode($get_customer_mobile['json_post_data']) : array();
        
        $mobile_last_digit = substr($post_data->mobile, -3);
			$this->Az->redirect('forgot/otp/'.$encrypt_otp_code, 'system_message_error',sprintf(lang('CUSTOMER_REGISTER_OTP_SUCCESS'),$mobile_last_digit));
		}
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('encrypt_otp_code', 'encrypt_otp_code', 'xss_clean');
		$this->form_validation->set_rules('otp_code', 'OTP Code', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->otp($post['encrypt_otp_code']);
		}
		else
		{
			$otp_code = trim($post['otp_code']);
			$chk_otp = $this->db->get_where('users_otp',array('otp_code'=>$otp_code,'status'=>0))->num_rows();
			if(!$chk_otp)
			{
				
				$this->Az->redirect('forgot/otp/'.$post['encrypt_otp_code'], 'system_message_error',lang('CUSTOMER_REGISTER_OTP_ERROR'));
				
			}
			$this->Az->redirect('forgot/updatePassword/'.$post['encrypt_otp_code'], 'system_message_error','');
		}
		
	}
	
	public function updatePassword($encrypt_otp_code = ''){
		
		// check otp encryption
		$chk_otp = $this->db->get_where('users_otp',array('encrypt_otp_code'=>$encrypt_otp_code,'status'=>0))->num_rows();
		if(!$chk_otp)
		{
			$this->Az->redirect('forgot', 'system_message_error',lang('COMMON_ERROR'));
		}
		
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			'encrypt_otp_code'  => $encrypt_otp_code,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'update-password'
        );
        $this->parser->parse('front/layout/column-2' , $data);
    }
	
	public function updateAuth()
	{
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('encrypt_otp_code', 'encrypt_otp_code', 'xss_clean');
		$this->form_validation->set_rules('password', 'Password', 'required|xss_clean|min_length[6]');
		$this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|xss_clean|matches[password]');
		if ($this->form_validation->run() == FALSE) {
			
			$this->updatePassword($post['encrypt_otp_code']);
		}
		else
		{
			
			// update organizer detail
			$encrypt_otp_code = $this->Register_model->updatePassword($post);

			if ($encrypt_otp_code) {
				$this->Az->redirect('login', 'system_message_error',lang('PASSWORD_UPDATE_SUCCESS'));
			}else{
				$this->Az->redirect('login', 'system_message_error',lang('DB_ERROR'));
			}
			
			
		}
		
	}
	
	
}
/* End of file login.php */
/* Location: ./application/controllers/login.php */