<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Home extends CI_Controller{

    public function __construct() {
        parent::__construct();
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front/message', 'english');
        $this->lang->load('front_common', 'english');
    }
	
	
	public function index(){
		
		$account_id = $this->User->get_logged_user_account_id();
		$loggedUser = $account_id;
		
		// get large banner list
		$largeBannerList = $this->db->order_by('order_no','asc')->get_where('banners',array('banner_type_id' => 1,'is_active' => 1))->result_array();
		// echo "<pre>";print_r($largeBannerList);die;
		// get small banner list
		$smallBannerList = $this->db->order_by('order_no','asc')->limit(2)->get_where('banners',array('banner_type_id'=>2,'is_active'=>1))->result_array();
		$categoryBannerList = $this->db->order_by('order_no','asc')->limit(1)->get_where('banners',array('banner_type_id' => 3,'is_active' => 1))->row_array();
		
		// get section list
		$sectionList = $this->db->order_by('order_no','asc')->get_where('sections',array('status' => 1))->result_array();
	
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			'loggedUser'  		=> $loggedUser,
			'largeBannerList'  	=> $largeBannerList,
			'smallBannerList'  	=> $smallBannerList,
			'sectionList'  		=> $sectionList,
			'categoryBannerList'=> $categoryBannerList,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'home'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }

	public function subscribeAuth() {
		$post = $this->input->post();
		$ip_address = $_SERVER['REMOTE_ADDR'];
		$email = $post['email'];
		$is_popup_show = isset($post['is_show']) ? 1 : 0; 
		
		$this->db->where('email', $email);
		$this->db->where('ip_address', $ip_address);
		$query = $this->db->get('tbl_subscribe');
	
		if ($query->num_rows() > 0) {
			// If record exists, do not insert and redirect with message
			$this->Az->redirect('home', 'system_message_error', lang('SUBSCRIBE_ALREADY_EXIST'));
		} else {
			// Record does not exist, proceed with insertion
			$data = array(
				'email'      => $email,
				'ip_address' => $ip_address,
				'is_show'    => $is_popup_show,
				'created'    => date('Y-m-d h:i:s')
			);
	
			$status = $this->db->insert('tbl_subscribe', $data);
	
			if ($status == true) {
				$this->Az->redirect('home', 'system_message_error', lang('SUBSCRIBE_SUCCESS'));
			} else {
				$this->Az->redirect('home', 'system_message_error', lang('DB_ERROR'));
			}
		}
	}
	

	
	public function crop()
	{
		if(file_exists("media/product_images/thumbnail-70x70/1bada7108cd997fbde211351754fe375b25ac312.jpg"))
		{
			die('success');
		}
		die('error');
			$this->load->library('image_lib');
	
			$config['image_library'] = 'gd2';
			$config['source_image'] = 'E:/xampp/htdocs/pinkekart/media/product_images/5fb6eba921c5904c0317bbdd2fd56e9dc8a248a2.jpg';
			$config['new_image'] = 'E:/xampp/htdocs/pinkekart/media/product_images/thumbnail-70x70';
			$config['create_thumb'] = FALSE;
			$config['maintain_ratio'] = TRUE;
			$config['width']         = 70;
			$config['height']       = 70;
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
			
			$config['image_library'] = 'gd2';
			$config['source_image'] = 'E:/xampp/htdocs/pinkekart/media/product_images/5fb6eba921c5904c0317bbdd2fd56e9dc8a248a2.jpg';
			$config['new_image'] = 'E:/xampp/htdocs/pinkekart/media/product_images/thumbnail-180x180';
			$config['create_thumb'] = FALSE;
			$config['maintain_ratio'] = TRUE;
			$config['width']         = 180;
			$config['height']       = 180;
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
			
			$config['image_library'] = 'gd2';
			$config['source_image'] = 'E:/xampp/htdocs/pinkekart/media/product_images/5fb6eba921c5904c0317bbdd2fd56e9dc8a248a2.jpg';
			$config['new_image'] = 'E:/xampp/htdocs/pinkekart/media/product_images/thumbnail-400x400';
			$config['create_thumb'] = FALSE;
			$config['maintain_ratio'] = TRUE;
			$config['width']         = 400;
			$config['height']       = 400;
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
		
		
		die('success');
	}
	
	public function checkPinCode()
	{
		$post = $this->input->post();
		$pincode = isset($post['pincode']) ? $post['pincode'] : '';
		$response = array();
		if($pincode){

			$api_url = 'https://api.postalpincode.in/pincode/'.$pincode;
				$ch = curl_init();
		        curl_setopt($ch, CURLOPT_URL, $api_url);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
		        $output = (array) json_decode(curl_exec($ch)); 
		        curl_close($ch);

			if(!$output){
				$response = array(
				  'status' => 0,
				  'msg' => 'Pincode does not exist'
				);
			}
			else
			{
				// check pincode already saved or not
				$chk_pincode = $this->db->get_where('pincode',array('pincode'=>$pincode))->num_rows();
				$district = '';
				if(!$chk_pincode)
				{
					$pincodeData = $output[0]->PostOffice[0];
						$pinData = array(
							'pincode' => $pincodeData->Pincode,
							'area_name' => $pincodeData->Name,
							'district' => $pincodeData->District,
							'state_name' => $pincodeData->State,
						);
					

						$this->db->insert('pincode',$pinData);
						$district = $pincodeData->District;
					
				}
				else
				{
					// get district name
					$get_district_name = $this->db->get_where('pincode',array('pincode'=>$pincode))->row_array();
					$district = isset($get_district_name['district']) ? $get_district_name['district'] : '';
				}

				$loggedUser = $this->session->userdata('pinkekart_customer_session');
				$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
				if(!$account_id)
				{
					$loggedUser = $this->session->userdata('pinkekart_vendor_session');
					$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
				}
				$user_ip_address = $_SERVER['REMOTE_ADDR'];

				if($account_id)
				{
					$chk_user_pincode = $this->db->get_where('user_delivery_pincode',array('user_id'=>$account_id))->num_rows();
					if($chk_user_pincode)
					{
						$pinData = array(
							'pincode' => $pincode,
							'district' => $district,
							'updated' => date('Y-m-d H:i:s')
						);
						$this->db->where('user_id',$account_id);
						$this->db->update('user_delivery_pincode',$pinData);

					}
					else
					{
						$pinData = array(
							'user_id' => $account_id,
							'pincode' => $pincode,
							'district' => $district,
							'created' => date('Y-m-d H:i:s')
						);
						
						$this->db->insert('user_delivery_pincode',$pinData);
					}

				}
				else
				{
					$chk_user_pincode = $this->db->get_where('user_delivery_pincode',array('ip'=>$user_ip_address))->num_rows();
					if($chk_user_pincode)
					{
						$pinData = array(
							'pincode' => $pincode,
							'district' => $district,
							'updated' => date('Y-m-d H:i:s')
						);
						$this->db->where('ip',$user_ip_address);
						$this->db->update('user_delivery_pincode',$pinData);

					}
					else
					{
						$pinData = array(
							'ip' => $user_ip_address,
							'pincode' => $pincode,
							'district' => $district,
							'created' => date('Y-m-d H:i:s')
						);
						
						$this->db->insert('user_delivery_pincode',$pinData);
					}
				}
				
				$response = array(
				  'status' => 1,
				  'msg' => 'Success',
				  'str' => ''
				);
			}
		}
		else
		{
			$response = array(
			  'status' => 0,
			  'msg' => 'Pincode does not exist'
			);
		}
		echo json_encode($response);
	}

	public function deliveryAddAuth($address_id = 0)
	{
		$account_id = $this->User->get_logged_user_account_id();
		// chk product slug
		$chk_product = $this->db->get_where('user_address',array('id'=>$address_id,'userID'=>$account_id))->num_rows();
		if(!$chk_product)
		{
			$this->Az->redirect('home', 'system_message_error','');
		}
		$get_pincode = $this->db->get_where('user_address',array('id'=>$address_id,'userID'=>$account_id))->row_array();
		$pincode = isset($get_pincode['zip_code']) ? $get_pincode['zip_code'] : '';
		$api_url = 'https://api.postalpincode.in/pincode/'.$pincode;
				$ch = curl_init();
		        curl_setopt($ch, CURLOPT_URL, $api_url);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
		        $output = (array) json_decode(curl_exec($ch)); 
		        curl_close($ch);
			if(!$output){
				$response = array(
				  'status' => 0,
				  'msg' => 'Pincode does not exist'
				);
			}
			else
			{
				// check pincode already saved or not
				$chk_pincode = $this->db->get_where('pincode',array('pincode'=>$pincode))->num_rows();
				$district = '';
				if(!$chk_pincode)
				{
					$pincodeData = $output[0]->PostOffice[0];
						$pinData = array(
							'pincode' => $pincodeData->Pincode,
							'area_name' => $pincodeData->Name,
							'district' => $pincodeData->District,
							'state_name' => $pincodeData->State,
						);
					

						$this->db->insert('pincode',$pinData);
						$district = $pincodeData->District;
					
				}
				else
				{
					// get district name
					$get_district_name = $this->db->get_where('pincode',array('pincode'=>$pincode))->row_array();
					$district = isset($get_district_name['district']) ? $get_district_name['district'] : '';
				}

				
					$chk_user_pincode = $this->db->get_where('user_delivery_pincode',array('user_id'=>$account_id))->num_rows();
					if($chk_user_pincode)
					{
						$pinData = array(
							'pincode' => $pincode,
							'district' => $district,
							'updated' => date('Y-m-d H:i:s')
						);
						$this->db->where('user_id',$account_id);
						$this->db->update('user_delivery_pincode',$pinData);

					}
					else
					{
						$pinData = array(
							'user_id' => $account_id,
							'pincode' => $pincode,
							'district' => $district,
							'created' => date('Y-m-d H:i:s')
						);
						
						$this->db->insert('user_delivery_pincode',$pinData);
					}

				
				
			}
		
		$this->Az->redirect('home', 'system_message_error','');
	}
	


	public function getAddress($pin_code = '')
	{
		$response = array();
		if($pin_code){

			$api_url = 'https://api.postalpincode.in/pincode/'.$pin_code;
				$ch = curl_init();
		        curl_setopt($ch, CURLOPT_URL, $api_url);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
		        $output = (array) json_decode(curl_exec($ch)); 
		        curl_close($ch);
		    if(!$output)
			{
				$response = array(
				  'status' => 0,
				  'msg' => 'Pincode does not exist'
				);
			}
			else
			{ 
			  $pincodeData = $output[0]->PostOffice[0];		
			  $response = array(
				  'status' => 1,
				  'msg' => 'Success',
				  'city'=> $pincodeData->District,
				  'state'=>$pincodeData->State,
				  'country'=>$pincodeData->Country,  
				);	
			}
		}
		else
		{
			$response = array(
			  'status' => 0,
			  'msg' => 'Pincode does not exist'
			);
		}
		echo json_encode($response);
	}


	public function getUpdateAddress($pin_code = '')
	{
		$response = array();
		if($pin_code){

			$api_url = 'https://api.postalpincode.in/pincode/'.$pin_code;
				$ch = curl_init();
		        curl_setopt($ch, CURLOPT_URL, $api_url);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
		        $output = (array) json_decode(curl_exec($ch)); 
		        curl_close($ch);
		    if(!$output)
			{
				$response = array(
				  'status' => 0,
				  'msg' => 'Pincode does not exist'
				);
			}
			else
			{ 
			  $pincodeData = $output[0]->PostOffice[0];		
			  $response = array(
				  'status' => 1,
				  'msg' => 'Success',
				  'city'=> $pincodeData->District,
				  'state'=>$pincodeData->State,
				  'country'=>$pincodeData->Country,  
				);	
			}
		}
		else
		{
			$response = array(
			  'status' => 0,
			  'msg' => 'Pincode does not exist'
			);
		}
		echo json_encode($response);
	}
	
	
	
	
	public function checkOrderStatus($txnid){
	   
	    $check = $this->db->get_where('payment_request', array('orderID' => $txnid))->row_array();
	    if($check){
	        if($check['status'] == 1) {
	            echo json_encode(['status' => 1, 'message' => 'Please Wait Payment Is Processing!']);    
	        }
	        elseif($check['status'] == 2){
	            echo json_encode(['status' => 2, 'message' => 'Payment Is Success!']);    
	        }
	        elseif($check['status'] == 3){
	            echo json_encode(['status' => 3, 'message' => 'Payment Is Failed!']);    
	        }
	    }
	    else{
	        echo json_encode(['status' => 0, 'message' => 'Txnid Not Found!']);
	    }
	}
	
	public function testOrder(){
	    
	    
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.owlxfintech.com/api/v1/auth//realms/owlx/protocol/openid-connect/token',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_secret=9dNubxuICN5PKSoN4USfyXpAUXGwerku&client_id=73f2af10-baf5-4efc-a350-69c65eb2cfbe',
          CURLOPT_HTTPHEADER => array(
            'Content-Transfer-Encoding: application/x-www-form-urlencoded',
            'Content-Type: application/x-www-form-urlencoded'
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        echo $response;
        die;
	}
	
	
	public function testPayin(){
	    
	    
	    
	    
        $orderId = '5245346475643123';
        
        $token = 'eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICJucVc0R2NHVzBCSjY4WGZtN0QzWmdjUFZBNTJZSTBOLUcyWExPTDJWM2lNIn0.eyJleHAiOjE3NTYxOTk2MDksImlhdCI6MTc1NjE5OTMwOSwianRpIjoiYTY4Y2VmNGItNGZkZS00YjJiLWEwNzktZDU4ZTI2MDlmODQyIiwiaXNzIjoiaHR0cHM6Ly9hcGkub3dseGZpbnRlY2guY29tL2FwaS92MS9hdXRoL3JlYWxtcy9vd2x4IiwiYXVkIjoiYWNjb3VudCIsInN1YiI6IjAyOWUyNTVhLWIwM2UtNGExMC1iNzk0LWQ1OTJiYjJiNmUwNCIsInR5cCI6IkJlYXJlciIsImF6cCI6IjczZjJhZjEwLWJhZjUtNGVmYy1hMzUwLTY5YzY1ZWIyY2ZiZSIsImFjciI6IjEiLCJyZWFsbV9hY2Nlc3MiOnsicm9sZXMiOlsibWVyY2hhbnRfcHJvZF81MiIsIm9mZmxpbmVfYWNjZXNzIiwiZGVmYXVsdC1yb2xlcy1vd2x4IiwidW1hX2F1dGhvcml6YXRpb24iXX0sInJlc291cmNlX2FjY2VzcyI6eyJhY2NvdW50Ijp7InJvbGVzIjpbIm1hbmFnZS1hY2NvdW50IiwibWFuYWdlLWFjY291bnQtbGlua3MiLCJ2aWV3LXByb2ZpbGUiXX19LCJzY29wZSI6ImVtYWlsIHByb2ZpbGUiLCJlbWFpbF92ZXJpZmllZCI6ZmFsc2UsImNsaWVudElkIjoiNzNmMmFmMTAtYmFmNS00ZWZjLWEzNTAtNjljNjVlYjJjZmJlIiwiY2xpZW50SG9zdCI6IjEwMS41My4xNDQuNzQiLCJwcmVmZXJyZWRfdXNlcm5hbWUiOiJzZXJ2aWNlLWFjY291bnQtNzNmMmFmMTAtYmFmNS00ZWZjLWEzNTAtNjljNjVlYjJjZmJlIiwiY2xpZW50QWRkcmVzcyI6IjEwMS41My4xNDQuNzQifQ.CkQ9CGWZk9B4i5l3WSz7qgGs7tV5-2hsdvAp1aXikhqgPqaW-Zg4zr05K1MAmS6j_BKyeFVEMiVWWpxciieLTDx54R_IR8vOi9_tFR870w-G9qcpCAgnFJhbUDfmwEN4Pw-9tZnM4XSlnDwRt-ZPE_6_hWLcOJrEophvBGtaXcMLLORiGtqA09b7Gdh1lTwPL15BhX7s1WMsBKY8pK47SiwoiMQWyBSRNzWoTLdkCEIDHLJwoqPa9YN1tg6lzwX74QGh-JPzi7kvNHSBVqWPEdeF8aobYHkBhjxtLT6Fiy1w-1TLGkR-ZEAu618FuMfBF_BX7kWl1IJTk6Y5FxdzgA';
        
        $api_url = 'https://api.owlxfintech.com/api/v1/collect/status';
        
        json_encode(array("orderId"=>$orderId));
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => $api_url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>json_encode(array("orderId"=>$orderId)),
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$token
          ),
        ));
        
        $output = curl_exec($curl);
        
        curl_close($curl);
        
        echo $output;
        die;
	}
	
	public function testOwlxPayin()
	{
	    $token = $this->User->generateOwlxfintechToken();
	    
	    $amount = '100';
	    $order_id = rand(1111111111,9999999999);
	    $name = 'lakshya';
	    $phone = '8545857485';
	    $email = 'test@gmail.com';
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.owlxfintech.com/api/v1/collect/payin',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
          "orderId": "'.$order_id.'",
          "provider": "provider1",
          "paymentType": "intent_sync",
          "amount": '.$amount.',
          "currency": "INR",
          "vpa": "customer@upi",
          "name": "'.$name.'",
          "phone": "'.$phone.'",
          "email": "'.$email.'",
          "description": "Payment for order #'.$order_id.'",
          "notifyurl": "https://mokshkart.com/cron/owlxfintechPayinCallback",
          "redirectUrl": "https://mokshkart.com/cron/owlxfintechPayinCallback"
        }',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$token
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        
        $responseData = json_decode($response,true);
        
        echo "<pre>";
        print_r($responseData);
        die;
	}
	
	
	
}
/* End of file login.php */
/* Location: ./application/controllers/login.php */