<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Page extends CI_Controller{

    public function __construct() {
        parent::__construct();
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front/message', 'english');
        $this->lang->load('front_common', 'english');
    }
	
	
	public function index($block_slug = '',$page_slug = ''){
		
		// check block slug
		$chk_block_slug = $this->db->get_where('blocks',array('slug'=>$block_slug,'status'=>1))->num_rows();
		if(!$chk_block_slug)
		{
			$this->Az->redirect('home', 'system_message_error',lang('COMMON_ERROR'));
		}
		
		// check page slug
		$chk_page_slug = $this->db->get_where('pages',array('slug'=>$page_slug,'status'=>1))->num_rows();
		if(!$chk_page_slug)
		{
			$this->Az->redirect('home', 'system_message_error',lang('COMMON_ERROR'));
		}
		
		// get block id
		$get_block_id = $this->db->get_where('blocks',array('slug'=>$block_slug,'status'=>1))->row_array();
		$block_id = isset($get_block_id['id']) ? $get_block_id['id'] : 0 ;
		
		
		// get block page list
		$blockPageList = $this->db->select('block_pages.*,pages.title as page_name,pages.slug as page_slug')->order_by('block_pages.page_order_no','asc')->join('pages','pages.id = block_pages.page_id')->get_where('block_pages',array('block_pages.block_id'=>$block_id,'pages.status'=>1))->result_array();
		
		
		// get page data
		$pageData = $this->db->get_where('pages',array('slug'=>$page_slug,'status'=>1))->row_array();
		
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
			'block_slug'  => $block_slug,
			'blockPageList'  => $blockPageList,
			'pageData'  => $pageData,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'page'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	
	
}
/* End of file login.php */
/* Location: ./application/controllers/login.php */