<?php
if (!defined('BASEPATH'))
	exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Register extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();

		$this->lang->load('front/message', 'english');
		$this->lang->load('front_common', 'english');
		$this->load->model('front/Register_model');
	}


	public function index($vendor = '')
	{

		$params = $this->input->get();

		$return_url = isset($params['ret_url']) ? $params['ret_url'] : '';
		if ($this->session->userdata('pinkekart_vendor_session') || $this->session->userdata('pinkekart_customer_session')) {
			$this->Az->redirect('home', 'system_message_error', lang('COMMON_ERROR'));
		}

		$content_block = 'register';
		$is_vendor = 0;
		if ($vendor) {
			$is_vendor = 1;
			$content_block = 'vendor-register';
		}

		$countryList = $this->db->get('countries')->result_array();

		// get state list
		$stateList = $this->db->order_by('name', 'asc')->get_where('states', array('country_code_char2' => 'IN'))->result_array();

		$siteUrl = base_url();
		$data = array(
			'meta_title' 		=> lang('SITE_NAME'),
			'meta_keywords' 	=> lang('SITE_NAME'),
			'meta_description' 	=> lang('SITE_NAME'),
			'site_url' 			=> $siteUrl,
			'is_vendor'  		=> $is_vendor,
			'countryList' 		=> $countryList,
			'stateList'   		=> $stateList,
			'return_url'  		=> $return_url,
			'system_message' 	=> $this->Az->getSystemMessageError(),
			'system_info' 		=> $this->Az->getsystemMessageInfo(),
			'system_warning' 	=> $this->Az->getSystemMessageWarning(),
			'content_block' 	=> $content_block
		);
		$this->parser->parse('front/layout/column-2', $data);
	}

	public function auth()
	{
		$post = $this->input->post();

		$vendor = '';
		if ($post['is_vendor']) {
			$vendor = 'vendor';
		}

		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'required|xss_clean|valid_email');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean|min_length[10]|max_length[10]');
		$this->form_validation->set_rules('password', 'Password', 'required|xss_clean|min_length[6]');

		if ($this->form_validation->run() == FALSE) {

			$this->index($vendor);
		} else {

			$email = trim(strtolower($post['email']));
			$mobile = trim($post['mobile']);

			// check email already exits or not
			$chk_user_email = $this->db->query("SELECT * from tbl_users where email = '$email' or mobile = '$mobile'")->num_rows();

			if ($chk_user_email) {
				if ($vendor) {
					$this->Az->redirect('register/index/vendor', 'system_message_error', lang('CUSTOMER_EMAIL_MOBILE_EXITS_ERROR'));
				} else {
					$this->Az->redirect('register', 'system_message_error', lang('CUSTOMER_EMAIL_MOBILE_EXITS_ERROR'));
				}
			}

			$user_id = $this->Register_model->registerCustomer($post, $vendor);

			$get_user_data = $this->db->get_where('users', array('id' => $user_id))->row_array();

			if ($get_user_data['role_id'] == 3) {

				$user_ip_address = $_SERVER['REMOTE_ADDR'];
				// update cart temp data
				$this->db->where('ip', $user_ip_address);
				$this->db->update('cart_temp_data', array('user_id' => $get_user_data['id']));

				$this->session->set_userdata('pinkekart_vendor_session', $get_user_data);

				if ($post['return_url'] && $post['return_url'] == 'checkout') {
					$this->Az->redirect('checkout');
				} else {
					$this->Az->redirect('vendor/dashboard');
				}
			} else if ($get_user_data['role_id'] == 4) {

				$user_ip_address = $_SERVER['REMOTE_ADDR'];
				// update cart temp data
				$this->db->where('ip', $user_ip_address);
				$this->db->update('cart_temp_data', array('user_id' => $get_user_data['id']));

				$this->session->set_userdata('pinkekart_customer_session', $get_user_data);

				if ($post['return_url'] && $post['return_url'] == 'checkout') {
					$this->Az->redirect('checkout');
				} else {

					$this->Az->redirect('customer/dashboard', 'system_message_error', lang('CUSTOMER_REGISTER_SUCCESS'));
					// $this->Az->redirect('customer/dashboard');
				}
			} else {

				$this->Az->redirect('register', 'system_message_error', lang('DB_ERROR'));
			}

			// update organizer detail
			// $encrypt_otp_code = $this->Register_model->sendOTP($post);
			// if ($vendor) {
			// 	if (isset($post['return_url'])) {
			// 		$this->Az->redirect('register/otp/' . $encrypt_otp_code . '/vendor?ret_url=checkout', 'system_message_error', lang('CUSTOMER_REGISTER_OTP_SUCCESS'));
			// 	} else {
			// 		$this->Az->redirect('register/otp/' . $encrypt_otp_code . '/vendor', 'system_message_error', lang('CUSTOMER_REGISTER_OTP_SUCCESS'));
			// 	}
			// } else {

			// 	if (isset($post['return_url'])) {

			// 		$this->Az->redirect('register/otp/' . $encrypt_otp_code . '?ret_url=checkout', 'system_message_error', lang('CUSTOMER_REGISTER_OTP_SUCCESS'));
			// 	} else {

			// 		$this->Az->redirect('register/otp/' . $encrypt_otp_code, 'system_message_error', lang('CUSTOMER_REGISTER_OTP_SUCCESS'));
			// 	}
			// }
		}
	}

	public function vendorAuth()
	{
		$post = $this->input->post();
		$vendor = '';
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'required|xss_clean|valid_email');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean|min_length[10]|max_length[10]');
		$this->form_validation->set_rules('password', 'Password', 'required|xss_clean|min_length[6]');
		$this->form_validation->set_rules('firm_name', 'Firm Name', 'xss_clean');
		$this->form_validation->set_rules('address', 'Address', 'required|xss_clean');
		$this->form_validation->set_rules('state', 'State', 'required|xss_clean');
		$this->form_validation->set_rules('country', 'Country', 'required|xss_clean');
		$this->form_validation->set_rules('zip_code', 'ZIP Code', 'required|xss_clean');
		$this->form_validation->set_rules('gst_no', 'GST No.', 'required|xss_clean');
		if (!isset($_FILES['address_proof']['name']) || !$_FILES['address_proof']['name']) {
			$this->form_validation->set_rules('address_proof', 'Address Proof', 'required|xss_clean');
		}
		if (!isset($_FILES['pan_card']['name']) || !$_FILES['pan_card']['name']) {
			$this->form_validation->set_rules('pan_card', 'PAN Card', 'required|xss_clean');
		}
		$this->form_validation->set_rules('account_holder_name', 'Account Holder Name', 'required|xss_clean');
		$this->form_validation->set_rules('account_no', 'Account No.', 'required|xss_clean');
		$this->form_validation->set_rules('ifsc', 'IFSC Code', 'required|xss_clean');
		$this->form_validation->set_rules('bank_name', 'Bank Name', 'required|xss_clean');

		if ($this->form_validation->run() == FALSE) {
			$this->index('vendor');
		} else {
			$email = trim(strtolower($post['email']));
			$mobile = trim($post['mobile']);
			// check email already exits or not
			$chk_user_email = $this->db->query("SELECT * from tbl_users where email = '$email' or mobile = '$mobile'")->num_rows();

			if ($chk_user_email) {
				$this->Az->redirect('register/index/vendor', 'system_message_error', lang('CUSTOMER_EMAIL_MOBILE_EXITS_ERROR'));
			}
			// update organizer detail

			$address_proof = '';
			if ($_FILES['address_proof']['name'] != '') {
				//generate logo name randomly
				$fileName = rand(1111, 999999999);
				$config['upload_path'] = './media/seller_document/';
				$config['allowed_types'] = 'jpg|png|gif|jpeg';
				$config['file_name'] = $fileName;
				$this->load->library('upload');
				$this->upload->initialize($config);
				$this->upload->do_upload('address_proof');
				$uploadError = $this->upload->display_errors();
				if ($uploadError) {
					$this->Az->redirect('register/index/vendor', 'system_message_error', $uploadError);
				} else {

					$fileData = $this->upload->data();
					//get uploaded file path
					$address_proof = substr($config['upload_path'] . $fileData['file_name'], 2);
				}
			}
			$pan_card = '';
			if ($_FILES['pan_card']['name'] != '') {
				//generate logo name randomly
				$fileName = rand(1111, 999999999);
				$config['upload_path'] = './media/seller_document/';
				$config['allowed_types'] = 'jpg|png|gif|jpeg';
				$config['file_name'] = $fileName;
				$this->load->library('upload');
				$this->upload->initialize($config);
				$this->upload->do_upload('pan_card');
				$uploadError = $this->upload->display_errors();
				if ($uploadError) {
					$this->Az->redirect('register/index/vendor', 'system_message_error', $uploadError);
				} else {

					$fileData = $this->upload->data();
					//get uploaded file path
					$pan_card = substr($config['upload_path'] . $fileData['file_name'], 2);
				}
			}

			$post['address_proof'] = $address_proof;
			$post['pan_card'] = $pan_card;

			$encrypt_otp_code = $this->Register_model->sendOTP($post);

			if (isset($post['return_url'])) {
				$this->Az->redirect('register/otp/' . $encrypt_otp_code . '/vendor?ret_url=checkout', 'system_message_error', lang('CUSTOMER_REGISTER_OTP_SUCCESS'));
			} else {
				$this->Az->redirect('register/otp/' . $encrypt_otp_code . '/vendor', 'system_message_error', lang('CUSTOMER_REGISTER_OTP_SUCCESS'));
			}
		}
	}

	public function otp($encrypt_otp_code = '', $vendor = '')
	{

		$params = $this->input->get();
		$return_url = isset($params['ret_url']) ? $params['ret_url'] : '';
		// check otp encryption
		$chk_otp = $this->db->get_where('users_otp', array('encrypt_otp_code' => $encrypt_otp_code, 'status' => 0))->num_rows();
		if (!$chk_otp) {
			$this->Az->redirect('register', 'system_message_error', lang('COMMON_ERROR'));
		}

		$content_block = 'register-otp';
		$is_vendor = 0;
		if ($vendor) {
			$is_vendor = 1;
			$content_block = 'register-vendor-otp';
		}

		$siteUrl = base_url();
		$data = array(
			'meta_title' 		=> lang('SITE_NAME'),
			'meta_keywords'	 	=> lang('SITE_NAME'),
			'meta_description' 	=> lang('SITE_NAME'),
			'site_url'	 		=> $siteUrl,
			'encrypt_otp_code'  => $encrypt_otp_code,
			'is_vendor'  		=> $is_vendor,
			'return_url' 		=> $return_url,
			'system_message' 	=> $this->Az->getSystemMessageError(),
			'system_info' 		=> $this->Az->getsystemMessageInfo(),
			'system_warning' 	=> $this->Az->getSystemMessageWarning(),
			'content_block' 	=> $content_block,
		);
		$this->parser->parse('front/layout/column-2', $data);
	}

	public function otpAuth()
	{
		$post = $this->input->post();

		if (isset($post['resend'])) {
			$encrypt_otp_code = $this->Register_model->resendOTP($post);
			$this->Az->redirect('register/otp/' . $encrypt_otp_code . '', 'system_message_error', lang('CUSTOMER_REGISTER_OTP_SUCCESS'));
		}

		$vendor = '';
		if ($post['is_vendor']) {
			$vendor = 'vendor';
		}
		$this->load->library('form_validation');
		$this->form_validation->set_rules('encrypt_otp_code', 'encrypt_otp_code', 'xss_clean');
		$this->form_validation->set_rules('otp_code', 'OTP Code', 'required|xss_clean');

		if ($this->form_validation->run() == FALSE) {
			$this->otp($post['encrypt_otp_code'], $vendor);
		} else {

			$otp_code = trim($post['otp_code']);
			$chk_otp = $this->db->get_where('users_otp', array('otp_code' => $otp_code, 'status' => 0))->num_rows();

			if (!$chk_otp) {
				if ($vendor) {
					$this->Az->redirect('register/otp/' . $post['encrypt_otp_code'] . '/vendor', 'system_message_error', lang('CUSTOMER_REGISTER_OTP_ERROR'));
				} else {
					$this->Az->redirect('register/otp/' . $post['encrypt_otp_code'], 'system_message_error', lang('CUSTOMER_REGISTER_OTP_ERROR'));
				}
			} else {

				// update organizer detail
				$user_id = $this->Register_model->registerCustomer($post, $vendor);

				$get_user_data = $this->db->get_where('users', array('id' => $user_id))->row_array();

				if ($get_user_data['role_id'] == 3) {

					$user_ip_address = $_SERVER['REMOTE_ADDR'];
					// update cart temp data
					$this->db->where('ip', $user_ip_address);
					$this->db->update('cart_temp_data', array('user_id' => $get_user_data['id']));

					echo $this->session->set_userdata('pinkekart_vendor_session', $get_user_data);
					die;

					if ($post['return_url'] && $post['return_url'] == 'checkout') {
						$this->Az->redirect('checkout');
					} else {
						$this->Az->redirect('vendor/dashboard');
					}
				} else if ($get_user_data['role_id'] == 4) {

					$user_ip_address = $_SERVER['REMOTE_ADDR'];
					// update cart temp data
					$this->db->where('ip', $user_ip_address);
					$this->db->update('cart_temp_data', array('user_id' => $get_user_data['id']));

					$this->session->set_userdata('pinkekart_customer_session', $get_user_data);

					if ($post['return_url'] && $post['return_url'] == 'checkout') {
						$this->Az->redirect('checkout');
					} else {
						$this->Az->redirect('customer/dashboard');
					}
				} else {

					$this->Az->redirect('register', 'system_message_error', lang('DB_ERROR'));
				}
			}
		}
	}

	public function vendorOtpAuth()
	{
		$post = $this->input->post();

		if (isset($post['resend'])) {
			$encrypt_otp_code = $this->Register_model->resendOTP($post);
			$this->Az->redirect('register/otp/' . $encrypt_otp_code . '/vendor', 'system_message_error', lang('CUSTOMER_REGISTER_OTP_SUCCESS'));
		}

		$this->load->library('form_validation');
		$this->form_validation->set_rules('encrypt_otp_code', 'encrypt_otp_code', 'xss_clean');
		$this->form_validation->set_rules('otp_code', 'OTP Code', 'required|xss_clean');

		if ($this->form_validation->run() == FALSE) {
			$this->otp($post['encrypt_otp_code'], 'vendor');
		} else {

			$otp_code = trim($post['otp_code']);
			$chk_otp = $this->db->get_where('users_otp', array('otp_code' => $otp_code, 'status' => 0))->num_rows();
			if (!$chk_otp) {
				$this->Az->redirect('register/otp/' . $post['encrypt_otp_code'] . '/vendor', 'system_message_error', lang('CUSTOMER_REGISTER_OTP_ERROR'));
			} else {

				// update organizer detail
				$user_id = $this->Register_model->registerVendor($post);
				$get_user_data = $this->db->get_where('users', array('id' => $user_id))->row_array();


				if ($get_user_data['role_id'] == 3) {

					$user_ip_address = $_SERVER['REMOTE_ADDR'];
					// update cart temp data
					$this->db->where('ip', $user_ip_address);
					$this->db->update('cart_temp_data', array('user_id' => $get_user_data['id']));

					$this->session->set_userdata('pinkekart_vendor_session', $get_user_data);

					$this->session->set_userdata('pinkekart_vendor_session', $get_user_data);

					if ($post['return_url'] && $post['return_url'] == 'checkout') {
						$this->Az->redirect('checkout');
					} else {
						$this->Az->redirect('vendor/dashboard');
					}
				} elseif ($get_user_data['role_id'] == 4) {

					$user_ip_address = $_SERVER['REMOTE_ADDR'];
					// update cart temp data
					$this->db->where('ip', $user_ip_address);
					$this->db->update('cart_temp_data', array('user_id' => $get_user_data['id']));

					$this->session->set_userdata('pinkekart_customer_session', $get_user_data);
					if ($post['return_url'] && $post['return_url'] == 'checkout') {
						$this->Az->redirect('checkout');
					} else {
						$this->Az->redirect('customer/dashboard');
					}
				} else {

					$this->Az->redirect('register', 'system_message_error', lang('DB_ERROR'));
				}
			}
		}
	}
}
/* End of file login.php */
/* Location: ./application/controllers/login.php */