<?php
class Blocks extends CI_Controller {    
    
    
    public function __construct() 
    {
        parent::__construct();
       	$this->User->checkPermission();
        $this->load->model('admin/Pages_model');		
        $this->load->model('admin/Section_model');		
        $this->lang->load('admin/dashboard', 'english');
        
    } 
    
	
	public function index()
    {
		
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $pageList = $this->db->order_by('id','desc')->get('blocks')->result_array();
		
		if($pageList)
		{
			foreach($pageList as $key=>$list)
			{
				// get page list
				$blockPageList = $this->db->select('block_pages.*,pages.title as page_name,links.title as link_name')->join('pages','pages.id = block_pages.page_id','left')->join('links','links.id = block_pages.page_id','left')->get_where('block_pages',array('block_pages.block_id'=>$list['id']))->result_array();
				
				$pageList[$key]['pages'] = $blockPageList;
			}
		}
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Blocks',
            'meta_keywords' => 'Blocks',
            'meta_description' => 'Blocks',
			'loggedUser' => $loggedUser,	
			'content_block' => 'blocks/blockList',
            'manager_description' => 'Blocks',
			'pageList' => $pageList,
			'pageID' => $pageID,
			'page_name' => $page_name,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

	public function addBlock()
    {
		// get page list
		$pageList = $this->db->select('id,title')->get_where('pages',array('status'=>1))->result_array();
		
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'blocks/addBlock',
            'manager_description' => lang('SITE_NAME'),
			'pageList' => $pageList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
   
	
	public function saveBlock()
	{
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$userID = $loggedUser['id'];
		$post = $this->input->post();
		$this->load->library('form_validation');
		$this->form_validation->set_rules('title', 'Title', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->addBlock();
		}
		else
		{
			
			// update organizer detail
			$this->Pages_model->save_block($post);
			$this->Az->redirect('admin/blocks', 'system_message_error',lang('BLOCK_SAVE_SUCCESS'));
		
		}
		
		
		
			
		
	}


	public function editBlock($pageID = 0)
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$chkBlock = $this->db->get_where('blocks',array('id'=>$pageID))->num_rows();
		if(!$chkBlock)
		{
			$this->Az->redirect('admin/blocks', 'system_message_error',lang('BLOCK_VALID_ERROR'));
		}
		// get banner data
		$pageData = $this->db->get_where('blocks',array('id'=>$pageID))->row_array();
		
		// get page list
		$pageList = $this->db->select('id,title')->get_where('pages',array('status'=>1))->result_array();
		
		// get link list
		$linkList = $this->db->select('id,title')->get_where('links',array('status'=>1))->result_array();
		
		// get banner data
		$blockPageList = $this->db->get_where('block_pages',array('block_id'=>$pageID))->result_array();
		
	
		
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'blocks/editBlock',
            'manager_description' => lang('SITE_NAME'),
            'pageData' => $pageData,
            'pageID' => $pageID,
            'pageList' => $pageList,
            'linkList' => $linkList,
            'blockPageList' => $blockPageList,
          	'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

    public function updateBlock()
	{
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$userID = $loggedUser['id'];
		$post = $this->input->post();
		$pageID = $post['pageID'];
		$this->load->library('form_validation');
		$this->form_validation->set_rules('title', 'Title', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->editBlock($pageID);
		}
		else
		{
			// update organizer detail
			$this->Pages_model->update_block($post,$pageID);
			$this->Az->redirect('admin/blocks', 'system_message_error',lang('BLOCK_SAVE_SUCCESS'));
		
		}
		
		
			
		
	}


	public function deleteBlock($pageID = 0)
	{
		$loggedUser = $this->User->getLoggedUser("admin_user");
		// check user valid or not
		$pageList = $this->db->get_where('blocks',array('id'=>$pageID))->num_rows();
		if(!$pageList)
		{
			$this->Az->redirect('admin/blocks', 'system_message_error',lang('BLOCK_VALID_ERROR'));
		}
		
		$this->db->where('block_id',$pageID);
		$this->db->delete('block_pages');
		
		$this->db->where('id',$pageID);
		$this->db->delete('blocks');
		
		
		
		$this->Az->redirect('admin/blocks', 'system_message_info', lang('BLOCK_DELETE_SUCCESS'));
		
    }
	
	public function getBlockTypeList($type = 1)
	{
		if($type == 1)
		{
			$pageList = $this->db->select('id,title')->get_where('pages',array('status'=>1))->result_array();
			$str = '<option value="0">Select Page</option>';
			if($pageList){
				foreach($pageList as $list){
					$str.='<option value="'.$list['id'].'">'.$list['title'].'</option>';
				}
			}
		}
		else
		{
			$pageList = $this->db->select('id,title')->get_where('links',array('status'=>1))->result_array();
			$str = '<option value="0">Select Link</option>';
			if($pageList){
				foreach($pageList as $list){
					$str.='<option value="'.$list['id'].'">'.$list['title'].'</option>';
				}
			}
		}
		
		echo $str;
	}
	
    

}
?>