<?php
class Customer extends CI_Controller {    
    
    
    public function __construct() 
    {
        parent::__construct();
       	$this->User->checkPermission();
        $this->load->model('admin/Customer_model');		
        $this->lang->load('admin/dashboard', 'english');
        
    } 
    
	public function index()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('users.*,user_roles.title as group_name,vendor_roles.title as package_name')
							     ->order_by('users.created','desc')
								 ->join('user_roles','user_roles.id = users.role_id')
								 ->join('vendor_roles','vendor_roles.id = users.vendor_role_id')
								 ->where_in('users.role_id',array(3,4))
								 ->get('users')->result_array();
								 
		if($customerList)
		{
			foreach($customerList as $key=>$list)
			{
				$customerID = $list['id'];
				// get customer address
				$customerAddress = $this->db->select('user_address.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = user_address.country')
											->join('states','states.id = user_address.state')
											->get_where('user_address',array('user_address.userID'=>$customerID))->row_array();
				$customerList[$key]['addresses'] = $customerAddress;
			}
		}
		
		$roleList = $this->db->where_in('id',array(3,4))->get_where('user_roles')->result_array();

		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'All Customer List',
            'meta_keywords' => 'All Customer List',
            'meta_description' => 'All Customer List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'customer/customerList',
            'manager_description' => 'All Customer List',
			'customerList' => $customerList,
			'roleList' => $roleList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }


    public function getTotalUserList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$keyword = '';
		$role_id = '';
		$status = '';
		
		if($extra_search)
		{
			$filterData = explode('|',$extra_search);
			$keyword = isset($filterData[0]) ? $filterData[0] : '';
			$role_id = isset($filterData[1]) ? $filterData[1] : '';
			$status = isset($filterData[2]) ? $filterData[2] : '';
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.id',
		);
			

			// getting total number records without any search
			$sql = "SELECT a.*,b.title as group_name,c.title as package_name ";
			
			$sql.=" FROM tbl_users as a ";
			$sql.=" LEFT JOIN tbl_user_roles as b ON a.role_id = b.id ";
			$sql.=" LEFT JOIN tbl_vendor_roles as c ON a.role_id = c.id ";
			//$sql.=" ORDER BY a.created DESC ";
			$sql.=" WHERE a.role_id IN (3,4) ";
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			// getting total number records without any search
			$sql = "SELECT a.*,b.title as group_name,c.title as package_name ";
			
			$sql.=" FROM tbl_users as a ";
			$sql.=" LEFT JOIN tbl_user_roles as b ON a.role_id = b.id ";
			$sql.=" LEFT JOIN tbl_vendor_roles as c ON a.role_id = c.id ";
			//$sql.=" ORDER BY a.created DESC ";
			$sql.=" WHERE a.role_id IN (3,4) ";
			
			if($keyword != '') {

				$sql.=" AND ( a.user_display_id LIKE '".$keyword."%' ";    
				$sql.=" OR a.name LIKE '".$keyword."%' ";
				$sql.=" OR a.email LIKE '".$keyword."%' ";
				$sql.=" OR a.mobile LIKE '".$keyword."%' )";
				
			}

			if($role_id != '') {

				$sql.=" AND a.role_id = '".$role_id."' ";
				
			}

			if($status != '') {

				$sql.=" AND a.is_active = '".$status."' ";
				
			}


			

			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 0 : $requestData['order'][0]['column'] : 0;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();
		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){

				$customerAddress = $this->db->select('user_address.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = user_address.country')
											->join('states','states.id = user_address.state')
											->get_where('user_address',array('user_address.userID'=>$list['id']))->row_array();
				
				$nestedData=array(); 
				
				$nestedData[] = $i;	
				
				$nestedData[] = $list['group_name'];

				$nestedData[] = $list['name'].'<br>( '.$list['user_display_id'].' )';
				
				$nestedData[] = $list['email'];

				$nestedData[] = $list['mobile'];

				$nestedData[] = $list['decode_password'];

				$nestedData[] = $list['dob'];

				if($list['gender'] == 1){
				 $nestedData[] = 'Male';  						
				}
				elseif($list['gender'] == 2){
				 $nestedData[] = 'Female';	
				}
				else{
				 $nestedData[] = 'Not Specified';	
				}

				
				
				$nestedData[] = date('d-m-Y',strtotime($list['created']));

				if($list['is_active'] == 1){
				 $nestedData[] = '<font color="green">Active</font>';	
				}
				else{
				 $nestedData[] = '<font color="red">Deactive</font>';	
				}
				
				$nestedData[] = '<a title="delete" class="del" href="'.base_url('admin/customer/editCustomer').'/'.$list['id'].'"><img src="'.base_url().'resources/icons/pencil.png"/></a>';					

				$nestedData[] = '<a title="delete" class="del" href="'.base_url('admin/customer/deleteCustomer').'/'.$list['id'].'" onclick="return confirm(\'Are you sure you want to delete?\')"><img src="'.base_url().'resources/icons/delete.png"/></a>';
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}



		$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					);

		echo json_encode($json_data);  // send data as json format
	}





    public function activeCustomer()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('users.*,user_roles.title as group_name,vendor_roles.title as package_name')
							     ->order_by('users.created','desc')
								 ->join('user_roles','user_roles.id = users.role_id')
								 ->join('vendor_roles','vendor_roles.id = users.vendor_role_id')
								 ->where_in('users.role_id',array(3,4))
								 ->get_where('users',array('is_active'=>1))->result_array();
								 
		if($customerList)
		{
			foreach($customerList as $key=>$list)
			{
				$customerID = $list['id'];
				// get customer address
				$customerAddress = $this->db->select('user_address.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = user_address.country')
											->join('states','states.id = user_address.state')
											->get_where('user_address',array('user_address.userID'=>$customerID))->row_array();
				$customerList[$key]['addresses'] = $customerAddress;
			}
		}
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Active Customer List',
            'meta_keywords' => 'Active Customer List',
            'meta_description' => 'Active Customer List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'customer/activecustomerList',
            'manager_description' => 'Active Customer List',
			'customerList' => $customerList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }


    public function deactiveCustomer()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('users.*,user_roles.title as group_name,vendor_roles.title as package_name')
							     ->order_by('users.created','desc')
								 ->join('user_roles','user_roles.id = users.role_id')
								 ->join('vendor_roles','vendor_roles.id = users.vendor_role_id')
								 ->where_in('users.role_id',array(3,4))
								 ->get_where('users',array('is_active'=>0))->result_array();
								 
		if($customerList)
		{
			foreach($customerList as $key=>$list)
			{
				$customerID = $list['id'];
				// get customer address
				$customerAddress = $this->db->select('user_address.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = user_address.country')
											->join('states','states.id = user_address.state')
											->get_where('user_address',array('user_address.userID'=>$customerID))->row_array();
				$customerList[$key]['addresses'] = $customerAddress;
			}
		}
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Deactive Customer List',
            'meta_keywords' => 'Deactive Customer List',
            'meta_description' => 'Deactive Customer List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'customer/deactivecustomerList',
            'manager_description' => 'Deactive Customer List',
			'customerList' => $customerList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

	
	
	public function vendorList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('users.*,user_roles.title as group_name,vendor_roles.title as package_name')
							     ->order_by('users.created','desc')
								 ->join('user_roles','user_roles.id = users.role_id')
								 ->join('vendor_roles','vendor_roles.id = users.vendor_role_id')
								 ->where_in('users.role_id',array(3))
								 ->get('users')->result_array();
								 
		if($customerList)
		{
			foreach($customerList as $key=>$list)
			{
				$customerID = $list['id'];
				// get customer address
				$customerAddress = $this->db->select('vendor_detail.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = vendor_detail.country')
											->join('states','states.id = vendor_detail.state')
											->get_where('vendor_detail',array('vendor_detail.vendor_id'=>$customerID))->row_array();
				$customerList[$key]['addresses'] = $customerAddress;
			}
		}
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'All Customer List',
            'meta_keywords' => 'All Customer List',
            'meta_description' => 'All Customer List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'customer/vendorList',
            'manager_description' => 'All Customer List',
			'customerList' => $customerList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }



    public function getVendorUserList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$keyword = '';
		$status = '';
		
		if($extra_search)
		{
			$filterData = explode('|',$extra_search);
			$keyword = isset($filterData[0]) ? $filterData[0] : '';
			$status = isset($filterData[1]) ? $filterData[1] : '';
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.id',
		);
			

			// getting total number records without any search
			$sql = "SELECT a.*,b.title as group_name,c.title as package_name ";
			
			$sql.=" FROM tbl_users as a ";
			$sql.=" LEFT JOIN tbl_user_roles as b ON a.role_id = b.id ";
			$sql.=" LEFT JOIN tbl_vendor_roles as c ON a.role_id = c.id ";
			//$sql.=" ORDER BY a.created DESC ";
			$sql.=" WHERE a.role_id IN (3) ";
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			// getting total number records without any search
			$sql = "SELECT a.*,b.title as group_name,c.title as package_name ";
			
			$sql.=" FROM tbl_users as a ";
			$sql.=" LEFT JOIN tbl_user_roles as b ON a.role_id = b.id ";
			$sql.=" LEFT JOIN tbl_vendor_roles as c ON a.role_id = c.id ";
			//$sql.=" ORDER BY a.created DESC ";
			$sql.=" WHERE a.role_id IN (3) ";
			
			if($keyword != '') {

				$sql.=" AND ( a.user_display_id LIKE '".$keyword."%' ";    
				$sql.=" OR a.name LIKE '".$keyword."%' ";
				$sql.=" OR a.email LIKE '".$keyword."%' ";
				$sql.=" OR a.mobile LIKE '".$keyword."%' )";
				
			}

			if($role_id != '') {

				$sql.=" AND a.role_id = '".$role_id."' ";
				
			}

			if($status != '') {

				$sql.=" AND a.is_active = '".$status."' ";
				
			}


			

			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 0 : $requestData['order'][0]['column'] : 0;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();
		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){

				$customerAddress = $this->db->select('user_address.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = user_address.country')
											->join('states','states.id = user_address.state')
											->get_where('user_address',array('user_address.userID'=>$list['id']))->row_array();
				
				$nestedData=array(); 
				
				$nestedData[] = $i;	
				
				$nestedData[] = $list['group_name'];

				$nestedData[] = $list['name'].'<br>( '.$list['user_display_id'].' )';
				
				$nestedData[] = $list['email'];

				$nestedData[] = $list['mobile'];

				$nestedData[] = $list['decode_password'];

				$nestedData[] = $list['dob'];

				if($list['gender'] == 1){
				 $nestedData[] = 'Male';  						
				}
				elseif($list['gender'] == 2){
				 $nestedData[] = 'Female';	
				}
				else{
				 $nestedData[] = 'Not Specified';	
				}
				
				
				
				$nestedData[] = date('d-m-Y',strtotime($list['created']));

				if($list['is_active'] == 1){
				 $nestedData[] = '<font color="green">Active</font>';	
				}
				else{
				 $nestedData[] = '<font color="red">Deactive</font>';	
				}
				
				$nestedData[] = '<a title="delete" class="del" href="'.base_url('admin/customer/editVendor').'/'.$list['id'].'"><img src="'.base_url().'resources/icons/pencil.png"/></a>';					

				$nestedData[] = '<a title="delete" class="del" href="'.base_url('admin/customer/deleteCustomer').'/'.$list['id'].'" onclick="return confirm(\'Are you sure you want to delete?\')"><img src="'.base_url().'resources/icons/delete.png"/></a>';
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}



		$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					);

		echo json_encode($json_data);  // send data as json format
	}


    public function activevendorList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('users.*,user_roles.title as group_name,vendor_roles.title as package_name')
							     ->order_by('users.created','desc')
								 ->join('user_roles','user_roles.id = users.role_id')
								 ->join('vendor_roles','vendor_roles.id = users.vendor_role_id')
								 ->where_in('users.role_id',array(3))
								 ->get_where('users',array('is_active'=>1))->result_array();
								 
		if($customerList)
		{
			foreach($customerList as $key=>$list)
			{
				$customerID = $list['id'];
				// get customer address
				$customerAddress = $this->db->select('vendor_detail.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = vendor_detail.country')
											->join('states','states.id = vendor_detail.state')
											->get_where('vendor_detail',array('vendor_detail.vendor_id'=>$customerID))->row_array();
				$customerList[$key]['addresses'] = $customerAddress;
			}
		}
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'All Customer List',
            'meta_keywords' => 'All Customer List',
            'meta_description' => 'All Customer List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'customer/activevendorList',
            'manager_description' => 'All Customer List',
			'customerList' => $customerList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }


    public function deactivevendorList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('users.*,user_roles.title as group_name,vendor_roles.title as package_name')
							     ->order_by('users.created','desc')
								 ->join('user_roles','user_roles.id = users.role_id')
								 ->join('vendor_roles','vendor_roles.id = users.vendor_role_id')
								 ->where_in('users.role_id',array(3))
								 ->get_where('users',array('is_active'=>0))->result_array();
								 
		if($customerList)
		{
			foreach($customerList as $key=>$list)
			{
				$customerID = $list['id'];
				// get customer address
				$customerAddress = $this->db->select('vendor_detail.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = vendor_detail.country')
											->join('states','states.id = vendor_detail.state')
											->get_where('vendor_detail',array('vendor_detail.vendor_id'=>$customerID))->row_array();
				$customerList[$key]['addresses'] = $customerAddress;
			}
		}
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'All Customer List',
            'meta_keywords' => 'All Customer List',
            'meta_description' => 'All Customer List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'customer/deactivevendorList',
            'manager_description' => 'All Customer List',
			'customerList' => $customerList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }


	
	public function generalList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('users.*,user_roles.title as group_name,vendor_roles.title as package_name')
							     ->order_by('users.created','desc')
								 ->join('user_roles','user_roles.id = users.role_id')
								 ->join('vendor_roles','vendor_roles.id = users.vendor_role_id')
								 ->where_in('users.role_id',array(4))
								 ->get('users')->result_array();
								 
		if($customerList)
		{
			foreach($customerList as $key=>$list)
			{
				$customerID = $list['id'];
				// get customer address
				$customerAddress = $this->db->select('user_address.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = user_address.country')
											->join('states','states.id = user_address.state')
											->get_where('user_address',array('user_address.userID'=>$customerID))->row_array();
				$customerList[$key]['addresses'] = $customerAddress;
			}
		}
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'All Customer List',
            'meta_keywords' => 'All Customer List',
            'meta_description' => 'All Customer List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'customer/generalList',
            'manager_description' => 'All Customer List',
			'customerList' => $customerList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }


    public function getGeneralUserList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$keyword = '';
		$status = '';
		
		if($extra_search)
		{
			$filterData = explode('|',$extra_search);
			$keyword = isset($filterData[0]) ? $filterData[0] : '';
			$status = isset($filterData[1]) ? $filterData[1] : '';
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.id',
		);
			

			// getting total number records without any search
			$sql = "SELECT a.*,b.title as group_name,c.title as package_name ";
			
			$sql.=" FROM tbl_users as a ";
			$sql.=" LEFT JOIN tbl_user_roles as b ON a.role_id = b.id ";
			$sql.=" LEFT JOIN tbl_vendor_roles as c ON a.role_id = c.id ";
			//$sql.=" ORDER BY a.created DESC ";
			$sql.=" WHERE a.role_id IN (4) ";
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			// getting total number records without any search
			$sql = "SELECT a.*,b.title as group_name,c.title as package_name ";
			
			$sql.=" FROM tbl_users as a ";
			$sql.=" LEFT JOIN tbl_user_roles as b ON a.role_id = b.id ";
			$sql.=" LEFT JOIN tbl_vendor_roles as c ON a.role_id = c.id ";
			//$sql.=" ORDER BY a.created DESC ";
			$sql.=" WHERE a.role_id IN (4) ";
			
			if($keyword != '') {

				$sql.=" AND ( a.user_display_id LIKE '".$keyword."%' ";    
				$sql.=" OR a.name LIKE '".$keyword."%' ";
				$sql.=" OR a.email LIKE '".$keyword."%' ";
				$sql.=" OR a.mobile LIKE '".$keyword."%' )";
				
			}

			if($role_id != '') {

				$sql.=" AND a.role_id = '".$role_id."' ";
				
			}

			if($status != '') {

				$sql.=" AND a.is_active = '".$status."' ";
				
			}


			

			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 0 : $requestData['order'][0]['column'] : 0;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();
		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){

				$customerAddress = $this->db->select('user_address.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = user_address.country')
											->join('states','states.id = user_address.state')
											->get_where('user_address',array('user_address.userID'=>$list['id']))->row_array();
				
				$nestedData=array(); 
				
				$nestedData[] = $i;	
				
				$nestedData[] = $list['group_name'];

				$nestedData[] = $list['name'].'<br>( '.$list['user_display_id'].' )';
				
				$nestedData[] = $list['email'];

				$nestedData[] = $list['mobile'];

				$nestedData[] = $list['decode_password'];

				$nestedData[] = $list['dob'];

				if($list['gender'] == 1){
				 $nestedData[] = 'Male';  						
				}
				elseif($list['gender'] == 2){
				 $nestedData[] = 'Female';	
				}
				else{
				 $nestedData[] = 'Not Specified';	
				}
				
				
				
				$nestedData[] = date('d-m-Y',strtotime($list['created']));

				if($list['is_active'] == 1){
				 $nestedData[] = '<font color="green">Active</font>';	
				}
				else{
				 $nestedData[] = '<font color="red">Deactive</font>';	
				}
				
				$nestedData[] = '<a title="delete" class="del" href="'.base_url('admin/customer/editCustomer').'/'.$list['id'].'"><img src="'.base_url().'resources/icons/pencil.png"/></a>';					

				$nestedData[] = '<a title="delete" class="del" href="'.base_url('admin/customer/deleteCustomer').'/'.$list['id'].'" onclick="return confirm(\'Are you sure you want to delete?\')"><img src="'.base_url().'resources/icons/delete.png"/></a>';
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}



		$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					);

		echo json_encode($json_data);  // send data as json format
	}


    public function activegeneralList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('users.*,user_roles.title as group_name,vendor_roles.title as package_name')
							     ->order_by('users.created','desc')
								 ->join('user_roles','user_roles.id = users.role_id')
								 ->join('vendor_roles','vendor_roles.id = users.vendor_role_id')
								 ->where_in('users.role_id',array(4))
								 ->get_where('users',array('is_active'=>1))->result_array();
								 
		if($customerList)
		{
			foreach($customerList as $key=>$list)
			{
				$customerID = $list['id'];
				// get customer address
				$customerAddress = $this->db->select('user_address.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = user_address.country')
											->join('states','states.id = user_address.state')
											->get_where('user_address',array('user_address.userID'=>$customerID))->row_array();
				$customerList[$key]['addresses'] = $customerAddress;
			}
		}
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'All Customer List',
            'meta_keywords' => 'All Customer List',
            'meta_description' => 'All Customer List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'customer/activegeneralList',
            'manager_description' => 'All Customer List',
			'customerList' => $customerList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }


    public function deactivegeneralList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('users.*,user_roles.title as group_name,vendor_roles.title as package_name')
							     ->order_by('users.created','desc')
								 ->join('user_roles','user_roles.id = users.role_id')
								 ->join('vendor_roles','vendor_roles.id = users.vendor_role_id')
								 ->where_in('users.role_id',array(4))
								 ->get_where('users',array('is_active'=>0))->result_array();
								 
		if($customerList)
		{
			foreach($customerList as $key=>$list)
			{
				$customerID = $list['id'];
				// get customer address
				$customerAddress = $this->db->select('user_address.*,countries.name as country_name,states.name as state_name')
											->join('countries','countries.id = user_address.country')
											->join('states','states.id = user_address.state')
											->get_where('user_address',array('user_address.userID'=>$customerID))->row_array();
				$customerList[$key]['addresses'] = $customerAddress;
			}
		}
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'All Customer List',
            'meta_keywords' => 'All Customer List',
            'meta_description' => 'All Customer List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'customer/deactivegeneralList',
            'manager_description' => 'All Customer List',
			'customerList' => $customerList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }




	public function addCustomer()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
		// get country list
		$countryList = $this->db->get('countries')->result_array();
		
		// get state list
		$stateList = $this->db->order_by('name','asc')->get_where('states',array('country_code_char2'=>'IN'))->result_array();
		
		// get package list
		$packageList = $this->db->get('vendor_roles')->result_array();
		
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'customer/addCustomer',
            'manager_description' => lang('SITE_NAME'),
			'countryList' => $countryList,
			'stateList' => $stateList,
			'packageList' => $packageList,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
   
	
	public function saveCustomer()
	{
		$loggedUser = $this->User->getLoggedUser('admin_user');
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('group_id', 'Group', 'required|xss_clean');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'required|xss_clean|valid_email');
		$this->form_validation->set_rules('password', 'Password', 'required|xss_clean|min_length[6]');
		$this->form_validation->set_rules('dob', 'DOB', 'xss_clean');
		$this->form_validation->set_rules('company', 'Company', 'xss_clean');
		$this->form_validation->set_rules('address_1', 'Street Address', 'required|xss_clean');
		$this->form_validation->set_rules('address_2', 'Street Address', 'xss_clean');
		$this->form_validation->set_rules('city', 'City', 'required|xss_clean');
		$this->form_validation->set_rules('state', 'State/Province', 'required|xss_clean');
		$this->form_validation->set_rules('zip_code', 'Zip/Postal Code', 'required|xss_clean');
		$this->form_validation->set_rules('phone_number', 'Phone Number', 'required|xss_clean|min_length[10]');
		$this->form_validation->set_rules('gst_no', 'Gst No.', 'xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->addCustomer();
		}
		else
		{
			$email = trim(strtolower($post['email']));
			$mobile = $post['phone_number'];
			// check email already exits or not
			$chk_user_email = $this->db->query("SELECT * from tbl_users where email = '$email' or mobile = '$mobile'")->num_rows();
			if($chk_user_email)
			{
				$this->Az->redirect('admin/customer/addCustomer', 'system_message_error',lang('CUSTOMER_EMAIL_MOBILE_EXITS_ERROR'));
			}
			// update organizer detail
			$this->Customer_model->save_customer($post);
			$this->Az->redirect('admin/customer', 'system_message_error',lang('CUSTOMER_SAVE_SUCCESS'));
		}
		
	}


	public function editCustomer($customerID = 0)
    {
		$loggedUser = $this->User->getLoggedUser();
		
		// check category valid or not
		$chk_cat = $this->db->get_where('users',array('id'=>$customerID))->num_rows();
		if(!$chk_cat)
		{
			$this->Az->redirect('admin/customer', 'system_message_error',lang('CUSTOMER_VALID_ERROR'));
		}

		// get customer data
		$userData = $this->db->get_where('users',array('id'=>$customerID))->row_array();
		
		// get category list
		$categoryList = $this->db->get_where('category',array('parent_id'=>0,'status'=>1))->result_array();
		
		if($categoryList)
		{
			foreach($categoryList as $key=>$list)
			{
				
				$get_setting = $this->db->get_where('commision_setting',array('vendor_id'=>$customerID,'category_id'=>$list['id']))->row_array();
				if(!$get_setting){
					$get_setting = $this->db->get_where('commision_setting',array('vendor_id'=>0,'category_id'=>$list['id']))->row_array();
				}
				
				$categoryList[$key]['commision'] = isset($get_setting['commission']) ? $get_setting['commission'] : 0;
			}
		}
		
		// get customer address data
		$userAddressData = $this->db->get_where('user_address',array('userID'=>$customerID))->row_array();
		
		// get country list
		$countryList = $this->db->get('countries')->result_array();
		
		// get state list
		$stateList = $this->db->order_by('name','asc')->get_where('states',array('country_code_char2'=>'IN'))->result_array();
		
		// get package list
		$packageList = $this->db->get('vendor_roles')->result_array();
		   	
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'customer/editCustomer',
            'manager_description' => lang('SITE_NAME'),
            'userData' => $userData,
            'userAddressData' => $userAddressData,
            'customerID' => $customerID,
			'countryList' => $countryList,
			'categoryList' => $categoryList,
			'packageList' => $packageList,
			'stateList' => $stateList,
          	'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

    public function updateCustomer()
	{
		$loggedUser = $this->User->getLoggedUser('admin_user');
		$post = $this->input->post();
		$customerID = $post['customerID'];
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'required|xss_clean|valid_email');
		$this->form_validation->set_rules('dob', 'DOB', 'xss_clean');
		$this->form_validation->set_rules('company', 'Company', 'xss_clean');
		$this->form_validation->set_rules('address_1', 'Street Address', 'required|xss_clean');
		$this->form_validation->set_rules('address_2', 'Street Address', 'xss_clean');
		$this->form_validation->set_rules('city', 'City', 'required|xss_clean');
		$this->form_validation->set_rules('state', 'State/Province', 'required|xss_clean');
		$this->form_validation->set_rules('zip_code', 'Zip/Postal Code', 'required|xss_clean');
		$this->form_validation->set_rules('phone_number', 'Phone Number', 'required|xss_clean');
		$this->form_validation->set_rules('gst_no', 'Gst No.', 'xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->editCustomer($customerID);
		}
		else
		{
			
			// check email already exits or not
			$chk_user_email = $this->db->get_where('users',array('email'=>trim(strtolower($post['email'])),'id !='=>$customerID))->row_array();

			if($chk_user_email)
			{
				$this->Az->redirect('admin/customer/editCustomer/'.$customerID, 'system_message_error',lang('CUSTOMER_EMAIL_EXITS_ERROR'));
			}
			// update organizer detail
			$this->Customer_model->update_customer($post);
			
			$chk_role = $this->db->select('role_id')->get_where('users',array('id'=>$customerID))->row_array();
			if($chk_role['role_id'] == 3){
			 $this->Az->redirect('admin/customer/vendorList', 'system_message_error',lang('CUSTOMER_SAVE_SUCCESS'));   
			}
			else{
			 $this->Az->redirect('admin/customer/generalList', 'system_message_error',lang('CUSTOMER_SAVE_SUCCESS'));
			}
		}	
		
	}




	public function editVendor($vendorID = 0)
    {
		$loggedUser = $this->User->getLoggedUser();
		
		// check category valid or not
		$chk_cat = $this->db->get_where('users',array('id'=>$vendorID))->num_rows();
		if(!$chk_cat)
		{
			$this->Az->redirect('admin/customer/vendorList', 'system_message_error',lang('CUSTOMER_VALID_ERROR'));
		}

		// get customer data
		$userData = $this->db->get_where('users',array('id'=>$vendorID))->row_array();
		
		// get category list
		$categoryList = $this->db->get_where('category',array('parent_id'=>0,'status'=>1))->result_array();
		
		if($categoryList)
		{
			foreach($categoryList as $key=>$list)
			{
				
				$get_setting = $this->db->get_where('commision_setting',array('vendor_id'=>$vendorID,'category_id'=>$list['id']))->row_array();
				if(!$get_setting){
					$get_setting = $this->db->get_where('commision_setting',array('vendor_id'=>0,'category_id'=>$list['id']))->row_array();
				}
				
				$categoryList[$key]['commision'] = isset($get_setting['commission']) ? $get_setting['commission'] : 0;
			}
		}
		
		// get customer address data
		$userAddressData = $this->db->get_where('vendor_detail',array('vendor_id'=>$vendorID))->row_array();
		
		// get country list
		$countryList = $this->db->get('countries')->result_array();
		
		// get state list
		$stateList = $this->db->order_by('name','asc')->get_where('states',array('country_code_char2'=>'IN'))->result_array();
		
		// get package list
		$packageList = $this->db->get('vendor_roles')->result_array();
		   	
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'customer/editVendor',
            'manager_description' => lang('SITE_NAME'),
            'userData' => $userData,
            'userAddressData' => $userAddressData,
            'vendorID' => $vendorID,
			'countryList' => $countryList,
			'categoryList' => $categoryList,
			'packageList' => $packageList,
			'stateList' => $stateList,
          	'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

    public function updateVendor()
	{
		$loggedUser = $this->User->getLoggedUser('admin_user');
		$post = $this->input->post();
		$customerID = $post['customerID'];
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'required|xss_clean|valid_email');
		$this->form_validation->set_rules('dob', 'DOB', 'xss_clean');
		$this->form_validation->set_rules('phone_number', 'Phone Number', 'required|xss_clean');
		$this->form_validation->set_rules('firm_name', 'Firm Name', 'xss_clean');
		$this->form_validation->set_rules('address', 'Address', 'required|xss_clean');
		$this->form_validation->set_rules('state', 'State', 'required|xss_clean');
		$this->form_validation->set_rules('country', 'Country', 'required|xss_clean');
		$this->form_validation->set_rules('zip_code', 'ZIP Code', 'required|xss_clean');
		$this->form_validation->set_rules('gst_no', 'GST No.', 'required|xss_clean');
		$this->form_validation->set_rules('acc_hold_name', 'Account Holder Name', 'required|xss_clean');
		$this->form_validation->set_rules('acc_no', 'Account No.', 'required|xss_clean');
		$this->form_validation->set_rules('ifsc', 'IFSC Code', 'required|xss_clean');
		$this->form_validation->set_rules('bank_name', 'Bank Name', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->editVendor($customerID);
		}
		else
		{
			
			// check email already exits or not
			$chk_user_email = $this->db->get_where('users',array('email'=>trim(strtolower($post['email'])),'id !='=>$customerID))->num_rows();
			if($chk_user_email)
			{
				$this->Az->redirect('admin/customer/editVendor/'.$customerID, 'system_message_error',lang('CUSTOMER_EMAIL_EXITS_ERROR'));
			}


			$address_proof = '';
				if ($_FILES['address_proof']['name'] != '') {
					//generate logo name randomly
					$fileName = rand(1111, 999999999);
					$config['upload_path'] = './media/seller_document/';
					$config['allowed_types'] = 'jpg|png|gif|jpeg';
					$config['file_name'] = $fileName;
					$this->load->library('upload');
					$this->upload->initialize($config);
					$this->upload->do_upload('address_proof');
					$uploadError = $this->upload->display_errors();
					if ($uploadError) {
						 $this->Az->redirect('admin/customer/editVendor/'.$customerID, 'system_message_error', $uploadError);
					} else {
					   
						$fileData = $this->upload->data();
						//get uploaded file path
						$address_proof = substr($config['upload_path'] . $fileData['file_name'], 2);
					}
				}
				$pan_card = '';
				if ($_FILES['pan_card']['name'] != '') {
					//generate logo name randomly
					$fileName = rand(1111, 999999999);
					$config['upload_path'] = './media/seller_document/';
					$config['allowed_types'] = 'jpg|png|gif|jpeg';
					$config['file_name'] = $fileName;
					$this->load->library('upload');
					$this->upload->initialize($config);
					$this->upload->do_upload('pan_card');
					$uploadError = $this->upload->display_errors();
					if ($uploadError) {
						 $this->Az->redirect('admin/customer/editVendor/'.$customerID, 'system_message_error', $uploadError);
					} else {
					   
						$fileData = $this->upload->data();
						//get uploaded file path
						$pan_card = substr($config['upload_path'] . $fileData['file_name'], 2);
					}
				}

				$post['address_proof'] = $address_proof;
				$post['pan_card'] = $pan_card;


			// update organizer detail
			$this->Customer_model->update_vendor($post);
			$this->Az->redirect('admin/customer/vendorList', 'system_message_error',lang('CUSTOMER_SAVE_SUCCESS'));
		}	
		
	}






	public function deleteCustomer($customerID = 0)
	{
		$loggedUser = $this->User->getLoggedUser();
		// check category valid or not
		$chk_cat = $this->db->get_where('users',array('id'=>$customerID))->num_rows();
		if(!$chk_cat)
		{
			$this->Az->redirect('admin/customer', 'system_message_error',lang('CUSTOMER_VALID_ERROR'));
		}
		
		$this->db->where('id',$customerID);
		$this->db->delete('users');
		$this->db->where('userID',$customerID);
		$this->db->delete('user_address');
		
		$this->db->where('vendor_id',$customerID);
		$this->db->delete('commision_setting');
		
		$this->Az->redirect('admin/customer', 'system_message_info', lang('CUSTOMER_DELETE_SUCCESS'));
		
    }


    public function getState($country_id = 0){

     $response = array();

     $str = '<option value>Select State</option>'; 

     if($country_id != ''){

      $country_code = $this->db->get_where('countries',array('id'=>$country_id))->row_array();

      $stateList = $this->db->get_where('states',array('country_code_char2'=>$country_code['sortname']))->result_array();

      if($stateList){

      	foreach($stateList as $list){

      	 $str.='<option value='.$list['id'].'>'.$list['name'].'</option>';	

      	}

      	$response = array(
         
         'status' => 1,
         'str'    => $str, 

      	);

      }

     }	

     echo json_encode($response);

    }
	
}
?>