<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Dashboard extends CI_Controller{

    public function __construct() {
        parent::__construct();
        //load language
		$this->User->checkPermission();
		$this->load->model('admin/Login_model');
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front_common' , 'english');
    }
	
	public function index($uname_prefix = '' , $username = ''){
		
		
		//get logged user info
        $loggedUser = $this->User->getLoggedUser("admin_user");
		$account_id = $loggedUser['id'];
		
		$total_product = $this->db->get('products')->num_rows();
		$pending_product = $this->db->get_where('products',array('approve_status'=>1))->num_rows();
		$approve_product = $this->db->get_where('products',array('approve_status'=>2))->num_rows();
        $reject_product = $this->db->get_where('products',array('approve_status'=>3))->num_rows();
		
        
        $total_users  = $this->db->where_in('role_id',array(3,4))->get('users')->num_rows();
        $active_users = $this->db->where_in('role_id',array(3,4))->get_where('users',array('is_active'=>1))->num_rows();
        $deactive_users  = $this->db->where_in('role_id',array(3,4))->get_where('users',array('is_active'=>0))->num_rows();
        

        $total_vendor  = $this->db->get_where('users',array('role_id'=>3))->num_rows();
        $active_vendor = $this->db->get_where('users',array('role_id'=>3,'is_active'=>1))->num_rows();
        $deactive_vendor = $this->db->get_where('users',array('role_id'=>3,'is_active'=>0))->num_rows();
        

        $total_customer = $this->db->get_where('users',array('role_id'=>4))->num_rows();
        $active_customer = $this->db->get_where('users',array('role_id'=>4,'is_active'=>1))->num_rows();
        $deactive_customer = $this->db->get_where('users',array('role_id'=>4,'is_active'=>0))->num_rows();

        $total_orders = $this->db->get('orders')->num_rows();
        $open_orders = $this->db->get_where('orders',array('status'=>1))->num_rows();
        $processing_orders = $this->db->get_where('orders',array('status'=>2))->num_rows();
        $dispatched_orders = $this->db->get_where('orders',array('status'=>3))->num_rows();
        $cancelled_orders = $this->db->get_where('orders',array('status'=>4))->num_rows();
        $delivered_orders = $this->db->get_where('orders',array('status'=>5))->num_rows();
        
        $get_total_sell = $this->db->select('SUM(amount) as total_sell')->get_where('payment_request',array('status'=>2))->row_array();
        
        $total_sell = isset($get_total_sell['total_sell']) ? $get_total_sell['total_sell'] : 0;
        
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
			'loggedUser'  => $loggedUser,
			'total_product' => $total_product,
			'pending_product' => $pending_product,
			'approve_product' => $approve_product,
            'reject_product' => $reject_product,
			'total_orders' => $total_orders,
            'open_orders'  => $open_orders,
            'processing_orders'=>$processing_orders,
            'dispatched_orders'=>$dispatched_orders,
            'cancelled_orders' =>$cancelled_orders,
            'delivered_orders' => $delivered_orders,
            // 'new_customer' => $new_customer,
            // 'lastOrder'    => $lastOrder,
            'total_users' => $total_users,
            'active_users'=> $active_users,
            'deactive_users'=>$deactive_users,
            'total_vendor' => $total_vendor,
            'active_vendor'=> $active_vendor,
            'deactive_vendor'=> $deactive_vendor,
            'total_customer' => $total_customer,
            'active_customer'=> $active_customer,
            'deactive_customer'=> $deactive_customer,
            'total_sell' => $total_sell,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'dashboard'
        );
        $this->parser->parse('admin/layout/column-1' , $data);
    }
	
	public function edit_admin($id = '') {
		$this->load->library('template');
		
        //verify id is avaialabel or not
		$verify_admin = $this->db->select('*')
                        ->where('id', $id)
                        ->get('user_det')->row_array();
		
        if (!$verify_admin) {
            $this->Az->redirect('admin/Dashboard/index', 'system_message_error', lang('CANOT_EDIT_ADMIN'));
        }

		$siteUrl = site_url();

        //get logged user info
        $loggedUser = $this->User->getLoggedUser('admin_user');

		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Edit User',
            'meta_keywords' => 'Edit User',
            'meta_description' => 'Edit User',
            'content_block' => 'edit_admin',
            'page_title' => 'Edit User',
            'manager_description' => 'Create User',
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'pagination' => $this->pagination->create_links(),
            'admin_info' => $verify_admin,
			'loggedUser' => $loggedUser,
            'title' => 'Edit User'
        );
        $this->parser->parse('admin/layout/column-1', $data);
    }
	
	public function chkoldpw() {
   
        //chekchk eneterd old pw is correct or not       
        if ($_POST['opw']) {
            $chk = $this->db->select('password')
                            ->where('password', do_hash($_POST['opw']))
                            ->get('user_det')->row_array();

            if (!$chk) {
                echo 'Please enter correct password';
            } else {
                echo 'Password matched';
            }
        }
    }
	
	public function update_admin() {
        
		$this->load->library('template');
        $siteUrl = site_url();
		$post = $this->input->post();
		
        //get logged user info
        $loggedUser = $this->User->getLoggedUser('admin_user');

        //check for foem validation
        $this->load->library('form_validation');
        $this->form_validation->set_rules('opw', 'Old Password', 'required|xss_clean');		
        

        if ($this->form_validation->run() == FALSE) {
			
			$this->edit_admin($post['admin_id']);
        } 
		else {
			
			$this->Login_model->updateUser($post);
			
			$this->Az->redirect('admin/Dashboard/', 'system_message_error',lang('USER_UPDATE_SUCCESSFULLY'));
			
			 
		}
		
    }
    
    
    
    
    public function report(){
		
		
		//get logged user info
        $loggedUser = $this->User->getLoggedUser("admin_user");
		$account_id = $loggedUser['id'];
		
		$today = date('Y-m-d');
		
        $get_total_sell = $this->db->select('SUM(amount) as total_sell')->get_where('payment_request',array('status'=>2))->row_array();
        // $get_total_sell = $this->db->select('SUM(amount) as total_sell')->get_where('payment_request',array('status'=>1))->row_array();
        
        $total_sell = isset($get_total_sell['total_sell']) ? $get_total_sell['total_sell'] : 0;
        
        $get_today_total_sell = $this->db->select('SUM(amount) as total_sell')->get_where('payment_request',array('status'=>2,'DATE(posted)'=>$today))->row_array();
// cod
        // $get_today_total_sell = $this->db->select('SUM(amount) as total_sell')->get_where('payment_request',array('status'=>1,'DATE(posted)'=>$today))->row_array();
        
        $today_total_sell = isset($get_today_total_sell['total_sell']) ? $get_today_total_sell['total_sell'] : 0;
        
        $this_month_start_date = date("Y-m-d", strtotime("first day of this month"));
		$this_month_end_date = date("Y-m-d", strtotime("last day of this month"));
		
		$get_this_month_total_sell = $this->db->select('SUM(amount) as total_sell')->get_where('payment_request',array('status'=>2,'DATE(posted)>='=>$this_month_start_date,'DATE(posted)<='=>$this_month_end_date))->row_array();
        // $get_this_month_total_sell = $this->db->select('SUM(amount) as total_sell')->get_where('payment_request',array('status'=>1,'DATE(posted)>='=>$this_month_start_date,'DATE(posted)<='=>$this_month_end_date))->row_array();
		
		$this_month_total_sell = isset($get_this_month_total_sell['total_sell']) ? $get_this_month_total_sell['total_sell'] : 0;
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
			'loggedUser'  => $loggedUser,
		    'total_sell' => $total_sell,
		    'today_total_sell' => $today_total_sell,
		    'this_month_total_sell' => $this_month_total_sell,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'report'
        );
        $this->parser->parse('admin/layout/column-1' , $data);
    }
    
    
    
    
    public function getSellList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$from_date = '';
		$to_date = '';
		
		if($extra_search)
		{
			$filterData = explode('|',$extra_search);
			$from_date = isset($filterData[0]) ? $filterData[0] : '';
			$to_date = isset($filterData[1]) ? $filterData[1] : '';
			
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.posted'
		);
		
		
			// getting total number records without any search
			$sql = "SELECT a.*,b.name as user_name,b.user_display_id as user_code ";
			
			$sql.=" FROM tbl_payment_request as a ";
			$sql.=" INNER JOIN tbl_users as b ON a.userID = b.id WHERE a.status = 2 ";
			$sql.=" ORDER BY a.posted DESC ";
			
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			$sql = "SELECT a.*,b.name as user_name,b.user_display_id as user_code ";
			
			$sql.=" FROM tbl_payment_request as a ";
			$sql.=" INNER JOIN tbl_users as b ON a.userID = b.id ";
			
			$sql.=" WHERE a.status = 2 ";
			
			if($from_date != '' && $to_date != '') {

				$sql.="AND DATE(a.posted) BETWEEN '".$from_date."' AND '".$to_date."' ";
				
			}
			
			
			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 0 : $requestData['order'][0]['column'] : 0;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();
		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){
				
				$nestedData=array(); 
				
				
				$nestedData[] = $i;
				$nestedData[] = $list['user_name'].' ('.$list['user_code'].')';
				$nestedData[] = $list['payment_request_id'];
				$nestedData[] = 'INR '.number_format($list['amount'],2);
				
				if($list['status'] == 1) {
					$nestedData[] = '<font color="orange">Pending</font>';
				}
				elseif($list['status'] == 2) {
					$nestedData[] = '<font color="green">Success</font>';
				}
				elseif($list['status'] == 3) {
					$nestedData[] = '<font color="red">Failed</font>';
				}
				else{
				    
				    $nestedData[] = '<font color="orange">Pending</font>';
				}

                $nestedData[] = date('d-M-Y',strtotime($list['posted']));
				

				
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}
        
        $json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					);

		echo json_encode($json_data);  // send data as json format
	}
    
    
    
    
    
    
    
	
	public function logOut() {
        $this->Login_model->adminLogout();
        $this->Az->redirect('admin/Login', 'system_message_error', lang('LOGOUT_SUCCESS'));
    }
	
	
	
	
}


/* End of file login.php */
/* Location: ./application/controllers/login.php */