<?php
class Links extends CI_Controller {    
    
    
    public function __construct() 
    {
        parent::__construct();
       	$this->User->checkPermission();
        $this->load->model('admin/Links_model');		
        $this->load->model('admin/Section_model');		
        $this->lang->load('admin/dashboard', 'english');
        
    } 
    
	
	public function index()
    {
		
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $pageList = $this->db->order_by('id','desc')->get('links')->result_array();
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Links',
            'meta_keywords' => 'Links',
            'meta_description' => 'Links',
			'loggedUser' => $loggedUser,	
			'content_block' => 'links/linkList',
            'manager_description' => 'Links',
			'pageList' => $pageList,
			'pageID' => $pageID,
			'page_name' => $page_name,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

	public function addLink()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'links/addLink',
            'manager_description' => lang('SITE_NAME'),
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
   
	
	public function saveLink()
	{
		
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$userID = $loggedUser['id'];
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('title', 'Title', 'required|xss_clean');
		$this->form_validation->set_rules('url', 'URL', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->addLink();
		}
		else
		{
			// update organizer detail
			$this->Links_model->save_link($post);
			$this->Az->redirect('admin/links', 'system_message_error',lang('LINK_SAVE_SUCCESS'));
		
		}
		
		
		
			
		
	}


	public function editLink($pageID = 0)
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$pageList = $this->db->get_where('links',array('id'=>$pageID))->num_rows();
		if(!$pageList)
		{
			$this->Az->redirect('admin/links', 'system_message_error',lang('LINK_VALID_ERROR'));
		}
		// get banner data
		$pageData = $this->db->get_where('links',array('id'=>$pageID))->row_array();
		   	
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'links/editLink',
            'manager_description' => lang('SITE_NAME'),
            'pageData' => $pageData,
            'pageID' => $pageID,
          	'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

    public function updateLink()
	{
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$userID = $loggedUser['id'];
		$post = $this->input->post();
		$pageID = $post['pageID'];
		$this->load->library('form_validation');
		$this->form_validation->set_rules('title', 'Title', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->editLink($pageID);
		}
		else
		{
			// update organizer detail
			$this->Links_model->update_link($post,$pageID);
			$this->Az->redirect('admin/links', 'system_message_error',lang('LINK_SAVE_SUCCESS'));
		
		}
		
		
			
		
	}


	public function deleteLink($pageID = 0)
	{
		$loggedUser = $this->User->getLoggedUser("admin_user");
		// check user valid or not
		$pageList = $this->db->get_where('links',array('id'=>$pageID))->num_rows();
		if(!$pageList)
		{
			$this->Az->redirect('admin/links', 'system_message_error',lang('LINK_VALID_ERROR'));
		}
		
		$this->db->where('id',$pageID);
		$this->db->delete('links');
		
		$this->Az->redirect('admin/links', 'system_message_info', lang('LINK_DELETE_SUCCESS'));
		
    }
	
    

}
?>