<?php
class Marketing extends CI_Controller {    
    
    
    public function __construct() 
    {
        parent::__construct();
       	$this->User->checkPermission();
        $this->load->model('admin/Marketing_model');		
        $this->lang->load('admin/dashboard', 'english');
        
    } 
    
	public function emailTemplateList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('email_templates.*')
							     ->order_by('email_templates.created','desc')
								 ->get('email_templates')->result_array();
								 
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Email Template List',
            'meta_keywords' => 'Email Template List',
            'meta_description' => 'Email Template List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'marketing/emailTemplateList',
            'manager_description' => 'Email Template List',
			'customerList' => $customerList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
	
	
	public function addEmailTemplate()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
		
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'marketing/addEmailTemplate',
            'manager_description' => lang('SITE_NAME'),
			'countryList' => $countryList,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
   
	
	public function saveEmailTemplate()
	{
		$loggedUser = $this->User->getLoggedUser('admin_user');
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('template_name', 'Template Name', 'required|xss_clean');
		$this->form_validation->set_rules('subject', 'Subject', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->addEmailTemplate();
		}
		else
		{
			// update organizer detail
			$this->Marketing_model->save_email_template($post);
			$this->Az->redirect('admin/marketing/emailTemplateList', 'system_message_error',lang('EMAIL_TEMPLATE_SAVE_SUCCESS'));
		}
		
	}


	public function editEmailTemplate($customerID = 0)
    {
		$loggedUser = $this->User->getLoggedUser();
		
		// check category valid or not
		$chk_cat = $this->db->get_where('email_templates',array('id'=>$customerID))->num_rows();
		if(!$chk_cat)
		{
			$this->Az->redirect('admin/marketing/emailTemplateList', 'system_message_error',lang('EMAIL_TEMPLATE_VALID_ERROR'));
		}

		// get customer data
		$userData = $this->db->get_where('email_templates',array('id'=>$customerID))->row_array();
		   	
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'marketing/editEmailTemplate',
            'manager_description' => lang('SITE_NAME'),
            'userData' => $userData,
            'recordID' => $customerID,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

    public function updateEmailTemplate()
	{
		$loggedUser = $this->User->getLoggedUser('admin_user');
		$post = $this->input->post();
		$recordID = $post['recordID'];
		$this->load->library('form_validation');
		$this->form_validation->set_rules('template_name', 'Template Name', 'required|xss_clean');
		$this->form_validation->set_rules('subject', 'Subject', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->editEmailTemplate($recordID);
		}
		else
		{
			
			// update organizer detail
			$this->Marketing_model->update_email_template($post);
			$this->Az->redirect('admin/marketing/emailTemplateList', 'system_message_error',lang('EMAIL_TEMPLATE_SAVE_SUCCESS'));
		}	
		
	}


	public function deleteEmailTemplate($customerID = 0)
	{
		$loggedUser = $this->User->getLoggedUser();
		// check category valid or not
		$chk_cat = $this->db->get_where('email_templates',array('id'=>$customerID))->num_rows();
		if(!$chk_cat)
		{
			$this->Az->redirect('admin/marketing/emailTemplateList', 'system_message_error',lang('EMAIL_TEMPLATE_VALID_ERROR'));
		}
		
		$this->db->where('id',$customerID);
		$this->db->delete('email_templates');
		$this->Az->redirect('admin/marketing/emailTemplateList', 'system_message_info', lang('EMAIL_TEMPLATE_DELETE_SUCCESS'));
		
    }
	
	public function smsTemplateList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $customerList = $this->db->select('sms_templates.*')
							     ->order_by('sms_templates.created','desc')
								 ->get('sms_templates')->result_array();
								 
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'SMS Template List',
            'meta_keywords' => 'SMS Template List',
            'meta_description' => 'SMS Template List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'marketing/smsTemplateList',
            'manager_description' => 'SMS Template List',
			'customerList' => $customerList,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
	
	
	public function addSMSTemplate()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
		
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'marketing/addSMSTemplate',
            'manager_description' => lang('SITE_NAME'),
			'countryList' => $countryList,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
   
	
	public function saveSMSTemplate()
	{
		$loggedUser = $this->User->getLoggedUser('admin_user');
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('template_name', 'Template Name', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->addSMSTemplate();
		}
		else
		{
			// update organizer detail
			$this->Marketing_model->save_sms_template($post);
			$this->Az->redirect('admin/marketing/smsTemplateList', 'system_message_error',lang('SMS_TEMPLATE_SAVE_SUCCESS'));
		}
		
	}


	public function editSMSTemplate($customerID = 0)
    {
		$loggedUser = $this->User->getLoggedUser();
		
		// check category valid or not
		$chk_cat = $this->db->get_where('sms_templates',array('id'=>$customerID))->num_rows();
		if(!$chk_cat)
		{
			$this->Az->redirect('admin/marketing/smsTemplateList', 'system_message_error',lang('SMS_TEMPLATE_VALID_ERROR'));
		}

		// get customer data
		$userData = $this->db->get_where('sms_templates',array('id'=>$customerID))->row_array();
		   	
		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'marketing/editSMSTemplate',
            'manager_description' => lang('SITE_NAME'),
            'userData' => $userData,
            'recordID' => $customerID,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

    public function updateSMSTemplate()
	{
		$loggedUser = $this->User->getLoggedUser('admin_user');
		$post = $this->input->post();
		$recordID = $post['recordID'];
		$this->load->library('form_validation');
		$this->form_validation->set_rules('template_name', 'Template Name', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->editSMSTemplate($recordID);
		}
		else
		{
			
			// update organizer detail
			$this->Marketing_model->update_sms_template($post);
			$this->Az->redirect('admin/marketing/smsTemplateList', 'system_message_error',lang('SMS_TEMPLATE_SAVE_SUCCESS'));
		}	
		
	}


	public function deleteSMSTemplate($customerID = 0)
	{
		$loggedUser = $this->User->getLoggedUser();
		// check category valid or not
		$chk_cat = $this->db->get_where('sms_templates',array('id'=>$customerID))->num_rows();
		if(!$chk_cat)
		{
			$this->Az->redirect('admin/marketing/smsTemplateList', 'system_message_error',lang('SMS_TEMPLATE_VALID_ERROR'));
		}
		
		$this->db->where('id',$customerID);
		$this->db->delete('sms_templates');
		$this->Az->redirect('admin/marketing/smsTemplateList', 'system_message_info', lang('SMS_TEMPLATE_DELETE_SUCCESS'));
		
    }
	
}
?>