<?php
class Order extends CI_Controller {    
    
    
    public function __construct() 
    {
        parent::__construct();
       	$this->User->checkPermission();
        $this->load->model('admin/Catalog_model');		
        $this->load->model('admin/Section_model');		
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('email_lang', 'english');
        
    } 
    
	
	public function orderList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
		// get vendor list
		$customerList = $this->db->select('id,name')->get_where('users',array('role_id'=>4))->result_array();
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Order List',
            'meta_keywords' => 'Order List',
            'meta_description' => 'Order List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'order/orderList',
            'manager_description' => 'Order List',
			'customerList' => $customerList,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
	
	public function getOrderList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$order_status = 0;
		$keyword = '';
		$customer_id = 0;
		
		if($extra_search)
		{
			$filterData = explode('-',$extra_search);
			$order_status = isset($filterData[0]) ? $filterData[0] : 0;
			$keyword = isset($filterData[1]) ? $filterData[1] : '';
			$customer_id = isset($filterData[2]) ? $filterData[2] : 0;
			
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.id',
			1 => 'a.order_display_id',
			2 => 'e.name',
			3 => 'd.address_1',
			5 => 'a.status',
			6 => 'a.created',
			
		);
		
		
			// getting total number records without any search
			$sql = "SELECT a.*, e.name as customer_name, d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";
			
			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";  
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			$sql.=" ORDER BY a.created DESC ";
			
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			$sql = "SELECT a.*, e.name as customer_name , d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";

			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			
			$sql.=" WHERE a.id > 0 ";
			
			if($order_status)
			{
				$sql.=" AND a.status = '$order_status' ";
			}
			
			if($customer_id)
			{
				$sql.=" AND a.customer_id = '$customer_id' ";
			}
			
			if($keyword != '') {

				$sql.=" AND ( a.order_display_id LIKE '".$keyword."%' ";    
				$sql.=" OR d.address_1 LIKE '".$keyword."%' ";
				$sql.=" OR d.address_2 LIKE '".$keyword."%' ";
				$sql.=" OR a.created LIKE '".$keyword."%' )";
				
			}
			
			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 1 : $requestData['order'][0]['column'] : 1;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();
		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){
				
				$nestedData=array(); 
				
				$item_summary = $this->db->get_where('order_item_summary',array('order_id'=>$list['id']))->result_array();
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$i.'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['order_display_id'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['customer_name'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['address_1'].'</br>'.$list['address_2'].'</a>';
				
				
				$nestedData[] = '<a title="View" class="btn btn-primary btn-sm" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">View Detail</a>';

				if($list['order_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Open</font>'.'</a>';
				}
				elseif($list['order_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="blue">Proessing</font>'.'</a>';
				}
				elseif($list['order_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="pink">Dispatched</font>'.'</a>';
				}
				elseif($list['order_status'] == 4) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Cancelled</font>'.'</a>';
				}
				elseif($list['order_status'] == 5) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Delivered</font>'.'</a>';
				}


				if($list['payment_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}
				elseif($list['payment_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Success</font>'.'</a>';
				}
				elseif($list['payment_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Failed</font>'.'</a>';
				}
				else{
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}



				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="Generate Invoice"  target="_blank"  href="'.base_url('admin/order/invoice').'/'.$list['encoded_order_id'].'" >Invoice</a>'.'</a>';	

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.date('d-m-Y',strtotime($list['created'])).'</a>';
				
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="delete" class="del" href="'.base_url('admin/order/deleteOrder').'/'.$list['id'].'" onclick="return confirm(\'Are you sure you want to delete?\')"><img src="'.base_url().'resources/icons/delete.png"/></a>'.'</a>';
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}



		$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					"total_selected_students" => $total_selected_students
					);

		echo json_encode($json_data);  // send data as json format
	}




	public function openOrderList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
		// get vendor list
		$customerList = $this->db->select('id,name')->get_where('users',array('role_id'=>4))->result_array();
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Order List',
            'meta_keywords' => 'Order List',
            'meta_description' => 'Order List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'order/openOrderList',
            'manager_description' => 'Order List',
			'customerList' => $customerList,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
	
	public function getOpenOrderList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$order_status = 0;
		$keyword = '';
		$customer_id = 0;
		
		if($extra_search)
		{
			$filterData = explode('-',$extra_search);
			$order_status = isset($filterData[0]) ? $filterData[0] : 0;
			$keyword = isset($filterData[1]) ? $filterData[1] : '';
			$customer_id = isset($filterData[2]) ? $filterData[2] : 0;
			
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.id',
			1 => 'a.order_display_id',
			2 => 'e.name',
			3 => 'd.address_1',
			5 => 'a.status',
			6 => 'a.created',
			
		);
		
		
			// getting total number records without any search
			$sql = "SELECT a.*, e.name as customer_name, d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";
			
			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";  
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			$sql.=" ORDER BY a.created DESC ";
			
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			$sql = "SELECT a.*, e.name as customer_name , d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";

			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			
			$sql.=" WHERE a.status = 1 ";
			
			if($order_status)
			{
				$sql.=" AND a.status = '$order_status' ";
			}
			
			if($customer_id)
			{
				$sql.=" AND a.customer_id = '$customer_id' ";
			}
			
			if($keyword != '') {

				$sql.=" AND ( a.order_display_id LIKE '".$keyword."%' ";    
				$sql.=" OR d.address_1 LIKE '".$keyword."%' ";
				$sql.=" OR d.address_2 LIKE '".$keyword."%' ";
				$sql.=" OR a.created LIKE '".$keyword."%' )";
				
			}
			
			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 1 : $requestData['order'][0]['column'] : 1;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();
		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){
				
				$nestedData=array(); 
				
				$item_summary = $this->db->get_where('order_item_summary',array('order_id'=>$list['id']))->result_array();
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$i.'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['order_display_id'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['customer_name'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['address_1'].'</br>'.$list['address_2'].'</a>';
				
				$nestedData[] = '<a title="View" class="btn btn-primary btn-sm" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">View Detail</a>';

				if($list['order_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Open</font>'.'</a>';
				}
				elseif($list['order_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="blue">Proessing</font>'.'</a>';
				}
				elseif($list['order_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="pink">Dispatched</font>'.'</a>';
				}
				elseif($list['order_status'] == 4) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Cancelled</font>'.'</a>';
				}
				elseif($list['order_status'] == 5) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Delivered</font>'.'</a>';
				}


				if($list['payment_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}
				elseif($list['payment_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Success</font>'.'</a>';
				}
				elseif($list['payment_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Failed</font>'.'</a>';
				}
				else{
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="Generate Invoice"  target="_blank"  href="'.base_url('admin/order/invoice').'/'.$list['encoded_order_id'].'" >Invoice</a>'.'</a>';	

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.date('d-m-Y',strtotime($list['created'])).'</a>';
				
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="delete" class="del" href="'.base_url('admin/order/deleteOrder').'/'.$list['id'].'" onclick="return confirm(\'Are you sure you want to delete?\')"><img src="'.base_url().'resources/icons/delete.png"/></a>'.'</a>';
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}



		$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					"total_selected_students" => $total_selected_students
					);

		echo json_encode($json_data);  // send data as json format
	}



	public function processingOrderList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
		// get vendor list
		$customerList = $this->db->select('id,name')->get_where('users',array('role_id'=>4))->result_array();
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Order List',
            'meta_keywords' => 'Order List',
            'meta_description' => 'Order List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'order/processingOrderList',
            'manager_description' => 'Order List',
			'customerList' => $customerList,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
	
	public function getProcessingOrderList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$order_status = 0;
		$keyword = '';
		$customer_id = 0;
		
		if($extra_search)
		{
			$filterData = explode('-',$extra_search);
			$order_status = isset($filterData[0]) ? $filterData[0] : 0;
			$keyword = isset($filterData[1]) ? $filterData[1] : '';
			$customer_id = isset($filterData[2]) ? $filterData[2] : 0;
			
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.id',
			1 => 'a.order_display_id',
			2 => 'e.name',
			3 => 'd.address_1',
			5 => 'a.status',
			6 => 'a.created',
			
		);
		
		
			// getting total number records without any search
			$sql = "SELECT a.*, e.name as customer_name, d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";
			
			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";  
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			$sql.=" ORDER BY a.created DESC ";
			
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			$sql = "SELECT a.*, e.name as customer_name , d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";

			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			
			$sql.=" WHERE a.status = 2 ";
			
			if($order_status)
			{
				$sql.=" AND a.status = '$order_status' ";
			}
			
			if($customer_id)
			{
				$sql.=" AND a.customer_id = '$customer_id' ";
			}
			
			if($keyword != '') {

				$sql.=" AND ( a.order_display_id LIKE '".$keyword."%' ";    
				$sql.=" OR d.address_1 LIKE '".$keyword."%' ";
				$sql.=" OR d.address_2 LIKE '".$keyword."%' ";
				$sql.=" OR a.created LIKE '".$keyword."%' )";
				
			}
			
			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 1 : $requestData['order'][0]['column'] : 1;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();
		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){
				
				$nestedData=array(); 
				
				$item_summary = $this->db->get_where('order_item_summary',array('order_id'=>$list['id']))->result_array();
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$i.'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['order_display_id'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['customer_name'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['address_1'].'</br>'.$list['address_2'].'</a>';
				
				$nestedData[] = '<a title="View" class="btn btn-primary btn-sm" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">View Detail</a>';

				if($list['order_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Open</font>'.'</a>';
				}
				elseif($list['order_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="blue">Proessing</font>'.'</a>';
				}
				elseif($list['order_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="pink">Dispatched</font>'.'</a>';
				}
				elseif($list['order_status'] == 4) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Cancelled</font>'.'</a>';
				}
				elseif($list['order_status'] == 5) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Delivered</font>'.'</a>';
				}


				if($list['payment_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}
				elseif($list['payment_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Success</font>'.'</a>';
				}
				elseif($list['payment_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Failed</font>'.'</a>';
				}
				else{
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="Generate Invoice"  target="_blank"  href="'.base_url('admin/order/invoice').'/'.$list['encoded_order_id'].'" >Invoice</a>'.'</a>';	

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.date('d-m-Y',strtotime($list['created'])).'</a>';
				
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="delete" class="del" href="'.base_url('admin/order/deleteOrder').'/'.$list['id'].'" onclick="return confirm(\'Are you sure you want to delete?\')"><img src="'.base_url().'resources/icons/delete.png"/></a>'.'</a>';
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}



		$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					"total_selected_students" => $total_selected_students
					);

		echo json_encode($json_data);  // send data as json format
	}



	public function dispatchedOrderList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
		// get vendor list
		$customerList = $this->db->select('id,name')->get_where('users',array('role_id'=>4))->result_array();
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Order List',
            'meta_keywords' => 'Order List',
            'meta_description' => 'Order List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'order/dispatchedOrderList',
            'manager_description' => 'Order List',
			'customerList' => $customerList,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
	
	public function getDispatchedOrderList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$order_status = 0;
		$keyword = '';
		$customer_id = 0;
		
		if($extra_search)
		{
			$filterData = explode('-',$extra_search);
			$order_status = isset($filterData[0]) ? $filterData[0] : 0;
			$keyword = isset($filterData[1]) ? $filterData[1] : '';
			$customer_id = isset($filterData[2]) ? $filterData[2] : 0;
			
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.id',
			1 => 'a.order_display_id',
			2 => 'e.name',
			3 => 'd.address_1',
			5 => 'a.status',
			6 => 'a.created',
			
		);
		
		
			// getting total number records without any search
			$sql = "SELECT a.*, e.name as customer_name, d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";
			
			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";  
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			$sql.=" ORDER BY a.created DESC ";
			
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			$sql = "SELECT a.*, e.name as customer_name , d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";

			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			
			$sql.=" WHERE a.status = 3 ";
			
			if($order_status)
			{
				$sql.=" AND a.status = '$order_status' ";
			}
			
			if($customer_id)
			{
				$sql.=" AND a.customer_id = '$customer_id' ";
			}
			
			if($keyword != '') {

				$sql.=" AND ( a.order_display_id LIKE '".$keyword."%' ";    
				$sql.=" OR d.address_1 LIKE '".$keyword."%' ";
				$sql.=" OR d.address_2 LIKE '".$keyword."%' ";
				$sql.=" OR a.created LIKE '".$keyword."%' )";
				
			}
			
			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 1 : $requestData['order'][0]['column'] : 1;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();
		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){
				
				$nestedData=array(); 
				
				$item_summary = $this->db->get_where('order_item_summary',array('order_id'=>$list['id']))->result_array();
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$i.'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['order_display_id'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['customer_name'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['address_1'].'</br>'.$list['address_2'].'</a>';
				
				$nestedData[] = '<a title="View" class="btn btn-primary btn-sm" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">View Detail</a>';

				if($list['order_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Open</font>'.'</a>';
				}
				elseif($list['order_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="blue">Proessing</font>'.'</a>';
				}
				elseif($list['order_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="pink">Dispatched</font>'.'</a>';
				}
				elseif($list['order_status'] == 4) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Cancelled</font>'.'</a>';
				}
				elseif($list['order_status'] == 5) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Delivered</font>'.'</a>';
				}


				if($list['payment_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}
				elseif($list['payment_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Success</font>'.'</a>';
				}
				elseif($list['payment_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Failed</font>'.'</a>';
				}
				else{
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="Generate Invoice"  target="_blank"  href="'.base_url('admin/order/invoice').'/'.$list['encoded_order_id'].'" >Invoice</a>'.'</a>';	

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.date('d-m-Y',strtotime($list['created'])).'</a>';
				
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="delete" class="del" href="'.base_url('admin/order/deleteOrder').'/'.$list['id'].'" onclick="return confirm(\'Are you sure you want to delete?\')"><img src="'.base_url().'resources/icons/delete.png"/></a>'.'</a>';
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}



		$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					"total_selected_students" => $total_selected_students
					);

		echo json_encode($json_data);  // send data as json format
	}




	public function cancelledOrderList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
		// get vendor list
		$customerList = $this->db->select('id,name')->get_where('users',array('role_id'=>4))->result_array();
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Order List',
            'meta_keywords' => 'Order List',
            'meta_description' => 'Order List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'order/cancelledOrderList',
            'manager_description' => 'Order List',
			'customerList' => $customerList,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
	
	public function getCancelledOrderList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$order_status = 0;
		$keyword = '';
		$customer_id = 0;
		
		if($extra_search)
		{
			$filterData = explode('-',$extra_search);
			$order_status = isset($filterData[0]) ? $filterData[0] : 0;
			$keyword = isset($filterData[1]) ? $filterData[1] : '';
			$customer_id = isset($filterData[2]) ? $filterData[2] : 0;
			
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.id',
			1 => 'a.order_display_id',
			2 => 'e.name',
			3 => 'd.address_1',
			5 => 'a.status',
			6 => 'a.created',
			
		);
		
		
			// getting total number records without any search
			$sql = "SELECT a.*, e.name as customer_name, d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";
			
			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";  
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			//$sql.="LEFT JOIN tbl_order"
			$sql.=" ORDER BY a.created DESC ";
			
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			$sql = "SELECT a.*, e.name as customer_name , d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";

			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			
			$sql.=" WHERE a.status = 4 ";
			
			if($order_status)
			{
				$sql.=" AND a.status = '$order_status' ";
			}
			
			if($customer_id)
			{
				$sql.=" AND a.customer_id = '$customer_id' ";
			}
			
			if($keyword != '') {

				$sql.=" AND ( a.order_display_id LIKE '".$keyword."%' ";    
				$sql.=" OR d.address_1 LIKE '".$keyword."%' ";
				$sql.=" OR d.address_2 LIKE '".$keyword."%' ";
				$sql.=" OR a.created LIKE '".$keyword."%' )";
				
			}
			
			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 1 : $requestData['order'][0]['column'] : 1;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();


		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){
				$cancel_by =$this->db->get_where('users',array('id'=>$list['updated_by']))->row_array();
				$role=$this->db->get_where('user_roles',array('id'=>$cancel_by['role_id']))->row_array();
				$nestedData=array(); 
				
				$item_summary = $this->db->get_where('order_item_summary',array('order_id'=>$list['id']))->result_array();
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$i.'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['order_display_id'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['customer_name'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['address_1'].'</br>'.$list['address_2'].'</a>';
				
				$nestedData[] = '<a title="View" class="btn btn-primary btn-sm" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">View Detail</a>';

				if($list['order_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Open</font>'.'</a>';
				}
				elseif($list['order_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="blue">Proessing</font>'.'</a>';
				}
				elseif($list['order_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="pink">Dispatched</font>'.'</a>';
				}
				elseif($list['order_status'] == 4) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Cancelled</font>'.'</a>';
				}
				elseif($list['order_status'] == 5) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Delivered</font>'.'</a>';
				}


				if($list['payment_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}
				elseif($list['payment_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Success</font>'.'</a>';
				}
				elseif($list['payment_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Failed</font>'.'</a>';
				}
				else{
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="Generate Invoice"  target="_blank"  href="'.base_url('admin/order/invoice').'/'.$list['encoded_order_id'].'" >Invoice</a>'.'</a>';	

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.date('d-m-Y',strtotime($list['created'])).'</a>';

				if($cancel_by['name']){

				$nestedData[] = $role['title'].' - '.$cancel_by['name'];
				
				}
				else{

					$nestedData[] = 'Not Available';
				}

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="delete" class="del" href="'.base_url('admin/order/deleteOrder').'/'.$list['id'].'" onclick="return confirm(\'Are you sure you want to delete?\')"><img src="'.base_url().'resources/icons/delete.png"/></a>'.'</a>';
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}



		$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					"total_selected_students" => $total_selected_students
					);

		echo json_encode($json_data);  // send data as json format
	}




	public function deliveredOrderList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
		// get vendor list
		$customerList = $this->db->select('id,name')->get_where('users',array('role_id'=>4))->result_array();
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Order List',
            'meta_keywords' => 'Order List',
            'meta_description' => 'Order List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'order/deliveredOrderList',
            'manager_description' => 'Order List',
			'customerList' => $customerList,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
	
	public function getDeliveredOrderList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$order_status = 0;
		$keyword = '';
		$customer_id = 0;
		
		if($extra_search)
		{
			$filterData = explode('-',$extra_search);
			$order_status = isset($filterData[0]) ? $filterData[0] : 0;
			$keyword = isset($filterData[1]) ? $filterData[1] : '';
			$customer_id = isset($filterData[2]) ? $filterData[2] : 0;
			
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.id',
			1 => 'a.order_display_id',
			2 => 'e.name',
			3 => 'd.address_1',
			5 => 'a.status',
			6 => 'a.created',
			
		);
		
		
			// getting total number records without any search
			$sql = "SELECT a.*, e.name as customer_name, d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";
			
			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";  
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			$sql.=" ORDER BY a.created DESC ";
			
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			$sql = "SELECT a.*, e.name as customer_name , d.address_1 as address_1, d.address_2 as address_2, f.id as order_status ";

			$sql.=" FROM tbl_orders as a ";
			$sql.=" LEFT JOIN tbl_user_address as d ON a.address_id = d.id ";
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			
			$sql.=" WHERE a.status = 5 ";
			
			if($order_status)
			{
				$sql.=" AND a.status = '$order_status' ";
			}
			
			if($customer_id)
			{
				$sql.=" AND a.customer_id = '$customer_id' ";
			}
			
			if($keyword != '') {

				$sql.=" AND ( a.order_display_id LIKE '".$keyword."%' ";    
				$sql.=" OR d.address_1 LIKE '".$keyword."%' ";
				$sql.=" OR d.address_2 LIKE '".$keyword."%' ";
				$sql.=" OR a.created LIKE '".$keyword."%' )";
				
			}
			
			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 1 : $requestData['order'][0]['column'] : 1;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();
		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){
				
				$nestedData=array(); 
				
				$item_summary = $this->db->get_where('order_item_summary',array('order_id'=>$list['id']))->result_array();
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$i.'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['order_display_id'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['customer_name'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.$list['address_1'].'</br>'.$list['address_2'].'</a>';
				
				$nestedData[] = '<a title="View" class="btn btn-primary btn-sm" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">View Detail</a>';

				if($list['order_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Open</font>'.'</a>';
				}
				elseif($list['order_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="blue">Proessing</font>'.'</a>';
				}
				elseif($list['order_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="pink">Dispatched</font>'.'</a>';
				}
				elseif($list['order_status'] == 4) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Cancelled</font>'.'</a>';
				}
				elseif($list['order_status'] == 5) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Delivered</font>'.'</a>';
				}


				if($list['payment_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}
				elseif($list['payment_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Success</font>'.'</a>';
				}
				elseif($list['payment_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Failed</font>'.'</a>';
				}
				else{
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Pending</font>'.'</a>';
				}

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="Generate Invoice"  target="_blank"  href="'.base_url('admin/order/invoice').'/'.$list['encoded_order_id'].'" >Invoice</a>'.'</a>';	

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.date('d-m-Y',strtotime($list['created'])).'</a>';
				
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewOrder').'/'.$list['encoded_order_id'].'">'.'<a title="delete" class="del" href="'.base_url('admin/order/deleteOrder').'/'.$list['id'].'" onclick="return confirm(\'Are you sure you want to delete?\')"><img src="'.base_url().'resources/icons/delete.png"/></a>'.'</a>';
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}



		$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					"total_selected_students" => $total_selected_students
					);

		echo json_encode($json_data);  // send data as json format
	}





	public function vendorOrderList()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
		// get vendor list
		$customerList = $this->db->select('id,name')->get_where('users',array('role_id'=>3))->result_array();
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Vendor Order List',
            'meta_keywords' => 'Vendor Order List',
            'meta_description' => 'Vendor Order List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'order/vendorOrderList',
            'manager_description' => 'Vendor Order List',
			'customerList' => $customerList,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
	
	public function getVendorOrderList()
	{
		
		$requestData= $this->input->get();
		$extra_search = $requestData['extra_search'];
		$order_status = 0;
		$keyword = '';
		$customer_id = 0;
		
		if($extra_search)
		{
			$filterData = explode('-',$extra_search);
			$order_status = isset($filterData[0]) ? $filterData[0] : 0;
			$keyword = isset($filterData[1]) ? $filterData[1] : '';
			$customer_id = isset($filterData[2]) ? $filterData[2] : 0;
			
		}
		
		
		$columns = array( 
		// datatable column index  => database column name
			0 => 'a.id',
			1 => 'a.id',
		);
		
		
			// getting total number records without any search
			$sql = "SELECT a.*, e.name as customer_name, f.id as order_status, b.name as vendor_name,o.order_display_id as customer_order_id ";
			$sql.=" FROM tbl_vendor_orders as a ";
			$sql.=" INNER JOIN tbl_orders as o ON a.order_id = o.id ";  
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";  
			$sql.=" LEFT JOIN tbl_users as b ON a.vendor_id = b.id ";  
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			$sql.=" ORDER BY a.created DESC ";
			
		
			$totalData = $this->db->query($sql)->num_rows();
			
			$totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
		
			$sql = "SELECT a.*, e.name as customer_name, f.id as order_status, b.name as vendor_name,o.order_display_id as customer_order_id ";
			$sql.=" FROM tbl_vendor_orders as a ";
			$sql.=" INNER JOIN tbl_orders as o ON a.order_id = o.id ";  
			$sql.=" LEFT JOIN tbl_users as e ON a.customer_id = e.id ";  
			$sql.=" LEFT JOIN tbl_users as b ON a.vendor_id = b.id ";  
			$sql.=" LEFT JOIN tbl_order_status as f ON a.status = f.id ";
			
			$sql.=" WHERE a.id > 0 ";
			
			if($order_status)
			{
				$sql.=" AND a.status = '$order_status' ";
			}
			
			if($customer_id)
			{
				$sql.=" AND a.vendor_id = '$customer_id' ";
			}
			
			if($keyword != '') {

				$sql.=" AND ( a.order_display_id LIKE '".$keyword."%' ";    
				$sql.=" OR b.name LIKE '".$keyword."%' ";
				$sql.=" OR a.created LIKE '".$keyword."%' )";
				
			}
			
			$order_type = $requestData['order'][0]['dir'];
			//if($requestData['draw'] == 1)
			//	$order_type = 'DESC';
			
			$order_no = isset($requestData['order'][0]['column']) ? ($requestData['order'][0]['column'] == 0) ? 1 : $requestData['order'][0]['column'] : 1;
			$totalFiltered = $this->db->query($sql)->num_rows();
			$sql.=" ORDER BY ". $columns[$order_no]."   ".$order_type."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
		
		
		
		$get_filter_data = $this->db->query($sql)->result_array();
		
		$data = array();
		//$totalrecord = 0;
		if($get_filter_data){
			$i=1;
			foreach($get_filter_data as $list){
				
				$nestedData=array(); 
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.$i.'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.$list['vendor_name'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.$list['order_display_id'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.$list['customer_name'].'</a>';
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.$list['customer_order_id'].'</a>';
				$nestedData[] = $list['total_item'];
				$nestedData[] = $list['total_price'];
				$nestedData[] = $list['total_commision'];
				$nestedData[] = $list['total_comission_amount'];
				$nestedData[] = $list['payable_amount'];
				
				
				

				if($list['order_status'] == 1) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.'<font color="orange">Open</font>'.'</a>';
				}
				
				if($list['order_status'] == 2) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.'<font color="blue">Proessing</font>'.'</a>';
				}

				if($list['order_status'] == 3) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.'<font color="pink">Dispatched</font>'.'</a>';
				}

				if($list['order_status'] == 4) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.'<font color="red">Cancelled</font>'.'</a>';
				}

				if($list['order_status'] == 5) {
					$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.'<font color="green">Delivered</font>'.'</a>';
				}

				if($list['is_paid'] == 1) {
					$nestedData[] = '<font color="green">Yes</font>';
				}
				else
				{
					$nestedData[] = '<font color="black">No</font>';
				}

				$nestedData[] = '<a title="View Invoice"  target="_blank"  href="'.base_url('admin/order/vendorInvoice').'/'.$list['encoded_order_id'].'" >View Invoice</a>';	

				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.date('d-m-Y',strtotime($list['created'])).'</a>';
				
				$nestedData[] = '<a title="View" href="'.base_url('admin/order/viewVendorOrder').'/'.$list['encoded_order_id'].'">'.'<a title="delete" class="del" href="'.base_url('admin/order/deleteVendorOrder').'/'.$list['id'].'" onclick="return confirm(\'Are you sure you want to delete?\')"><img src="'.base_url().'resources/icons/delete.png"/></a>'.'</a>';
				
				$data[] = $nestedData;
				
				
				
			$i++;}
		}



		$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data,   // total data array
					"total_selected_students" => $total_selected_students
					);

		echo json_encode($json_data);  // send data as json format
	}




	public function invoice($encoded_order_id = ''){
		
		$account_id = $this->User->get_logged_user_account_id();
		// check order id valid or not
		$chk_address = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();
		
		$get_customer_id = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->row_array();

		if(!$chk_address)
		{
			$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
		}
		
		$orderData = $this->User->get_customer_current_order_data($get_customer_id['customer_id'],$encoded_order_id);


		
		// GET COMPANY DATA
		$companyData = $this->db->select('address,company_name,pan_number,gst_number')->get_where('site_settings',array('id'=>1))->row_array();
		
		$order_id = isset($orderData[0]['id']) ? $orderData[0]['id'] : 0 ;
		// get order invoice data
		$invoiceData = $this->db->select('*')->get_where('order_invoice',array('order_id'=>$order_id,'customer_id'=>$get_customer_id['customer_id'],$encoded_order_id))->row_array();
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => "Home - People Mart",
            'meta_keywords' => "Home - People Mart",
            'meta_description' => "Home - People Mart",
            'site_url' => $siteUrl,
            'orderData' => $orderData,
            'companyData' => $companyData,
            'invoiceData' => $invoiceData,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'order/order-invoice'
        );
        $this->parser->parse('admin/layout/column-3' , $data);
    }


    public function vendorInvoice($encoded_order_id = ''){
		
		$account_id = $this->User->get_logged_user_account_id();
		// check order id valid or not
		$chk_address = $this->db->get_where('vendor_orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();
		
		$get_customer_id = $this->db->get_where('vendor_orders',array('encoded_order_id'=>$encoded_order_id))->row_array();

		if(!$chk_address)
		{
			$this->Az->redirect('customer/order/vendorOrderList', 'system_message_error',lang('DB_ERROR'));
		}
		
		$orderData = $this->User->get_vendor_current_order_data($get_customer_id['vendor_id'],$encoded_order_id);
		
		
		$get_gst_no = $this->db->select('gst_no')->get_where('users',array('id'=>$get_customer_id['vendor_id']))->row_array();
		$get_vendor_address = $this->db->select('company,address_1,address_2,city')->get_where('user_address',array('userID'=>$get_customer_id['vendor_id']))->row_array();
		$companyData = array();
		$companyData['gst_number'] = isset($get_gst_no['gst_no']) ? $get_gst_no['gst_no'] : '';
		$companyData['company_name'] = isset($get_vendor_address['company']) ? $get_vendor_address['company'] : '';
		$companyData['address'] = isset($get_vendor_address['company']) ? $get_vendor_address['address_1'].' '.$get_vendor_address['address_2'].' '.$get_vendor_address['city'] : '';
		$companyData['pan_number'] = '';
		
		$order_id = isset($orderData[0]['id']) ? $orderData[0]['id'] : 0 ;
		// get order invoice data
		$invoiceData = $this->db->select('*')->get_where('order_invoice',array('order_id'=>$order_id,'vendor_id'=>$get_customer_id['vendor_id'],'invoice_type'=>2))->row_array();
		
		
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => "Home - People Mart",
            'meta_keywords' => "Home - People Mart",
            'meta_description' => "Home - People Mart",
            'site_url' => $siteUrl,
            'orderData' => $orderData,
            'companyData' => $companyData,
            'invoiceData' => $invoiceData,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'order/vendor-order-invoice'
        );
        $this->parser->parse('admin/layout/column-3' , $data);
    }



    public function viewOrder($encoded_order_id = ''){
		
		$account_id = $this->User->get_logged_user_account_id();
		// check order id valid or not
		$chk_address = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();
		$get_customer_id = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->row_array();	

		if(!$chk_address)
		{
			$this->Az->redirect('admin/order/orderList', 'system_message_error',lang('DB_ERROR'));
		}
		
		$orderData = $this->User->get_customer_current_order_data($get_customer_id['customer_id'],$encoded_order_id);

		
		// GET COMPANY DATA
		$companyData = $this->db->select('address,company_name,pan_number,gst_number')->get_where('site_settings',array('id'=>1))->row_array();
		
		$order_id = isset($orderData[0]['id']) ? $orderData[0]['id'] : 0 ;
		// get order invoice data
		$invoiceData = $this->db->select('*')->get_where('order_invoice',array('order_id'=>$order_id,'customer_id'=>$get_customer_id['customer_id']))->row_array();
		
		
		$status = $this->db->get('order_status')->result_array();


		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => "Order - People Mart",
            'meta_keywords' => "Order - People Mart",
            'meta_description' => "Order - People Mart",
            'site_url' => $siteUrl,
            'orderData' => $orderData,
            'companyData' => $companyData,
            'invoiceData' => $invoiceData,
            'status'	  => $status,
            'encoded_order_id'=>$encoded_order_id,	
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'order/viewOrder'
        );
        $this->parser->parse('admin/layout/column-1' , $data);
    }
    
    
    public function viewVendorOrder($encoded_order_id = ''){
		
		$account_id = $this->User->get_logged_user_account_id();
		// check order id valid or not
		// check order id valid or not
		$chk_address = $this->db->get_where('vendor_orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();
		$get_customer_id = $this->db->get_where('vendor_orders',array('encoded_order_id'=>$encoded_order_id))->row_array();	

		if(!$chk_address)
		{
			$this->Az->redirect('admin/order/vendorOrderList', 'system_message_error',lang('DB_ERROR'));
		}
		
		$orderData = $this->User->get_vendor_current_order_data($get_customer_id['vendor_id'],$encoded_order_id);
		
		$get_gst_no = $this->db->select('gst_no')->get_where('users',array('id'=>$get_customer_id['vendor_id']))->row_array();
		$get_vendor_address = $this->db->select('company,address_1,address_2,city')->get_where('user_address',array('userID'=>$get_customer_id['vendor_id']))->row_array();
		$companyData = array();
		$companyData['gst_number'] = isset($get_gst_no['gst_no']) ? $get_gst_no['gst_no'] : '';
		$companyData['company_name'] = isset($get_vendor_address['company']) ? $get_vendor_address['company'] : '';
		$companyData['address'] = isset($get_vendor_address['company']) ? $get_vendor_address['address_1'].' '.$get_vendor_address['address_2'].' '.$get_vendor_address['city'] : '';
		$companyData['pan_number'] = '';
		
		$order_id = isset($orderData[0]['id']) ? $orderData[0]['id'] : 0 ;
		// get order invoice data
		$invoiceData = $this->db->select('*')->get_where('order_invoice',array('order_id'=>$order_id,'vendor_id'=>$get_customer_id['vendor_id'],'invoice_type'=>2))->row_array();
		
		
		$status = $this->db->get('order_status')->result_array();
		 
		$siteUrl = base_url();
		$data = array(
            'meta_title' => "Order - People Mart",
            'meta_keywords' => "Order - People Mart",
            'meta_description' => "Order - People Mart",
            'site_url' => $siteUrl,
            'orderData' => $orderData,
            'companyData' => $companyData,
            'invoiceData' => $invoiceData,
            'status'	  => $status,
            'encoded_order_id'=>$encoded_order_id,	
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'order/viewOrder'
        );
        $this->parser->parse('admin/layout/column-1' , $data);
    }


   public function updateOrderStatus(){

   		$loggedUser = $this->User->getLoggedUser("admin_user");


	   	$post = $this->input->post();
	   	$chk_order_id = $this->db->get_where('orders',array('encoded_order_id'=>$post['encoded_order_id']))->row_array();

	   

	   	if($chk_order_id){

		   	$data = array(

		   	'status' => $post['order_status'],	
		   	'updated'=> date('Y-m-d H:i:s'),
		   	'updated_by'=>$loggedUser['id']
		   	);	
		   		
		   	$this->db->where('encoded_order_id',$post['encoded_order_id']);
			$this->db->update('orders',$data);

				$this->db->where('order_id',$chk_order_id['id']);
		$this->db->update('vendor_orders',$data);

			$get_user_data = $this->db->get_where('users',array('id'=>$chk_order_id['customer_id']))->row_array();

			if($post['order_status'] == 2){
			 $sms = 'Dear '.$get_user_data['name'].' Your order (#'.$chk_order_id['order_display_id'].') is in processing Peoplemart.com. ';
			 
			 $email = 'Dear '.$get_user_data['name'].' Your order (#'.$chk_order_id['order_display_id'].') is in processing Peoplemart.com ';
			 
			}
			elseif($post['order_status'] == 3){
			    
			 $orderData = $this->User->get_customer_current_order_data($chk_order_id['customer_id'],$post['encoded_order_id']);
		    
		    
		    $product = '';
		    if(isset($orderData[0]['productInfo']) && $orderData[0]['productInfo']){
            
            foreach($orderData[0]['productInfo'] as $key=>$list){ 
           
              $product.= $list['product_qty'].' '.$list['product_name'].' ';
           
            }}
			 
			 $smsTemplateData = $this->db->get_where('sms_templates',array('id'=>5,'status'=>1))->row_array();
             $sms_message = isset($smsTemplateData['message']) ? $smsTemplateData['message'] : '' ;
             
             
             $emailTemplateData = $this->db->get_where('email_templates',array('id'=>2,'status'=>1))->row_array();
             $email_message = isset($emailTemplateData['message']) ? $emailTemplateData['message'] : '' ;

             if($sms_message){
            
              $output = '';
              $sms = $sms_message;

              $sms = str_replace('{PRODUCT}',$product,$sms);   
             }
             
             
             if($email_message){
            
              $email = $email_message;

              $email = str_replace('{PRODUCT}',$product,$email);   
             }
             
             
			  
			}
			elseif($post['order_status'] == 4){
			 $sms = 'Dear '.$get_user_data['name'].' Your order (#'.$chk_order_id['order_display_id'].') is Cancelled Peoplemart.com';
			 
			 $email = 'Dear '.$get_user_data['name'].' Your order (#'.$chk_order_id['order_display_id'].') is Cancelled Peoplemart.com';
			 
			 
			}
			elseif($post['order_status'] == 5){
			 $orderData = $this->User->get_customer_current_order_data($chk_order_id['customer_id'],$post['encoded_order_id']);
		    
		    
		    $product = '';
		    if(isset($orderData[0]['productInfo']) && $orderData[0]['productInfo']){
            
            foreach($orderData[0]['productInfo'] as $key=>$list){ 
           
              $product.= $list['product_qty'].' '.$list['product_name'].' ';
           
            }}
			 
			 $smsTemplateData = $this->db->get_where('sms_templates',array('id'=>6,'status'=>1))->row_array();
             $sms_message = isset($smsTemplateData['message']) ? $smsTemplateData['message'] : '' ;
             
             $emailTemplateData = $this->db->get_where('email_templates',array('id'=>1,'status'=>1))->row_array();
             $email_message = isset($emailTemplateData['message']) ? $emailTemplateData['message'] : '' ;

             if($sms_message){
            
              $output = '';
              $sms = $sms_message;

              $sms = str_replace('{PRODUCT}',$product,$sms);
              $sms = str_replace('{USER_NAME}',$get_user_data['name'],$sms);
             }
             
             
             if($email_message){
            
              $email = $email_message;

              $email = str_replace('{PRODUCT}',$product,$email);
              $email = str_replace('{USER_NAME}',$get_user_data['name'],$email);
             }
             
             
			}

			if($sms){
				$output = '';
				
				$mobile = isset($get_user_data['mobile']) ? $get_user_data['mobile'] : '';

		        $api_url = SMS_API_URL.'authkey='.SMS_API_AUTH_KEY.'&mobiles=91'.$mobile.'&message='.urlencode($sms).'&sender='.SMS_API_SENDERID.'&route=4&country=0';
                
		        $ch = curl_init();
		        curl_setopt($ch, CURLOPT_URL, $api_url);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
		        $output = curl_exec($ch);
		        curl_close($ch);
		    }
		    
		    
		    if($email){

                $sms = $email;
                
                $get_site_email = $this->db->select('email_id')->get_where('site_settings',array('id'=>1))->row_array();

                $site_email = isset($get_site_email['email_id']) ? $get_site_email['email_id'] : '';
                
                $siteName = 'People Mart';
                
                $emailTimeStamp = date('d-m-Y h:i:s');
                $emailTemplate = sprintf((string) lang('ORDER_EMAIL'), site_url(), $siteName,$sms,$emailTimeStamp);
    
                $email_subject = 'People Mart Order'; 
    
                $configEmail = array(
                    'mailtype' => 'html',
                );
                
                
                $email_id = isset($get_user_data['email']) ? $get_user_data['email'] : '';
                
                // send mail to customer
                $this->load->library('email');
                $this->email->initialize($configEmail);
                $this->email->from($site_email, 'People Mart');
                $this->email->to($email_id);
                $this->email->subject($email_subject);
                $this->email->message($emailTemplate);
                $this->email->send();
                
                
                //send mail to admin
                
                $this->load->library('email');
                $this->email->initialize($configEmail);
                $this->email->from($site_email, 'People Mart');
                $this->email->to($site_email);
                $this->email->subject($email_subject);
                $this->email->message($emailTemplate);
                $this->email->send();
                
                
            }

			
			$this->Az->redirect('admin/order/viewOrder/'.$post['encoded_order_id'], 'system_message_info', lang('ORDER_STATUS_UPDATE_SUCCESS'));
		}

		else{

			$this->Az->redirect('admin/order/orderList', 'system_message_info', lang('DB_ERROR'));	

		}


   } 



 
  public function deleteOrder($orderID = 0){


   	$this->db->where('id',$orderID);
	$this->db->delete('orders');

	$this->db->where('order_id',$orderID);
	$this->db->delete('order_item_summary');
    
    $this->db->where('order_id',$orderID);
    $this->db->delete('vendor_orders');
    
	$this->Az->redirect('admin/order/orderList', 'system_message_info', lang('ORDER_DELETE_SUCCESS'));

  } 


  public function deleteVendorOrder($orderID = 0){


   	$this->db->where('id',$orderID);
	$this->db->delete('vendor_orders');

	$this->Az->redirect('admin/order/orderList', 'system_message_info', lang('ORDER_DELETE_SUCCESS'));

  } 
	
		
}
?>