<?php
class Pages extends CI_Controller {    
    
    
    public function __construct() 
    {
        parent::__construct();
       	$this->User->checkPermission();
        $this->load->model('admin/Pages_model');		
        $this->load->model('admin/Section_model');		
        $this->lang->load('admin/dashboard', 'english');
        
    } 
    
	
	public function index()
    {
		
		$loggedUser = $this->User->getLoggedUser("admin_user");
		
        $pageList = $this->db->order_by('id','desc')->get('pages')->result_array();
		
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Pages',
            'meta_keywords' => 'Pages',
            'meta_description' => 'Pages',
			'loggedUser' => $loggedUser,	
			'content_block' => 'pages/pageList',
            'manager_description' => 'Pages',
			'pageList' => $pageList,
			'pageID' => $pageID,
			'page_name' => $page_name,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

	public function addPage()
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$siteUrl = site_url();

		// get media list
		$mediaList = $this->db->order_by('posted','desc')->get('media_files')->result_array();

        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'pages/addPage',
            'mediaList' => $mediaList,
            'manager_description' => lang('SITE_NAME'),
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }
   
	
	public function savePage()
	{
		
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$userID = $loggedUser['id'];
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('title', 'Title', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->addPage();
		}
		else
		{
			// update organizer detail
			$this->Pages_model->save_page($post);
			$this->Az->redirect('admin/pages', 'system_message_error',lang('PAGE_SAVE_SUCCESS'));
		
		}
		
		
		
			
		
	}


	public function editPage($pageID = 0)
    {
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$pageList = $this->db->get_where('pages',array('id' => $pageID))->num_rows();
		if(!$pageList)
		{
			$this->Az->redirect('admin/pages', 'system_message_error',lang('PAGE_VALID_ERROR'));
		}
		// get banner data
		$pageData = $this->db->get_where('pages',array('id'=>$pageID))->row_array();

		// get media list
		$mediaList = $this->db->order_by('posted','desc')->get('media_files')->result_array();
		
		   	
		$siteUrl = site_url();
        $data = array(
            'site_url' 				=> $siteUrl,
			'loggedUser' 			=> $loggedUser,
            'meta_title' 			=> lang('SITE_NAME'),
            'meta_keywords' 		=> lang('SITE_NAME'),
            'meta_description' 		=> lang('SITE_NAME'),
            'content_block' 		=> 'pages/editPage',
            'manager_description' 	=> lang('SITE_NAME'),
            'pageData' 				=> $pageData,
            'pageID' 				=> $pageID,
            'mediaList' 			=> $mediaList,
          	'system_message' 		=> $this->Az->getSystemMessageError(),
            'system_info' 			=> $this->Az->getSystemMessageInfo(),
            'system_warning' 		=> $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('admin/layout/column-1', $data);
		
    }

    public function updatePage()
	{
		$loggedUser = $this->User->getLoggedUser("admin_user");
		$userID = $loggedUser['id'];
		$post = $this->input->post();

		$pageID = $post['pageID'];
		$this->load->library('form_validation');
		$this->form_validation->set_rules('title', 'Title', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->editPage($pageID);
		}
		else
		{
			// update organizer detail
			$this->Pages_model->update_page($post,$pageID);
			$this->Az->redirect('admin/pages', 'system_message_error',lang('PAGE_SAVE_SUCCESS'));
		
		}
		
		
			
		
	}


	public function deletePage($pageID = 0)
	{
		$loggedUser = $this->User->getLoggedUser("admin_user");
		// check user valid or not
		$pageList = $this->db->get_where('pages',array('id'=>$pageID))->num_rows();
		if(!$pageList)
		{
			$this->Az->redirect('admin/pages', 'system_message_error',lang('PAGE_VALID_ERROR'));
		}
		
		$this->db->where('id',$pageID);
		$this->db->delete('pages');
		
		$this->Az->redirect('admin/pages', 'system_message_info', lang('PAGE_DELETE_SUCCESS'));
		
    }
    
    
    public function deleteMedia($id = 0)
	{
		$loggedUser = $this->User->getLoggedUser("admin_user");
		// check user valid or not
		$pageList = $this->db->get_where('media_files',array('id' => $id))->num_rows();

		if(!$pageList)
		{
			$this->Az->redirect('admin/pages', 'system_message_error',lang('PAGE_VALID_ERROR'));
		}else{

			$this->db->where('id',$id);
			$this->db->delete('media_files');
			
			$this->Az->redirect('admin/pages', 'system_message_info',lang('DELETE_SUCCESS'));

		}
		
		
		
    }

    public function uploadMedia()
	{
		
		//generate logo name randomly
		$config['upload_path'] = './media/media_files/';
		$config['allowed_types'] = '*';
		$siteUrl = site_url();
		
		$arr_files = $_FILES['photos'];
		if($arr_files)
		{
  
			   $_FILES = array();
			   
			   foreach(array_keys($arr_files['name']) as $h){
				  $_FILES["file_{$h}"] = array(
					'name' => $arr_files['name'][$h],
				   'type' => $arr_files['type'][$h],
				   'tmp_name' => $arr_files['tmp_name'][$h],
				   'error' => $arr_files['error'][$h],
				   'size' => $arr_files['size'][$h]
				  );
			   
			   }
			   $allFiles = '';
			foreach (array_keys($_FILES) as $h) 
			{
				$fileName = rand(1111,9999).time();
				$config['file_name'] = $fileName;
				$this->load->library('upload', $config);
				$this->upload->do_upload($h);		
				$uploadError = $this->upload->display_errors();
			
				if($uploadError){
					unlink(str_replace('system/', '', BASEPATH . $filePath));
					echo json_encode(
							array(
								"status"=>0
								)
					);
				}
				else
				{
					
					$fileData = $this->upload->data();
					//get uploaded file path
					$filePath = substr($config['upload_path'] . $fileData['file_name'], 2);
					
					// save file
					$fileData = array(
						'file_url' => $filePath,
						'posted' => date('Y-m-d H:i:s')
					);
					$this->db->insert('media_files',$fileData);
					$file_id = $this->db->insert_id();

					$allFiles.='<div class="col-md-3 media-img-block text-center"><div class="media-img"><img src="'.base_url($filePath).'"></div><input type="hidden" id="media-txt-'.$file_id.'" value="'.base_url($filePath).'"><button type="button" onclick="copyMediaUrl('.$file_id.')" class="btn btn-primary">Show URL</button></br></br><a href="'.base_url('admin/pages/deleteMedia/').$file_id.'" class="btn btn-danger">Delete</a></div>';
					
				}
			
			}
			echo json_encode(
							array(
								"status"=>1,
								'msg' => 'Success',
								"file_data" => $allFiles
								)
						);
		}
		else
		{
			echo json_encode(
						array(
							"status"=>0,
							"msg" => 'Please select a file.'
							)
					);
		}

		
	}
	
    

}
?>