<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Setting extends CI_Controller{

    public function __construct() {
        parent::__construct();
        //load language
		$this->User->checkPermission();
		$this->load->model('admin/setting_model');
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front_common' , 'english');
    }
	
	public function index($uname_prefix = '' , $username = ''){
		//get logged user info
        $loggedUser = $this->User->getLoggedUser("lekker_admin");
		$account_id = $loggedUser['id'];
		$siteUrl = base_url();
		$get_setting = $this->db->get('site_settings')->row_array();
		
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			'loggedUser'  		=> $loggedUser,
			'id' 				=> $account_id,
			'get_setting'		=> $get_setting,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'setting/siteSetting'
        );
        $this->parser->parse('admin/layout/column-1' , $data);
    }
	
	
	
	public function saveSetting()
	{
		//check for foem validation
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('email_id', 'Email Id', 'required');
		if ($this->form_validation->run() == FALSE) {
			
			$this->index();
		}
		else
		{
			
			$logo_image_path = '';
			if($_FILES['logo']['name'])
			{
				//generate icon name randomly
				$fileName = rand(1111,999999999);
				$config['upload_path'] = './media/logo/';
				$config['allowed_types'] = 'gif|jpeg|JPEG|JPG|PNG|jpg|png';
				$config['file_name'] 		= $fileName;
					
				$this->load->library('upload',$config);	
				$this->upload->do_upload('logo');
				$uploadError = $this->upload->display_errors();
				if($uploadError){
					$this->Az->redirect('admin/setting', 'system_message_error',$uploadError);
				}
				else
				{
					$fileData = $this->upload->data();
					//get uploaded file path
					$logo_image_path = substr($config['upload_path'] . $fileData['file_name'], 2);
						
				}
				
			}
			
			
			$status = $this->setting_model->saveSetting($post,$logo_image_path);
			if($status == true)
			{
				$this->Az->redirect('admin/setting', 'system_message_error',lang('SITE_SETTING_SAVE'));
			}
			else
			{
				$this->Az->redirect('admin/setting', 'system_message_error',lang('DB_ERROR'));
			}
			
		}
	
	}
	
	
	
	
	
}


/* End of file login.php */
/* Location: ./application/controllers/login.php */