<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Users extends CI_Controller{

    public function __construct() {
        parent::__construct();
        //load language
		$this->User->checkPermission();
		$this->load->model('admin/Login_model');
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front/message', 'english');
    }
	
	public function index($uname_prefix = '' , $username = ''){
		//get logged user info
        $loggedUser = $this->User->getLoggedUser("admin_user");
		$account_id = $loggedUser['id'];
		
		// get users list
		$users_list = $this->db->order_by('id','desc')->get_where('users',array('role_id'=>2))->result_array();
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => "Users List",
            'meta_keywords' => "Users List",
            'meta_description' => "Users List",
            'site_url' => $siteUrl,
			'loggedUser'  => $loggedUser,
			'users_list' => $users_list,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'users/list'
        );
        $this->parser->parse('admin/layout/column-1' , $data);
    }
	
	
	
	public function deactiveUser($userID = 0)
	{
		
		// check user valid or not
		$chk_user = $this->db->get_where('user_det',array('id'=>$userID))->num_rows();
		if(!$chk_user)
		{
			$this->Az->redirect('admin/users', 'system_message_error', lang('SYSTEM_ERROR'));
		}
		
		$this->db->where('id',$userID);
		$this->db->update('user_det',array('is_active'=>0));
		$this->Az->redirect('admin/users', 'system_message_info', lang('USER_DEACTIVE_SUCCESS'));
		
	}
	
	public function activeUser($userID = 0)
	{
		
		// check user valid or not
		$chk_user = $this->db->get_where('user_det',array('id'=>$userID))->num_rows();
		if(!$chk_user)
		{
			$this->Az->redirect('admin/users', 'system_message_error', lang('SYSTEM_ERROR'));
		}
		
		$this->db->where('id',$userID);
		$this->db->update('user_det',array('is_active'=>1));
		
		
		$get_user_detail = $this->db->select('first_name,username,decode_password,email_id')->get_where('user_det',array('id'=>$userID))->row_array();
		
		$email = isset($get_user_detail['email_id']) ? $get_user_detail['email_id'] : '';
		$first_name = isset($get_user_detail['first_name']) ? $get_user_detail['first_name'] : '';
		$username = isset($get_user_detail['username']) ? $get_user_detail['username'] : '';
		$password = isset($get_user_detail['decode_password']) ? $get_user_detail['decode_password'] : '';
		
		// send success email to student
		$this->lang->load('common', 'english');
		$this->lang->load('email', 'english');
		$siteName = lang('SITE_NAME');
		
		$final_message = '
		Dear User,
		Thanks for registering on BSS, 
		We have activated your profile, Login Details are below:
		Username - '.$username.'
		Password - '.$password.'
		Thanks again
		Team Bairwa Samaj Sansthan
		179-A, Natraj Vihar, Bhankrota, Jaipur(Raj.) - 302026
		+91-9929228966
		';
		$emailTimeStamp = date('d-m-Y h:i:s');
		$emailTemplate = sprintf((string) lang('REGISTRATION_EMAIL'), site_url(), $siteName,$final_message,$emailTimeStamp);

		$configEmail = array(
			'mailtype' => 'html',
		);

		//send email to user
		$this->load->library('email');
		$this->email->initialize($configEmail);
		$this->email->from('info@bairvasamajsansthan.com', $siteName);
		$this->email->to($email);
		$this->email->cc('bairwasamajsansthan@gmail.com');
		$this->email->subject(lang('PROFILE_ACTIVE_SUB'));
		$this->email->message($emailTemplate);
		$this->email->send();
		
		$this->Az->redirect('admin/users', 'system_message_info', lang('USER_ACTIVE_SUCCESS'));
		
	}
	
	public function delete($userID = 0)
	{
		
		// check user valid or not
		$chk_user = $this->db->get_where('users',array('id'=>$userID))->num_rows();
		if(!$chk_user)
		{
			$this->Az->redirect('admin/users', 'system_message_error', lang('SYSTEM_ERROR'));
		}
		
		$this->db->where('id',$userID);
		$this->db->delete('users');
		$this->Az->redirect('admin/users', 'system_message_info', lang('USER_DELETE_SUCCESS'));
		
	}
	
	
	public function edit($studentID = 0)
    {
        // check student id
        $chk_student_id = $this->db->get_where('users',array('id'=>$studentID,'role_id'=>2))->num_rows();
        if(!$chk_student_id)
        {
            $this->Az->redirect('admin/users', 'system_message_error',lang('COMMON_ERROR'));  
        }

        $studentDetail = $this->db->get_where('users',array('id'=>$studentID,'role_id'=>2))->row_array();

        $loggedUser = $this->User->getLoggedUser("lekker_admin");
        $siteUrl = site_url();
        $data = array(
        'site_url' => $siteUrl,
        'loggedUser' => $loggedUser,
        'meta_title' => lang('SITE_NAME'),
        'meta_keywords' => lang('SITE_NAME'),
        'meta_description' => lang('SITE_NAME'),
        'content_block' => 'users/edit',
        'studentDetail' => $studentDetail,
        'manager_description' => lang('SITE_NAME'),
        'system_message' => $this->Az->getSystemMessageError(),
        'system_info' => $this->Az->getSystemMessageInfo(),
        'system_warning' => $this->Az->getSystemMessageWarning() 
        );
        $this->parser->parse('admin/layout/column-1', $data);

    }

    public function update()
    {

        $post = $this->input->post();
        $recordID = $post['recordID'];
        $this->load->library('form_validation');
        $this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
        $this->form_validation->set_rules('email', 'Email ', 'required|xss_clean|valid_email');
        $this->form_validation->set_rules('mobile', 'Mobile Number', 'required|xss_clean|numeric|max_length[12]');
        if ($this->form_validation->run() == FALSE)
        {
            $this->edit($recordID);
        }
        else
        {
            // check mobile and email already exits or not
            $chk_email_mobile =$this->db->query("SELECT * FROM tbl_users WHERE (email = '$post[email]' or mobile = '$post[mobile]') and id != '$recordID'")->num_rows();
            if(!$chk_email_mobile)
            {
                $data = array(    
					'name'               =>  $post['name'],
					'username'           =>  trim(strtolower($post['email'])),
					'email'              =>  trim(strtolower($post['email'])),
					'mobile'             =>  $post['mobile'],
					'updated'            =>  date('Y-m-d H:i:s')
				);

				if($post['password'])
				{
					$data['password'] = do_hash($post['password']);
					$data['decode_password'] = $post['password'];
				}

				
				$this->db->where('id',$post['recordID']);
				$this->db->update('users',$data);
                
                
                $this->Az->redirect('admin/users', 'system_message_error',lang('STUDENT_UPDATE_SUCCESS')); 
            }
            else{
                $this->Az->redirect('admin/users/edit/'.$recordID, 'system_message_error',lang('STUDENT_MOBILE_EMAIL_ERROR'));
            }

        }
    } 
	
	//USER MANAGEMENT
	


	public function enquiryList()
    {
    
		$users_List = $this->db->select('enquiry.*,bike_type.title as bike_type_name')->join('bike_type','bike_type.id = enquiry.bike_type_id','left')->order_by('enquiry.created','desc')->get("enquiry")->result_array();
        


        $loggedUser = $this->User->getLoggedUser("lekker_admin");   
        $siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
            'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'content_block' => 'pages/enquirylist',
            'manager_description' => lang('SITE_NAME'),
              'users_List'        => $users_List,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
        );
        $this->parser->parse('admin/layout/column-1', $data);
        
    }

    public function deleteEnquiry($id = 0)
	{
		// check course id valid or not
		$chk_id = $this->db->get_where('enquiry',array('id'=>$id))->num_rows();
		if(!$chk_id)
		{
			$this->Az->redirect('admin/users/enquiryList', 'system_message_error',lang('DB_ERROR'));
		}
		
		$this->db->where('id', $id);
		$this->db->delete('enquiry');
		$this->Az->redirect('admin/users/enquiryList', 'system_message_info', lang('ENQUIRY_DELETE_SUCCESS'));


	}
	
	public function downloadUserData()
	{
		// get users list
		$users_list = $this->db->order_by('id','desc')->get_where('users',array('role_id'=>2))->result_array();
		if($users_list)
		{
			$file = "user-data-".date('d-m-Y').".csv";
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment; filename='.$file);
			$content = "#,Name,Email,Mobile\n";
			$i = 1;
			foreach($users_list as $list)
			{
				$content .= $i.",".$list['name'].",".$list['email'].",".$list['mobile']."\n";
				$i++;
			}
			echo $content;
		}
		else
		{
			$this->Az->redirect('admin/users', 'system_message_error',lang('USER_DATA_ERROR'));
		}
	}
	
	public function downloadEnquiryData()
	{
		// get users list
		$users_List = $this->db->select('enquiry.*,bike_type.title as bike_type_name')->join('bike_type','bike_type.id = enquiry.bike_type_id','left')->order_by('enquiry.created','desc')->get("enquiry")->result_array();
		if($users_List)
		{
			$file = "enquiry-user-data-".date('d-m-Y').".csv";
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment; filename='.$file);
			$content = "#,Name,Email,Mobile,Bike Type,Message,Date,Time\n";
			$i = 1;
			foreach($users_List as $list)
			{
				$content .= $i.",".$list['name'].",".$list['email'].",".$list['mobile'].",".$list['bike_type_name'].",".$list['message'].",".date('d-m-Y',strtotime($list['created'])).",".date('H:i:s',strtotime($list['created']))."\n";
				$i++;
			}
			echo $content;
		}
		else
		{
			$this->Az->redirect('admin/users/enquiryList', 'system_message_error',lang('USER_DATA_ERROR'));
		}
	}
}
/* End of file login.php */
/* Location: ./application/controllers/login.php */