<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Addresses extends CI_Controller{

    public function __construct() {
        parent::__construct();
        //load language
		$this->User->checkCustomerPermission();
		
		$this->load->model('admin/Login_model');
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front_common' , 'english');
		$this->load->model('front/Checkout_model');
    }
	
	public function index(){
		
		// get country list
		$countryList = $this->db->order_by('name','asc')->get('countries')->result_array();
		
		// get state list
		$stateList = $this->db->order_by('name','asc')->get_where('states',array('country_code_char2'=>'IN'))->result_array();
		
		$account_id = $this->User->get_logged_user_account_id();

		$addressList = $this->db->get_where('user_address',array('userID'=>$account_id))->result_array();

		
		
		$siteUrl = base_url();
		// echo "<pre>";print_r($siteUrl);die;
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
            'countryList' 		=> $countryList,
			'addressList' 		=> $addressList,
			'stateList' 		=> $stateList,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'customer/addresses'
        );
		// echo "<pre>";print_r($siteUrl);die;
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function addAuth()
	{
		
		$post = $this->input->post();
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('address_line_1', 'Address', 'required|xss_clean');
		$this->form_validation->set_rules('address_line_2', 'Address', 'xss_clean');
		$this->form_validation->set_rules('city', 'City', 'required|xss_clean');
		$this->form_validation->set_rules('postal_code', 'Zip/Postal Code', 'required|xss_clean');
		$this->form_validation->set_rules('phone_number', 'Phone Number', 'required|xss_clean|min_length[10]');
		$this->form_validation->set_rules('state', 'State', 'required|xss_clean');
		$this->form_validation->set_rules('country', 'Country', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->index();
		}
		else
		{
			// update organizer detail
			$address_id = $this->Checkout_model->save_user_address($post);
			$this->Az->redirect('customer/addresses', 'system_message_error',lang('CHECKOUT_ADDRESS_SAVE_SUCCESS'));
		}
		
	}
	
	public function getAddressData($recordID = 0)
	{
		$response = array();
		// get user address list
		$account_id = $this->User->get_logged_user_account_id();

		$addressList = $this->db->get_where('user_address',array('id'=>$recordID,'userID'=>$account_id))->row_array();

		
		if($addressList)
		{
			$response = array(
				'status' 		=> 1,
				'name' 			=> $addressList['name'],
				'phone_number' 	=> $addressList['phone_number'],
				'address_1' 	=> $addressList['address_1'],
				'address_2' 	=> $addressList['address_2'],
				'city' 			=> $addressList['city'],
				'country' 		=> $addressList['country'],
				'state' 		=> $addressList['state'],
				'zip_code' 		=> $addressList['zip_code'],
			);
		}
		else
		{
			$this->session->set_flashdata('system_message_error', lang('DB_ERROR'));
			$response = array(
				'status' => 0,
				'msg' => 'Something Wrong'
			);
		}
		echo json_encode($response);
	}
	
	public function updateCheckoutAdd()
	{
		$response = array();
		$post = $this->input->post();
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('address_line_1', 'Address', 'required|xss_clean');
		$this->form_validation->set_rules('address_line_2', 'Address', 'xss_clean');
		$this->form_validation->set_rules('city', 'City', 'required|xss_clean');
		$this->form_validation->set_rules('postal_code', 'Zip/Postal Code', 'required|xss_clean');
		$this->form_validation->set_rules('phone_number', 'Phone Number', 'required|xss_clean|min_length[10]');
		$this->form_validation->set_rules('state', 'State', 'required|xss_clean');
		$this->form_validation->set_rules('country', 'Country', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$response = array(
				'status' => 0,
				'msg' => validation_errors()
			);
		}
		else
		{
			// update organizer detail
			$this->Checkout_model->update_user_address($post);
			$this->session->set_flashdata('system_message_error', lang('CHECKOUT_ADDRESS_SAVE_SUCCESS'));
			$response = array(
				'status' => 1,
				'msg' => 'Success'
			);
		}
		echo json_encode($response);
	}
	
	public function deleteAddress($recordID = 0)
	{
		$response = array();
		// get user address list
		$account_id = $this->User->get_logged_user_account_id();
		$chkAddress = $this->db->get_where('user_address',array('id'=>$recordID,'userID'=>$account_id))->num_rows();
		if($chkAddress)
		{
			$this->db->where('id',$recordID);
			$this->db->where('userID',$account_id);
			$this->db->delete('user_address');
		
			$this->session->set_flashdata('system_message_error', lang('CHECKOUT_ADDRESS_DELETE_SUCCESS'));
			$response = array(
				'status' => 1,
				'msg' => 'Success'
			);
		}
		else
		{
			$this->session->set_flashdata('system_message_error', lang('DB_ERROR'));
			$response = array(
				'status' => 0,
				'msg' => 'Something Wrong'
			);
		}
		echo json_encode($response);
	}
	
	
	
}


/* End of file login.php */
/* Location: ./application/controllers/login.php */