<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Orders extends CI_Controller{

    public function __construct() {
        parent::__construct();
        //load language
		$this->User->checkCustomerPermission();
		
		$this->load->model('admin/Login_model');
		$this->load->model('front/Order_model');
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front_common' , 'english');
    }
	
	public function index(){
		
		$account_id = $this->User->get_logged_user_account_id();
		
		$orderData = $this->User->get_customer_order_data($account_id);
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
            'orderData' => $orderData,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'customer/orders'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function openOrder(){
		
		$account_id = $this->User->get_logged_user_account_id();
		$orderData = $this->User->get_customer_order_data($account_id,1);
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
            'orderData' => $orderData,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'customer/orders-open'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function cancelOrder(){
		
		$account_id = $this->User->get_logged_user_account_id();
		$orderData = $this->User->get_customer_order_data($account_id,4);
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
            'orderData' => $orderData,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'customer/orders-cancel'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function detail($encoded_order_id = ''){
		
		$account_id = $this->User->get_logged_user_account_id();
		// check order id valid or not
		$chk_address = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();
		if(!$chk_address)
		{
			$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
		}
		
		$orderData = $this->User->get_customer_current_order_data($account_id,$encoded_order_id);
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
            'orderData' => $orderData,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'customer/orders-detail'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function invoice($encoded_order_id = ''){
		
		$account_id = $this->User->get_logged_user_account_id();
		// check order id valid or not
		$chk_address = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();
		if(!$chk_address)
		{
			$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
		}
		
		$orderData = $this->User->get_customer_current_order_data($account_id,$encoded_order_id);
		
		// GET COMPANY DATA
		$companyData = $this->db->select('address,company_name,pan_number,gst_number')->get_where('site_settings',array('id'=>1))->row_array();
		
		$order_id = isset($orderData[0]['id']) ? $orderData[0]['id'] : 0 ;
		// get order invoice data
		$invoiceData = $this->db->select('*')->get_where('order_invoice',array('order_id'=>$order_id,'customer_id'=>$account_id))->row_array();
		
		
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
            'orderData' => $orderData,
            'companyData' => $companyData,
            'invoiceData' => $invoiceData,
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'customer/order-invoice'
        );
        $this->parser->parse('front/layout/column-3' , $data);
    }
	
	
	public function feedback($encoded_order_id = '', $product_id =''){
		
		$account_id = $this->User->get_logged_user_account_id();
		
		// check order id valid or not
		$chk_address = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();

		
		if(!$chk_address)
		{
			$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
		}
		
		$orderData = $this->User->get_customer_current_order_data($account_id,$encoded_order_id);
		
		$order_id = isset($orderData[0]['id']) ? $orderData[0]['id'] : 0 ;
		// check product id valid or not
		$chk_product = $this->db->get_where('order_item_summary',array('order_id'=>$order_id,'customer_id'=>$account_id,'product_id'=>$product_id))->num_rows();
		if(!$chk_product)
		{
			$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
		}
		
		// get vendor name
		$get_vendor_name = $this->db->select('users.name as vendor_name')->join('users','users.id = order_item_summary.vendor_id')->get_where('order_item_summary',array('order_id'=>$order_id,'customer_id'=>$account_id,'product_id'=>$product_id))->row_array();
		$vendor_name = isset($get_vendor_name['vendor_name']) ? $get_vendor_name['vendor_name'] : '';
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
            'orderData' => $orderData,
            'vendor_name' => $vendor_name,
            'encoded_order_id' => $encoded_order_id,
            'product_id' => $product_id,
            'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'customer/seller-review'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function feedbackAuth()
	{
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('encoded_order_id', 'encoded_order_id', 'required|xss_clean');
		$this->form_validation->set_rules('product_id', 'product_id', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->feedback($post['encoded_order_id'],$post['product_id']);
		}
		else
		{
			$encoded_order_id = $post['encoded_order_id'];
			$product_id = $post['product_id'];
			$rating = $post['rating'];
			
			if($rating < 1 || $rating > 5)
			{
				$this->Az->redirect('customer/orders/feedback/'.$encoded_order_id.'/'.$product_id, 'system_message_error',lang('FEEDBACK_RATING_VALID_ERROR'));
			}
			
			$account_id = $this->User->get_logged_user_account_id();
			// check order id valid or not
			$chk_address = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();
			if(!$chk_address)
			{
				$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
			}
			
			$orderData = $this->User->get_customer_current_order_data($account_id,$encoded_order_id);
			
			$order_id = isset($orderData[0]['id']) ? $orderData[0]['id'] : 0 ;
			// check product id valid or not
			$chk_product = $this->db->get_where('order_item_summary',array('order_id'=>$order_id,'customer_id'=>$account_id,'product_id'=>$product_id))->num_rows();
			if(!$chk_product)
			{
				$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
			}
			
			$this->Order_model->save_seller_feedback($post,$account_id,$order_id);
			
			$this->Az->redirect('customer/orders', 'system_message_error',lang('FEEDBACK_RATING_SUCCESS'));
		}
		
	}
	
	public function review($encoded_order_id = '', $product_id = 0){
		
		$account_id = $this->User->get_logged_user_account_id();
		// check order id valid or not
		$chk_address = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();
		if(!$chk_address)
		{
			$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
		}
		
		$orderData = $this->User->get_customer_current_order_data($account_id,$encoded_order_id);
		
		$order_id = isset($orderData[0]['id']) ? $orderData[0]['id'] : 0 ;
		// check product id valid or not
		$chk_product = $this->db->get_where('order_item_summary',array('order_id'=>$order_id,'customer_id'=>$account_id,'product_id'=>$product_id))->num_rows();
		if(!$chk_product)
		{
			$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
		}
		
		// get vendor name
		$get_vendor_name = $this->db->select('users.name as vendor_name')->join('users','users.id = order_item_summary.vendor_id')->get_where('order_item_summary',array('order_id'=> $order_id,'customer_id'=> $account_id,'product_id'=> $product_id))->row_array();
		$vendor_name = isset($get_vendor_name['vendor_name']) ? $get_vendor_name['vendor_name'] : '';
		
		$productData = $this->User->get_current_product_data($product_id);
		
		
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
            'orderData' 		=> $orderData,
            'productData' 		=> $productData,
            'vendor_name' 		=> $vendor_name,
            'encoded_order_id' 	=> $encoded_order_id,
            'product_id' 		=> $product_id,
            'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'customer/product-review'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function reviewAuth()
	{
		$post = $this->input->post();

		$this->load->library('form_validation');
		$this->form_validation->set_rules('encoded_order_id', 'encoded_order_id', 'required|xss_clean');
		$this->form_validation->set_rules('product_id', 'product_id', 'required|xss_clean');

		$this->form_validation->set_rules('comment', 'Comment', 'required|xss_clean');

		if ($this->form_validation->run() == FALSE) {
			
			$this->review($post['encoded_order_id'],$post['product_id']);
		} 
		else
		{
			$encoded_order_id = $post['encoded_order_id'];
			$product_id = $post['product_id'];
			$rating = $post['rating'];
			
			if($rating < 1 || $rating > 5)
			{
				$this->Az->redirect('customer/orders/review/'.$encoded_order_id.'/'.$product_id, 'system_message_error',lang('FEEDBACK_RATING_VALID_ERROR'));
			}
			
			$account_id = $this->User->get_logged_user_account_id();
			// check order id valid or not
			$chk_address = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->num_rows();
			if(!$chk_address)
			{
				$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
			}
			
			$orderData = $this->User->get_customer_current_order_data($account_id,$encoded_order_id);
			
			$order_id = isset($orderData[0]['id']) ? $orderData[0]['id'] : 0 ;
			// check product id valid or not
			$chk_product = $this->db->get_where('order_item_summary',array('order_id'=>$order_id,'customer_id'=>$account_id,'product_id'=>$product_id))->num_rows();
			if(!$chk_product)
			{
				$this->Az->redirect('customer/orders', 'system_message_error',lang('DB_ERROR'));
			}
			
			$this->Order_model->save_product_feedback($post,$account_id,$order_id);
			
			$this->Az->redirect('customer/orders', 'system_message_error',lang('FEEDBACK_RATING_SUCCESS'));
		}
		
	}



	public function sellerFeedbackAuth()
	{
		$post = $this->input->post();
		
		$product_id = $post['product_id'];
		$vendor_id = $post['vendor_id'];
		$rating = $post['rating'];
			
		if($rating < 1 || $rating > 5)
		{
			$this->Az->redirect('VendorProduct/index/'.$vendor_id, 'system_message_error',lang('FEEDBACK_RATING_VALID_ERROR'));
		}
			
		$account_id = $this->User->get_logged_user_account_id();
			
		$this->Order_model->save_seller_rating($post,$account_id);
			
		$this->Az->redirect('VendorProduct/index/'.$vendor_id, 'system_message_error',lang('FEEDBACK_RATING_SUCCESS'));
		
	}

	//cancel customer order


	public function cancel($encoded_order_id=''){
		
		$account_id = $this->User->get_logged_user_account_id();
		$orderData = $this->User->get_customer_order_data($account_id,4);
		
		$chk_order_id = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->row_array();
		
		if($chk_order_id){

			$data = array(

			'status' => 4,	
			'updated'=> date('Y-m-d H:i:s'),
			'updated_by'=> $chk_order_id['customer_id']
			);	
			
		   	$this->db->where('encoded_order_id',$chk_order_id['encoded_order_id']);
			$this->db->update('orders',$data);

			$this->db->where('order_id',$chk_order_id['id']);
			$this->db->update('vendor_orders',$data);

			$get_user_data = $this->db->get_where('users',array('id'=>$chk_order_id['customer_id']))->row_array();
				
		// 	$sms = 'Dear '.$get_user_data['name'].' Your order (#'.$chk_order_id['order_display_id'].') is Cancelled pinkekart.com.';

		// 	if($sms){
			
		// 	$output = '';
				
				
		// 	$mobile = isset($get_user_data['mobile']) ? $get_user_data['mobile'] : '';

		//     $api_url = SMS_API_URL.'authkey='.SMS_API_AUTH_KEY.'&mobiles=91'.$mobile.'&message='.urlencode($sms).'&sender='.SMS_API_SENDERID.'&route=4&country=91';


		//     $ch = curl_init();
		//     curl_setopt($ch, CURLOPT_URL, $api_url);
		//     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		//     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		//     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
		//     $output = curl_exec($ch); 
		//     curl_close($ch);
		// }




			$this->Az->redirect('customer/orders', 'system_message_error',lang('ORDER_CANCEL_SUCCESS'));

		

		
		
		
    }
}
	
	
	
	
}


/* End of file login.php */
/* Location: ./application/controllers/login.php */