<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Security extends CI_Controller{

    public function __construct() {
        parent::__construct();
        //load language
		$this->User->checkCustomerPermission();
		
		$this->load->model('admin/Login_model');
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front_common' , 'english');
    }
	
	public function index(){
		
		$account_id = $this->User->get_logged_user_account_id();
		
		// get user data
		$userData = $this->db->select('name,email,mobile')->get_where('users',array('id'=>$account_id))->row_array();
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
            'userData' 			=> $userData,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'customer/security'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function updateName(){
		
		$account_id = $this->User->get_logged_user_account_id();
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'customer/security-update-name'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function nameUpdateAuth()
	{
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->updateName();
		}
		else
		{
			$account_id = $this->User->get_logged_user_account_id();
			$this->db->where('id',$account_id);
			$this->db->update('users',array('name' => $post['name']));
			
			$this->Az->redirect('customer/security', 'system_message_error',lang('CUSTOMER_NAME_UPDATE_SUCCESS'));
		}
		
	}
	
	public function updatePassword(){
		
		$account_id = $this->User->get_logged_user_account_id();
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
			'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'customer/security-update-password'
        );
        $this->parser->parse('front/layout/column-1' , $data);
    }
	
	public function passwordUpdateAuth()
	{
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('current_password', 'Current Password', 'required|xss_clean');
		$this->form_validation->set_rules('new_password', 'New Password', 'required|xss_clean|min_length[6]');
		$this->form_validation->set_rules('reenter_new_password', 'Confirm New Password', 'required|xss_clean|matches[new_password]');
		if ($this->form_validation->run() == FALSE) {
			
			$this->updatePassword();
		}
		else
		{
			$account_id = $this->User->get_logged_user_account_id();
			
			$current_password = do_hash($post['current_password']);
			$new_password = do_hash($post['new_password']);

			// check current password is valid or not
			$chk_current_pwd = $this->db->get_where('users',array('id' => $account_id,'password'=>$current_password))->num_rows();

			if(!$chk_current_pwd)
			{
				$this->Az->redirect('customer/security/updatePassword', 'system_message_error',lang('CUSTOMER_CURRENT_PASSWORD_VALID_ERROR'));
			}
			
			$this->db->where('id',$account_id);
			$this->db->update('users',array('password' => $new_password,'decode_password' => $post['new_password']));
			
			$this->Az->redirect('customer/security', 'system_message_error',lang('CUSTOMER_CURRENT_PASSWORD_UPDATE_SUCCESS'));
		}
		
	}
	
	
	
}


/* End of file login.php */
/* Location: ./application/controllers/login.php */