<?php
class Coupon extends CI_Controller {    
    
    
    public function __construct() 
    {
        parent::__construct();
       	$this->User->checkVendorPermission();
        $this->load->model('vendor/Coupon_model');		
        $this->load->model('admin/Section_model');		
        $this->lang->load('admin/dashboard', 'english');
        
    } 
    
	
	public function index()
    {
		$loggedUser = $this->User->getLoggedUser("vendor_user");
		
		$cupon_list=$this->db->get_where('coupon',array('account_id'=>$loggedUser['id']))->result_array();
		$siteUrl = site_url();
		$data = array(
            'site_url' => $siteUrl,
            'meta_title' => 'Coupons List',
            'meta_keywords' => 'Coupons List',
            'meta_description' => 'Coupons List',
			'loggedUser' => $loggedUser,	
			'content_block' => 'coupon/couponList',
			'cupon_list'=>$cupon_list,
            'manager_description' => 'Coupons List',
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning()
        );
        $this->parser->parse('vendor/layout/column-1', $data);
		
    }
	
	
	public function addCoupon()
    {
		$loggedUser = $this->User->getLoggedUser("vendor_user");

		// product token
		$token = do_hash(time());
		
		$categoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>0))->result_array();
		$parent_category_list = array();
		$j = 0;
		if($categoryList)
		{
			foreach($categoryList as $key=>$list)
			{
				$parent_category_list[$key]['id'] = $list['id'];
				$parent_category_list[$key]['title'] = $list['title'];
				$parent_category_list[$key]['slug'] = $list['slug'];
				$cat_id = $list['id'];
				$subCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$cat_id))->result_array();
				if($subCategoryList)
				{
					foreach($subCategoryList as $subKey=>$subList)
					{
						$parent_category_list[$key]['subCat'][$subKey]['id'] = $subList['id'];
						$parent_category_list[$key]['subCat'][$subKey]['title'] = $subList['title'];
						$parent_category_list[$key]['subCat'][$subKey]['slug'] = $subList['slug'];
						$j++;
						$sub_cat_id = $subList['id'];
						$subSubCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$sub_cat_id))->result_array();
						if($subSubCategoryList)
						{
							foreach($subSubCategoryList as $subSubKey=>$subSubList)
							{
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['id'] = $subSubList['id'];
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['title'] = $subSubList['title'];
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['slug'] = $subSubList['slug'];
								$j++;
								$sub_sub_cat_id = $subSubList['id'];
								$subSubSubCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$sub_sub_cat_id))->result_array();
								if($subSubSubCategoryList)
								{
									foreach($subSubSubCategoryList as $subSubSubKey=>$subSubSubList)
									{
										$sub_sub_sub_cat_id = $subSubSubList['id'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['id'] = $subSubSubList['id'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['title'] = $subSubSubList['title'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['slug'] = $subSubSubList['slug'];
										$j++;
									}
								}
							}
						}
					}
				}
			}
		}
		
		


		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'parent_category_list'=>$parent_category_list,
            'content_block' => 'coupon/addCoupon',
            'manager_description' => lang('SITE_NAME'),
		    'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('vendor/layout/column-1', $data);
		
    }
   
	
	public function saveCoupon()
	{
		$loggedUser = $this->User->getLoggedUser('vendor_user');
		$userID = $loggedUser['id'];
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('cupon_name', 'Coupon Name', 'required|xss_clean');
		$this->form_validation->set_rules('code', 'Code', 'required|xss_clean');
		$this->form_validation->set_rules('discount', 'Discount', 'numeric|xss_clean');
		$this->form_validation->set_rules('total_amount', 'Total Amount', 'numeric|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->addCoupon();
		}
		else
		{
			
			// update organizer detail
			$this->Coupon_model->save_coupon($post);
			$this->Az->redirect('vendor/coupon', 'system_message_error',lang('CUPON_SAVE_SUCCESS'));
		}
		
	}
	


	public function editCoupon($id = 0)
    {
		$loggedUser = $this->User->getLoggedUser("vendor_user");
		$account_id = $loggedUser['id'];
		// check category valid or not
		$chk_coupon_id = $this->db->get_where('coupon',array('id'=>$id,'account_id'=>$account_id))->num_rows();
		if(!$chk_coupon_id)
		{
			$this->Az->redirect('vendor/coupon', 'system_message_error',lang('CUPON_VALID_ERROR'));
		}
		
		// get coupon data
		$cupon_list = $this->db->get_where('coupon',array('account_id'=>$loggedUser['id'],'id'=>$id))->row_array();
		
		// get coupon category
		$couponCategory = $this->db->get_where('coupon_category',array('account_id'=>$loggedUser['id'],'coupon_id'=>$id))->result_array();
		$couponCategoryId = array();
		if($couponCategory)
		{
			foreach($couponCategory as $cKey=>$cList)
			{
				$couponCategoryId[$cKey] = $cList['category_id'];
			}
		}

		// product token
		$token = do_hash(time());
		$id=$id;
		$categoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>0))->result_array();
		$parent_category_list = array();
		$j = 0;
		if($categoryList)
		{
			foreach($categoryList as $key=>$list)
			{
				$parent_category_list[$key]['id'] = $list['id'];
				$parent_category_list[$key]['title'] = $list['title'];
				$parent_category_list[$key]['slug'] = $list['slug'];
				$cat_id = $list['id'];
				$subCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$cat_id))->result_array();
				if($subCategoryList)
				{
					foreach($subCategoryList as $subKey=>$subList)
					{
						$parent_category_list[$key]['subCat'][$subKey]['id'] = $subList['id'];
						$parent_category_list[$key]['subCat'][$subKey]['title'] = $subList['title'];
						$parent_category_list[$key]['subCat'][$subKey]['slug'] = $subList['slug'];
						$j++;
						$sub_cat_id = $subList['id'];
						$subSubCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$sub_cat_id))->result_array();
						if($subSubCategoryList)
						{
							foreach($subSubCategoryList as $subSubKey=>$subSubList)
							{
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['id'] = $subSubList['id'];
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['title'] = $subSubList['title'];
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['slug'] = $subSubList['slug'];
								$j++;
								$sub_sub_cat_id = $subSubList['id'];
								$subSubSubCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$sub_sub_cat_id))->result_array();
								if($subSubSubCategoryList)
								{
									foreach($subSubSubCategoryList as $subSubSubKey=>$subSubSubList)
									{
										$sub_sub_sub_cat_id = $subSubSubList['id'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['id'] = $subSubSubList['id'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['title'] = $subSubSubList['title'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['slug'] = $subSubSubList['slug'];
										$j++;
									}
								}
							}
						}
					}
				}
			}
		}
		
		


		$siteUrl = site_url();
        $data = array(
            'site_url' => $siteUrl,
			'loggedUser' => $loggedUser,
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'parent_category_list'=>$parent_category_list,
            'content_block' => 'coupon/editCoupon',
            'cupon_list'=>$cupon_list,
            'id'=>$id,
            'couponCategoryId'=>$couponCategoryId,
            'manager_description' => lang('SITE_NAME'),
		    'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getSystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning() 
		);
        $this->parser->parse('vendor/layout/column-1', $data);
		
    }
   
	
	public function updateCoupon()
	{
		$loggedUser = $this->User->getLoggedUser('vendor_user');
		$userID = $loggedUser['id'];
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		$this->form_validation->set_rules('cupon_name', 'Coupon Name', 'required|xss_clean');
		$this->form_validation->set_rules('code', 'Code', 'required|xss_clean');
		$this->form_validation->set_rules('discount', 'Discount', 'numeric|xss_clean');
		$this->form_validation->set_rules('total_amount', 'Total Amount', 'numeric|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			
			$this->editCoupon($post['id']);
		}
		else
		{
			
			// update organizer detail
			$this->Coupon_model->update_coupon($post);
			$this->Az->redirect('vendor/coupon', 'system_message_error',lang('CUPON_UPDATE_SUCCESS'));
		}
		
	}




	public function deleteCoupon($id)
	{

		$this->db->where('id',$id);	
		$this->db->delete('coupon');

		$this->db->where('coupon_id',$id);	
		$this->db->delete('coupon_product');

		$this->db->where('coupon_id',$id);	
		$this->db->delete('coupon_category');

		$this->Az->redirect('vendor/coupon', 'system_message_error',lang('CUPON_DELETE_SUCCESS'));

	}
	
	public function applyCouponAction($action_type = 0)
	{
		$response = array();
		$post = $this->input->post();
		if(!isset($post['coupon_id']) || !$post['coupon_id'])
		{
			$response = array(
				'status' => 0,
				'msg' => 'Please select coupon.'
			);
		}
		else
		{
			if($action_type == 1)
			{
				$this->db->where_in('id',$post['coupon_id']);
				$this->db->update('coupon',array('status'=>1));
				$response = array(
					'status' => 1,
					'msg' => 'Coupon enabled successfully.'
				);
			}
			elseif($action_type == 2)
			{
				$this->db->where_in('id',$post['coupon_id']);
				$this->db->update('coupon',array('status'=>0));
				$response = array(
					'status' => 1,
					'msg' => 'Coupon disabled successfully.'
				);
			}
			elseif($action_type == 3)
			{
				foreach($post['coupon_id'] as $coupon_id){
					$this->db->where('id',$coupon_id);	
					$this->db->delete('coupon');

					$this->db->where('coupon_id',$coupon_id);	
					$this->db->delete('coupon_product');

					$this->db->where('coupon_id',$coupon_id);	
					$this->db->delete('coupon_category');
				}
				$response = array(
					'status' => 1,
					'msg' => 'Coupon Deleted Successfully.'
				);
			}
			
		}
		
		echo json_encode($response);
	}


	
	
}
?>