<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Login extends CI_Controller{

    public function __construct() {
        parent::__construct();
		
        //load language
        $this->lang->load('front_common' , 'english');
        $this->lang->load('front_login' , 'english');
		$this->lang->load('front/message', 'english');
		//load Model
		$this->load->model('admin/Login_model');
    }

    public function index($uname_prefix = '' , $username = ''){
		
    	$user = $this->session->userdata('pinkekart_vendor_session');
	
		if($user)
		{
			redirect('vendor/dashboard');
		}
		$siteUrl = base_url();
		$data = array(
            'meta_title' 		=> lang('SITE_NAME'),
            'meta_keywords' 	=> lang('SITE_NAME'),
            'meta_description' 	=> lang('SITE_NAME'),
            'site_url' 			=> $siteUrl,
            'system_message' 	=> $this->Az->getSystemMessageError(),
            'system_info' 		=> $this->Az->getsystemMessageInfo(),
            'system_warning' 	=> $this->Az->getSystemMessageWarning(),
            'content_block' 	=> 'vendor-login'
        );
        $this->parser->parse('front/layout/column-2' , $data);
    }
	
	public function auth()
	{
		$post = $this->input->post();
	

		$this->load->library('form_validation');
		$this->form_validation->set_rules('username', 'Email/Mobile', 'required|xss_clean');
		$this->form_validation->set_rules('password', 'Password', 'required|xss_clean');
		$this->form_validation->set_rules('return_url', 'return_url', 'xss_clean');

		if ($this->form_validation->run() == FALSE) {
			
			$this->index();
		}
		else
		{
			
			$username = trim(strtolower($post['username']));
			$password = do_hash($post['password']);
			
			// check user exits or not
			$chk_user = $this->db->query("SELECT * from tbl_users where (username = '$username' or mobile = '$username') AND password = '$password'")->num_rows();
			
			if($chk_user)
			{
				$get_user_data = $this->db->query("SELECT id,role_id,name,is_active from tbl_users where (username = '$username' or mobile = '$username') AND password = '$password'")->row_array();

				$is_active = isset($get_user_data['is_active']) ? $get_user_data['is_active'] : 0 ;
				$role_id = isset($get_user_data['role_id']) ? $get_user_data['role_id'] : 0 ;

				if($is_active == 0)
				{
					$this->Az->redirect('login', 'system_message_error',lang('USER_PROFILE_ACTIVE_ERROR'));
				}
				
				if($role_id == 3)
				{
					$user_ip_address = $_SERVER['REMOTE_ADDR'];
					// update cart temp data
					$this->db->where('ip',$user_ip_address);
					$this->db->update('cart_temp_data',array('user_id'=>$get_user_data['id']));
					
					$this->session->set_userdata('pinkekart_vendor_session',$get_user_data);
					if($post['return_url'] && $post['return_url'] == 'checkout'){
						$this->Az->redirect('checkout');	
					}
					else
					{
						$this->Az->redirect('vendor/dashboard');	
					}
				}
				
				elseif($role_id == 4)
				{
					$user_ip_address = $_SERVER['REMOTE_ADDR'];
					// update cart temp data
					$this->db->where('ip',$user_ip_address);
					$this->db->update('cart_temp_data',array('user_id'=>$get_user_data['id']));
					
					$this->session->set_userdata('pinkekart_customer_session',$get_user_data);
					if($post['return_url'] && $post['return_url'] == 'checkout'){
						$this->Az->redirect('checkout');	
					}
					else
					{
						$this->Az->redirect('customer/dashboard');	
					}
				}
				else
				{
					$this->Az->redirect('login', 'system_message_error',lang('COMMON_ERROR'));
				}
				
				
			}
			else
			{
				$this->Az->redirect('vendor/login', 'system_message_error',lang('USER_LOGIN_ERROR'));
			}
			
		}
		
	}
}


/* End of file login.php */
/* Location: ./application/controllers/login.php */