<?php
if(!defined('BASEPATH'))
    exit('No direct scrip access allowed');

/*
 * login Register controller for Frontend
 * 
 * this controller user for login, register, logout, forgot password, reset password
 * @author trilok
 */

class Profile extends CI_Controller{

    public function __construct() {
        parent::__construct();
        //load language
		$this->User->checkVendorPermission();
		$this->load->model('admin/Profile_model');
        $this->lang->load('admin/dashboard', 'english');
        $this->lang->load('front_common' , 'english');
    }
	
	
	
	
	public function index(){
		//get logged user info
        $loggedUser = $this->User->getLoggedUser("vendor_user");
		$account_id = $loggedUser['id'];
		
		$vendor_data = $this->db->get_where('users',array('id'=>$account_id))->row_array();
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
			'loggedUser'  => $loggedUser,
			'vendor_data' => $vendor_data,
            'page_title' => 'Update Profile',
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'profile/profile'
        );
        $this->parser->parse('vendor/layout/column-1' , $data);
    }
	
	
	
	public function updateProfile() {
        
		$this->load->library('template');
        $siteUrl = site_url();
		$post = $this->input->post();
		
        //get logged user info
        $loggedUser = $this->User->getLoggedUser('vendor_user');
        $account_id = $loggedUser['id'];

        //check for foem validation
        $this->load->library('form_validation');
        $this->form_validation->set_rules('name', 'Name', 'required|xss_clean');		
        if ($this->form_validation->run() == FALSE) {
			
			$this->index();
        } 
		else {
		    
		    
		    $image = '';
			if ($_FILES['image']['name'] != '') {
				//generate logo name randomly
				$fileName = rand(1111, 999999999);
				$config['upload_path'] = './media/banner_images/';
				$config['allowed_types'] = 'jpg|png|gif';
				$config['file_name'] = $fileName;
				$this->load->library('upload');
				$this->upload->initialize($config);
				$this->upload->do_upload('image');
				$uploadError = $this->upload->display_errors();
				if ($uploadError) {
					 $this->Az->redirect('vendor/profile', 'system_message_error', $uploadError);
				} else {
					   
					$fileData = $this->upload->data();
					//get uploaded file path
					$image = substr($config['upload_path'] . $fileData['file_name'], 2);
				}
			}
		    
			
            $data = array(
             'name' => $post['name'],
             'page_image'=>isset($image) ? $image : '' 
            );
            $this->db->where('id',$account_id);
            $this->db->update('users',$data);
			$this->Az->redirect('vendor/profile', 'system_message_error',lang('PROFILE_UPDATE_SUCCESSFULLY'));
			
			 
		}
		
    }
	
	
	
	
	
	
	public function changePassword($uname_prefix = '' , $username = ''){
		//get logged user info
        $loggedUser = $this->User->getLoggedUser("vendor_user");
		$account_id = $loggedUser['id'];
		
		$siteUrl = base_url();
		$data = array(
            'meta_title' => lang('SITE_NAME'),
            'meta_keywords' => lang('SITE_NAME'),
            'meta_description' => lang('SITE_NAME'),
            'site_url' => $siteUrl,
			'loggedUser'  => $loggedUser,
            'page_title' => 'Change Password',
			'system_message' => $this->Az->getSystemMessageError(),
            'system_info' => $this->Az->getsystemMessageInfo(),
            'system_warning' => $this->Az->getSystemMessageWarning(),
            'content_block' => 'profile/changePassword'
        );
        $this->parser->parse('vendor/layout/column-1' , $data);
    }
	
	
	
	public function update() {
        
		$this->load->library('template');
        $siteUrl = site_url();
		$post = $this->input->post();
		
        //get logged user info
        $loggedUser = $this->User->getLoggedUser('vendor_user');
        $account_id = $loggedUser['id'];

        //check for foem validation
        $this->load->library('form_validation');
        $this->form_validation->set_rules('opw', 'Old Password', 'required|xss_clean');		
        $this->form_validation->set_rules('npw', 'New Password', 'required|xss_clean');     
        $this->form_validation->set_rules('cpw', 'Confirm New Password', 'required|xss_clean|matches[npw]');     
        if ($this->form_validation->run() == FALSE) {
			
			$this->changePassword();
        } 
		else {
			
            // check old password valid or not
            $chk_old_pwd = $this->db->get_where('users',array('id'=>$account_id,'password'=>do_hash($post['opw'])))->num_rows();
            if(!$chk_old_pwd)
            {
                $this->Az->redirect('vendor/profile/changePassword', 'system_message_error',lang('OLD_PASSWORD_FAILED'));   
            }

			$this->Profile_model->updateAdminPassword($post,$account_id);
			
			$this->Az->redirect('vendor/profile/changePassword', 'system_message_error',lang('PASSWORD_UPDATE_SUCCESSFULLY'));
			
			 
		}
		
    }
    
    
    
	
	
	
	
	
}


/* End of file login.php */
/* Location: ./application/controllers/login.php */