<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * Model used for setup default message and resize image
 * 
 * This one used for defined some methods accross all site.
 * this one used for show system message, errors.
 * this one used for image resizing
 * @author trilok
 */

require_once BASEPATH . '/core/Model.php';

class Catalog_model extends CI_Model 
{ 

    public function __construct() 
    {
 		parent::__construct();
    }
    
	public function save_category($post,$image = '')
	{
		$slug = url_title($post['title'], 'dash', true);
		$data = array(
			'title' => $post['title'],
			'slug' => $slug,
			'parent_id' => $post['parent_cat_id'],
			'menu_status' => $post['menu_status'],
			'banner'      => isset($image) ? $image : '',
			'status' => $post['status'],
			'created' => date('Y-m-d H:i:s')
		);
		
		
		if($post['parent_cat_id'] == 0){
		    
		    
		    if(!$post['order_no'])
    		{
    			// get last block position
    			$get_last_order = $this->db->order_by('order_no','desc')->get_where('category',array('parent_id'=>0))->row_array();
    			$order = isset($get_last_order['order_no']) ? $get_last_order['order_no'] + 1 : 1 ;
    			$data['order_no'] = $order;
    		}
		    else{
		     $data['order_no'] = $post['order_no'];    
		    }
		    
		    
		}
		
		$this->db->insert('category',$data);
		return true;
	
	}
	
	public function update_category($post,$image = '')
	{
		$slug = url_title($post['title'], 'dash', true);	
		$data = array(
			'title' => $post['title'],
			'slug' => $slug,
			'parent_id' => $post['parent_cat_id'],
			'menu_status' => $post['menu_status'],
			'status' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		
		if($image != ''){
		   $data['banner'] = $image; 
		}
		
		if($post['parent_cat_id'] == 0){
		    
		    
		    if(!$post['order_no'])
    		{
    			// get last block position
    			$get_last_order = $this->db->order_by('order_no','desc')->get_where('category',array('parent_id'=>0))->row_array();
    			$order = isset($get_last_order['order_no']) ? $get_last_order['order_no'] + 1 : 1 ;
    			$data['order_no'] = $order;
    		}
		    else{
		     $data['order_no'] = $post['order_no'];    
		    }
		    
		    
		}
		
		$this->db->where('id',$post['catID']);
		$this->db->update('category',$data);
		return true;
	
	}
	
	public function save_product_data($post)
	{
		$is_variation = 0;
		$variation_variable = '';
		$variation_attribute_id = array();
		if($post['variation_theme_id'])
		{
			$is_variation = 1;
			$explode_theme_id = explode('_',$post['variation_theme_id']);
			
			$is_combo = isset($explode_theme_id[0]) ? $explode_theme_id[0] : 0 ;
			if($is_combo == 0)
			{
				
				$variation_variable = 'attribute_1';
				$attribute_id = isset($explode_theme_id[1]) ? $explode_theme_id[1] : 0 ;
				$variation_attribute_id['attribute_1'] = $attribute_id;
			}
			else
			{
				$attribute_1_id = isset($explode_theme_id[1]) ? $explode_theme_id[1] : 0 ;
				$attribute_2_id = isset($explode_theme_id[2]) ? $explode_theme_id[2] : 0 ;
				$attribute_3_id = isset($explode_theme_id[3]) ? $explode_theme_id[3] : 0 ;
				$attribute_4_id = isset($explode_theme_id[4]) ? $explode_theme_id[4] : 0 ;
				$attribute_5_id = isset($explode_theme_id[5]) ? $explode_theme_id[5] : 0 ;
				if($attribute_1_id)
				{
					$variation_variable.='attribute_1|';
					$variation_attribute_id['attribute_1'] = $attribute_1_id;
				}
				if($attribute_2_id)
				{
					$variation_variable.='attribute_2|';
					$variation_attribute_id['attribute_2'] = $attribute_2_id;
				}
				if($attribute_3_id)
				{
					$variation_variable.='attribute_3|';
					$variation_attribute_id['attribute_3'] = $attribute_3_id;
				}
				if($attribute_4_id)
				{
					$variation_variable.='attribute_4|';
					$variation_attribute_id['attribute_4'] = $attribute_4_id;
				}
				if($attribute_5_id)
				{
					$variation_variable.='attribute_5|';
					$variation_attribute_id['attribute_5'] = $attribute_5_id;
				}
				
			}
		}
		
		$account_id = 1;
		$slug = url_title($post['product_name'].time().rand(1111,9999), 'dash', true);
		$data = array(
			'account_id' => $account_id,
			'product_name' => $post['product_name'],
			'slug' => $slug,
			'sku' => $post['sku'],
			'hsncode' => $post['hsncode'],
			'tax_rule_id' => $post['tax_rule_id'],
			'price' => $post['price'],
			'special_price' => $post['special_price'],
			'special_price_from' => ($post['special_price_from']) ? date('Y-m-d',strtotime($post['special_price_from'])) : '',
			'special_price_to' => ($post['special_price_to']) ? date('Y-m-d',strtotime($post['special_price_to'])) : '',
			'weight' => $post['weight'],
			'weight_unit' => $post['weight_unit'],
			'visibility' => $post['product_visibility'],
			'quantity' => $post['quantity'],
			'stock_status' => $post['stock_status'],
			'image_token' => $post['token'],
			'attribute_set_id' => $post['attribute_set_id'],
			'is_variation' => $is_variation,
			'variation_variable' => $variation_variable,
			'short_description' => $post['short_description'],
			'description' => $post['description'],
			'instruction' => isset($post['instruction']) ? implode('|',$post['instruction']) : '',
			'status' => $post['status'],
			'approve_status' => 2,
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('products',$data);
		$product_id = $this->db->insert_id();
		
		
		// save product variation attribute
		if($is_variation && $variation_attribute_id)
		{
			
			$variation_attribute_data = array(
				'account_id' => $account_id,
				'product_id' => $product_id,
				'is_combo' => $is_combo,
				'attribute_1' => isset($variation_attribute_id['attribute_1']) ? $variation_attribute_id['attribute_1'] : 0,
				'attribute_2' => isset($variation_attribute_id['attribute_2']) ? $variation_attribute_id['attribute_2'] : 0,
				'attribute_3' => isset($variation_attribute_id['attribute_3']) ? $variation_attribute_id['attribute_3'] : 0,
				'attribute_4' => isset($variation_attribute_id['attribute_4']) ? $variation_attribute_id['attribute_4'] : 0,
				'attribute_5' => isset($variation_attribute_id['attribute_5']) ? $variation_attribute_id['attribute_5'] : 0,
			);
			$this->db->insert('product_variation_attribute',$variation_attribute_data);
		}
		
		
		// save product sku
		$product_sku_data = array(
			'account_id' => $account_id,
			'is_main_product' => 1,
			'product_id' => $product_id,
			'sku' => $post['sku'],
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('product_sku',$product_sku_data);
		
		
		
		
		
		// save product category
		if(isset($post['category_id']))
		{
			foreach($post['category_id'] as $catID)
			{
				$catData = array(
					'account_id' => $account_id,
					'product_id' => $product_id,
					'category_id' => $catID
				);
				$this->db->insert('product_category',$catData);
			}
		}
		
		// save product brands
		if(isset($post['brand']))
		{
			foreach($post['brand'] as $brand_id)
			{
				$catData = array(
					'account_id' => $account_id,
					'product_id' => $product_id,
					'brand_id' => $brand_id
				);
				$this->db->insert('product_brands',$catData);
			}
		}
		
		// save product offer data
		$offer_start_date = ($post['offer_start_date']) ? date('Y-m-d',strtotime($post['offer_start_date'])) : '';
		$offer_end_date = ($post['offer_end_date']) ? date('Y-m-d',strtotime($post['offer_end_date'])) : '';
		$offer_code = $post['offer_code'];
		$offer_type = $post['offer_type'];
		$offer_type_value = $post['offer_type_value'];
		
		$offerData = array(
			'account_id' => $account_id,
			'product_id' => $product_id,
			'offer_start_date' => $offer_start_date,
			'offer_end_date' => $offer_end_date,
			'offer_code' => $offer_code,
			'offer_type' => $offer_type,
			'offer_type_value' => $offer_type_value,
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('product_offer',$offerData);
		
		
		// save product meta data
		$meta_title = $post['meta_title'];
		$meta_description = $post['meta_description'];
		$meta_keyword = $post['meta_keyword'];
		
		$metaData = array(
			'account_id' => $account_id,
			'product_id' => $product_id,
			'meta_title' => $meta_title,
			'meta_description' => $meta_description,
			'meta_keyword' => $meta_keyword,
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('product_meta_data',$metaData);
		
		// get all token images
		$imageList = $this->db->get_where('product_image_temp_data',array('token'=>$post['token'],'row_no IS NULL'))->result_array();
		if($imageList)
		{
			foreach($imageList as $imgList)
			{
				$image_id = $imgList['id'];
				$image_path = $imgList['image_path'];
				$file_name = $imgList['file_name'];
				$is_base = 0;
				$is_small = 0;
				$is_thumbnail = 0;
				$is_large = 0;
				if($imgList['type'] == 1)
				{
					$is_base = 1;
				}
				else{
					$is_large = 1;
				}
				
				$imageData = array(
					'account_id' => $account_id,
					'product_id' => $product_id,
					'is_base' => $is_base,
					'is_small' => $is_small,
					'is_thumbnail' => $is_thumbnail,
					'is_large' => $is_large,
					'image_path' => $image_path,
					'file_name' => $file_name,
				);
				$this->db->insert('product_images',$imageData);
			}
		}
		
		// save all attribute data
		$attribute_set_id = $post['attribute_set_id'];
		$attributeList = $this->db->select('attribute.*')->join('attribute','attribute.id = attribute_set_attributes.attribute_id')->get_where('attribute_set_attributes',array('attribute_set_id'=>$attribute_set_id))->result_array();
		if($attributeList)
		{
			foreach($attributeList as $list)
			{
				$attribute_id = $list['id'];
				$form_type = $list['form_type'];
				$is_input_box = $list['is_input_box'];
				
				if($form_type == 4)
				{
					$attribute_value = isset($post['attribute_'.$attribute_id]) ? $post['attribute_'.$attribute_id] : array();
					
					if($attribute_value)
					{
						foreach($attribute_value as $val){
							$attribute_data = array(
								'account_id' => $account_id,
								'product_id' => $product_id,
								'attribute_id' => $attribute_id,
								'attribute_value' => $val
							);
							$this->db->insert('product_attribute',$attribute_data);
						}
					}
				}
				else
				{
					$attribute_value = isset($post['attribute_'.$attribute_id]) ? $post['attribute_'.$attribute_id] : 0;
					$attribute_input_value = isset($post['attribute_value_'.$attribute_id]) ? $post['attribute_value_'.$attribute_id] : '';
					
					if($attribute_value)
					{
						$attribute_data = array(
							'account_id' => $account_id,
							'product_id' => $product_id,
							'attribute_id' => $attribute_id,
							'attribute_value' => $attribute_value,
							'attribute_input_value' => $attribute_input_value
						);
						$this->db->insert('product_attribute',$attribute_data);
					}
				}
			}
		}
		
		// save variation theme data
		$variation_theme_id = $post['variation_theme_id'];
		if(isset($post['theme_data']) && $post['theme_data'])
		{
			$v_atr_data = array();
			$v_i = 1;
			if($variation_attribute_id)
			{
				foreach($variation_attribute_id as $v_atr_id)
				{
					//$attributeData = $this->db->get_where('attribute',array('id'=>$first_attribute_id))->row_array();
					$v_atr_data[$v_i] = $v_atr_id;
					$v_i++;
				}
			}
			// variation variable
			$explode_var_variable = array_filter(explode('|',$variation_variable));
			
			foreach($post['theme_data'] as $variation_order_no=>$variation_val)
			{
				$first_attribute_id = 0;
				$first_option_data = '';
				
				$second_attribute_id = 0;
				$second_option_data = '';
				
				$third_attribute_id = 0;
				$third_option_data = '';
				
				$fourth_attribute_id = 0;
				$fourth_option_data = '';
				
				$fifth_attribute_id = 0;
				$fifth_option_data = '';
				
				if($variation_val){
					foreach($variation_val as $v_order_no=>$v_val){
						
						
						
						$variation_theme_data = array(
							'account_id' => $account_id,
							'product_id' => $product_id,
							'attribute_id' => isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0,
							'option_data' => $v_val
						);
						$this->db->insert('product_variation_theme_data',$variation_theme_data);
						
						if($v_order_no == 1)
						{
							$first_attribute_id = isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0;
							$first_option_data = $v_val;
						}
						elseif($v_order_no == 2)
						{
							$second_attribute_id = isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0;
							$second_option_data = $v_val;
						}
						elseif($v_order_no == 3)
						{
							$third_attribute_id = isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0;
							$third_option_data = $v_val;
						}
						elseif($v_order_no == 4)
						{
							$fourth_attribute_id = isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0;
							$fourth_option_data = $v_val;
						}
						elseif($v_order_no == 5)
						{
							$fifth_attribute_id = isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0;
							$fifth_option_data = $v_val;
						}
					}
				}
				
				$color_map = isset($post['theme_color_map'][$variation_order_no]) ? $post['theme_color_map'][$variation_order_no] : '';
				$unit = isset($post['theme_unit'][$variation_order_no]) ? $post['theme_unit'][$variation_order_no] : '';
				$sku = isset($post['theme_sku'][$variation_order_no]) ? $post['theme_sku'][$variation_order_no] : '';
				$hsncode = isset($post['theme_hsncode'][$variation_order_no]) ? $post['theme_hsncode'][$variation_order_no] : '';
				$tax_rule_id = isset($post['theme_tax_rule_id'][$variation_order_no]) ? $post['theme_tax_rule_id'][$variation_order_no] : '';
				$price = isset($post['theme_price'][$variation_order_no]) ? $post['theme_price'][$variation_order_no] : '';
				$discount_price = isset($post['theme_discount_price'][$variation_order_no]) ? $post['theme_discount_price'][$variation_order_no] : '';
				$quantity = isset($post['theme_qty'][$variation_order_no]) ? $post['theme_qty'][$variation_order_no] : '';
				$stock_status = isset($post['theme_stock'][$variation_order_no]) ? $post['theme_stock'][$variation_order_no] : '';
				$variation_status = isset($post['theme_status'][$variation_order_no]) ? $post['theme_status'][$variation_order_no] : '';
				$variation_desc = isset($post['variation_description'][$variation_order_no]) ? $post['variation_description'][$variation_order_no] : '';
				
				$variation_product_data = array(
					'account_id' => $account_id,
					'product_id' => $product_id,
					'variation_order_no' => $variation_order_no,
					'first_attribute_id' => $first_attribute_id,
					'first_option_data' => $first_option_data,
					'second_attribute_id' => $second_attribute_id,
					'second_option_data' => $second_option_data,
					'third_attribute_id' => $third_attribute_id,
					'third_option_data' => $third_option_data,
					'fourth_attribute_id' => $fourth_attribute_id,
					'fourth_option_data' => $fourth_option_data,
					'fifth_attribute_id' => $fifth_attribute_id,
					'fifth_option_data' => $fifth_option_data,
					'color_map' => $color_map,
					'unit' => $unit,
					'sku' => $sku,
					'hsncode' => $hsncode,
					'tax_rule_id' => $tax_rule_id,
					'price' => $price,
					'discount_price' => $discount_price,
					'quantity' => $quantity,
					'stock_status' => $stock_status,
					'variation_status' => $variation_status,
					'description' => $variation_desc,
					'created' => date('Y-m-d H:i:s')
				);
				$this->db->insert('product_variation_product_data',$variation_product_data);
				$variation_product_id = $this->db->insert_id();
				
				
				// save product sku
				$product_sku_data = array(
					'account_id' => $account_id,
					'is_variation_product' => 1,
					'product_id' => $product_id,
					'variation_product_id' => $variation_product_id,
					'sku' => $sku,
					'created' => date('Y-m-d H:i:s')
				);
				$this->db->insert('product_sku',$product_sku_data);
				
				if(isset($post['variation_instruction'][$variation_order_no]) && $post['variation_instruction'][$variation_order_no])
				{
					$v_ins_order_no = 1;
					foreach($post['variation_instruction'][$variation_order_no] as $v_ins)
					{
						if($v_ins){
							// save variation product instructions
							$variation_instruction_data = array(
								'account_id' => $account_id,
								'product_id' => $product_id,
								'variation_product_id' => $variation_product_id,
								'instruction' => $v_ins,
								'order_no' => $v_ins_order_no
							);
							$this->db->insert('product_variation_product_instruction',$variation_instruction_data);
							$v_ins_order_no++;
						}
					}
				}
				
				// get all token images for vaiation
				$vImageList = $this->db->get_where('product_image_temp_data',array('token'=>$post['token'],'row_no'=>$variation_order_no))->result_array();
				if($vImageList)
				{
					foreach($vImageList as $imgList)
					{
						$image_id = $imgList['id'];
						$image_path = $imgList['image_path'];
						$file_name = $imgList['file_name'];
						$is_base = 0;
						$is_large = 0;
						if($imgList['type'] == 1)
						{
							$is_base = 1;
						}
						else{
							$is_large = 1;
						}
						
						$vImageData = array(
							'account_id' => $account_id,
							'product_id' => $product_id,
							'variation_product_id' => $variation_product_id,
							'is_base' => $is_base,
							'is_large' => $is_large,
							'image_path' => $image_path,
							'file_name' => $file_name,
						);
						$this->db->insert('product_variation_product_images',$vImageData);
					}
				}
				
			}
		}
		
		
		
		
		return true;
	
	}
	
	
	public function update_product_data($post)
	{
		
		$slug = url_title($post['product_name'].time().rand(1111,9999), 'dash', true);
		$data = array(
			'product_name' => $post['product_name'],
			'slug' => $slug,
			'sku' => $post['sku'],
			'hsncode' => $post['hsncode'],
			'tax_rule_id' => $post['tax_rule_id'],
			'price' => $post['price'],
			'special_price' => $post['special_price'],
			'special_price_from' => ($post['special_price_from']) ? date('Y-m-d',strtotime($post['special_price_from'])) : '',
			'special_price_to' => ($post['special_price_to']) ? date('Y-m-d',strtotime($post['special_price_to'])) : '',
			'visibility' => $post['product_visibility'],
			'quantity' => $post['quantity'],
			'stock_status' => $post['stock_status'],
			'image_token' => $post['token'],
			'short_description' => $post['short_description'],
			'description' => $post['description'],
			'instruction' => isset($post['instruction']) ? implode('|',$post['instruction']) : '',
			'status' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		$this->db->where('id',$post['product_id']);
		$this->db->update('products',$data);
		$product_id = $post['product_id'];
		
		// get product account_id
		$get_pro_account_id = $this->db->select('account_id')->get_where('products',array('id'=>$product_id))->row_array();
		$account_id = isset($get_pro_account_id['account_id']) ? $get_pro_account_id['account_id'] : 0 ;
		
		
		// save product category
		if(isset($post['category_id']))
		{
			$this->db->where('account_id',$account_id);
			$this->db->where('product_id',$product_id);
			$this->db->delete('product_category');
			foreach($post['category_id'] as $catID)
			{
				$catData = array(
					'account_id' => $account_id,
					'product_id' => $product_id,
					'category_id' => $catID
				);
				$this->db->insert('product_category',$catData);
			}
		}
		
		// save product brands
		if(isset($post['brand']))
		{
			$this->db->where('account_id',$account_id);
			$this->db->where('product_id',$product_id);
			$this->db->delete('product_brands');
			foreach($post['brand'] as $brand_id)
			{
				$catData = array(
					'account_id' => $account_id,
					'product_id' => $product_id,
					'brand_id' => $brand_id
				);
				$this->db->insert('product_brands',$catData);
			}
		}
		
		// save product offer data
		$offer_start_date = ($post['offer_start_date']) ? date('Y-m-d',strtotime($post['offer_start_date'])) : '';
		$offer_end_date = ($post['offer_end_date']) ? date('Y-m-d',strtotime($post['offer_end_date'])) : '';
		$offer_code = $post['offer_code'];
		$offer_type = $post['offer_type'];
		$offer_type_value = $post['offer_type_value'];
		
		$offerData = array(
			'offer_start_date' => $offer_start_date,
			'offer_end_date' => $offer_end_date,
			'offer_code' => $offer_code,
			'offer_type' => $offer_type,
			'offer_type_value' => $offer_type_value,
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->where('account_id',$account_id);
		$this->db->where('product_id',$product_id);
		$this->db->update('product_offer',$offerData);
		
		
		// save product meta data
		$meta_title = $post['meta_title'];
		$meta_description = $post['meta_description'];
		$meta_keyword = $post['meta_keyword'];
		
		$metaData = array(
			'meta_title' => $meta_title,
			'meta_description' => $meta_description,
			'meta_keyword' => $meta_keyword,
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->where('account_id',$account_id);
		$this->db->where('product_id',$product_id);
		$this->db->update('product_meta_data',$metaData);
		
		// get all token images
		$imageList = $this->db->get_where('product_image_temp_data',array('token'=>$post['token'],'row_no IS NULL'))->result_array();
		if($imageList)
		{
			foreach($imageList as $imgList)
			{
				$image_id = $imgList['id'];
				$image_path = $imgList['image_path'];
				$file_name = $imgList['file_name'];
				$is_base = 0;
				$is_small = 0;
				$is_thumbnail = 0;
				$is_large = 0;
				if($imgList['type'] == 1)
				{
					$is_base = 1;
				}
				else{
					$is_large = 1;
				}
				
				$imageData = array(
					'account_id' => $account_id,
					'product_id' => $product_id,
					'is_base' => $is_base,
					'is_small' => $is_small,
					'is_thumbnail' => $is_thumbnail,
					'is_large' => $is_large,
					'image_path' => $image_path,
					'file_name' => $file_name,
				);
				$this->db->insert('product_images',$imageData);
			}
		}
		
		// get product attribute set id
		$get_attribute_set_id = $this->db->select('attribute_set_id')->get_where('products',array('id'=>$product_id))->row_array();
		// save all attribute data
		$attribute_set_id = isset($get_attribute_set_id['attribute_set_id']) ? $get_attribute_set_id['attribute_set_id'] : 0 ;
		$attributeList = $this->db->select('attribute.*')->join('attribute','attribute.id = attribute_set_attributes.attribute_id')->get_where('attribute_set_attributes',array('attribute_set_id'=>$attribute_set_id))->result_array();
		if($attributeList)
		{
			foreach($attributeList as $list)
			{
				$attribute_id = $list['id'];
				$form_type = $list['form_type'];
				$is_input_box = $list['is_input_box'];
				
				if($form_type == 4)
				{
					$attribute_value = isset($post['attribute_'.$attribute_id]) ? $post['attribute_'.$attribute_id] : array();
					
					if($attribute_value)
					{
						foreach($attribute_value as $val){
							// check attribute already saved or not
							$chk_pro_attribute = $this->db->get_where('product_attribute',array('account_id'=>$account_id,'product_id'=>$product_id,'attribute_id'=>$attribute_id))->num_rows();
							if($chk_pro_attribute){
								$attribute_data = array(
									'attribute_value' => $val
								);
								$this->db->where('account_id',$account_id);
								$this->db->where('product_id',$product_id);
								$this->db->where('attribute_id',$attribute_id);
								$this->db->update('product_attribute',$attribute_data);
							}
							else
							{
								$attribute_data = array(
									'account_id' => $account_id,
									'product_id' => $product_id,
									'attribute_id' => $attribute_id,
									'attribute_value' => $val
								);
								$this->db->insert('product_attribute',$attribute_data);
							}
						}
					}
				}
				else
				{
					$attribute_value = isset($post['attribute_'.$attribute_id]) ? $post['attribute_'.$attribute_id] : 0;
					$attribute_input_value = isset($post['attribute_value_'.$attribute_id]) ? $post['attribute_value_'.$attribute_id] : '';
					
					if($attribute_value)
					{
						// check attribute already saved or not
						$chk_pro_attribute = $this->db->get_where('product_attribute',array('account_id'=>$account_id,'product_id'=>$product_id,'attribute_id'=>$attribute_id))->num_rows();
						if($chk_pro_attribute){
							$attribute_data = array(
								'attribute_value' => $attribute_value,
								'attribute_input_value' => $attribute_input_value
							);
							$this->db->where('account_id',$account_id);
							$this->db->where('product_id',$product_id);
							$this->db->where('attribute_id',$attribute_id);
							$this->db->update('product_attribute',$attribute_data);
						}
						else
						{
							$attribute_data = array(
								'account_id' => $account_id,
								'product_id' => $product_id,
								'attribute_id' => $attribute_id,
								'attribute_value' => $attribute_value,
								'attribute_input_value' => $attribute_input_value
							);
							$this->db->insert('product_attribute',$attribute_data);
						}
					}
				}
			}
		}
		
		// save variation
		
		$is_variation = 0;
		$variation_variable = '';
		$variation_attribute_id = array();
		if($post['variation_theme_id'])
		{   
		  	$is_variation = 1;
			$explode_theme_id = explode('_',$post['variation_theme_id']);
			
			$is_combo = isset($explode_theme_id[0]) ? $explode_theme_id[0] : 0 ;
			if($is_combo == 0)
			{
				
				$variation_variable = 'attribute_1';
				$attribute_id = isset($explode_theme_id[1]) ? $explode_theme_id[1] : 0 ;
				$variation_attribute_id['attribute_1'] = $attribute_id;
			}
			else
			{
				$attribute_1_id = isset($explode_theme_id[1]) ? $explode_theme_id[1] : 0 ;
				$attribute_2_id = isset($explode_theme_id[2]) ? $explode_theme_id[2] : 0 ;
				$attribute_3_id = isset($explode_theme_id[3]) ? $explode_theme_id[3] : 0 ;
				$attribute_4_id = isset($explode_theme_id[4]) ? $explode_theme_id[4] : 0 ;
				$attribute_5_id = isset($explode_theme_id[5]) ? $explode_theme_id[5] : 0 ;
				if($attribute_1_id)
				{
					$variation_variable.='attribute_1|';
					$variation_attribute_id['attribute_1'] = $attribute_1_id;
				}
				if($attribute_2_id)
				{
					$variation_variable.='attribute_2|';
					$variation_attribute_id['attribute_2'] = $attribute_2_id;
				}
				if($attribute_3_id)
				{
					$variation_variable.='attribute_3|';
					$variation_attribute_id['attribute_3'] = $attribute_3_id;
				}
				if($attribute_4_id)
				{
					$variation_variable.='attribute_4|';
					$variation_attribute_id['attribute_4'] = $attribute_4_id;
				}
				if($attribute_5_id)
				{
					$variation_variable.='attribute_5|';
					$variation_attribute_id['attribute_5'] = $attribute_5_id;
				}
				
			}
		}
		
		$data = array(
			'is_variation' => $is_variation,
			'variation_variable' => $variation_variable,
		);
		$this->db->where('id',$post['product_id']);
		$this->db->update('products',$data);
		
		// save product variation attribute
		if($is_variation && $variation_attribute_id)
		{
			// check variation attribute saved or not
			$chk_variation_attribute = $this->db->get_where('product_variation_attribute',array('account_id'=>$account_id,'product_id'=>$product_id))->num_rows();
			if($chk_variation_attribute)
			{
				$variation_attribute_data = array(
					'is_combo' => $is_combo,
					'attribute_1' => isset($variation_attribute_id['attribute_1']) ? $variation_attribute_id['attribute_1'] : 0,
					'attribute_2' => isset($variation_attribute_id['attribute_2']) ? $variation_attribute_id['attribute_2'] : 0,
					'attribute_3' => isset($variation_attribute_id['attribute_3']) ? $variation_attribute_id['attribute_3'] : 0,
					'attribute_4' => isset($variation_attribute_id['attribute_4']) ? $variation_attribute_id['attribute_4'] : 0,
					'attribute_5' => isset($variation_attribute_id['attribute_5']) ? $variation_attribute_id['attribute_5'] : 0,
				);
				$this->db->where('account_id',$account_id);
				$this->db->where('product_id',$product_id);
				$this->db->update('product_variation_attribute',$variation_attribute_data);
			}
			else
			{
				$variation_attribute_data = array(
					'account_id' => $account_id,
					'product_id' => $product_id,
					'is_combo' => $is_combo,
					'attribute_1' => isset($variation_attribute_id['attribute_1']) ? $variation_attribute_id['attribute_1'] : 0,
					'attribute_2' => isset($variation_attribute_id['attribute_2']) ? $variation_attribute_id['attribute_2'] : 0,
					'attribute_3' => isset($variation_attribute_id['attribute_3']) ? $variation_attribute_id['attribute_3'] : 0,
					'attribute_4' => isset($variation_attribute_id['attribute_4']) ? $variation_attribute_id['attribute_4'] : 0,
					'attribute_5' => isset($variation_attribute_id['attribute_5']) ? $variation_attribute_id['attribute_5'] : 0,
				);
				$this->db->insert('product_variation_attribute',$variation_attribute_data);
			}
		}
		
		// save variation theme data
		$variation_theme_id = $post['variation_theme_id'];
		if(isset($post['theme_data']) && $post['theme_data'])
		{   
		    // delete product image temp data
			$this->db->where('account_id',$account_id);
			$this->db->where('product_id',$product_id);
			$this->db->delete('product_variation_theme_data');
			
			$v_atr_data = array();
			$v_i = 1;
			if($variation_attribute_id)
			{
				foreach($variation_attribute_id as $v_atr_id)
				{
					//$attributeData = $this->db->get_where('attribute',array('id'=>$first_attribute_id))->row_array();
					$v_atr_data[$v_i] = $v_atr_id;
					$v_i++;
				}
			}
			// variation variable
			$explode_var_variable = array_filter(explode('|',$variation_variable));
			
			foreach($post['theme_data'] as $variation_order_no=>$variation_val)
			{
				$first_attribute_id = 0;
				$first_option_data = '';
				
				$second_attribute_id = 0;
				$second_option_data = '';
				
				$third_attribute_id = 0;
				$third_option_data = '';
				
				$fourth_attribute_id = 0;
				$fourth_option_data = '';
				
				$fifth_attribute_id = 0;
				$fifth_option_data = '';
				
				if($variation_val){
					foreach($variation_val as $v_order_no=>$v_val){
						
						
						
						$variation_theme_data = array(
							'account_id' => $account_id,
							'product_id' => $product_id,
							'attribute_id' => isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0,
							'option_data' => $v_val
						);
						$this->db->insert('product_variation_theme_data',$variation_theme_data);
						
						if($v_order_no == 1)
						{
							$first_attribute_id = isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0;
							$first_option_data = $v_val;
						}
						elseif($v_order_no == 2)
						{
							$second_attribute_id = isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0;
							$second_option_data = $v_val;
						}
						elseif($v_order_no == 3)
						{
							$third_attribute_id = isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0;
							$third_option_data = $v_val;
						}
						elseif($v_order_no == 4)
						{
							$fourth_attribute_id = isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0;
							$fourth_option_data = $v_val;
						}
						elseif($v_order_no == 5)
						{
							$fifth_attribute_id = isset($v_atr_data[$v_order_no]) ? $v_atr_data[$v_order_no] : 0;
							$fifth_option_data = $v_val;
						}
					}
				}
				
				$color_map = isset($post['theme_color_map'][$variation_order_no]) ? $post['theme_color_map'][$variation_order_no] : '';
				$unit = isset($post['theme_unit'][$variation_order_no]) ? $post['theme_unit'][$variation_order_no] : '';
				$sku = isset($post['theme_sku'][$variation_order_no]) ? $post['theme_sku'][$variation_order_no] : '';
				$hsncode = isset($post['theme_hsncode'][$variation_order_no]) ? $post['theme_hsncode'][$variation_order_no] : '';
				$tax_rule_id = isset($post['theme_tax_rule_id'][$variation_order_no]) ? $post['theme_tax_rule_id'][$variation_order_no] : '';
				$price = isset($post['theme_price'][$variation_order_no]) ? $post['theme_price'][$variation_order_no] : '';
				$discount_price = isset($post['theme_discount_price'][$variation_order_no]) ? $post['theme_discount_price'][$variation_order_no] : '';
				$quantity = isset($post['theme_qty'][$variation_order_no]) ? $post['theme_qty'][$variation_order_no] : '';
				$stock_status = isset($post['theme_stock'][$variation_order_no]) ? $post['theme_stock'][$variation_order_no] : '';
				$variation_status = isset($post['theme_status'][$variation_order_no]) ? $post['theme_status'][$variation_order_no] : '';
				$variation_desc = isset($post['variation_description'][$variation_order_no]) ? $post['variation_description'][$variation_order_no] : '';
				
				// check data already saved or not
				$chk_variation_product_data = $this->db->get_where('product_variation_product_data',array('account_id'=>$account_id,'product_id'=>$product_id,'variation_order_no'=>$variation_order_no))->num_rows();
				if($chk_variation_product_data)
				{
					$variation_product_data = array(
						'first_attribute_id' => $first_attribute_id,
						'first_option_data' => $first_option_data,
						'second_attribute_id' => $second_attribute_id,
						'second_option_data' => $second_option_data,
						'third_attribute_id' => $third_attribute_id,
						'third_option_data' => $third_option_data,
						'fourth_attribute_id' => $fourth_attribute_id,
						'fourth_option_data' => $fourth_option_data,
						'fifth_attribute_id' => $fifth_attribute_id,
						'fifth_option_data' => $fifth_option_data,
						'color_map' => $color_map,
						'unit' => $unit,
						'sku' => $sku,
						'hsncode' => $hsncode,
						'tax_rule_id' => $tax_rule_id,
						'price' => $price,
						'discount_price' => $discount_price,
						'quantity' => $quantity,
						'stock_status' => $stock_status,
						'variation_status' => $variation_status,
						'description' => $variation_desc,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->where('account_id',$account_id);
					$this->db->where('product_id',$product_id);
					$this->db->where('variation_order_no',$variation_order_no);
					$this->db->update('product_variation_product_data',$variation_product_data);
					
					// get variation product id
					$get_variation_product_data = $this->db->select('id')->get_where('product_variation_product_data',array('account_id'=>$account_id,'product_id'=>$product_id,'variation_order_no'=>$variation_order_no))->row_array();
					
					$variation_product_id = isset($get_variation_product_data['id']) ? $get_variation_product_data['id'] : 0 ; 
				}
				else
				{
					$variation_product_data = array(
						'account_id' => $account_id,
						'product_id' => $product_id,
						'variation_order_no' => $variation_order_no,
						'first_attribute_id' => $first_attribute_id,
						'first_option_data' => $first_option_data,
						'second_attribute_id' => $second_attribute_id,
						'second_option_data' => $second_option_data,
						'third_attribute_id' => $third_attribute_id,
						'third_option_data' => $third_option_data,
						'fourth_attribute_id' => $fourth_attribute_id,
						'fourth_option_data' => $fourth_option_data,
						'fifth_attribute_id' => $fifth_attribute_id,
						'fifth_option_data' => $fifth_option_data,
						'color_map' => $color_map,
						'unit' => $unit,
						'sku' => $sku,
						'hsncode' => $hsncode,
						'tax_rule_id' => $tax_rule_id,
						'price' => $price,
						'discount_price' => $discount_price,
						'quantity' => $quantity,
						'stock_status' => $stock_status,
						'variation_status' => $variation_status,
						'description' => $variation_desc,
						'created' => date('Y-m-d H:i:s')
					);
					$this->db->insert('product_variation_product_data',$variation_product_data);
					$variation_product_id = $this->db->insert_id();
				}
				
				if(isset($post['variation_instruction'][$variation_order_no]) && $post['variation_instruction'][$variation_order_no])
				{
					$v_ins_order_no = 1;
					foreach($post['variation_instruction'][$variation_order_no] as $v_ins)
					{
						if($v_ins){
							// check data already saved or not
							$chk_variation_ins_data = $this->db->get_where('product_variation_product_instruction',array('account_id'=>$account_id,'product_id'=>$product_id,'variation_product_id'=>$variation_product_id,'order_no'=>$v_ins_order_no))->num_rows();
							if($chk_variation_product_data)
							{
								// save variation product instructions
								$variation_instruction_data = array(
									'instruction' => $v_ins,
								);
								$this->db->where('account_id',$account_id);
								$this->db->where('product_id',$product_id);
								$this->db->where('variation_product_id',$variation_product_id);
								$this->db->where('order_no',$v_ins_order_no);
								$this->db->update('product_variation_product_instruction',$variation_instruction_data);
							}
							else
							{
								// save variation product instructions
								$variation_instruction_data = array(
									'account_id' => $account_id,
									'product_id' => $product_id,
									'variation_product_id' => $variation_product_id,
									'instruction' => $v_ins,
									'order_no' => $v_ins_order_no
								);
								$this->db->insert('product_variation_product_instruction',$variation_instruction_data);
							}
							$v_ins_order_no++;
						}
					}
				}
				
				// get all token images for vaiation
				$vImageList = $this->db->get_where('product_image_temp_data',array('token'=>$post['token'],'row_no'=>$variation_order_no))->result_array();
				if($vImageList)
				{
					foreach($vImageList as $imgList)
					{
						$image_id = $imgList['id'];
						$image_path = $imgList['image_path'];
						$file_name = $imgList['file_name'];
						$is_base = 0;
						$is_large = 0;
						if($imgList['type'] == 1)
						{
							$is_base = 1;
						}
						else{
							$is_large = 1;
						}
						
						$vImageData = array(
							'account_id' => $account_id,
							'product_id' => $product_id,
							'variation_product_id' => $variation_product_id,
							'is_base' => $is_base,
							'is_large' => $is_large,
							'image_path' => $image_path,
							'file_name' => $file_name,
						);
						$this->db->insert('product_variation_product_images',$vImageData);
					}
				}
				
			}
		}
		
		return true;
	
	}
	
}
?>