<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * Model used for setup default message and resize image
 * 
 * This one used for defined some methods accross all site.
 * this one used for show system message, errors.
 * this one used for image resizing
 * @author trilok
 */

require_once BASEPATH . '/core/Model.php';

class Customer_model extends CI_Model 
{ 

    public function __construct() 
    {
 		parent::__construct();
    }
    
	public function save_customer($post)
	{	
		


			if($post['group_id'] == 3)
			{
				$role_id = 3;
				// get last member number 
				$get_user_display_number = $this->db->select('user_display_number')->order_by('user_display_number','desc')->get_where('users',array('role_id'=>3))->row_array();
				$user_display_number = isset($get_user_display_number['user_display_number']) ? $get_user_display_number['user_display_number'] + 1 : 1;
				
				$application_display_id = 'JBV';
			}
			else
			{
				$role_id = 4;
				// get last member number 
				$get_user_display_number = $this->db->select('user_display_number')->order_by('user_display_number','desc')->get_where('users',array('role_id'=>4))->row_array();
				$user_display_number = isset($get_user_display_number['user_display_number']) ? $get_user_display_number['user_display_number'] + 1 : 1;
				
				$application_display_id = 'JBC';
			}
			if(strlen($user_display_number) == 1)
			{
				$application_display_id.='0000'.$user_display_number;
			}
			elseif(strlen($user_display_number) == 2)
			{
				$application_display_id.='000'.$user_display_number;
			}
			elseif(strlen($user_display_number) == 3)
			{
				$application_display_id.='00'.$user_display_number;
			}
			elseif(strlen($user_display_number) == 4)
			{
				$application_display_id.='0'.$user_display_number;
			}
			elseif(strlen($user_display_number) == 5)
			{
				$application_display_id.=$user_display_number;
			}
			else
			{
				$application_display_id.=$user_display_number;
			}


		$data = array(
			'role_id' => $post['group_id'],
			'user_display_id' => $application_display_id,
    		'user_display_number' => $user_display_number,
			'vendor_role_id' => $post['package_id'],
			'name' => $post['name'],
			'username' => trim(strtolower($post['email'])),
			'password' => do_hash($post['password']),
			'decode_password' => $post['password'],
			'email' => trim(strtolower($post['email'])),
			'mobile' => $post['phone_number'],
			'dob' => ($post['dob']) ? $post['dob'] : 'null',
			'gender' => $post['gender'],
			'country_id' => $post['country'],
			'state_id' => $post['state'],
			'gst_no' => $post['gst_no'],
			'is_active' => $post['status'],
			'is_verified' => 1,
			'otp_verified' => 1,
			'is_admin_manual' => 1,
			'created' => date('Y-m-d H:i:s')
		);
		
		$this->db->insert('users',$data);
		$userID = $this->db->insert_id();
		
		$userAddressData = array(
			'userID' => $userID,
			'company' => $post['company'],
			'address_1' => $post['address_1'],
			'address_2' => $post['address_2'],
			'city' => $post['city'],
			'country' => $post['country'],
			'state' => $post['state'],
			'zip_code' => $post['zip_code'],
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('user_address',$userAddressData);
		
		return true;
	
	}
	
	public function update_customer($post)
	{
		$data = array(
			'vendor_role_id' => $post['package_id'],
			'name' => $post['name'],
			'username' => trim(strtolower($post['email'])),
			'email' => trim(strtolower($post['email'])),
			'mobile' => $post['phone_number'],
			'dob' => ($post['dob']) ? $post['dob'] : 'null',
			'gender' => $post['gender'],
			'country_id' => $post['country'],
			'state_id' => $post['state'],
			'gst_no' => $post['gst_no'],
			'is_active' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		
		if($post['password'])
		{
			$data['password'] = do_hash($post['password']);
			$data['decode_password'] = $post['password'];
		}
		
		$this->db->where('id',$post['customerID']);
		$this->db->update('users',$data);
		$userID = $post['customerID'];
		
		$chk_address = $this->db->get_where('user_address',array('userID'=>$userID))->num_rows();
		if($chk_address){
		$userAddressData = array(
			'company' => $post['company'],
			'address_1' => $post['address_1'],
			'address_2' => $post['address_2'],
			'city' => $post['city'],
			'country' => $post['country'],
			'state' => $post['state'],
			'zip_code' => $post['zip_code'],
			'updated' => date('Y-m-d H:i:s')
		);
		$this->db->where('userID',$userID);
		$this->db->update('user_address',$userAddressData);
		}
		else{
		    $userAddressData = array(
		    'userID' => $userID,       
			'company' => $post['company'],
			'address_1' => $post['address_1'],
			'address_2' => $post['address_2'],
			'city' => $post['city'],
			'country' => $post['country'],
			'state' => $post['state'],
			'zip_code' => $post['zip_code'],
			'updated' => date('Y-m-d H:i:s')
		);
		$this->db->insert('user_address',$userAddressData);
		}
		
		
		if(isset($post['commission']) && $post['commission'])
		{
			foreach($post['commission'] as $catID=>$commission)
			{
				// check setting already saved or not
				$chk_setting = $this->db->get_where('commision_setting',array('vendor_id'=>$post['customerID'],'category_id'=>$catID))->num_rows();
				if($chk_setting)
				{
					$data = array(
						'commission' => $commission
					);
					$this->db->where('vendor_id',$post['customerID']);
					$this->db->where('category_id',$catID);
					$this->db->update('commision_setting',$data);
					
				}
				else
				{
					$data = array(
						'vendor_id' => $post['customerID'],
						'category_id' => $catID,
						'commission' => $commission
					);
					$this->db->insert('commision_setting',$data);
				}
			}
			
		}
		
		return true;
	
	}



	public function update_vendor($post)
	{	
		
	
		$data = array(
			'vendor_role_id' => $post['package_id'],
			'name' => $post['name'],
			'username' => trim(strtolower($post['email'])),
			'email' => trim(strtolower($post['email'])),
			'mobile' => $post['phone_number'],
			'dob' => ($post['dob']) ? $post['dob'] : 'null',
			'gender' => $post['gender'],
			'country_id' => $post['country'],
			'state_id' => $post['state'],
			'gst_no' => $post['gst_no'],
			'is_active' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		
		if($post['password'])
		{
			$data['password'] = do_hash($post['password']);
			$data['decode_password'] = $post['password'];
		}
		
		$this->db->where('id',$post['customerID']);
		$this->db->update('users',$data);
		$userID = $post['customerID'];
		

		$chk_vendor_detail = $this->db->get_where('vendor_detail',array('vendor_id'=>$userID))->num_rows();


		$userAddressData = array(
			'firm_name' => $post['firm_name'],
			'address' => $post['address'],
			'country' => $post['country'],
			'state' => $post['state'],
			'zip_code' => $post['zip_code'],
			'gst_no'   => $post['gst_no'],
			'account_holder_name'=>$post['acc_hold_name'],
			'account_no' => $post['acc_no'],
			'ifsc'      => $post['ifsc'],
			'bank_name' => $post['bank_name'],
		);

		if($post['address_proof'])
		{
			$userAddressData['address_proof'] = $post['address_proof'];
		}

		if($post['pan_card'])
		{
			$userAddressData['pan_card'] = $post['pan_card'];
		}

		if($chk_vendor_detail){
		$this->db->where('vendor_id',$post['customerID']);
		$this->db->update('vendor_detail',$userAddressData);
		}
		else{

		$userAddressData['vendor_id'] = $userID;
		$userAddressData['created'] = date('Y-m-d H:i:s');	
		$this->db->insert('vendor_detail',$userAddressData);	
		}
		
		if(isset($post['commission']) && $post['commission'])
		{
			foreach($post['commission'] as $catID=>$commission)
			{
				// check setting already saved or not
				$chk_setting = $this->db->get_where('commision_setting',array('vendor_id'=>$post['customerID'],'category_id'=>$catID))->num_rows();
				if($chk_setting)
				{
					$data = array(
						'commission' => $commission
					);
					$this->db->where('vendor_id',$post['customerID']);
					$this->db->where('category_id',$catID);
					$this->db->update('commision_setting',$data);
					
				}
				else
				{
					$data = array(
						'vendor_id' => $post['customerID'],
						'category_id' => $catID,
						'commission' => $commission
					);
					$this->db->insert('commision_setting',$data);
				}
			}
			
		}
		
		return true;
	
	}
	
}
?>