<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * Model used for setup default message and resize image
 * 
 * This one used for defined some methods accross all site.
 * this one used for show system message, errors.
 * this one used for image resizing
 * @author trilok
 */

require_once BASEPATH . '/core/Model.php';

class Pages_model extends CI_Model 
{ 

    public function __construct() 
    {
 		parent::__construct();
    }
    
	
	
	public function save_page($post)
	{
		$slug = url_title($post['title'], 'dash', true);
		$data = array(
			'title' => $post['title'],
			'slug' => $slug,
			'content' => $post['description'],
			'status' => $post['status'],
			'created' => date('Y-m-d H:i:s')
		);
		
		$this->db->insert('pages',$data);
		return true;
	
	}
	
	public function update_page($post,$pageID)
	{
		$slug = url_title($post['title'], 'dash', true);
		$data = array(
			'title' => $post['title'],
			'slug' => $slug,
			'content' => $post['description'],
			'status' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		
		$this->db->where('id',$pageID);
		$this->db->update('pages',$data);
		return true;
	
	}
	
	
	public function save_block($post)
	{
		$block_position = $post['block_position'];
		if(!$post['block_position'])
		{
			// get last block position
			$get_last_position = $this->db->order_by('position_no','desc')->get('blocks')->row_array();
			$block_position = isset($get_last_position['position_no']) ? $get_last_position['position_no'] + 1 : 1 ;
		}
		$slug = url_title($post['title'], 'dash', true);
		$data = array(
			'title' => $post['title'],
			'slug' => $slug,
			'position_no' => $block_position,
			'status' => $post['status'],
			'created' => date('Y-m-d H:i:s')
		);
		
		$this->db->insert('blocks',$data);
		$block_id = $this->db->insert_id();
		
		if(isset($post['page_id']))
		{
			foreach($post['page_id'] as $key=>$page_id)
			{
				if($page_id){
					
					$page_order_no = isset($post['page_order'][$key]) ? $post['page_order'][$key] : '';
					$is_footer = isset($post['page_is_footer'][$key]) ? 1 : 0;
					
					$type = isset($post['type'][$key]) ? $post['type'][$key] : 1;
					
					if(!$page_order_no)
					{
						// get last block position
						$get_last_order_no = $this->db->order_by('page_order_no','desc')->get_where('block_pages',array('block_id'=>$block_id))->row_array();
						$page_order_no = isset($get_last_order_no['page_order_no']) ? $get_last_order_no['page_order_no'] + 1 : 1 ;
					}
					$pageData = array(
						'block_id' => $block_id,
						'type' => $type,
						'page_id' => $page_id,
						'page_order_no' => $page_order_no,
						'is_footer' => $is_footer
					);
					$this->db->insert('block_pages',$pageData);
				}
			}
		}
		
		return true;
	
	}
	
	public function update_block($post,$pageID)
	{
		$block_position = $post['block_position'];
		if(!$post['block_position'])
		{
			// get last block position
			$get_last_position = $this->db->order_by('position_no','desc')->get('blocks')->row_array();
			$block_position = isset($get_last_position['position_no']) ? $get_last_position['position_no'] + 1 : 1 ;
		}
		$slug = url_title($post['title'], 'dash', true);
		$data = array(
			'title' => $post['title'],
			'slug' => $slug,
			'position_no' => $block_position,
			'status' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		
		$this->db->where('id',$pageID);
		$this->db->update('blocks',$data);
		
		$block_id = $pageID;
		if(isset($post['page_id']))
		{
			$this->db->where('block_id',$block_id);
			$this->db->delete('block_pages');
			
			foreach($post['page_id'] as $key=>$page_id)
			{
				if($page_id){
					
					$page_order_no = isset($post['page_order'][$key]) ? $post['page_order'][$key] : '';
					$is_footer = isset($post['page_is_footer'][$key]) ? 1 : 0;
					
					$type = isset($post['type'][$key]) ? $post['type'][$key] : 1;
					
					if(!$page_order_no)
					{
						// get last block position
						$get_last_order_no = $this->db->order_by('page_order_no','desc')->get_where('block_pages',array('block_id'=>$block_id))->row_array();
						$page_order_no = isset($get_last_order_no['page_order_no']) ? $get_last_order_no['page_order_no'] + 1 : 1 ;
					}
					$pageData = array(
						'block_id' => $block_id,
						'type' => $type,
						'page_id' => $page_id,
						'page_order_no' => $page_order_no,
						'is_footer' => $is_footer
					);
					$this->db->insert('block_pages',$pageData);
				}
			}
		}
		
		return true;
	
	}
	

}
?>