<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * Model used for setup default message and resize image
 * 
 * This one used for defined some methods accross all site.
 * this one used for show system message, errors.
 * this one used for image resizing
 * @author trilok
 */

require_once BASEPATH . '/core/Model.php';

class Store_model extends CI_Model 
{ 

    public function __construct() 
    {
 		parent::__construct();
    }
    
	public function save_attribute_set($post)
	{
		$slug = url_title($post['title'], 'dash', true);
		$data = array(
			'title' => $post['title'],
			'slug' => $slug,
			'status' => $post['status'],
			'created' => date('Y-m-d H:i:s')
		);
		
		$this->db->insert('attribute_set',$data);
		return true;
	
	}
	
	public function update_attribute_set($post)
	{
		$slug = url_title($post['title'], 'dash', true);	
		$data = array(
			'title' => $post['title'],
			'slug' => $slug,
			'status' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		
		$this->db->where('id',$post['catID']);
		$this->db->update('attribute_set',$data);
		
		if(isset($post['attribute_id']) || isset($post['combo']))
		{
			// delete previous variation
			$this->db->where('attribute_set_id',$post['catID']);
			$this->db->delete('attribute_set_variation');
		}
		$order_no = 1;
		
		if(isset($post['attribute_id']) && $post['attribute_id'])
		{
			
			foreach($post['attribute_id'] as $attribute_id)
			{
				$attribute_data = array(
					'attribute_id' => $attribute_id,
					'attribute_set_id' => $post['catID'],
					'order_no' => $order_no
				);
				$this->db->insert('attribute_set_variation',$attribute_data);
				
				$order_no++;
			}
		}
		
		$combo = array();
		if(isset($post['combo']) && $post['combo'])
		{
			$combo = $post['combo'];
			foreach($combo as $ckey=>$clist)
			{
				if(!array_filter($clist))
				{
					unset($combo[$ckey]);
				}
			}
		}
		
		if($combo)
		{
			foreach($combo as $ckey=>$clist)
			{
				if($clist)
				{
					$attribute_1 = 0;
					$attribute_2 = 0;
					$attribute_3 = 0;
					$attribute_4 = 0;
					$attribute_5 = 0;
					foreach($clist as $kk=>$klist)
					{
						if($klist)
						{
							if($kk == 0)
							{
								$attribute_1 = $klist;
							}
							elseif($kk == 1)
							{
								$attribute_2 = $klist;
							}
							elseif($kk == 2)
							{
								$attribute_3 = $klist;
							}
							elseif($kk == 3)
							{
								$attribute_4 = $klist;
							}
							elseif($kk == 4)
							{
								$attribute_5 = $klist;
							}
						}
					}
					$attribute_data = array(
						'attribute_set_id' => $post['catID'],
						'is_combo' => 1,
						'order_no' => $order_no,
						'attribute_1' => $attribute_1,
						'attribute_2' => $attribute_2,
						'attribute_3' => $attribute_3,
						'attribute_4' => $attribute_4,
						'attribute_5' => $attribute_5,
					);
					$this->db->insert('attribute_set_variation',$attribute_data);
					
					$order_no++;
				}
			}
		}
		
		
		return true;
	
	}
	
	
	public function save_attribute($post)
	{
		$slug = url_title($post['label'], 'dash', true);
		$data = array(
			'label' => $post['label'],
			'slug' => $slug,
			'attribute_code' => $post['attribute_code'],
			'is_filter' => $post['is_filter'],
			'form_type' => $post['form_type'],
			'is_required' => $post['is_required'],
			'is_input_box	' => $post['is_input_box'],
			'status	' => $post['status'],
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('attribute',$data);
		$attribute_id = $this->db->insert_id();
		
		
		
		if($post['form_type'] == 1 || $post['form_type'] == 2 || $post['form_type'] == 3)
		{
			$dropdown_is_default = isset($post['dropdown_is_default']) ? $post['dropdown_is_default'] : 0 ;
			if($post['dropdown_label'])
			{
				$order_no = 1;
				foreach($post['dropdown_label'] as $key=>$label)
				{
					$description = isset($post['dropdown_value'][$key]) ? $post['dropdown_value'][$key] : '' ;
					if($label)
					{
						$is_default = 0;
						if($key == $dropdown_is_default)
							$is_default = 1;
						
						$attribute_data = array(
							'attribute_id' => $attribute_id,
							'order_no' => $order_no,
							'is_default' => $is_default,
							'label' => $label,
							'description' => $description
						);
						$this->db->insert('attribute_data',$attribute_data);
						
						$order_no++;
						
					}
				}
			}
		}
		if($post['form_type'] == 4)
		{
			$dropdown_is_default = isset($post['dropdown_is_default']) ? $post['dropdown_is_default'] : array() ;
			if($post['dropdown_label'])
			{
				$order_no = 1;
				foreach($post['dropdown_label'] as $key=>$label)
				{
					$description = isset($post['dropdown_value'][$key]) ? $post['dropdown_value'][$key] : '' ;
					if($label)
					{
						$is_default = 0;
						if(in_array($key,$dropdown_is_default))
							$is_default = 1;
						
						$attribute_data = array(
							'attribute_id' => $attribute_id,
							'order_no' => $order_no,
							'is_default' => $is_default,
							'label' => $label,
							'description' => $description
						);
						$this->db->insert('attribute_data',$attribute_data);
						
						$order_no++;
						
					}
				}
			}
		}
		
		if(isset($post['attribute_set_id']))
		{
			foreach($post['attribute_set_id'] as $attribute_set_id)
			{
				$attribute_set_data = array(
					'attribute_id' => $attribute_id,
					'attribute_set_id' => $attribute_set_id,
				);
				$this->db->insert('attribute_set_attributes',$attribute_set_data);
			}
		}
		
		return true;
	
	}
	
	public function update_attribute($post)
	{
		
		$slug = url_title($post['label'], 'dash', true);
		$data = array(
			'label' => $post['label'],
			'slug' => $slug,
			'attribute_code' => $post['attribute_code'],
			'is_filter' => $post['is_filter'],
			'is_required' => $post['is_required'],
			'is_input_box	' => $post['is_input_box'],
			'status	' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		
		$attribute_id = $post['attribute_id'];
		
		$this->db->where('id',$attribute_id);
		$this->db->update('attribute',$data);
		
		
		$this->db->where('attribute_id',$attribute_id);
		$this->db->delete('attribute_data');
		
		
		$this->db->where('attribute_id',$attribute_id);
		$this->db->delete('attribute_set_attributes');
		
		
		
		if($post['form_type_id'] == 1 || $post['form_type_id'] == 2 || $post['form_type_id'] == 3)
		{
			$dropdown_is_default = isset($post['dropdown_is_default']) ? $post['dropdown_is_default'] : 0 ;
			if($post['dropdown_label'])
			{
				$order_no = 1;
				foreach($post['dropdown_label'] as $key=>$label)
				{
					$description = isset($post['dropdown_value'][$key]) ? $post['dropdown_value'][$key] : '' ;
					if($label)
					{
						$is_default = 0;
						if($key == $dropdown_is_default)
							$is_default = 1;
						
						$attribute_data = array(
							'attribute_id' => $attribute_id,
							'order_no' => $order_no,
							'is_default' => $is_default,
							'label' => $label,
							'description' => $description
						);
						
						$this->db->insert('attribute_data',$attribute_data);
						
						$order_no++;
						
					}
				}
			}
		}
		if($post['form_type_id'] == 4)
		{
			$dropdown_is_default = isset($post['dropdown_is_default']) ? $post['dropdown_is_default'] : array() ;
			if($post['dropdown_label'])
			{
				$order_no = 1;
				foreach($post['dropdown_label'] as $key=>$label)
				{
					$description = isset($post['dropdown_value'][$key]) ? $post['dropdown_value'][$key] : '' ;
					if($label)
					{
						$is_default = 0;
						if(in_array($key,$dropdown_is_default))
							$is_default = 1;
						
						$attribute_data = array(
							'attribute_id' => $attribute_id,
							'order_no' => $order_no,
							'is_default' => $is_default,
							'label' => $label,
							'description' => $description
						);
						$this->db->insert('attribute_data',$attribute_data);
						
						$order_no++;
						
					}
				}
			}
		}
		
		if(isset($post['attribute_set_id']))
		{
			foreach($post['attribute_set_id'] as $attribute_set_id)
			{
				$attribute_set_data = array(
					'attribute_id' => $attribute_id,
					'attribute_set_id' => $attribute_set_id,
				);
				$this->db->insert('attribute_set_attributes',$attribute_set_data);
			}
		}
		
		return true;
	
	}
	
	
	public function save_variation($post)
	{
		$slug = url_title($post['label'], 'dash', true);
		$data = array(
			'title' => $post['label'],
			'slug' => $slug,
			'status	' => $post['status'],
			'created' => date('Y-m-d H:i:s')
		);
		$this->db->insert('variation_theme',$data);
		$theme_id = $this->db->insert_id();
		
		if(isset($post['variation_lable']))
		{
			$order_no = 1;
			foreach($post['variation_lable'] as $key=>$val)
			{
				$slug = url_title($val, 'dash', true);
				$option_data = array(
					'theme_id' => $theme_id,
					'label' => $val,
					'slug' => $slug,
					'is_color' => isset($post['is_color'][$key]) ? $post['is_color'][$key] : 0,
					'order_no' => $order_no
				);
				$this->db->insert('variation_option',$option_data);
				$order_no++;
			}
		}
		
		return true;
	
	}
	
	public function update_variation($post,$variationID)
	{
		$slug = url_title($post['label'], 'dash', true);
		$data = array(
			'title' => $post['label'],
			'slug' => $slug,
			'status	' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		$this->db->where('id',$variationID);
		$this->db->update('variation_theme',$data);
		$theme_id = $variationID;
		
		if(isset($post['variation_lable']))
		{
			$deleteOptList = $this->db->where_not_in('id',$post['option_id'])->get_where('variation_option',array('theme_id'=>$theme_id))->result_array();
			if($deleteOptList)
			{
				foreach($deleteOptList as $list)
				{
					$this->db->where('id',$list['id']);
					$this->db->delete('variation_option');
				}
			}
			$order_no = 1;
			foreach($post['variation_lable'] as $key=>$val)
			{
				$option_id = isset($post['option_id'][$key]) ? $post['option_id'][$key] : 0 ;
				$slug = url_title($val, 'dash', true);
				$option_data = array(
					'theme_id' => $theme_id,
					'label' => $val,
					'slug' => $slug,
					'is_color' => isset($post['is_color'][$key]) ? $post['is_color'][$key] : 0,
					'order_no' => $order_no
				);
				if($option_id){
					$this->db->where('id',$option_id);
					$this->db->update('variation_option',$option_data);
				}
				else
				{
					$this->db->insert('variation_option',$option_data);
				}
				$order_no++;
			}
		}
		
		return true;
	
	}
	
	public function save_tax_rule($post)
	{
		$data = array(
			'title' => $post['title'],
			'percentage' => $post['percentage'],
			'status' => $post['status'],
			'created' => date('Y-m-d H:i:s')
		);
		
		$this->db->insert('tax_rules',$data);
		return true;
	
	}
	
	public function update_tax_rule($post)
	{
		$data = array(
			'title' => $post['title'],
			'percentage' => $post['percentage'],
			'status' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		
		$this->db->where('id',$post['catID']);
		$this->db->update('tax_rules',$data);
		return true;
	
	}
	
	public function save_brand($post)
	{
		$data = array(
			'title' => $post['title'],
			'status' => $post['status'],
			'created' => date('Y-m-d H:i:s')
		);
		
		$this->db->insert('brands',$data);
		return true;
	
	}
	
	public function update_brand($post)
	{
		$data = array(
			'title' => $post['title'],
			'status' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		
		$this->db->where('id',$post['catID']);
		$this->db->update('brands',$data);
		return true;
	
	}
	
}
?>