<?php
if(!defined('BASEPATH'))
    exit('No direct script access allowed.');

/*
 * Model for manage users information.
 * 
 * This model used for manage user data.
 * this one used for authenticate users, get informations about users
 * @author trilok
 */

class User extends CI_Model{

    public function checkPermission($mode = 'pinkekart_user_session' , $is_front = false) {
        
        $user = $this->session->userdata($mode);
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            $currLang = $this->session->userdata('language');
            $this->lang->load('admin/dashboard', $currLang);
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('admin/login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('admin/login');
            }
        }
        //only super admin can access admin panel
      /*  if($is_front === false && $user['id'] > 1){
            $this->az->redirect('', 'system_message_error', lang('COMMON_ACCESS_DENIED'));
        }*/
    }

    public function checkVendorPermission($mode = 'pinkekart_vendor_session' , $is_front = false) {
        
        $user = $this->session->userdata($mode);
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            $currLang = $this->session->userdata('language');
            $this->lang->load('admin/dashboard', $currLang);
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('vendor/login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('vendor/login');
            }
        }
        //only super admin can access admin panel
      /*  if($is_front === false && $user['id'] > 1){
            $this->az->redirect('', 'system_message_error', lang('COMMON_ACCESS_DENIED'));
        }*/
    }
	
	public function checkCustomerPermission($mode = 'pinkekart_customer_session' , $is_front = false) {
        
        $user = $this->session->userdata($mode);
		$this->lang->load('front', 'english');
        if (!$user) {
            // Load language
            $currLang = $this->session->userdata('language');
            $this->lang->load('admin/dashboard', $currLang);
            $this->load->helper('language');

            if ($is_front === false) {
                $this->session->set_flashdata('message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            } else {
                $this->session->set_flashdata('system_message_error', lang('COMMON_ACCESS_DENIED'));
                redirect('login');
            }
        }
        //only super admin can access admin panel
      /*  if($is_front === false && $user['id'] > 1){
            $this->az->redirect('', 'system_message_error', lang('COMMON_ACCESS_DENIED'));
        }*/
    }


    



    public function getLoggedUser($user_session = ''){
        if($user_session == 'pinkekart_vendor_session' || $user_session == 'vendor_user'){
			$user = $this->session->userdata('pinkekart_vendor_session'); 
		}
		elseif($user_session == 'nurshing_student_session'){
			$user = $this->session->userdata($user_session); 
		}
		else
		{
			$user = $this->session->userdata('pinkekart_user_session');
		}
		if(!$user){
		
	   		 redirect('vendor/login');
            return false;
        }
        else{
            $user = $this->db->get_where('users',array('id'=>$user['id']))->row_array();
			
            return $user;
        }

    }



	public function get_social_link($type = 0)
	{
		$get_content = $this->db->select('facebook_link,twitter_link,linkedin_link,youtube_link,google_plus_link')->get_where('page_content',array('page_id'=>4))->row_array();
		if($type == 1)
			return isset($get_content['twitter_link']) ? $get_content['twitter_link'] : '#' ;
		elseif($type == 2)
			return isset($get_content['facebook_link']) ? $get_content['facebook_link'] : '#' ;
		elseif($type == 3)
			return isset($get_content['google_plus_link']) ? $get_content['google_plus_link'] : '#' ;
		elseif($type == 4)
			return isset($get_content['linkedin_link']) ? $get_content['linkedin_link'] : '#' ;
		elseif($type == 5)
			return isset($get_content['youtube_link']) ? $get_content['youtube_link'] : '#' ;
		else
			return '#';
	}
	
	public function get_consumer_no()
	{
		$get_content = $this->db->select('consumer_no')->get('site_settings')->row_array();
		return isset($get_content['consumer_no']) ? $get_content['consumer_no'] : '' ;
	}
	
	public function get_customer_no()
	{
		$get_content = $this->db->select('customer_no')->get('site_settings')->row_array();
		return isset($get_content['customer_no']) ? $get_content['customer_no'] : '' ;
	}
	
	public function get_facebook_url()
	{
		$get_content = $this->db->select('facebook_url')->get('site_settings')->row_array();
		return isset($get_content['facebook_url']) ? $get_content['facebook_url'] : '#' ;
	}
	
	public function get_twitter_url()
	{
		$get_content = $this->db->select('twitter_url')->get('site_settings')->row_array();
		return isset($get_content['twitter_url']) ? $get_content['twitter_url'] : '#' ;
	}
	
	public function get_instagram_url()
	{
		$get_content = $this->db->select('instagram_url')->get('site_settings')->row_array();
		return isset($get_content['instagram_url']) ? $get_content['instagram_url'] : '#' ;
	}
	
	public function get_youtube_url()
	{
		$get_content = $this->db->select('youtube_url')->get('site_settings')->row_array();
		return isset($get_content['youtube_url']) ? $get_content['youtube_url'] : '#' ;
	}
	
	public function get_email()
	{
		$get_content = $this->db->select('email_id')->get('site_settings')->row_array();
		return isset($get_content['email_id']) ? $get_content['email_id'] : '' ;
	}
	
	
	
	public function get_logo()
	{
		$get_content = $this->db->select('logo')->get('site_settings')->row_array();
		$logo = isset($get_content['logo']) ? $get_content['logo'] : '' ;
		if($logo)
		{
			return '<img src="'.base_url($logo).'" alt="logo" width="167">';
		}
		else
		{
			return '<img src="'.base_url().'skin/front/assets/images/logo.png" alt="logo" width="167">';
		}
	}
	
	function get_footer_data()
	{
		$response = array();
		$get_content = $this->db->select('*')->get('site_settings')->row_array();
		$response['instagram_url'] = isset($get_content['instagram_url']) ? $get_content['instagram_url'] : '#';
		$response['facebook_url'] = isset($get_content['facebook_url']) ? $get_content['facebook_url'] : '#';
		$response['twitter_url'] = isset($get_content['twitter_url']) ? $get_content['twitter_url'] : '#';
		$response['linkedin_url'] = isset($get_content['linkedin_url']) ? $get_content['linkedin_url'] : '#';
		$response['copyright_msg'] = isset($get_content['copyright_msg']) ? $get_content['copyright_msg'] : '';
		return $response;
		
	}
	
	function get_loan_type()
	{
		return $this->db->select('*')->order_by('id','asc')->get_where('loan_type',array('status'=>1))->result_array();
	}
	
	function getCategoryList()
	{
		$categoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>0))->result_array();
		$parent_category_list = array();
		$j = 0;
		if($categoryList)
		{
			foreach($categoryList as $key=>$list)
			{
				$parent_category_list[$key]['id'] = $list['id'];
				$parent_category_list[$key]['title'] = $list['title'];
				$parent_category_list[$key]['slug'] = $list['slug'];
				$cat_id = $list['id'];
				$subCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$cat_id))->result_array();
				if($subCategoryList)
				{
					foreach($subCategoryList as $subKey=>$subList)
					{
						$parent_category_list[$key]['subCat'][$subKey]['id'] = $subList['id'];
						$parent_category_list[$key]['subCat'][$subKey]['title'] = $subList['title'];
						$parent_category_list[$key]['subCat'][$subKey]['slug'] = $subList['slug'];
						$j++;
						$sub_cat_id = $subList['id'];
						$subSubCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$sub_cat_id))->result_array();
						if($subSubCategoryList)
						{
							foreach($subSubCategoryList as $subSubKey=>$subSubList)
							{
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['id'] = $subSubList['id'];
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['title'] = $subSubList['title'];
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['slug'] = $subSubList['slug'];
								$j++;
								$sub_sub_cat_id = $subSubList['id'];
								$subSubSubCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$sub_sub_cat_id))->result_array();
								if($subSubSubCategoryList)
								{
									foreach($subSubSubCategoryList as $subSubSubKey=>$subSubSubList)
									{
										$sub_sub_sub_cat_id = $subSubSubList['id'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['id'] = $subSubSubList['id'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['title'] = $subSubSubList['title'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['slug'] = $subSubSubList['slug'];
										$j++;
									}
								}
							}
						}
					}
				}
			}
		}
		
		return $parent_category_list;
	}
	
	function getParentCategoryList()
	{
		$categoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>0))->result_array();
		$parent_category_list = array();
		$j = 0;
		if($categoryList)
		{
			foreach($categoryList as $key=>$list)
			{
				$parent_category_list[$key]['id'] = $list['id'];
				$parent_category_list[$key]['title'] = $list['title'];
				$parent_category_list[$key]['slug'] = $list['slug'];
				
			}
		}
		
		return $parent_category_list;
	}
	
	function getFrontCategoryList()
	{
		$categoryList = $this->db->order_by('order_no','asc')->get_where('category',array('parent_id'=>0,'status'=>1))->result_array();
		
		$parent_category_list = array();
		$j = 0;
		if($categoryList)
		{
			foreach($categoryList as $key=>$list)
			{
				$parent_category_list[$key]['id'] = $list['id'];
				$parent_category_list[$key]['title'] = $list['title'];
				$parent_category_list[$key]['slug'] = $list['slug'];
				$parent_category_list[$key]['slug'] = $list['slug'];
				$is_banner = $this->db->get_where('banners',array('banner_type_id'=>3,'category_id'=>$list['id'],'is_active'=>1))->num_rows();
				$parent_category_list[$key]['is_banner'] = $is_banner;
				$parent_category_list[$key]['banners'] = $this->db->order_by('order_no','asc')->get_where('banners',array('banner_type_id'=>3,'category_id'=>$list['id'],'is_active'=>1))->result_array();
				
				$cat_id = $list['id'];
				$subCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$cat_id,'status'=>1))->result_array();
				if($subCategoryList)
				{
					foreach($subCategoryList as $subKey=>$subList)
					{
						$parent_category_list[$key]['subCat'][$subKey]['id'] = $subList['id'];
						$parent_category_list[$key]['subCat'][$subKey]['title'] = $subList['title'];
						$parent_category_list[$key]['subCat'][$subKey]['slug'] = $subList['slug'];
						$j++;
						$sub_cat_id = $subList['id'];
						$subSubCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$sub_cat_id,'status'=>1))->result_array();
						if($subSubCategoryList)
						{
							foreach($subSubCategoryList as $subSubKey=>$subSubList)
							{
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['id'] = $subSubList['id'];
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['title'] = $subSubList['title'];
								$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['slug'] = $subSubList['slug'];
								$j++;
								$sub_sub_cat_id = $subSubList['id'];
								$subSubSubCategoryList = $this->db->order_by('created','desc')->get_where('category',array('parent_id'=>$sub_sub_cat_id,'status'=>1))->result_array();
								if($subSubSubCategoryList)
								{
									foreach($subSubSubCategoryList as $subSubSubKey=>$subSubSubList)
									{
										$sub_sub_sub_cat_id = $subSubSubList['id'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['id'] = $subSubSubList['id'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['title'] = $subSubSubList['title'];
										$parent_category_list[$key]['subCat'][$subKey]['subCat'][$subSubKey]['subCat'][$subSubSubKey]['slug'] = $subSubSubList['slug'];
										$j++;
									}
								}
							}
						}
					}
				}
			}
		}
		
		return $parent_category_list;
	}
	
	
	public function get_saved_combo_attribute($order_no,$attribute_id,$attribute_number,$attribute_set_id)
	{
		
		// get saved attribute list
		$savedAttributeList = $this->db->get_where('attribute_set_variation',array('attribute_set_id'=>$attribute_set_id,'is_combo'=>1,'order_no'=>$order_no))->row_array();
		if($attribute_number == 1)
		{
			return isset($savedAttributeList['attribute_1']) ? $savedAttributeList['attribute_1'] : 0;
		}
		elseif($attribute_number == 2)
		{
			return isset($savedAttributeList['attribute_2']) ? $savedAttributeList['attribute_2'] : 0;
		}
		elseif($attribute_number == 3)
		{
			return isset($savedAttributeList['attribute_3']) ? $savedAttributeList['attribute_3'] : 0;
		}
		elseif($attribute_number == 4)
		{
			return isset($savedAttributeList['attribute_4']) ? $savedAttributeList['attribute_4'] : 0;
		}
		elseif($attribute_number == 5)
		{
			return isset($savedAttributeList['attribute_5']) ? $savedAttributeList['attribute_5'] : 0;
		}
		
	}
	
	function get_footer_block_list()
	{
		// get footer block list
		$blockList = $this->db->order_by('position_no','asc')->get_where('blocks',array('status'=>1))->result_array();
		
		if($blockList)
		{
			foreach($blockList as $key=>$list)
			{
				// get page list
				$blockPageList = $this->db->select('block_pages.*')->order_by('block_pages.page_order_no','asc')->get_where('block_pages',array('block_pages.block_id'=>$list['id'],'block_pages.is_footer'=>1))->result_array();
				if($blockPageList)
				{
					foreach($blockPageList as $bkey=>$blist)
					{
						$type = $blist['type'];
						$page_id = $blist['page_id'];
						$page_name = '';
						$page_slug = '';
						$link_name = '';
						$link_url = '';
						if($type == 1)
						{
							// get page name and slug
							$get_page_data = $this->db->select('title,slug')->get_where('pages',array('id'=>$page_id))->row_array();
							$page_name = isset($get_page_data['title']) ? $get_page_data['title'] : '';
							$page_slug = isset($get_page_data['slug']) ? $get_page_data['slug'] : '';
						}
						else
						{
							// get link name and url
							$get_page_data = $this->db->select('title,url')->get_where('links',array('id'=>$page_id))->row_array();
							$link_name = isset($get_page_data['title']) ? $get_page_data['title'] : '';
							$link_url = isset($get_page_data['url']) ? $get_page_data['url'] : '';
						}
						$blockPageList[$bkey]['page_name'] = $page_name;
						$blockPageList[$bkey]['page_slug'] = $page_slug;
						$blockPageList[$bkey]['link_name'] = $link_name;
						$blockPageList[$bkey]['link_url'] = $link_url;
					}
				}
				
				$blockList[$key]['pages'] = $blockPageList;
			}
		}
		
		return $blockList;
	}
	
	
	public function get_section_product_list($product_id_str = '')
	{
		$product_id = array_unique(array_filter(explode('|',$product_id_str)));
		$today_date = date('Y-m-d');
		$productList = array();
		if($product_id){
			// product list
			$productList = $this->db->where_in('id',$product_id)->get_where('products',array('status'=>1,'approve_status'=>2))->result_array();
			if($productList)
			{
				foreach($productList as $key=>$list)
				{
					// get product image
					$get_product_img = $this->db->select('image_path,file_name')->get_where('product_images',array('product_id'=>$list['id'],'is_base'=>1))->row_array();
					$product_img = isset($get_product_img['file_name']) ? 'media/product_images/thumbnail-70x70/'.$get_product_img['file_name'] : 'skin/front/assets/images/product-default-img.png' ;
					
					
					$productList[$key]['product_img'] = $product_img;
					
					if($list['special_price'] && $list['special_price_to'] >= $today_date)
					{
						$productList[$key]['special_price_status'] = 1;
					}
					else
					{
						$productList[$key]['special_price_status'] = 0;
					}

					// get product review & rating
					$totalReview = $this->db->select('count(*) as total_user,sum(rating) as total_rating')->get_where('product_review',array('is_variation'=>0,'product_id'=>$list['id'],'type'=>2))->row_array();					
					
					$productList[$key]['total_review'] = isset($totalReview['total_user']) ? $totalReview['total_user'] : 0;
					$productList[$key]['total_user'] = isset($totalReview['total_user']) ? $totalReview['total_user'] : 0;
					$productList[$key]['total_rating'] = isset($totalReview['total_user']) ? (($totalReview['total_user']) ? round($totalReview['total_rating']/$totalReview['total_user']) : 0) : 0;
					
					if($productList[$key]['total_rating'] == 0)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/0-star.png');
					elseif($productList[$key]['total_rating'] == 1)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/1-star.png');
					elseif($productList[$key]['total_rating'] == 2)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/2-star.png');	
					elseif($productList[$key]['total_rating'] == 3)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/3-star.png');	
					elseif($productList[$key]['total_rating'] == 4)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/4-star.png');	
					elseif($productList[$key]['total_rating'] == 5)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/5-star.png');	
						
					// check wishlist status
					$productList[$key]['wishlist_status'] = $this->User->check_product_wishlist_status($list['id']);
					
					
				}
			}
		}
		
		return $productList;
	}



	public function get_vendor_section_product_list($product_id_str = '',$vendor_id = 0)
	{
		$product_id = array_unique(array_filter(explode('|',$product_id_str)));
		$today_date = date('Y-m-d');
		$productList = array();
		if($product_id){
			// product list
			$productList = $this->db->where_in('id',$product_id)->get_where('products',array('status'=>1,'approve_status'=>2,'account_id'=>$vendor_id))->result_array();
			if($productList)
			{
				foreach($productList as $key=>$list)
				{
					// get product image
					$get_product_img = $this->db->select('image_path,file_name')->get_where('product_images',array('product_id'=>$list['id'],'is_base'=>1))->row_array();
					$product_img = isset($get_product_img['file_name']) ? 'media/product_images/thumbnail-70x70/'.$get_product_img['file_name'] : 'skin/front/assets/images/product-default-img.png' ;
					
					
					$productList[$key]['product_img'] = $product_img;
					
					if($list['special_price'] && $list['special_price_to'] >= $today_date)
					{
						$productList[$key]['special_price_status'] = 1;
					}
					else
					{
						$productList[$key]['special_price_status'] = 0;
					}

					// get product review & rating
					$totalReview = $this->db->select('count(*) as total_user,sum(rating) as total_rating')->get_where('product_review',array('is_variation'=>0,'product_id'=>$list['id'],'type'=>2))->row_array();					
					
					$productList[$key]['total_review'] = isset($totalReview['total_user']) ? $totalReview['total_user'] : 0;
					$productList[$key]['total_user'] = isset($totalReview['total_user']) ? $totalReview['total_user'] : 0;
					$productList[$key]['total_rating'] = isset($totalReview['total_user']) ? ($totalReview['total_user']) ? round($totalReview['total_rating']/$totalReview['total_user']) : 0 : 0;
					
					if($productList[$key]['total_rating'] == 0)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/0-star.png');
					elseif($productList[$key]['total_rating'] == 1)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/1-star.png');
					elseif($productList[$key]['total_rating'] == 2)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/2-star.png');	
					elseif($productList[$key]['total_rating'] == 3)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/3-star.png');	
					elseif($productList[$key]['total_rating'] == 4)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/4-star.png');	
					elseif($productList[$key]['total_rating'] == 5)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/5-star.png');	
						
					// check wishlist status
					$productList[$key]['wishlist_status'] = $this->User->check_product_wishlist_status($list['id']);
					
					
				}
			}
		}
		
		return $productList;
	}


	public function get_cart_temp_data()
	{
		$today_date = date('Y-m-d');
		$loggedUser = $this->session->userdata('pinkekart_customer_session');
		$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;

		if(!$account_id)
		{
			$loggedUser = $this->session->userdata('pinkekart_vendor_session');
			$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		}

		$user_ip_address = $_SERVER['REMOTE_ADDR'];
		if($account_id){
			
			$productList = $this->db->query("SELECT b.*,a.qty,a.id as temp_id,a.is_variation,a.variation_pro_id FROM tbl_cart_temp_data as a INNER JOIN tbl_products as b on b.id = a.product_id where a.user_id = '$account_id' AND b.status = 1 AND b.approve_status = 2")->result_array();
		}
		else
		{
			$productList = $this->db->query("SELECT b.*,a.qty,a.id as temp_id,a.is_variation,a.variation_pro_id FROM tbl_cart_temp_data as a INNER JOIN tbl_products as b on b.id = a.product_id where (a.user_id = '$account_id' or a.ip = '$user_ip_address') AND b.status = 1 AND b.approve_status = 2")->result_array();
		}
		
		if($productList)
		{
			foreach($productList as $key=>$list)
			{
				if($list['is_variation'])
				{
					$get_product_img = $this->db->select('image_path,file_name')->get_where('product_variation_product_images',array('product_id'=>$list['id'],'variation_product_id'=>$list['variation_pro_id'],'is_base'=>1))->row_array();
					
					$product_img = isset($get_product_img['file_name']) ? 'media/product_images/thumbnail-70x70/'.$get_product_img['file_name'] : 'skin/front/assets/images/product-default-img.png' ;
					
					$productList[$key]['product_img'] = $product_img;
					
					// get variation product data
					$variationProData = $this->db->get_where('product_variation_product_data',array('id'=>$list['variation_pro_id'],'product_id'=>$list['id']))->row_array();
					

					$chk_offer_applied_product = $this->db->get_where('offer_history',array('product_id'=>$list['id']))->row_array();
					
					if($chk_offer_applied_product){

					 $productList[$key]['price'] = isset($chk_offer_applied_product['after_apply_offer_price']) ? $chk_offer_applied_product['after_apply_offer_price'] : 0;	
					}
					else{
					$productList[$key]['price'] = isset($variationProData['discount_price']) ? $variationProData['discount_price'] : 0;
					}


				}
				else
				{
					// get product image
					$get_product_img = $this->db->select('image_path,file_name')->get_where('product_images',array('product_id'=>$list['id'],'is_base'=>1))->row_array();
					$product_img = isset($get_product_img['file_name']) ? 'media/product_images/thumbnail-70x70/'.$get_product_img['file_name'] : 'skin/front/assets/images/product-default-img.png' ;
					
					$productList[$key]['product_img'] = $product_img;
					
					
					$chk_offer_applied_product = $this->db->get_where('offer_history',array('product_id'=>$list['id']))->row_array();
					
					if($chk_offer_applied_product){

					 $productList[$key]['price'] = isset($chk_offer_applied_product['after_apply_offer_price']) ? $chk_offer_applied_product['after_apply_offer_price'] : 0;	
					}
					else{

						if($list['special_price'] && $list['special_price_to'] >= $today_date)
						{
						$productList[$key]['price'] = $list['special_price'];
						}

					}



				}
				$productList[$key]['qty'] = $list['qty'];	
				$productList[$key]['temp_id'] = $list['temp_id'];	
			}
		}
		
		return $productList;
		
	}
	
	public function get_wish_list_product_temp_data()
	{
		$today_date = date('Y-m-d');
		$loggedUser = $this->session->userdata('pinkekart_customer_session');
		$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		if(!$account_id)
		{
			$loggedUser = $this->session->userdata('pinkekart_vendor_session');
			$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		}
		$user_ip_address = $_SERVER['REMOTE_ADDR'];
		if($account_id){
			$productList = $this->db->query("SELECT b.*,a.id as temp_id,a.is_variation,a.variation_pro_id,a.created as added_date_time FROM tbl_wish_list_temp_data as a INNER JOIN tbl_products as b on b.id = a.product_id where a.user_id = '$account_id' AND b.status = 1 AND b.approve_status = 2")->result_array();
		}
		else
		{
			$productList = $this->db->query("SELECT b.*,a.id as temp_id,a.is_variation,a.variation_pro_id,a.created as added_date_time FROM tbl_wish_list_temp_data as a INNER JOIN tbl_products as b on b.id = a.product_id where (a.user_id = '$account_id' or a.ip = '$user_ip_address') AND b.status = 1 AND b.approve_status = 2")->result_array();
		}
		
		if($productList)
		{
			foreach($productList as $key => $list)
			{
				if($list['is_variation'])
				{
					$get_product_img = $this->db->select('image_path,file_name')->get_where('product_variation_product_images',array('product_id'=>$list['id'],'variation_product_id'=>$list['variation_pro_id'],'is_base'=>1))->row_array();
					
					$product_img = isset($get_product_img['file_name']) ? 'media/product_images/thumbnail-70x70/'.$get_product_img['file_name'] : 'skin/front/assets/images/product-default-img.png' ;
					
					$productList[$key]['product_img'] = $product_img;
					
					// get variation product data
					$variationProData = $this->db->get_where('product_variation_product_data',array('id'=>$list['variation_pro_id'],'product_id'=>$list['id']))->row_array();
					
					$productList[$key]['price'] = isset($variationProData['discount_price']) ? $variationProData['discount_price'] : 0;
					
				}
				else
				{
					// get product image
					$get_product_img = $this->db->select('image_path,file_name')->get_where('product_images',array('product_id'=>$list['id'],'is_base'=>1))->row_array();
					$product_img = isset($get_product_img['file_name']) ? 'media/product_images/thumbnail-70x70/'.$get_product_img['file_name'] : 'skin/front/assets/images/product-default-img.png' ;
					
					$productList[$key]['product_img'] = $product_img;
					
					if($list['special_price'] && $list['special_price_to'] >= $today_date)
					{
						$productList[$key]['price'] = $list['special_price'];
					}
				}
				
				// get product review & rating
				$totalReview = $this->db->select('count(*) as total_user,sum(rating) as total_rating')->get_where('product_review',array('is_variation'=>0,'product_id'=>$list['id'],'type'=>2))->row_array();					
				
				$productList[$key]['total_review'] = isset($totalReview['total_user']) ? $totalReview['total_user'] : 0;
				$productList[$key]['total_user'] = isset($totalReview['total_user']) ? $totalReview['total_user'] : 0;
				$productList[$key]['total_rating'] = isset($totalReview['total_user']) ? ($totalReview['total_user']) ? round($totalReview['total_rating']/$totalReview['total_user']) : 0 : 0;
				
				if($productList[$key]['total_rating'] == 0)
					$productList[$key]['rating_img'] = base_url('skin/front/assets/images/0-star.png');
				elseif($productList[$key]['total_rating'] == 1)
					$productList[$key]['rating_img'] = base_url('skin/front/assets/images/1-star.png');
				elseif($productList[$key]['total_rating'] == 2)
					$productList[$key]['rating_img'] = base_url('skin/front/assets/images/2-star.png');	
				elseif($productList[$key]['total_rating'] == 3)
					$productList[$key]['rating_img'] = base_url('skin/front/assets/images/3-star.png');	
				elseif($productList[$key]['total_rating'] == 4)
					$productList[$key]['rating_img'] = base_url('skin/front/assets/images/4-star.png');	
				elseif($productList[$key]['total_rating'] == 5)
					$productList[$key]['rating_img'] = base_url('skin/front/assets/images/5-star.png');	
				
				$productList[$key]['temp_id'] = $list['temp_id'];	
				$productList[$key]['stock_status'] = $list['stock_status'];	
				$productList[$key]['added_date_time'] = date('d M Y',strtotime($list['added_date_time']));	
			}
		}
		
		return $productList;
		
	}
	
	public function get_wish_list_temp_data()
	{
		$today_date = date('Y-m-d');
		$loggedUser = $this->session->userdata('pinkekart_customer_session');
		$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		if(!$account_id)
		{
			$loggedUser = $this->session->userdata('pinkekart_vendor_session');
			$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		}
		$user_ip_address = $_SERVER['REMOTE_ADDR'];
		if($account_id){
			$total_product = $this->db->get_where('wish_list_temp_data',array('user_id'=>$account_id))->num_rows();
		}
		else
		{
			$total_product = $this->db->get_where('wish_list_temp_data',array('ip'=>$user_ip_address))->num_rows();
		}
		
		return $total_product;
		
	}
	
	public function check_product_wishlist_status($product_id = 0)
	{
		$today_date = date('Y-m-d');
		$loggedUser = $this->session->userdata('pinkekart_customer_session');
		$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		if(!$account_id)
		{
			$loggedUser = $this->session->userdata('pinkekart_vendor_session');
			$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		}
		$user_ip_address = $_SERVER['REMOTE_ADDR'];
		if($account_id){
			$total_product = $this->db->get_where('wish_list_temp_data',array('user_id'=>$account_id,'product_id'=>$product_id))->num_rows();
		}
		else
		{
			$total_product = $this->db->get_where('wish_list_temp_data',array('ip'=>$user_ip_address,'product_id'=>$product_id))->num_rows();
		}
		
		return $total_product;
		
	}
	
	public function get_logged_user_account_id()
	{
		$loggedUser = $this->session->userdata('pinkekart_customer_session');
		$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		if(!$account_id)
		{
			$loggedUser = $this->session->userdata('pinkekart_vendor_session');
			$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		}
		return $account_id;
	}
	
	public function get_last_order_display_id()
	{
		// get last order display id
		$get_order_number = $this->db->select('order_number')->order_by('order_number','desc')->get('orders')->row_array();
		$order_number = isset($get_order_number['order_number']) ? $get_order_number['order_number'] + 1 : 1;
		
		$get_invoice_year = $this->db->select('invoice_year')->get_where('tbl_site_settings',array('id'=>1))->row_array();
		
		$invoice_year = $get_invoice_year['invoice_year'];
		
		$order_display_id = 'PEOPLEORD';
		if(strlen($order_number) == 1)
		{
			$order_display_id.='0000'.$order_number;
		}
		elseif(strlen($order_number) == 2)
		{
			$order_display_id.='000'.$order_number;
		}
		elseif(strlen($order_number) == 3)
		{
			$order_display_id.='00'.$order_number;
		}
		elseif(strlen($order_number) == 4)
		{
			$order_display_id.='0'.$order_number;
		}
		else
		{
			$order_display_id.=$order_number;
		}
		
		return array('order_display_id'=>$order_display_id,'order_number'=>$order_number);
		
	}


	public function get_last_vendor_order_display_id()
	{
		// get last order display id
		$get_order_number = $this->db->select('order_number')->order_by('order_number','desc')->get('vendor_orders')->row_array();
		$order_number = isset($get_order_number['order_number']) ? $get_order_number['order_number'] + 1 : 1;
		
		$order_display_id = 'PKVO';
		if(strlen($order_number) == 1)
		{
			$order_display_id.='0000'.$order_number;
		}
		elseif(strlen($order_number) == 2)
		{
			$order_display_id.='000'.$order_number;
		}
		elseif(strlen($order_number) == 3)
		{
			$order_display_id.='00'.$order_number;
		}
		elseif(strlen($order_number) == 4)
		{
			$order_display_id.='0'.$order_number;
		}
		else
		{
			$order_display_id.=$order_number;
		}
		
		return array('order_display_id'=>$order_display_id,'order_number'=>$order_number);
		
	}
	
	public function get_last_invoice_display_id()
	{
		// get last order display id
		$get_order_number = $this->db->select('invoice_number')->order_by('invoice_number','desc')->get('order_invoice')->row_array();
		$invoice_number = isset($get_order_number['invoice_number']) ? $get_order_number['invoice_number'] + 1 : 1;
		
		$invoice_display_id = 'PK';
		if(strlen($invoice_number) == 1)
		{
			$invoice_display_id.='0000'.$invoice_number;
		}
		elseif(strlen($invoice_number) == 2)
		{
			$invoice_display_id.='000'.$invoice_number;
		}
		elseif(strlen($invoice_number) == 3)
		{
			$invoice_display_id.='00'.$invoice_number;
		}
		elseif(strlen($invoice_number) == 4)
		{
			$invoice_display_id.='0'.$invoice_number;
		}
		else
		{
			$invoice_display_id.=$invoice_number;
		}
		
		return array('invoice_display_id'=>$invoice_display_id,'invoice_number'=>$invoice_number);
		
	}
	
	public function get_customer_order_data($account_id = 0, $status = 0)
	{

		
		$orderList = array();
		if($status == 0){
			// get order list
			$orderList = $this->db->select('orders.*,user_address.name as add_name,user_address.phone_number,user_address.address_1,user_address.address_2,user_address.city,countries.name as country_name,order_status.title as status_title')->order_by('orders.created','desc')->join('user_address','user_address.id = orders.address_id')->join('countries','countries.id = user_address.country')->join('order_status','order_status.id = orders.status')->get_where('orders',array('orders.customer_id' => $account_id))->result_array();

		}
		else{
			// get order list
			$orderList = $this->db->select('orders.*,user_address.name as add_name,user_address.phone_number,user_address.address_1,user_address.address_2,user_address.city,countries.name as country_name,order_status.title as status_title')->order_by('orders.created','desc')->join('user_address','user_address.id = orders.address_id')->join('countries','countries.id = user_address.country')->join('order_status','order_status.id = orders.status')->get_where('orders',array('orders.customer_id'=>$account_id,'orders.status'=>$status))->result_array();
		}
		

		
		if($orderList)
		{
			foreach($orderList as $key=>$list)
			{
				$order_id = $list['id'];
				$productList = $this->db->select('products.id,products.product_name,products.slug,order_item_summary.product_qty,order_item_summary.product_price,order_item_summary.product_total_price,order_item_summary.gross_amount,order_item_summary.payable_amount')->join('products','products.id = order_item_summary.product_id')->get_where('order_item_summary',array('order_item_summary.order_id' => $order_id,'order_item_summary.customer_id'=> $account_id))->result_array();
				
				if($productList)
				{
					foreach($productList as $prokey=>$prolist)
					{
						// get product image
						$get_product_img = $this->db->select('image_path')->get_where('product_images',array('product_id'=>$prolist['id'],'is_base'=>1))->row_array();
						$product_img = isset($get_product_img['image_path']) ? $get_product_img['image_path'] : 'skin/front/assets/images/product-default-img.png' ;
						
						$productList[$prokey]['product_img'] = $product_img;
						
						
					}
				}
				
				$orderList[$key]['productInfo'] = $productList;
			}
		}
		
		return $orderList;
	}
	
	public function get_customer_current_order_data($account_id = 0,$encoded_order_id = '')
	{
		// get order list
		$orderList = $this->db->select('orders.*,user_address.name as add_name,user_address.phone_number,user_address.address_1,user_address.address_2,user_address.city,user_address.zip_code,states.name as state,countries.name as country_name,order_status.title as status_title,users.name as customer_name,users.email as customer_email,users.mobile as customer_mobile')->order_by('orders.created','desc')->join('user_address','user_address.id = orders.address_id')->join('users','users.id = orders.customer_id')->join('countries','countries.id = user_address.country')->join('states','states.id = user_address.state')->join('order_status','order_status.id = orders.status')->get_where('orders',array('orders.customer_id'=>$account_id,'orders.encoded_order_id'=>$encoded_order_id))->result_array();
		
		if($orderList)
		{
			foreach($orderList as $key=>$list)
			{
				$order_id = $list['id'];
				$productList = $this->db->select('products.id,products.product_name,products.sku,products.slug,order_item_summary.*')->join('products','products.id = order_item_summary.product_id')->get_where('order_item_summary',array('order_item_summary.order_id'=>$order_id,'order_item_summary.customer_id'=>$account_id))->result_array();
				
				if($productList)
				{
					foreach($productList as $prokey=>$prolist)
					{
						// get product image
						$get_product_img = $this->db->select('image_path')->get_where('product_images',array('product_id'=>$prolist['product_id'],'is_base'=>1))->row_array();
						$product_img = isset($get_product_img['image_path']) ? $get_product_img['image_path'] : 'skin/front/assets/images/product-default-img.png' ;
						
						$productList[$prokey]['product_img'] = $product_img;
						
						
					}
				}
				
				$orderList[$key]['productInfo'] = $productList;
			}
		}
		
		return $orderList;
	}


	public function get_vendor_current_order_data($account_id = 0,$encoded_order_id = '')
	{
		// get order list
		$orderList = $this->db->select('vendor_orders.*,user_address.name as add_name,user_address.phone_number,user_address.address_1,user_address.address_2,user_address.city,countries.name as country_name,order_status.title as status_title,users.name as customer_name,users.email as customer_email,users.mobile as customer_mobile')->order_by('vendor_orders.created','desc')->join('user_address','user_address.id = vendor_orders.address_id')->join('users','users.id = vendor_orders.customer_id')->join('countries','countries.id = user_address.country')->join('order_status','order_status.id = vendor_orders.status')->get_where('vendor_orders',array('vendor_orders.vendor_id'=>$account_id,'vendor_orders.encoded_order_id'=>$encoded_order_id))->result_array();
		
		if($orderList)
		{
			foreach($orderList as $key=>$list)
			{
				$order_id = $list['order_id'];
				$vendor_id = $list['vendor_id'];
				$productList = $this->db->select('products.id,products.product_name,products.slug,order_item_summary.*')->join('products','products.id = order_item_summary.product_id')->get_where('order_item_summary',array('order_item_summary.order_id'=>$order_id,'order_item_summary.vendor_id'=>$vendor_id))->result_array();
				
				if($productList)
				{
					foreach($productList as $prokey=>$prolist)
					{
						// get product image
						$get_product_img = $this->db->select('image_path')->get_where('product_images',array('product_id'=>$prolist['id'],'is_base'=>1))->row_array();
						$product_img = isset($get_product_img['image_path']) ? $get_product_img['image_path'] : 'skin/front/assets/images/product-default-img.png' ;
						
						$productList[$prokey]['product_img'] = $product_img;
						
						
					}
				}
				
				$orderList[$key]['productInfo'] = $productList;
			}
		}
		
		return $orderList;
	}
	
	public function convert_number_to_text($number = 0)
	{
		$no = floor($number);
		$point = round($number - $no, 2) * 100;
		$hundred = null;
		$digits_1 = strlen($no);
		$i = 0;
		$str = array();
		$words = array('0' => '', '1' => 'one', '2' => 'two',
		'3' => 'three', '4' => 'four', '5' => 'five', '6' => 'six',
		'7' => 'seven', '8' => 'eight', '9' => 'nine',
		'10' => 'ten', '11' => 'eleven', '12' => 'twelve',
		'13' => 'thirteen', '14' => 'fourteen',
		'15' => 'fifteen', '16' => 'sixteen', '17' => 'seventeen',
		'18' => 'eighteen', '19' =>'nineteen', '20' => 'twenty',
		'30' => 'thirty', '40' => 'forty', '50' => 'fifty',
		'60' => 'sixty', '70' => 'seventy',
		'80' => 'eighty', '90' => 'ninety');
		$digits = array('', 'hundred', 'thousand', 'lakh', 'crore');
		while ($i < $digits_1) {
		$divider = ($i == 2) ? 10 : 100;
		$number = floor($no % $divider);
		$no = floor($no / $divider);
		$i += ($divider == 10) ? 1 : 2;
		if ($number) {
		$plural = (($counter = count($str)) && $number > 9) ? 's' : null;
		$hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
		$str [] = ($number < 21) ? $words[$number] .
		" " . $digits[$counter] . $plural . " " . $hundred
		:
		$words[floor($number / 10) * 10]
		. " " . $words[$number % 10] . " "
		. $digits[$counter] . $plural . " " . $hundred;
		} else $str[] = null;
		}
		$str = array_reverse($str);
		$result = implode('', $str);
		$points = ($point) ?
		"." . $words[$point / 10] . " " . 
		$words[$point = $point % 10] : '';
		return ucwords($result) . "Rupees  ";
  
		
	}
	
	public function get_seller_feedback_btn_status($encoded_order_id = '', $product_id = 0, $type = 1)
	{

		// get order id
		$get_order_id = $this->db->get_where('orders',array('encoded_order_id'=>$encoded_order_id))->row_array();
		$order_id = isset($get_order_id['id']) ? $get_order_id['id'] : 0 ;

		$account_id = $this->User->get_logged_user_account_id();
		
		// check seller feedback for account
		return $this->db->get_where('product_review',array('type' => $type,'customer_id' => $account_id,'order_id' => $order_id,'product_id'=>$product_id))->num_rows();
		
		
	}
	
	public function get_current_product_data($product_id = 0)
	{
		$today_date = date('Y-m-d');
		$productList = array();
		if($product_id){
			// product list
			$productList = $this->db->get_where('products',array('status'=>1,'approve_status'=>2,'id'=>$product_id))->result_array();
			if($productList)
			{
				foreach($productList as $key=>$list)
				{
					// get product image
					$get_product_img = $this->db->select('image_path')->get_where('product_images',array('product_id'=>$list['id'],'is_base'=>1))->row_array();
					$product_img = isset($get_product_img['image_path']) ? $get_product_img['image_path'] : 'skin/front/assets/images/product-default-img.png' ;
					
					$productList[$key]['product_img'] = $product_img;
					
					if($list['special_price'] && $list['special_price_to'] >= $today_date)
					{
						$productList[$key]['special_price_status'] = 1;
					}
					else
					{
						$productList[$key]['special_price_status'] = 0;
					}	
					
					
					
				}
			}
		}
		
		return $productList;
	}
	
	public function resize_pro_image($file_name = '')
	{
		if($file_name)
		{
			$this->load->library('image_lib');
	
			$config['image_library'] = 'gd2';
			$config['source_image'] = PRODUCT_IMAGE_FILE_PATH.$file_name;
			$config['new_image'] = PRODUCT_IMAGE_FILE_PATH.'thumbnail-70x70';
			$config['create_thumb'] = FALSE;
			$config['maintain_ratio'] = TRUE;
			$config['width']         = 70;
			$config['height']       = 70;
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
			
			$config['image_library'] = 'gd2';
			$config['source_image'] = PRODUCT_IMAGE_FILE_PATH.$file_name;
			$config['new_image'] = PRODUCT_IMAGE_FILE_PATH.'thumbnail-180x180';
			$config['create_thumb'] = FALSE;
			$config['maintain_ratio'] = TRUE;
			$config['width']         = 180;
			$config['height']       = 180;
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
			
			$config['image_library'] = 'gd2';
			$config['source_image'] = PRODUCT_IMAGE_FILE_PATH.$file_name;
			$config['new_image'] = PRODUCT_IMAGE_FILE_PATH.'thumbnail-400x400';
			$config['create_thumb'] = FALSE;
			$config['maintain_ratio'] = TRUE;
			$config['width']         = 400;
			$config['height']       = 400;
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
		}
		return true;
	}
	public function get_user_delivery_pincode()
	{
		
		$loggedUser = $this->session->userdata('pinkekart_customer_session');
		$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		if(!$account_id)
		{
			$loggedUser = $this->session->userdata('pinkekart_vendor_session');
			$account_id = isset($loggedUser['id']) ? $loggedUser['id'] : 0;
		}
		$user_ip_address = $_SERVER['REMOTE_ADDR'];
		
		$str = 'Deliver to India';
		if($account_id)
		{
			$get_pincode_data = $this->db->get_where('user_delivery_pincode',array('user_id' => $account_id))->row_array();
			if($get_pincode_data)
			{
				$str = 'Deliver to <br /><b>'.$get_pincode_data['district'].' '.$get_pincode_data['pincode'].'</b>';
			}
		}
		else
		{
			$get_pincode_data = $this->db->get_where('user_delivery_pincode',array('ip'=>$user_ip_address))->row_array();
			if($get_pincode_data)
			{
				$str = 'Deliver to <br /><b>'.$get_pincode_data['district'].' '.$get_pincode_data['pincode'].'</b>';
			}
		}
		return $str;
		
	}

	public function get_user_addresses()
	{
		$account_id = $this->get_logged_user_account_id();

		// get all address
		$addressList = $this->db->get_where('user_address',array('userID'=>$account_id))->result_array();
		return $addressList;
	}
	
	public function get_related_product_list($product_id = 0)
	{
		$productList = array();
		if($product_id)
		{
			$productList = $this->db->query("SELECT a.* FROM tbl_products as a INNER JOIN tbl_product_category as b on b.product_id = a.id WHERE b.category_id IN (SELECT category_id FROM tbl_product_category WHERE product_id = '$product_id') AND a.status =1 AND a.approve_status = 2 AND a.id != '$product_id' GROUP BY a.id ")->result_array();
			if($productList)
			{
				foreach($productList as $key=>$list)
				{
					// get product image
					$get_product_img = $this->db->select('image_path,file_name')->get_where('product_images',array('product_id'=>$list['id'],'is_base'=>1))->row_array();
					$product_img = isset($get_product_img['file_name']) ? 'media/product_images/thumbnail-70x70/'.$get_product_img['file_name'] : 'skin/front/assets/images/product-default-img.png' ;
					
					$productList[$key]['product_img'] = $product_img;
					
					if($list['special_price'] && $list['special_price_to'] >= $today_date)
					{
						$productList[$key]['special_price_status'] = 1;
					}
					else
					{
						$productList[$key]['special_price_status'] = 0;
					}	
					
					// get product review & rating
					$totalReview = $this->db->select('count(*) as total_user,sum(rating) as total_rating')->get_where('product_review',array('is_variation'=>0,'product_id'=>$list['id'],'type'=>2))->row_array();					
					
					$productList[$key]['total_review'] = isset($totalReview['total_user']) ? $totalReview['total_user'] : 0;
					$productList[$key]['total_user'] = isset($totalReview['total_user']) ? $totalReview['total_user'] : 0;
					$productList[$key]['total_rating'] = isset($totalReview['total_user']) ? ($totalReview['total_user']) ? round($totalReview['total_rating']/$totalReview['total_user']) : 0 : 0;
					
					if($productList[$key]['total_rating'] == 0)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/0-star.png');
					elseif($productList[$key]['total_rating'] == 1)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/1-star.png');
					elseif($productList[$key]['total_rating'] == 2)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/2-star.png');	
					elseif($productList[$key]['total_rating'] == 3)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/3-star.png');	
					elseif($productList[$key]['total_rating'] == 4)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/4-star.png');	
					elseif($productList[$key]['total_rating'] == 5)
						$productList[$key]['rating_img'] = base_url('skin/front/assets/images/5-star.png');
					
					// check wishlist status
					$productList[$key]['wishlist_status'] = $this->User->check_product_wishlist_status($list['id']);
					
				}
			}
		}
		return $productList;
	}
	
	public function get_category_sub_category_list($slug)
	{
		// check slug is valid or not
		$response = array();
		$chk_category = $this->db->get_where('category',array('id'=>$slug,'status'=>1))->num_rows();
		if($chk_category)
		{
			$get_category_id = $this->db->get_where('category',array('id'=>$slug,'status'=>1))->row_array();
			$i = 0;
			$response[$i] = $get_category_id['id'];
			// get sub category id
			$sub_category_list = $this->db->get_where('category',array('parent_id'=>$get_category_id['id'],'status'=>1))->result_array();
			if($sub_category_list)
			{
				foreach($sub_category_list as $list)
				{
					$i++;
					$response[$i] = $list['id'];
					// get sub category id
					$sub_sub_category_list = $this->db->get_where('category',array('parent_id'=>$list['id'],'status'=>1))->result_array();
					if($sub_sub_category_list)
					{
						foreach($sub_sub_category_list as $sub_list)
						{
							$i++;
							$response[$i] = $sub_list['id'];
							// get sub category id
							$sub_sub_sub_category_list = $this->db->get_where('category',array('parent_id'=>$sub_list['id'],'status'=>1))->result_array();
							if($sub_sub_sub_category_list)
							{
								foreach($sub_sub_sub_category_list as $sub_sub_list)
								{
									$i++;
									$response[$i] = $sub_sub_list['id'];
								}
							}
						}
					}
				}
			}
		}
		return $response;
	}
	
	public function get_category_sub_category_list_by_slug($slug)
	{
		// check slug is valid or not
		$response = array();
		$chk_category = $this->db->get_where('category',array('slug'=>$slug,'status'=>1))->num_rows();
		if($chk_category)
		{
			$get_category_id = $this->db->get_where('category',array('slug'=>$slug,'status'=>1))->row_array();
			$i = 0;
			$response[$i] = $get_category_id['id'];
			// get sub category id
			$sub_category_list = $this->db->get_where('category',array('parent_id'=>$get_category_id['id'],'status'=>1))->result_array();
			if($sub_category_list)
			{
				foreach($sub_category_list as $list)
				{
					$i++;
					$response[$i] = $list['id'];
					// get sub category id
					$sub_sub_category_list = $this->db->get_where('category',array('parent_id'=>$list['id'],'status'=>1))->result_array();
					if($sub_sub_category_list)
					{
						foreach($sub_sub_category_list as $sub_list)
						{
							$i++;
							$response[$i] = $sub_list['id'];
							// get sub category id
							$sub_sub_sub_category_list = $this->db->get_where('category',array('parent_id'=>$sub_list['id'],'status'=>1))->result_array();
							if($sub_sub_sub_category_list)
							{
								foreach($sub_sub_sub_category_list as $sub_sub_list)
								{
									$i++;
									$response[$i] = $sub_sub_list['id'];
								}
							}
						}
					}
				}
			}
		}
		return $response;
	}
	
	public function get_parent_category_list()
	{
		// get page list
		$categoryList = $this->db->get_where('category',array('parent_id'=>0,'status'=>1))->result_array();
		return $categoryList;
	}

	public function get_category_brand_list($category_id)
	{
		// get brand list
		$brandList = $this->db->select('brands.id,brands.title')->join('product_brands','product_brands.product_id = product_category.product_id')->join('brands','brands.id = product_brands.brand_id')->group_by('product_brands.brand_id')->where_in('product_category.category_id',$category_id)->get_where('product_category',array('brands.status'=>1))->result_array();
		return $brandList;
	}

	public function get_all_category_brand_list()
	{
		// get brand list
		$brandList = $this->db->select('brands.id,brands.title')->join('product_brands','product_brands.product_id = product_category.product_id')->join('brands','brands.id = product_brands.brand_id')->group_by('product_brands.brand_id')->get_where('product_category',array('brands.status'=>1))->result_array();
		return $brandList;
	}

	public function get_vendor_role_id($vendor_id = 0)
	{
		$get_content = $this->db->select('vendor_role_id')->get_where('users',array('id'=>$vendor_id))->row_array();
		return isset($get_content['vendor_role_id']) ? $get_content['vendor_role_id'] : 0 ;
	}

	public function get_parent_category_id($cat_id = 0)
	{
		// get parent id
		$get_parent_id = $this->db->select('parent_id')->get_where('category',array('id'=>$cat_id))->row_array();
		if($get_parent_id)
		{
			$parent_id = isset($get_parent_id['parent_id']) ? $get_parent_id['parent_id'] : 0 ;
			if($parent_id)
			{
				// get parent id
				$get_sub_parent_id = $this->db->select('parent_id')->get_where('category',array('id'=>$parent_id))->row_array();
				if($get_sub_parent_id)
				{
					$sub_parent_id = isset($get_sub_parent_id['parent_id']) ? $get_sub_parent_id['parent_id'] : 0 ;
					if($sub_parent_id)
					{
						// get parent id
						$get_sub_sub_parent_id = $this->db->select('parent_id')->get_where('category',array('id'=>$sub_parent_id))->row_array();
						if($get_sub_sub_parent_id)
						{
							$sub_sub_parent_id = isset($get_sub_sub_parent_id['parent_id']) ? $get_sub_sub_parent_id['parent_id'] : 0 ;
							if($sub_sub_parent_id)
							{
								// get parent id
								$get_sub_sub_sub_parent_id = $this->db->select('parent_id')->get_where('category',array('id'=>$sub_sub_parent_id))->row_array();
								if($get_sub_sub_sub_parent_id)
								{
									$sub_sub_sub_parent_id = isset($get_sub_sub_sub_parent_id['parent_id']) ? $get_sub_sub_sub_parent_id['parent_id'] : 0 ;
									if($sub_sub_sub_parent_id)
									{

									}
									else
									{
										return $sub_sub_parent_id;
									}
								}
								else
								{
									return $sub_sub_parent_id;
								}
							}
							else
							{
								return $sub_parent_id;
							}
						}
						else
						{
							return $sub_parent_id;
						}
					}
					else
					{
						return $parent_id;
					}
				}
				else
				{
					return $parent_id;
				}
			}
			else
			{
				return $cat_id;
			}
		}
		else
		{
			return $cat_id;
		}
	}



	public function generate_shiprocket_token(){


		$shiprocket_token_generate_url = SHIPROCKET_TOKEN_GENERATE_URL;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$shiprocket_token_generate_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
       	curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS,
            "email=".USER_EMAIL."&password=".USER_PASSWORD."");
       	$output = curl_exec ($ch);
        curl_close ($ch);
        $responseData = json_decode($output,true);

        if(isset($responseData['token'])){

        	$this->db->where('id',1);
        	$this->db->update('site_settings',array('shiprocket_token'=>$responseData['token']));
        }

	}



	public function save_shiprocket_address($account_id = 0,$address_id = 0){

		$chk_address = $this->db->get_where('user_address',array('id'=>$address_id,'userID'=>$account_id,'is_shiprocket_saved'=>0))->row_array();
		
		$get_token = $this->db->get_where('site_settings',array('id'=>1))->row_array();

		$token = isset($get_token['shiprocket_token']) ? $get_token['shiprocket_token'] : '';

		$loggedUser = $this->db->get_where('users',array('id'=>$account_id))->row_array();

		$get_state = $this->db->get_where('states',array('id'=>$chk_address['state']))->row_array();

		$state = isset($get_state['name']) ? $get_state['name'] : '';
		
		$country = 'india';

		if($chk_address && $token){


			$shiprocket_pickup_location_add_url = SHIPROCKET_PICKUP_LOCATION_ADD_URL;

	        $ch = curl_init();
	        curl_setopt($ch, CURLOPT_URL,$shiprocket_pickup_location_add_url);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	        $headers = array(
			   "Content-Type: application/json",
			   "Authorization: Bearer ".$token,
			);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

			$post = array(

			 'pickup_location' => $chk_address['address_1'],
			 'name'	           => $chk_address['name'],
			 'email'           => $loggedUser['email'],
			 'phone'           => $chk_address['phone_number'],
			 'address'         => $chk_address['address_1'],
			 'address_2'       => $chk_address['address_2'],
			 'city'			   => $chk_address['city'],
			 'state'		   => $state,
			 'country'		   => $country,
			 'pin_code'		   => $chk_address['zip_code']	
			);

			$post_data = json_encode($post);

	       	curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
	       	$output = curl_exec ($ch);
	       	$responseData = json_decode($output,true);
	       	curl_close ($ch);
	        
	        if($responseData['success'] == "true"){

	        	$this->db->where('id',$address_id);
	        	$this->db->where('userID',$account_id);
	        	$this->db->update('user_address',array('is_shiprocket_saved'=>1,'shiprocket_response'=>json_encode($responseData)));

	        	$response = array(

				 'status' => 1,
				 'message'=>'Success'	

				);

	        }
	        else{

	        	$response = array(

				 'status' => 0,
				 'message'=>'Sorry!! address is not valid.'	

				);
	        }	

		}
		else{


			$response = array(

			 'status' => 1,
			 'message'=>'success'	

			);

		}

		return $response;

	}



	public function create_shiprocket_order($order_data)
	{	
		$get_token = $this->db->get_where('site_settings',array('id'=>1))->row_array();

		$token = isset($get_token['shiprocket_token']) ? $get_token['shiprocket_token'] : '';

		if($order_data){


			$shiprocket_create_order_url = SHIPROCKET_CREATE_ORDER_URL;

	        $ch = curl_init();
	        curl_setopt($ch, CURLOPT_URL,$shiprocket_create_order_url);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	        $headers = array(
			   "Content-Type: application/json",
			   "Authorization: Bearer ".$token,
			);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

			$post_data = json_encode($order_data);

	       	curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
	       	$output = curl_exec ($ch);
	       	$responseData = json_decode($output,true);
	       	
	       	curl_close ($ch);
	    	
	    }
		else{


			$response = array(

			 'status' => 0,
			 'message'=>'failed'	

			);

		}

		return $response;

	}
	
	
	
	public function generateOwlxfintechToken(){
	    
	    $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.owlxfintech.com/api/v1/auth/realms/owlx/protocol/openid-connect/token',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          //CURLOPT_POSTFIELDS => 'client_id=31fb6ecb-7fb4-41a2-a451-83ad75c55042&client_secret=XGckBSHngkNvkp7N0c27T6NaSuJGnk93&grant_type=client_credentials',
          CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_secret=9dNubxuICN5PKSoN4USfyXpAUXGwerku&client_id=73f2af10-baf5-4efc-a350-69c65eb2cfbe',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        
        $responseData = json_decode($response,true);
        
        return $responseData['access_token'];
	}
    
    
    public function generateOwlxfintechOrder($order_id = '',$amount = '',$name = '',$phone = '',$email = ''){
        
        $token = $this->generateOwlxfintechToken();
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.owlxfintech.com/api/v1/collect/payin',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
          "orderId": "'.$order_id.'",
          "provider": "provider1",
          "paymentType": "intent",
          "amount": '.$amount.',
          "currency": "INR",
          "vpa": "customer@upi",
          "name": "'.$name.'",
          "phone": "'.$phone.'",
          "email": "'.$email.'",
          "description": "Payment for order #'.$order_id.'",
          "notifyurl": "https://mokshkart.com/cron/owlxfintechPayinCallback",
          "redirectUrl": "https://mokshkart.com/cron/owlxfintechPayinCallback"
        }',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$token
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        
        $responseData = json_decode($response,true);
        
        return array("orderId"=>$responseData['orderId'],"token"=>$token);
    }
	

}


/* end of file: user.php */
/* Location: ./application/models/admin/user.php */