<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * Model used for setup default message and resize image
 * 
 * This one used for defined some methods accross all site.
 * this one used for show system message, errors.
 * this one used for image resizing
 * @author trilok
 */

require_once BASEPATH . '/core/Model.php';

class Coupon_model extends CI_Model 
{ 

    public function __construct() 
    {
 		parent::__construct();
    }
    
	
	public function save_coupon($post)
	{
		$loggedUser = $this->User->getLoggedUser("vendor_user");
		$account_id = $loggedUser['id'];
		
		$data = array(
			'account_id' => $account_id,
			'coupon_name' => $post['cupon_name'],
			'code' => $post['code'],
			'type' => $post['type'],
			'discount' => $post['discount'],
			'total_amount' => $post['total_amount'],
			'is_customer_login' => 0,
			'date_start' => $post['start_date'],
			'date_end' => $post['end_date'],
			'uses_per_coupon' => $post['uses_per_cupon'],
			'uses_per_customer' => $post['uses_per_customer'],
			'status' => $post['status'],
			'created' => date('Y-m-d H:i:s')
		);
		$query=$this->db->insert('coupon',$data);
		$cupon_id = $this->db->insert_id();

		
		if(isset($post['product_id'])){
			foreach($post['product_id'] as $id){

				$product_data=array(
					'account_id'=>$account_id,	
					'coupon_id'=>$cupon_id,
					'product_id'=>$id
				);	

				$this->db->insert('coupon_product',$product_data);

			}

		}

		if(isset($post['category_id']))
		{
			foreach($post['category_id'] as $catID)
			{
				$catData = array(
					'account_id' => $account_id,
					'coupon_id' => $cupon_id,
					'category_id' => $catID,
				);
				$this->db->insert('coupon_category',$catData);
			}
		}

		return true;
	
	}


	public function update_coupon($post)
	{

		$loggedUser = $this->User->getLoggedUser("vendor_user");
		$account_id = $loggedUser['id'];
		
		$data = array(
			'coupon_name' => $post['cupon_name'],
			'code' => $post['code'],
			'type' => $post['type'],
			'discount' => $post['discount'],
			'total_amount' => $post['total_amount'],
			'is_customer_login' => 0,
			'date_start' => $post['start_date'],
			'date_end' => $post['end_date'],
			'uses_per_coupon' => $post['uses_per_cupon'],
			'uses_per_customer' => $post['uses_per_customer'],
			'status' => $post['status'],
			'updated' => date('Y-m-d H:i:s')
		);
		$this->db->where('id',$post['id']);
		$this->db->where('account_id',$account_id);
		$this->db->update('coupon',$data);
		
		$coupn_id = $post['id'];


		if(isset($post['product_id'])){

			$this->db->where('account_id',$account_id);
			$this->db->where('coupon_id',$post['id']);
			$this->db->delete('coupon_product');


			foreach($post['product_id'] as $product_id){
				
				$product_data=array(
					'account_id'=>$account_id,	
					'coupon_id'=>$post['id'],
					'product_id'=>$product_id,
				);	
				$this->db->insert('coupon_product',$product_data);
				

			}

		}

		if(isset($post['category_id']))
		{
			$this->db->where('account_id',$account_id);
			$this->db->where('coupon_id',$post['id']);
			$this->db->delete('coupon_category');
			foreach($post['category_id'] as $catID)
			{
				$catData = array(
					'account_id' => $account_id,
					'coupon_id' => $post['id'],
					'category_id' => $catID,
				);
				
				$this->db->insert('coupon_category',$catData);
				
			}
		}

		return true;
	
	}
	
}
?>