<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
	<?php echo form_open_multipart('admin/banners/updateBanner', array('id' => 'admin_profile'), array('method' => 'post')); ?>
	<!-- Content Header (Page header) -->
	<section class="content-header">
		{system_message}
		{system_info}
		<h1>Edit Banner</h1>
		<br />
		<?php
		$data = array(
			'name' => 'btn-create',
			'value' => 'Update Banner',
			'class' => 'btn btn-primary'
		);
		echo form_submit($data);
		?>
		<a href="{site_url}admin/banners" class="btn btn-warning">Back to Banner List</a>

	</section>

	<section class="content">
		<div class="row">
			<!-- left column -->
			<div class="col-md-6">
				<div class="box box-success">
					<div class="box-body">
						<input type="hidden" name="id" value="<?php echo $id; ?>">
						<div class="form-group">
							<label>Status</label>
							<select id="select01" class="form-control" name="status">
								<option value="1" <?php if ($bannerData['is_active'] == 1) { ?> selected="" <?php } ?>>Active</option>
								<option value="0" <?php if ($bannerData['is_active'] == 0) { ?> selected="" <?php } ?>>Deactive</option>
							</select>
						</div>

						<div class="form-group">
							<label>Banner Type <span class="star">*</span></label>
							<select id="select01" class="form-control" name="banner_type_id">
								<option value="">Select Banner Type</option>
								<?php if ($bannerTypeList) { ?>
									<?php foreach ($bannerTypeList as $list) { ?>
										<option value="<?php echo $list['id']; ?>" <?php if ($list['id'] == $bannerData['banner_type_id']) { ?> selected="" <?php } ?>><?php echo $list['title']; ?></option>
									<?php } ?>
								<?php } ?>
							</select>
							<?php echo form_error('banner_type_id', '<div class="error">', '</div>'); ?>
						</div>

						<div class="form-group">
							<label>Banner Image <span class="star">*</span></label>
							<input type="file" name="banner_image" />
							<p>Only .jpg,.png or .gif format allowed.</p>
							<img src="{site_url}<?php echo $bannerData['image_path']; ?>" width="80" height="80">
							<?php echo form_error('banner_image', '<div class="error">', '</div>'); ?>
						</div>

						<div class="form-group">
							<label>Position No. (optional)</label>
							<input type="text" class="form-control input-sm" name="order_no" id="order_no" autocomplete="off" placeholder="Position No. (Leave Blank for auto position)" value="<?php echo $bannerData['order_no']; ?>">
							<?php echo form_error('order_no', '<div class="error">', '</div>'); ?>
						</div>
						
						<div class="form-group">
							<label>Link URL (optional)</label>
							<?php
							$data = array(
								'name' => 'redirect_url',
								'id' => 'redirect_url',
								'class' => 'form-control input-sm',
								'autocomplete' => 'off',
								'placeholder' => 'Link URL',
								'value' => $bannerData['redirect_url'],

							);
							echo form_input($data);
							?>
							<?php echo form_error('redirect_url', '<div class="error">', '</div>'); ?>
						</div>

						<div class="form-group">
							<label>Is open link url in new tab ?</label><br />
							<input type="radio" name="is_new_tab" value="1" id="is_new_tab_1" <?php if ($bannerData['is_new_tab'] == 1) { ?> checked="" <?php } ?> />
							<label for="is_new_tab_1">Yes</label>
							<input type="radio" name="is_new_tab" value="0" id="is_new_tab_0" <?php if ($bannerData['is_new_tab'] == 0) { ?> checked="" <?php } ?> />
							<label for="is_new_tab_0">No</label>
						</div>

						<div class="form-group">
							<label>Banner Title</label>
							<input type="text" class="form-control input-sm" name="title" id="title" autocomplete="off" placeholder="Title" value="<?php echo $bannerData['title']; ?>">
							<?php echo form_error('title', '<div class="error">', '</div>'); ?>
						</div>

						<div class="form-group">
							<label>Banner Sub Title</label>
							<input type="text" class="form-control input-sm" name="sub_title" id="sub_title" autocomplete="off" placeholder="Sub Title" value="<?php echo $bannerData['sub_title']; ?>">
							<?php echo form_error('sub_title', '<div class="error">', '</div>'); ?>
						</div>

						<div class="form-group">
							<label>Banner Short Description</label>
							<textarea type="text" class="form-control input-sm" name="short_desc" id="short_desc" autocomplete="off" placeholder="Short Description" ><?php echo $bannerData['short_desc']; ?></textarea>

							<?php echo form_error('short_desc', '<div class="error">', '</div>'); ?>
						</div>

					</div>
				</div>
			</div>
		</div>
	</section>
	<?php echo form_close(); ?>
</div>
