<div class="breadcrumb-area">
    <div class="container">
        <div class="breadcrumb-wrap text-center">
            <h2 class="page-title">Shopping Cart</h2>
            <ul class="breadcrumb-pages">
                <li class="page-item"><a class="page-item-link" href="{site_url}home">Home</a></li>
                <li class="page-item">Shopping Cart</li>
            </ul>
        </div>
    </div>
</div>
<br>
<input type="hidden" name="site_url" id="siteUrl" value="<?php echo $site_url; ?>">
{system_message}
{system_warning}


<div class="product-area pt-70 pb-70">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 col-lg-12">

                    <div class="container">
                        <table class="table table-bordered">
                            <thead style="text-align: center;">
                                <tr>
                                    <th>SN</th>
                                    <th>Image</th>
                                    <th>Product Name</th>
                                    <th>Price</th>
                                    <th>Quantity</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $total = 0; $sn= 1;
                                if ($cartProductList) {
                                    foreach ($cartProductList as $list) {
                                        $total += $list['price'] * $list['qty']; ?>
                                        <tr id="cart-row-<?php echo $list['id']; ?>" style="text-align:center">
                                        <td><?php echo $sn; ?></td>
                                            <td>
                                                <a href="{site_url}product/detail/<?php echo $list['slug']; ?>">
                                                    <img class="img-thumbnail" src="{site_url}<?php echo $list['product_img']; ?>" alt="product" width="50" height="50"/>
                                                </a>
                                            </td>
                                            <td>
                                                <h3 class="product-name">
                                                    <a class="product-link" href="{site_url}product/detail/<?php echo $list['slug']; ?>">
                                                        <?php echo substr($list['product_name'], 0, 40); ?>
                                                    </a>
                                                </h3>
                                            </td>

                                            <td>
                                                <?php if ($list['special_price_status']) { ?>
                                                    <div>
                                                        <h4 id="pro-qty-price<?php echo $list['id']; ?>"><span class="regular-price">Rs.<?php echo number_format($list['price'] * $list['qty'], 2); ?></span></h4>
                                                        <br/>
                                                        <span class="price">Rs.<?php echo $list['special_price']; ?></span>
                                                    </div>
                                                <?php } else { ?>
                                                    <h4 id="pro-qty-price<?php echo $list['id']; ?>"><span class="price">Rs. <?php echo number_format($list['price'] * $list['qty'], 2); ?></span></h4>
                                                <?php } ?>
                                            </td>

                                            <td>
                                                <select id="selProQty<?php echo $list['id']; ?>" class="cat-pro-qty" onchange="updateProCart(<?php echo $list['id']; ?>, this.value, <?php echo $list['temp_id']; ?>)">
                                                    <?php for ($i = 1; $i <= 10; $i++) { ?>
                                                        <option value="<?php echo $i; ?>" <?php if ($list['qty'] == $i) { ?> selected="selected" <?php } ?>><?php echo $i; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </td>

                                            <td>

                                                <button class="btn btn-link text-danger p-0" onclick="deleteProCart(<?php echo $list['id']; ?>, <?php echo $list['temp_id']; ?>)" aria-label="Delete" style="font-size:25px;"><i class="fas fa-trash"></i></button>

                                                <button class="btn btn-link text-danger p-0" onclick="addtowish(<?php echo $list['id']; ?>, <?php echo $list['temp_id']; ?>)" aria-label="Delete" style="font-size:25px;"><i class="fa fa-heart"></i></button>

                                            </td>
                                        </tr>

                                    <?php $sn++;  } 
                                } else { ?>
                                    <tr>
                                        <td colspan="12" class="text-center" id="msgBody">Sorry! There are no products available in your cart.</td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>

                        <?php if ($cartProductList) { ?>
                        
                        <div class="col-sm-12" id="cart-total-block">

                            <div class="box">
                                <div class="box_inner">
                                    <div class="single-grid-product">
                                        <div class="product-info">
                                            <div class="product-price">
                                                <h3 id="pro-total-price">Subtotal (<?php echo count($cartProductList); ?> Items) : <span class="price">Rs. <?php echo number_format($total, 2); ?></span></h3>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if ($this->session->userdata('pinkekart_vendor_session') || $this->session->userdata('pinkekart_customer_session')) { ?>

                                        <a href="{site_url}checkout"><button type="button" class="pro_btn" name="proceed" value="Proceed">Proceed to Checkout</button></a>

                                    <?php } else { ?>

                                        <a href="{site_url}login?ret_url=checkout"><button type="button" class="pro_btn" name="proceed" value="Proceed">Proceed to Checkout</button></a>

                                    <?php } ?>
                                    <a href="{site_url}"><button type="button" class="btn-primary">Continue to shopping</button></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    </div>


                    
                </div>
            </div>
        </div>
    </div>
</div>