<div class="breadcrumb-area">
	<div class="container">
		<div class="breadcrumb-wrap text-center">
			<h2 class="page-title">Checkout</h2>
			<ul class="breadcrumb-pages">
				<li class="page-item"><a class="page-item-link" href="{site_url}home">Home</a></li>
				<li class="page-item">Checkout</li>
			</ul>

		</div>
	</div>
</div>
{system_message}
{system_warning}
<?php if ($addressList) { ?>
	<div class="sign-in-page sign-up-page section">
		<div class="container">
			<div class="row align-items-center justify-content-center">
				<div class="row">
					<div class="col-sm-12 text-center">
						<div class="form_content">
							<h3>Select a delivery address</h3>
							<p>Is the address you'd like to use displayed below? If so, click the corresponding "Deliver to this address" button. Or you can enter a new shipping address. </p>
						</div>
					</div>
				</div>


				<div class="col-12 col-lg-12">
					<div class="login-wrap">

						<?php foreach ($addressList as $aList) { ?>
							<div class="col-sm-4" id="checkout-add-block-<?php echo $aList['id']; ?>">
								<div class="content_new_div">
									<h3><?php echo $aList['name']; ?></h3>
									<p><?php echo $aList['address_1']; ?>,<br /><?php echo $aList['address_2']; ?><br />
										Phone: <?php echo $aList['phone_number']; ?></p>

									<div class="col-sm-12" style="padding-left:0px;">
										<a href="{site_url}checkout/review/<?php echo $aList['id']; ?>"><button type="button" class="btn-primary" value="deliver">Deliver to this address</button></a>

										<button type="button" onclick="openUpdateAddModal(<?php echo $aList['id']; ?>)" class="btn-secondary" value="edit">Edit</button>

										<button type="button" onclick="deleteCheckoutAdd(<?php echo $aList['id']; ?>)" class="btn-danger" value="delete">Delete</button>
									</div>

									
								</div>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php } ?>

<div class="sign-in-page sign-up-page section">
	<div class="container">
		<div class="row align-items-center justify-content-center">
			<div class="row">
				<div class="col-sm-12 text-center">
					<div class="form_content">
						<h3>Add a new address</h3>
						<p>Be sure to click "Deliver to this address" when done.</p>
					</div>
				</div>
			</div>

			<div class="col-12 col-lg-12">
				<div class="login-wrap">
					<?php echo form_open('checkout/addAuth'); ?>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<label for="name">Full Name<span class="star">*</span> : </label>
								<input type="text" name="name" class="form-control" placeholder="Full Name" value="<?php echo set_value('name'); ?>">
								<?php echo form_error('name', '<div class="error">', '</div>'); ?>
							</div>
						</div>

						<div class="col-sm-6">
							<div class="form-group">
								<label for="phone_number">Phone Number<span class="star">*</span> : </label>
								<input type="text" name="phone_number" maxlength="10" class="form-control" placeholder="Phone Number" value="<?php echo set_value('phone_number'); ?>">
								<?php echo form_error('phone_number', '<div class="error">', '</div>'); ?>
							</div>
						</div>

						<div class="col-sm-6">
							<div class="form-group">
								<label for="address_line_1"> Address line 1<span class="star">*</span> : </label>
								<input type="text" name="address_line_1" maxlength="36" class="form-control" placeholder="Street address, P.O. box, company name, c/o " value="<?php echo set_value('address_line_1'); ?>">
								<?php echo form_error('address_line_1', '<div class="error">', '</div>'); ?>
							</div>
						</div>
						<div class="col-sm-6">

							<div class="form-group">
								<label for="address_line_2"> Address line 2 : </label>
								<input type="text" name="address_line_2" class="form-control" placeholder="Apartment, suite, unit, building, floor, etc." value="<?php echo set_value('address_line_2'); ?>">
								<?php echo form_error('address_line_2', '<div class="error">', '</div>'); ?>
							</div>
						</div>




						<div class="col-sm-6">

							<div class="form-group">
								<label for="postal_code"> ZIP/Postal Code<span class="star">*</span> : </label>
								<input type="text" name="postal_code" id="postal_code" class="form-control" placeholder="Zip/Postal Code" maxlength="6" value="<?php echo set_value('postal_code'); ?>">
								<?php echo form_error('postal_code', '<div class="error">', '</div>'); ?>
							</div>
						</div>
						<div class="col-sm-6">

							<div class="form-group">
								<label for="city"> City : </label>
								<input type="text" name="city" style="background: white;" title="Please Enter City" id="city" class="form-control" placeholder="City Name" value="<?php echo set_value('city'); ?>">
								<?php echo form_error('city', '<div class="error">', '</div>'); ?>
							</div>
						</div>
						<div class="col-sm-6">

							<div class="form-group">
								<label for="state"> State/Province/Region : </label>
								<select name="state" class="form-control">
									<option value="">Select State</option>
									<?php if ($stateList) { ?>
										<?php foreach ($stateList as $cList) { ?>
											<option value="<?php echo $cList['id']; ?>"><?php echo $cList['name']; ?></option>
										<?php } ?>
									<?php } ?>

								</select>
								<!-- <input type="text" class="form-control" style="background: white;" name="state" id="state" title="Please Enter State" placeholder="State Name">
								<?php echo form_error('state', '<div class="error">', '</div>'); ?> -->
							</div>
						</div>
						<div class="col-sm-6">

							<div class="form-group">
								<label for="country"> Country/Region : </label>
								<!-- <input type="text" class="form-control" style="background: white;" name="country" id="country" title="Please Enter Country"  placeholder="Country Name"> -->
								<select name="country" class="form-control">
									<option value="">Select Country</option>
									<?php if ($countryList) { ?>
										<?php foreach ($countryList as $cList) { ?>
											<option value="<?php echo $cList['id']; ?>" <?php if ($cList['id'] == 101) { ?> selected="selected" <?php } ?>><?php echo $cList['name']; ?></option>
										<?php } ?>
									<?php } ?>

								</select>

								<?php echo form_error('country', '<div class="error">', '</div>'); ?>
							</div>
						</div>

						<div class="form-group">
							<button type="submit" class="form-control btn btn-primary rounded submit px-3 primary-btn">Pay Now</button>
						</div>

					</div>

				</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<!-- Modal -->
<div id="checkoutAddModal" class="modal fade" role="dialog">
	<div class="modal-dialog">

		<!-- Modal content-->
		<div class="modal-content">
			<?php echo form_open('#', array('id' => 'checkout-add-form')); ?>
            <input type="hidden" name="recordID" id="recordID" value="0" />
            <div class="modal-header">
			<h4 class="modal-title">Update Address</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                
            </div>

			<div class="modal-body">
				<div class="row">
					<div class="col-sm-12">
						
						<div class="form-group mb-3">
							<label for="checkout-add-name-input">Full Name :</label>
							<input type="text" name="name" class="form-control" id="checkout-add-name-input" value="" />
							<?php echo form_error('name', '<div class="error">', '</div>'); ?>
						</div>

						<div class="form-group mb-3">
                            <label for="checkout-add-phone-input">Phone Number:</label>
                            <input type="text" name="phone_number" maxlength="10" class="form-control" id="checkout-add-phone-input" value=""/>
							<?php echo form_error('phone_number', '<div class="error">', '</div>'); ?>
                        </div>

                        <div class="form-group mb-3">
                            <label for="checkout-add-address-1-input">Address Line 1:</label>
                            <input type="text" name="address_line_1" maxlength="36" class="form-control" id="checkout-add-address-1-input" value="" />
							<?php echo form_error('address_line_1', '<div class="error">', '</div>'); ?>
                        </div>

                        <div class="form-group mb-3">
                            <label for="checkout-add-address-2-input">Address Line 2:</label>
                            <input type="text" name="address_line_2" class="form-control" id="checkout-add-address-2-input" value="" />
							<?php echo form_error('address_line_2', '<div class="error">', '</div>'); ?>
                        </div>

                        <div class="form-group mb-3">
                            <label for="checkout-add-postal-code-input">ZIP/Postal Code:</label>
                            <input type="text" name="postal_code" id="checkout-add-postal-code-input" maxlength="6" class="form-control" value="" />
							<?php echo form_error('postal_code', '<div class="error">', '</div>'); ?>
                        </div>

                        <div class="form-group mb-3">
                            <label for="checkout-add-city-input">City:</label>
                            <input type="text" placeholder="City" readonly class="form-control" title="Please Enter Zip Code" name="city" id="checkout-add-city-input" value="" />
                        </div>

                        <div class="form-group mb-3">
                            <label for="checkout-add-state-input">State/Province/Region:</label>
                            <input type="text" class="form-control" style="background: white;" name="state" id="checkout-add-state-input" title="Please Enter Zip Code" readonly placeholder="State Name">
                        </div>

                        <div class="form-group mb-3">
                            <label for="checkout-add-country-input">Country/Region:</label>
                            <input type="text" class="form-control" style="background: white;" name="country" id="checkout-add-country-input" title="Please Enter Zip Code" readonly placeholder="Country Name">
                        </div>

                        <div class="col-sm-12" id="checkout-update-add-loader"></div>
						</div>
				</div>

			</div>
			<div class="modal-footer">
				<button type="button" id="checkout-update-add-btn" class="seller-btn">Update</button>
			</div>
			<?php echo form_close(); ?>
		</div>

	</div>
</div>