<div class="breadcrumb-area">
    <div class="container">
        <div class="breadcrumb-wrap text-center">
            <h2 class="page-title">Open Orders</h2>
            <ul class="breadcrumb-pages">
                <li class="page-item"><a class="page-item-link" href="{site_url}home">Home</a></li>

                <li class="page-item"><a class="page-item-link" href="{site_url}customer/dashboard">Your Account</a></li>

                <li class="page-item">Your Open Orders</li>
            </ul>
        </div>
    </div>
</div>

{system_message}
{system_warning}
<div class="sign-in-page order_page ">
    <div class="login_section">
        <div class="container">
            <div class="row box2">
                <div class="col-md-4">
                    <div class="account"><a href="{site_url}customer/orders">
                            <div class="inner_box">

                                <div class="col-md-12 text-center">
                                    <button type="button" class="btn btn-primary">All Orders</button>
                                    <hr>
                                        <h3 class="ord">Your all orders list</h3>
                                </div>

                            </div>
                        </a>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="account"><a href="{site_url}customer/orders/openOrder">
                            <div class="inner_box">

                                <div class="col-sm-12 text-center">
                                    <button type="button" class="btn btn-secondary">Open Orders</button>
                                    <hr>
                                        <h3 class="ord">Your open orders list</h3>
                                </div>

                            </div>
                        </a>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="account"><a href="{site_url}customer/orders/cancelOrder">
                            <div class="inner_box">
                                <div class="img_box">
                                    <div class="col-sm-12 text-center">
                                        <button type="button" class="btn btn-danger">Cancelled Orders</button>
                                        <hr>
                                        <h3 class="ord">Your cancelled orders list</h3>
                                        <!-- <p class="para-track">Your cancelled orders list</p> -->
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>




            <?php if ($orderData): ?>
                <?php foreach ($orderData as $key => $list): ?>
                    <?php
                    $total = 0;
                    foreach ($list['productInfo'] as $prooList) {
                        $total += $prooList['payable_amount'];
                    }
                    ?>

                    <div class="container order-pro-info">
                        <div class="row">
                            <div class="content_box">
                                <div class="content">
                                    <div class="col-sm-12">
                                        <div class="row con order_summary_head">
                                            <div class="col-sm-2">
                                                <h5>ORDER PLACED</h5>
                                                <h5><?php echo date('d M, Y', strtotime($list['created'])); ?></h5>
                                            </div>

                                            <div class="col-sm-2">
                                                <h5>TOTAL</h5>
                                                <h5>&#8377; <?php echo number_format($total, 2); ?></h5>
                                            </div>

                                            <div class="col-sm-3">
                                                <h5>SHIP TO</h5>
                                                <h5>
                                                    <a href="#" data-html="true" data-toggle="tooltip" title="<?php echo htmlspecialchars($list['add_name']); ?><br>
                                                    <?php echo htmlspecialchars($list['address_1']); ?><br>
                                                <?php echo htmlspecialchars($list['address_2']); ?><br>
                                                <?php echo htmlspecialchars($list['city']); ?>, <?php echo htmlspecialchars($list['country_name']); ?><br>
                                                Phone: <?php echo htmlspecialchars($list['phone_number']); ?> ">
                                                        <?php echo htmlspecialchars($list['add_name']); ?>
                                                    </a>
                                                </h5>
                                            </div>

                                            <div class="col-sm-2">&nbsp;</div>
                                            <div class="col-sm-3" align="right">
                                                <h5>ORDER # <?php echo htmlspecialchars($list['order_display_id']); ?></h5>
                                                <h5>
                                                    <a href="{site_url}customer/orders/detail/<?php echo htmlspecialchars($list['encoded_order_id']); ?>">Order Details</a>
                                                    &nbsp;&nbsp;|&nbsp;&nbsp;
                                                    <a href="{site_url}customer/orders/invoice/<?php echo htmlspecialchars($list['encoded_order_id']); ?>" target="_blank">Invoice</a>
                                                </h5>
                                            </div>
                                        </div>

                                        <div class="col-sm-12" style="border: 1px solid #eee; margin-top: 0px; background: #f7f7f7; padding: 5px 10px; border-bottom: 0px;">
                                            <div class="col-sm-6">
                                                <div class="gift1">
                                                    <?php if ($list['status'] == 4): ?>
                                                        <h5>
                                                            <font color="red"><?php echo htmlspecialchars($list['status_title']); ?></font> <?php echo date('d M, Y', strtotime($list['updated'])); ?>
                                                        </h5>
                                                    <?php elseif ($list['status'] == 5): ?>
                                                        <h5>
                                                            <font color="green"><?php echo htmlspecialchars($list['status_title']); ?></font> <?php echo date('d M, Y', strtotime($list['updated'])); ?>
                                                        </h5>
                                                    <?php else: ?>
                                                        <h5><?php echo htmlspecialchars($list['status_title']); ?></h5>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>

                                        <?php if (!empty($list['productInfo'])): ?>
                                            <?php foreach ($list['productInfo'] as $proList): ?>
                                                <div class="col-sm-12 order-pro-block">
                                                    <div class="row">
                                                        <div class="col-sm-1">
                                                            <div class="gift">
                                                                <a href="{site_url}product/detail/<?php echo htmlspecialchars($proList['slug']); ?>">
                                                                    <img src="<?php echo base_url(htmlspecialchars($proList['product_img'])); ?>" alt="img">
                                                                </a>
                                                            </div>
                                                        </div>

                                                        <div class="col-sm-7 patter" align="left">
                                                            <p>
                                                                <a href="{site_url}product/detail/<?php echo htmlspecialchars($proList['slug']); ?>" title="<?php echo htmlspecialchars($proList['product_name']); ?>">
                                                                    <?php echo htmlspecialchars($proList['product_name']); ?>
                                                                </a><br>
                                                                <span>Qty: <?php echo htmlspecialchars($proList['product_qty']); ?></span><br>
                                                                &#8377; <?php echo number_format($proList['payable_amount'], 2); ?>
                                                            </p>
                                                        </div>

                                                        <div class="col-sm-4 order_tb_btns" align="right">
                                                            <?php $seller_feedback_status = $this->User->get_seller_feedback_btn_status($list['encoded_order_id'], $proList['id']); ?>
                                                            <?php if (!$seller_feedback_status): ?>
                                                                <div class="col-sm-12">
                                                                    <a href="{site_url}customer/orders/feedback/<?php echo htmlspecialchars($list['encoded_order_id']); ?>/<?php echo htmlspecialchars($proList['id']); ?>">
                                                                        <button type="button" class="seller-btn">Leave seller feedback</button>
                                                                    </a>
                                                                </div>
                                                            <?php endif; ?>

                                                            <?php $product_feedback_status = $this->User->get_seller_feedback_btn_status($list['encoded_order_id'], $proList['id'], 2); ?>
                                                            <?php if (!$product_feedback_status): ?>
                                                                <div class="col-sm-12">
                                                                    <a href="{site_url}customer/orders/review/<?php echo htmlspecialchars($list['encoded_order_id']); ?>/<?php echo htmlspecialchars($proList['id']); ?>">
                                                                        <button type="button" class="seller-btn">Write a product review</button>
                                                                    </a>
                                                                </div>
                                                            <?php endif; ?>

                                                            <?php if ($list['status'] == 1): ?>
                                                                <div class="col-sm-12">
                                                                    <a href="{site_url}customer/orders/cancel/<?php echo htmlspecialchars($list['encoded_order_id']); ?>/<?php echo htmlspecialchars($proList['id']); ?>">
                                                                        <button type="button" class="seller-btn" onclick="return confirm('Are you sure you want to cancel this order?')">Cancel Order</button>
                                                                    </a>
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="row align-items-center justify-content-center">
                    <div class="row">
                    <div class="col-sm-12">
                            <div class="form_content" id="msgBody" style="padding-top: 20px;">
                            <center>We are unable to locate any orders at this time.</center>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>




        </div>
    </div>
</div>