
    <!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>{meta_title}</title>
  <meta name="description" content="" />
  <meta name="keywords" content="" />
  <meta name="author" content="" />

  <!-- fonts file -->
  <link href="https://fonts.googleapis.com/css2?family=Jost:wght@300;400;500;600;700;800;900&amp;display=swap" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Allison&amp;display=swap" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Marcellus&amp;display=swap" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@300;400;700&amp;display=swap" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Fira+Sans:wght@300;400;500;600;700&amp;display=swap" rel="stylesheet" />

  <?php if(isset($content_block) && ($content_block == 'customer/product-review' || $content_block == 'customer/seller-review' || $content_block == 'vendorProduct')){ ?>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
  <?php }  ?>
    <link rel="stylesheet" href="{site_url}skin/front/assets/css/bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <!-- css file  -->
  <link rel="stylesheet" href="{site_url}skin/front/assets/css/bootstrap.min.css" />
  <link rel="stylesheet" href="{site_url}skin/front/assets/css/plugins.css" />
  <link rel="stylesheet" href="{site_url}skin/front/assets/css/style.css" />
  <link rel="stylesheet" href="{site_url}skin/front/assets/css/responsive.css" />

  <!-- Favicon -->
  <link rel="shortcut icon" href="{site_url}skin/front/assets/images/favicon.png" type="image/x-icon" />
  
 <!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-WJ08Z0EYR4"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-WJ08Z0EYR4');
</script>
</head>

<body>
  <input type="hidden" id="siteUrl" value="<?php echo base_url(); ?>">
  <div class="modal fade" id="beforeloginModal" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Choose your Location</h4>
        </div>
        <div class="modal-body">
          <p>Select a delivery location to see product availability and delivery options</p>
          <center><a href="<?php echo base_url('login'); ?>">Sign in to see your address</a></center>
        </div>
        <?php echo form_open('#', array('id' => 'pincode-form')); ?>
        <div class="modal-footer">
          <p class="text-center">or enter a pincode</p>
          <input type="text" autocomplete="off" name="pincode" class="form-control text-type" />
          <button type="button" id="pincodeChkBtn" class="btn btn-default apply-popup-btn">Apply</button>
          <div class="clearfix"></div>
          <div class="pincode-loader text-center"></div>
        </div>
        <?php echo form_close(); ?>
      </div>
    </div>
  </div>
  <?php if ($this->session->userdata('pinkekart_vendor_session') || $this->session->userdata('pinkekart_customer_session')) { ?>
    <div class="modal fade" id="afterloginModal" role="dialog">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Choose your Location</h4>
          </div>
          <div class="modal-body" style="border:0px solid #ccc;">
            <p>Select a delivery Location to see product availability and delivery option</p>
            <?php $addressList = $this->User->get_user_addresses(); ?>
            <?php if ($addressList) { ?>
              <?php foreach ($addressList as $list) { ?>
                <a href="<?php echo base_url('home/deliveryAddAuth/' . $list['id']); ?>">
                  <div class="col-sm-12" style="border:1px solid #ccc; padding:10px;">
                    <p><strong><?php echo $list['name']; ?>- <?php echo $list['city']; ?></strong> - <?php echo $list['zip_code']; ?></p>
                  </div>
                </a>
              <?php } ?>
            <?php } else { ?>
              <div class="col-sm-12" style="border:1px solid #ccc; padding:10px;">
                <p>No Address Found</p>
              </div>
            <?php } ?>

          </div>
          <?php echo form_open('#', array('id' => 'pincode-form2')); ?>
          <div class="modal-footer" style="border:0px solid #ccc;">
            <p class="text-center">or enter a pincode</p>
            <div class="row">
              <div class="col-sm-6">
                <input type="text" autocomplete="off" name="pincode" class="form-control text-type" style="width:100%;" />
              </div>
              <div class="col-sm-6">
                <button type="button" id="pincodeChkBtn2" class="btn btn-default apply-popup-btn btn-block" style="height:50px;">Apply</button>
                <div class="clearfix"></div>
              </div>
            </div>
            <div class="pincode-loader2 text-center"></div>
          </div>
          <?php echo form_close(); ?>
        </div>
      </div>
    </div>
  <?php } ?>

  <div class="cart-msg-block fadeInDown wow animated"></div>


  <!-- header area start here  -->
  <header class="header-area">
    <div class="header-middle">
      <div class="container">
        <div class="header-middle-wrap">


          <?php echo form_open('product/search', array('method' => 'get', 'class' => 'example')); ?>
          <div class="search-area">
            <div class="search-wrap">
              <?php $parentCategoryList = $this->User->get_parent_category_list(); ?>
              <select class="form-select" name="category_type">
                <option selected value="0">All Categories</option>
                <?php if ($parentCategoryList) { ?>
                  <?php foreach ($parentCategoryList as $catList) { ?>
                    <option value="<?php echo $catList['id']; ?>" <?php if (isset($category_type) && $category_type == $catList['id']) { ?> selected="selected" <?php } ?>><?php echo $catList['title']; ?></option>
                  <?php } ?>
                <?php } ?>
              </select>

              <div class="form-group">
                <input type="text" class="form-control" id="keyword" name="keyword" value="<?php echo isset($keyword) ? $keyword : ''; ?>" placeholder="Search Here" />
                <button type="submit" class="search-btn">
                  <i class="flaticon-search"></i>
                </button>
              </div>
            </div>
          </div>
          <?php echo form_close(); ?>

          <div class="brand-area">
            <a class="brand-logo" href="{site_url}home"><img class="brand-image" src="{site_url}skin/front/assets/images/logo.png" alt="logo" /></a>
          </div>

          <?php $cartTempData = $this->User->get_cart_temp_data(); ?>
          <?php $wishListTempData = $this->User->get_wish_list_temp_data(); ?>

          <div class="header-right">
            <div class="wishlist single-btn">
              <a href="{site_url}product/wishList" class="wishlist-btn header-btn">
                <div class="btn-left">
                  <i class="btn-icon flaticon-like"></i>
                  <span class="count" id="top_wish_list_number_block"><?php echo $wishListTempData; ?></span>
                </div>
                
              </a>
            </div>

            <div class="cart single-btn new_class dropdown">
              <a  data-bs-toggle="dropdown" href="#" role="button" aria-controls="dropdown" class="cart-btn header-btn dropdown-toggle">
                <div class="btn-left">
                  <i class="btn-icon flaticon-shopping-bag"></i>
                  <span class="count" id="top_cart_number_block"><?php echo count($cartTempData); ?></span>
                </div>
              </a>

              <div class="dropdown-menu dropdown-content" id="top_cart_data_block">
                <div class="show_div">
                  <div class="col-sm-12">
                    <div class="btn-div-hov">

                      <a href="{site_url}cart"><button type="button" id="view-cart-btn"><i class="fa fa-shopping-cart" id="cart"></i> View Cart</button></a>

                      <?php if ($this->session->userdata('pinkekart_vendor_session') || $this->session->userdata('pinkekart_customer_session')) { ?>

                        <a href="{site_url}checkout"><button type="button" id="view-cart-btn"><i class="fa fa-share" id="cart"></i>Checkout</button></a>

                      <?php } else { ?>
                        <a href="{site_url}login?ret_url=checkout"><button type="button" id="view-cart-btn"><i class="fa fa-share" id="cart"></i>Checkout</button></a>
                      <?php } ?>
                    </div>
                  </div>

                </div>
              </div>
            </div>

            


            <?php if ($this->session->userdata('pinkekart_vendor_session') || $this->session->userdata('pinkekart_customer_session')) { ?>
              <?php if ($this->session->userdata('pinkekart_vendor_session')) {
                $loggedUser = $this->session->userdata('pinkekart_vendor_session'); ?>

                <div class="compare single-btn dropdown">
                  <a class="compare-btn header-btn dropdown-toggle" data-bs-toggle="dropdown">
                    <div class="btn-left">
                      <i class="btn-icon flaticon-user"></i>
                    </div>

                    <div class="btn-right">
                      <span class="btn-text">Hello, <?php echo $loggedUser['name']; ?></span>
                    </div>
                  </a>
                  <ul class="dropdown-menu">
                    <li><a href="{site_url}vendor/dashboard"> Dashboard</a></li>
                    <li><a href="{site_url}vendor/catalog/productList">My Product</a></li>
                    <li><a href="{site_url}vendor/dashboard/logOut">Logout</a></li>
                  </ul>
                </div>

              <?php } ?>

              <?php if ($this->session->userdata('pinkekart_customer_session')) {
                $loggedUser = $this->session->userdata('pinkekart_customer_session'); ?>

                <div class="compare single-btn dropdown">
                  <a class="compare-btn header-btn dropdown-toggle" data-bs-toggle="dropdown">
                    <div class="btn-left">
                      <i class="btn-icon flaticon-user"></i>
                    </div>

                    <div class="btn-right">
                      <span class="btn-text">Hello, <?php echo $loggedUser['name']; ?></span>
                    </div>

                  </a>
                  <ul class="dropdown-menu">
                    <li><a href="{site_url}customer/dashboard"><i class="fa fa-chart-line"></i> Dashboard</a></li>
                    <li><a href="{site_url}customer/orders"><i class="fa fa-tasks"></i> Your Order</a></li>
                    <li><a href="{site_url}customer/security"><i class="fa fa-user-shield"></i> Login & Security</a></li>
                    <li><a href="{site_url}customer/dashboard/logOut"><i class="fa fa-sign-out-alt"></i> Logout</a></li>
                  </ul>
                </div>
              <?php } ?>
            <?php } else { ?>
              <div class="compare single-btn dropdown">
                <a class="compare-btn header-btn dropdown-toggle" data-bs-toggle="dropdown">
                  <div class="btn-left">
                    <i class="btn-icon flaticon-user"></i>

                  </div>

                </a>
                <ul class="dropdown-menu">
                  <li><a href="{site_url}login">Login</a></li>
                  <li><a href="{site_url}register">Sign Up</a></li>
                </ul>
              </div>



            <?php } ?>









           
          </div>
        </div>
      </div>
    </div>

    


    <div class="header-bottom">
         
      <nav id="navheadermenu" class="offcanvas offcanvas-start menu-offcanvas menu-area">
          <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"><i class="fa fa-close"></i></button>
        <ul class="main-menu menu-list">
          <li class="menu-item menu-item-has-children active">
            <a class="menu-link" href="{site_url}home">Home</a>
          </li>


          <?php $categoryList = $this->User->getFrontCategoryList(); ?>
          <?php if ($categoryList) { ?>
            <li class="menu-item mega-menu-parent">
              <a class="menu-link" href="javascript:void(0)">Collection <i class="arrow-icon fas fa-angle-down"></i></a>
              <div class="mega-menu-area">
                <div class="container">
                  <ul class="mega-menu">
                    <?php foreach ($categoryList as $cList) { ?>

                      <li class="mega-menu-item">
                        <a class="mega-menu-title" href="{site_url}product/index/<?php echo $cList['slug']; ?>"><?php echo $cList['title']; ?></a>
                        <ul class="menu-items">
                          <?php foreach ($cList['subCat'] as $ccList) { ?>
                            <li class="mega-menu-items">
                              <a class="mega-menu-link" href="{site_url}product/index/<?php echo $ccList['slug']; ?>"><?php echo $ccList['title']; ?></a>
                            </li>
                          <?php } ?>

                        </ul>
                      </li>

                    <?php } ?>
                  </ul>
                </div>
              </div>
            </li>
          <?php } ?>

          
          <li class="menu-item">
            <a class="menu-link" href="{site_url}contact">Contact Us</a>
          </li>
          
          <li class="d-block d-lg-none d-md-none menu-item"><a class="menu-link" href="{site_url}login">Login</a></li>
          <li class="d-block d-lg-none d-md-none menu-item"><a class="menu-link" href="{site_url}register">Sign Up</a></li>
                  
        </ul>
      </nav>
    </div>
  </header>
  <!-- header area end here  -->

  <!-- mobile-header-area area start here  -->
  <div class="mobile-header-area d-block d-lg-none">
    <div class="container">
      <div class="menu-wrap">
        <div class="header-left">
          <a class="brand-logo" href="{site_url}home"><img class="brand-image" src="{site_url}skin/front/assets/images/logo.png" alt="" /></a>
        </div>
        
        <div class="header-right">
          <a href="{site_url}product/wishList" class="wishlist-btn header-btn">
            <div class="btn-left">
              <i class="btn-icon flaticon-like"></i>
              <span class="count"><?php echo $wishListTempData; ?></span>
            </div>
          </a>

          <a href="{site_url}cart" class="cart-btn header-btn">
            <div class="btn-left">
              <i class="btn-icon flaticon-shopping-bag"></i>
              <span class="count"><?php echo count($cartTempData); ?></span>
            </div>
          </a>
          <!--<button class="menu-bar" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasMobileMenu" aria-controls="offcanvasMobileMenu">-->
          <!--  <i class="fas fa-bars"></i>-->
          <!--</button>-->
          <button class="menu-bar" type="button" data-bs-toggle="offcanvas" data-bs-target="#navheadermenu" aria-controls="navheadermenu">
            <i class="fas fa-bars"></i>
          </button>
        </div>
      </div>
    </div>
  </div>
  <!-- mobile-header-area area end here  -->
  
  
  
 

  <!-- mobile-menu-area area start here  -->
  <div style="display:none;" class="offcanvas offcanvas-start menu-offcanvas" tabindex="-1" id="offcanvasMobileMenu">
    <div class="mobile-menu-area">
      <div class="offcanvas-header">
        <a class="brand-logo" href="javascript:void(0)"><img class="brand-image" src="assets/images/logo.png" alt="" /></a>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
      </div>
      <div class="menu-search-form">
        <?php echo form_open('product/search', array('method' => 'get', 'class' => 'example')); ?>
          <div class="search-wrap">
            <select class="form-select" name="category_type">
              <option selected value="0">All Categories</option>
              <?php if ($parentCategoryList) { ?>
                  <?php foreach ($parentCategoryList as $catList) { ?>
                    <option value="<?php echo $catList['id']; ?>" <?php if (isset($category_type) && $category_type == $catList['id']) { ?> selected="selected" <?php } ?>><?php echo $catList['title']; ?></option>
                  <?php } ?>
                <?php } ?>
            </select>
            <div class="form-group">
              <input type="text" class="form-control" id="mobilesearch" name="search" placeholder="Search Here" />
              <button type="submit" class="search-btn">
                <i class="flaticon-search"></i>
              </button>
            </div>
          </div>
        </form>
      </div>
      <nav class="main-menu">
        <ul class="menu-list">
          <li class="menu-item">
            <span class="menu-expand"></span>
            <a class="menu-link" href="{site_url}home">Home</a>
          </li>
          <li class="menu-item">
            <span class="menu-expand"></span>
            <a class="menu-link" href="javascript:void(0)">Best Sellers</a>
          </li>
          
          
          
          
          <!--<?php foreach ($categoryList as $cList) { ?>-->

          <!--            <li class="mega-menu-item">-->
          <!--              <a class="mega-menu-title" href="{site_url}product/index/<?php echo $cList['slug']; ?>"><?php echo $cList['title']; ?></a>-->
          <!--              <ul class="menu-items">-->
          <!--                <?php foreach ($cList['subCat'] as $ccList) { ?>-->
          <!--                  <li class="mega-menu-items">-->
          <!--                    <a class="mega-menu-link" href="{site_url}product/index/<?php echo $ccList['slug']; ?>"><?php echo $ccList['title']; ?></a>-->
          <!--                  </li>-->
          <!--                <?php } ?>-->

          <!--              </ul>-->
          <!--            </li>-->

          <!--          <?php } ?>-->
          
          
          <?php if ($categoryList) { ?>
          <li class="menu-item">
            <span class="menu-expand"></span>
            <a class="menu-link" href="javascript:void(0)">Collection</a>
            <ul class="sub-menu">
              
              <?php foreach ($categoryList as $cList) { ?>
                  <li class="sub-menu-item">
                    <a class="mega-menu-link" href="{site_url}product/index/<?php echo $cList['slug']; ?>"><?php echo $cList['title']; ?></a>
                  </li>
              <?php } ?>
              
              
            </ul>
          </li>
          <?php } ?>
          
          <li class="menu-item">
            <a class="menu-link" href="javascript:void(0)">Accessories </a>
          </li>
          
          <li class="menu-item">
            <a class="menu-link" href="{site_url}contact">Contact Us</a>
          </li>
        </ul>
        
      </nav>
      <div class="menu-bottom">
        <a class="account-btn" href="javascript:void(0)"><i class="user-icon flaticon-user"></i> My Account
        </a>
      </div>
    </div>
  </div>