$(document).ready(function() {
	$('#example1').DataTable();
	
	adminProductDataTable();
	adminPendingProductDataTable();
	adminApproveProductDataTable();
	adminRejectProductDataTable();
	adminOrderDataTable();
	adminOpenOrderDataTable();
	adminProcessingOrderDataTable();
	adminDispatchedOrderDataTable();
	adminCancelledOrderDataTable();
	adminDeliveredOrderDataTable();
	vendorOrderDataTable();
	sectionProductDataTable();
	couponProductDataTable();

	totalUserDataTable();
	totalGeneralDataTable();
	totalVendorDataTable();
	
	adminSellDataTable();
	
	function adminOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminOrderDataTable = $('#adminOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/order/getOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}
	
	
	function adminSellDataTable(from_date = '', to_date = '')
	{
		var siteUrl = $("#siteUrl").val();
		var adminSellDataTable = $('#adminSellDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [{"targets": 0,"orderable": true},{"targets": 1,"orderable": false},{"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false}],
			"processing": false,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/dashboard/getSellList",
				"data": function ( d ) {
					d.extra_search = from_date+'|'+to_date;
				}
			},
			"initComplete": function( settings, json ) {
				
			}
				
			
		});
	}
	
	$('#reportFilterBtn').on('click', function() {
		$('#adminSellDataTable').DataTable().destroy();
		var from_date = $("#from_date").val();
		var to_date = $("#to_date").val();
		adminSellDataTable(from_date,to_date);
	});


	function adminOpenOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminOpenOrderDataTable = $('#adminOpenOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/order/getOpenOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminOpenOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminProcessingOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminProcessingOrderDataTable = $('#adminProcessingOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/order/getProcessingOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminProcessingOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminDispatchedOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminDispatchedOrderDataTable = $('#adminDispatchedOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/order/getDispatchedOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminDispatchedOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminCancelledOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminCancelledOrderDataTable = $('#adminCancelledOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false},{"targets": 8,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/order/getCancelledOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminCancelledOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminDeliveredOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminDeliveredOrderDataTable = $('#adminDeliveredOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/order/getDeliveredOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminDeliveredOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function vendorOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var vendorOrderDataTable = $('#vendorOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 1,"orderable": false},{"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 6,"orderable": false},{"targets": 7,"orderable": false},{"targets": 8,"orderable": false},{"targets": 9,"orderable": false},{"targets": 10,"orderable": false},{"targets": 11,"orderable": false},{"targets": 12,"orderable": false},{"targets": 13,"orderable": false},{"targets": 14,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/order/getVendorOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = vendorOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}



	function adminProductDataTable(stock_status = 0, keyword = '', approve_status = 0, vendor_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminProductDataTable = $('#adminProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 1,"orderable": false},{"targets": 3,"orderable": false},{"targets": 10,"orderable": false},{"targets": 12,"orderable": false},{"targets": 14,"orderable": false},{"targets": 15,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 2, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/catalog/getProductList",
				"data": function ( d ) {
					d.extra_search = stock_status+'-'+keyword+'-'+approve_status+'-'+vendor_id;
					//d.extra_search = stock_status+'- -'+approve_status+'-'+vendor_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminPendingProductDataTable(stock_status = 0, keyword = '', approve_status = 0, vendor_id = 0)
	{	
		var siteUrl = $("#siteUrl").val();
		var adminPendingProductDataTable = $('#adminPendingProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 1,"orderable": false},{"targets": 3,"orderable": false},{"targets": 10,"orderable": false},{"targets": 12,"orderable": false},{"targets": 14,"orderable": false},{"targets": 15,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 2, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/catalog/getPendingProductList",
				"data": function ( d ) {
					d.extra_search = stock_status+'-'+keyword+'-'+approve_status+'-'+vendor_id;
					//d.extra_search = stock_status+'- -'+approve_status+'-'+vendor_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminPendingProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminRejectProductDataTable(stock_status = 0, keyword = '', approve_status = 0, vendor_id = 0)
	{	
		var siteUrl = $("#siteUrl").val();
		var adminRejectProductDataTable = $('#adminRejectProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 1,"orderable": false},{"targets": 3,"orderable": false},{"targets": 10,"orderable": false},{"targets": 12,"orderable": false},{"targets": 14,"orderable": false},{"targets": 15,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 2, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/catalog/getRejectProductList",
				"data": function ( d ) {
					d.extra_search = stock_status+'-'+keyword+'-'+approve_status+'-'+vendor_id;
					//d.extra_search = stock_status+'- -'+approve_status+'-'+vendor_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminRejectProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminApproveProductDataTable(stock_status = 0, keyword = '', approve_status = 0, vendor_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminApproveProductDataTable = $('#adminApproveProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 1,"orderable": false},{"targets": 3,"orderable": false},{"targets": 10,"orderable": false},{"targets": 12,"orderable": false},{"targets": 14,"orderable": false},{"targets": 15,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 2, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/catalog/getApproveProductList",
				"data": function ( d ) {
					d.extra_search = stock_status+'-'+keyword+'-'+approve_status+'-'+vendor_id;
					//d.extra_search = stock_status+'- -'+approve_status+'-'+vendor_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminApproveProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	
	function sectionProductDataTable(stock_status = 0, keyword = '', approve_status = 0, vendor_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var sectionID = $("#sectionID").val();
		var sectionProductDataTable = $('#sectionProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": true,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 2,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 1, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/catalog/getSectionProductList",
				"data": function ( d ) {
					d.extra_search = sectionID+'|'+keyword+'|'+approve_status+'|'+vendor_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = sectionProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}
	
	function couponProductDataTable(stock_status = 0, keyword = '', approve_status = 0, vendor_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var sectionID = $("#sectionID").val();
		var couponProductDataTable = $('#couponProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": true,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 2,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 1, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/catalog/getCouponProductList",
				"data": function ( d ) {
					d.extra_search = sectionID+'|'+keyword+'|'+approve_status+'|'+vendor_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = couponProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}
	
	$('#searchBtn').on('click', function() {
		$('#adminProductDataTable').DataTable().destroy();
		var stock_status = $("#stock_status").val();
		var keyword = $("#keyword").val();
		var approve_status = $("#approve_status").val();
		var vendor_id = $("#vendor_id").val();
		adminProductDataTable(stock_status,keyword,approve_status,vendor_id);
	});




	function totalUserDataTable(keyword = '',role_id = '',status = '')
	{
		var siteUrl = $("#siteUrl").val();
		var totalUserDataTable = $('#totalUserDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 2,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/customer/getTotalUserList",
				"data": function ( d ) {
					d.extra_search = keyword+'|'+role_id+'|'+status;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = totalUserDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}
	
	$('#totalUserSearchBtn').on('click', function() {
		$('#totalUserDataTable').DataTable().destroy();
		var keyword = $("#keyword").val();
		var role_id = $("#role_id").val();
		var status = $("#status").val();
		totalUserDataTable(keyword,role_id,status);
	});


	function totalGeneralDataTable(keyword = '',status = '')
	{
		var siteUrl = $("#siteUrl").val();
		var totalGeneralDataTable = $('#totalGeneralDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 2,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/customer/getGeneralUserList",
				"data": function ( d ) {
					d.extra_search = keyword+'|'+status;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = totalGeneralDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}
	
	$('#totalGeneralSearchBtn').on('click', function() {
		$('#totalGeneralDataTable').DataTable().destroy();
		var keyword = $("#keyword").val();
		var status = $("#status").val();
		totalGeneralDataTable(keyword,status);
	});


	function totalVendorDataTable(keyword = '',status = '')
	{
		var siteUrl = $("#siteUrl").val();
		var totalVendorDataTable = $('#totalVendorDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 2,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"admin/customer/getVendorUserList",
				"data": function ( d ) {
					d.extra_search = keyword+'|'+status;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = totalVendorDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}
	
	$('#totalVendorSearchBtn').on('click', function() {
		$('#totalVendorDataTable').DataTable().destroy();
		var keyword = $("#keyword").val();
		var status = $("#status").val();
		totalVendorDataTable(keyword,status);
	});










	$('#searchBtn').on('click', function() {
		$('#adminPendingProductDataTable').DataTable().destroy();
		var stock_status = $("#stock_status").val();
		var keyword = $("#keyword").val();
		var approve_status = $("#approve_status").val();
		var vendor_id = $("#vendor_id").val();
		adminPendingProductDataTable(stock_status,keyword,approve_status,vendor_id);
	});

	$('#searchBtn').on('click', function() {
		$('#adminApproveProductDataTable').DataTable().destroy();
		var stock_status = $("#stock_status").val();
		var keyword = $("#keyword").val();
		var approve_status = $("#approve_status").val();
		var vendor_id = $("#vendor_id").val();
		adminApproveProductDataTable(stock_status,keyword,approve_status,vendor_id);
	});

	$('#searchBtn').on('click', function() {
		$('#adminRejectProductDataTable').DataTable().destroy();
		var stock_status = $("#stock_status").val();
		var keyword = $("#keyword").val();
		var approve_status = $("#approve_status").val();
		var vendor_id = $("#vendor_id").val();
		adminRejectProductDataTable(stock_status,keyword,approve_status,vendor_id);
	});
	
	$('#productFilterForm').on('keyup keypress', function(e) {
	  var keyCode = e.keyCode || e.which;
	  if (keyCode === 13) { 
		$("#searchBtn").click();
		e.preventDefault();
		return false;
	  }
	});



	$('#orderFilterBtn').on('click', function() {
		$('#adminOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminOrderDataTable(order_status,keyword,customer_id);
	});

	$('#orderFilterBtn').on('click', function() {
		$('#adminOpenOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminOpenOrderDataTable(order_status,keyword,customer_id);
	});

	$('#orderFilterBtn').on('click', function() {
		$('#adminProcessingOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminProcessingOrderDataTable(order_status,keyword,customer_id);
	});

	$('#orderFilterBtn').on('click', function() {
		$('#adminDispatchedOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminDispatchedOrderDataTable(order_status,keyword,customer_id);
	});

	$('#orderFilterBtn').on('click', function() {
		$('#adminCancelledOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminCancelledOrderDataTable(order_status,keyword,customer_id);
	});

	$('#orderFilterBtn').on('click', function() {
		$('#adminDeliveredOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminDeliveredOrderDataTable(order_status,keyword,customer_id);
	});
	
	$('#orderFilterForm').on('keyup keypress', function(e) {
	  var keyCode = e.keyCode || e.which;
	  if (keyCode === 13) { 
		$("#orderFilterBtn").click();
		e.preventDefault();
		return false;
	  }
	});


	$('#vendorOrderFilterBtn').on('click', function() {
		$('#vendorOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		vendorOrderDataTable(order_status,keyword,customer_id);
	});
	
	$('#vendorOrderFilterForm').on('keyup keypress', function(e) {
	  var keyCode = e.keyCode || e.which;
	  if (keyCode === 13) { 
		$("#vendorOrderFilterBtn").click();
		e.preventDefault();
		return false;
	  }
	});


} );