$(document).ready(function() {
	
	$('#example1').DataTable();
	
	adminProductDataTable();
	adminPendingProductDataTable();
	adminApproveProductDataTable();
	adminRejectProductDataTable();
	sectionProductDataTable();
	adminOrderDataTable();
	adminOpenOrderDataTable();
	adminProcessingOrderDataTable();
	adminDispatchedOrderDataTable();
	adminCancelledOrderDataTable();
	adminCancelledOrderHistoryDataTable();
	adminDeliveredOrderDataTable();
	
	function adminOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminOrderDataTable = $('#adminOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/order/getOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminOpenOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminOpenOrderDataTable = $('#adminOpenOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/order/getOpenOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminOpenOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminProcessingOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminProcessingOrderDataTable = $('#adminProcessingOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/order/getProcessingOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminProcessingOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminDispatchedOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminDispatchedOrderDataTable = $('#adminDispatchedOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/order/getDispatchedOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminDispatchedOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminCancelledOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminCancelledOrderDataTable = $('#adminCancelledOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/order/getCancelledOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminCancelledOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}

	function adminCancelledOrderHistoryDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminCancelledOrderHistoryDataTable = $('#adminCancelledOrderHistoryDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/order/getCancelledOrderHistoryList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminCancelledOrderHistoryDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminDeliveredOrderDataTable(order_status = 0, keyword = '',customer_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminDeliveredOrderDataTable = $('#adminDeliveredOrderDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 2,"orderable": false},{"targets": 3,"orderable": false},{"targets": 4,"orderable": false},{"targets": 5,"orderable": false},{"targets": 7,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 0, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/order/getDeliveredOrderList",
				"data": function ( d ) {
					d.extra_search = order_status+'-'+keyword+'-'+customer_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminDeliveredOrderDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}



	function adminProductDataTable(stock_status = 0, keyword = '', approve_status = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminProductDataTable = $('#adminProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 2,"orderable": false},{"targets": 11,"orderable": false},{"targets": 12,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 1, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/catalog/getProductList",
				"data": function ( d ) {
					//d.extra_search = stock_status+'|'+keyword+'|'+approve_status;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}



	function adminPendingProductDataTable(stock_status = 0, keyword = '', approve_status = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminPendingProductDataTable = $('#adminPendingProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 2,"orderable": false},{"targets": 11,"orderable": false},{"targets": 12,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 1, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/catalog/getPendingProductList",
				"data": function ( d ) {
					//d.extra_search = stock_status+'|'+keyword+'|'+approve_status;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminPendingProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}



	function adminApproveProductDataTable(stock_status = 0, keyword = '', approve_status = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminApproveProductDataTable = $('#adminApproveProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 2,"orderable": false},{"targets": 11,"orderable": false},{"targets": 12,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 1, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/catalog/getApproveProductList",
				"data": function ( d ) {
					//d.extra_search = stock_status+'|'+keyword+'|'+approve_status;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminApproveProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}


	function adminRejectProductDataTable(stock_status = 0, keyword = '', approve_status = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var adminRejectProductDataTable = $('#adminRejectProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": false,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 2,"orderable": false},{"targets": 11,"orderable": false},{"targets": 12,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 1, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/catalog/getRejectProductList",
				"data": function ( d ) {
					//d.extra_search = stock_status+'|'+keyword+'|'+approve_status;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = adminRejectProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}

	
	function sectionProductDataTable(stock_status = 0, keyword = '', approve_status = 0, vendor_id = 0)
	{
		var siteUrl = $("#siteUrl").val();
		var sectionID = $("#sectionID").val();
		var sectionProductDataTable = $('#sectionProductDataTable').DataTable({
			"pageLength": 50,
			"lengthMenu": [ 10, 25, 50, 75, 100 ],
			"searching": true,
			"columnDefs": [ {"targets": 0,"orderable": false},{"targets": 2,"orderable": false}],
			"processing": true,
			"serverSide": true,
			"order": [[ 1, "desc" ]],
			deferRender: true,
			"ajax": {
				"url": siteUrl+"vendor/catalog/getSectionProductList",
				"data": function ( d ) {
					d.extra_search = sectionID+'|'+keyword+'|'+approve_status+'|'+vendor_id;
				}
			},
			"initComplete": function( settings, json ) {
				$("#check_all").click(function(){
					
					var rows = sectionProductDataTable.rows({ 'search': 'applied' }).nodes();
					$('input[type="checkbox"]', rows).prop('checked', this.checked);
					
					
				});
			}
				
			
		});
	}
	
	$('#searchBtn').on('click', function() {
		$('#adminProductDataTable').DataTable().destroy();
		var stock_status = $("#stock_status").val();
		var keyword = $("#keyword").val();
		var approve_status = $("#approve_status").val();
		adminProductDataTable(stock_status,keyword,approve_status);
	});

	$('#searchBtn').on('click', function() {
		$('#adminPendingProductDataTable').DataTable().destroy();
		var stock_status = $("#stock_status").val();
		var keyword = $("#keyword").val();
		var approve_status = $("#approve_status").val();
		adminPendingProductDataTable(stock_status,keyword,approve_status);
	});

	$('#searchBtn').on('click', function() {
		$('#adminApproveProductDataTable').DataTable().destroy();
		var stock_status = $("#stock_status").val();
		var keyword = $("#keyword").val();
		var approve_status = $("#approve_status").val();
		adminApproveProductDataTable(stock_status,keyword,approve_status);
	});

	$('#searchBtn').on('click', function() {
		$('#adminRejectProductDataTable').DataTable().destroy();
		var stock_status = $("#stock_status").val();
		var keyword = $("#keyword").val();
		var approve_status = $("#approve_status").val();
		adminRejectProductDataTable(stock_status,keyword,approve_status);
	});
	

	$('#orderFilterBtn').on('click', function() {
		$('#adminOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminOrderDataTable(order_status,keyword,customer_id);
	});

	$('#orderFilterBtn').on('click', function() {
		$('#adminOpenOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminOpenOrderDataTable(order_status,keyword,customer_id);
	});

	$('#orderFilterBtn').on('click', function() {
		$('#adminProcessingOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminProcessingOrderDataTable(order_status,keyword,customer_id);
	});

	$('#orderFilterBtn').on('click', function() {
		$('#adminDispatchedOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminDispatchedOrderDataTable(order_status,keyword,customer_id);
	});

	$('#orderFilterBtn').on('click', function() {
		$('#adminCancelledOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminCancelledOrderDataTable(order_status,keyword,customer_id);
	});

	//cancel order

	$('#orderFilterBtn').on('click', function() {
		$('#adminCancelledOrderHistoryDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminCancelledOrderHistoryDataTable(order_status,keyword,customer_id);
	});

	$('#orderFilterBtn').on('click', function() {
		$('#adminDeliveredOrderDataTable').DataTable().destroy();
		var order_status = $("#order_status").val();
		var keyword = $("#keyword").val();
		var customer_id = $("#customer_id").val();
		adminDeliveredOrderDataTable(order_status,keyword,customer_id);
	});

	$('#productFilterForm').on('keyup keypress', function(e) {
	  var keyCode = e.keyCode || e.which;
	  if (keyCode === 13) { 
		$("#searchBtn").click();
		e.preventDefault();
		return false;
	  }
	});
} );